/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractTailType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TailType {
    public static final AbstractTailType NONE;
    public static final AbstractTailType DEMON_COMMON;
    public static final AbstractTailType DEMON_HAIR_TIP;
    public static final AbstractTailType DEMON_TAPERED;
    public static final AbstractTailType DEMON_HORSE;
    public static final AbstractTailType DEMON_OVIPOSITOR;
    public static final AbstractTailType ALLIGATOR_MORPH;
    public static final AbstractTailType BAT_MORPH;
    public static final AbstractTailType CAT_MORPH;
    public static final AbstractTailType CAT_MORPH_SHORT;
    public static final AbstractTailType CAT_MORPH_TUFTED;
    public static final AbstractTailType COW_MORPH;
    public static final AbstractTailType DOG_MORPH;
    public static final AbstractTailType DOG_MORPH_STUBBY;
    public static final AbstractTailType FOX_MORPH;
    public static final AbstractTailType FOX_MORPH_MAGIC;
    public static final AbstractTailType HARPY;
    public static final AbstractTailType HORSE_MORPH;
    public static final AbstractTailType HORSE_MORPH_ZEBRA;
    public static final AbstractTailType RAT_MORPH;
    public static final AbstractTailType RABBIT_MORPH;
    public static final AbstractTailType REINDEER_MORPH;
    public static final AbstractTailType SQUIRREL_MORPH;
    public static final AbstractTailType WOLF_MORPH;
    private static List<AbstractTailType> allTailTypes;
    private static Map<AbstractTailType, String> tailToIdMap;
    private static Map<String, AbstractTailType> idToTailMap;
    private static Map<AbstractRace, List<AbstractTailType>> typesMap;

    public static AbstractTailType getTailTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        if (id.equals("LYCAN")) {
            return WOLF_MORPH;
        }
        id = Util.getClosestStringMatch(id, idToTailMap.keySet());
        return idToTailMap.get(id);
    }

    public static String getIdFromTailType(AbstractTailType tailType) {
        return tailToIdMap.get(tailType);
    }

    public static List<AbstractTailType> getAllTailTypes() {
        return allTailTypes;
    }

    public static List<AbstractTailType> getTailTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractTailType> types = new ArrayList<AbstractTailType>();
        for (AbstractTailType type : TailType.getAllTailTypes()) {
            if (type.getRace() != r || type == FOX_MORPH_MAGIC) continue;
            types.add(type);
        }
        if (types.isEmpty()) {
            types.add(NONE);
        }
        typesMap.put(r, types);
        return types;
    }

    public static List<AbstractTailType> getTailTypesSuitableForTransformation(List<AbstractTailType> options) {
        if (!options.contains(NONE)) {
            return options;
        }
        ArrayList<AbstractTailType> duplicatedOptions = new ArrayList<AbstractTailType>(options);
        duplicatedOptions.remove(NONE);
        return duplicatedOptions;
    }

    static {
        Field[] fieldArray;
        NONE = new AbstractTailType(null, Race.NONE, PenetrationGirth.THREE_AVERAGE, 0.0f, "\u65e0", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues(new String[0]), Util.newArrayListOfValues(new String[0]), "", "", Util.newArrayListOfValues(new String[0]), Util.newArrayListOfValues(new String[0]), "#IF(npc.getTailCount()==1)\u5f53[npc.She]\u611f\u5230[npc.tail]\u9010\u6e10\u7f29\u5c0f\uff0c\u5e76\u6d88\u5931\u5728[npc.her]\u80cc\u540e\u65f6\uff0c[npc.She]\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\u3002#ELSE\u5f53[npc.She]\u611f\u5230[npc.tails]\u9010\u6e10\u7f29\u5c0f\uff0c\u5e76\u6d88\u5931\u5728[npc.her]\u80cc\u540e\u65f6\uff0c[npc.She]\u5012\u5438\u4e86\u4e00\u53e3\u51c9\u6c14\u3002#ENDIF<br/>[npc.Name]\u73b0\u5728[style.boldTfGeneric(\u6ca1\u6709\u5c3e\u5df4)]\u3002", "[style.colourDisabled([npc.She]\u6ca1\u6709\u5c3e\u5df4\u3002)]", Util.newArrayListOfValues(new BodyPartTag[0]), false){};
        DEMON_COMMON = new AbstractTailType(BodyCoveringType.DEMON_COMMON, Race.DEMON, PenetrationGirth.ONE_SLENDER, 1.0f, "\u6076\u9b54(\u6843\u5fc3\u5f62)", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u6843\u5fc3\u5f62", "\u6076\u9b54"), Util.newArrayListOfValues("\u6843\u5fc3\u5f62", "\u6076\u9b54"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6843\u5fc3\u5f62"), Util.newArrayListOfValues("\u6843\u5fc3\u5f62"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6843\u5fc3\u72b6\u7684\u6076\u9b54\u5c3e\u5df4\uff0c\u5c16\u7aef\u6709\u4e00\u7c07\u7ed2\u6bdb\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4eff\u4f5b\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709#IF(npc.isShortStature())\u4e00\u6761[style.boldImp(\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE\u4e00\u6761[style.boldDemon(\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.tailCount]\u6761\u6843\u5fc3\u72b6\u7684\u6076\u9b54\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4eff\u4f5b\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761#IF(npc.isShortStature())[style.boldImp(\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE[style.boldDemon(\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761\u6843\u5fc3\u72b6\u7684[npc.tailColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u5c3e\u5df4\u3002[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002#ELSE[npc.tailCount]\u6761\u6843\u5fc3\u72b6\u7684\uff0c[npc.tailColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u5c3e\u5df4\u3002\u5b83\u6d3b\u52a8\u81ea\u5982\uff0c\u80fd\u591f\u5e2e\u52a9[npc.herHim]\u6293\u53d6\u5e76\u63e1\u4f4f\u7269\u4f53\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_SUITABLE_FOR_PENETRATION, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_SKIN, BodyPartTag.TAIL_TAPERING_EXPONENTIAL), false){};
        DEMON_HAIR_TIP = new AbstractTailType(BodyCoveringType.DEMON_COMMON, Race.DEMON, PenetrationGirth.ONE_SLENDER, 0.5f, "\u6076\u9b54(\u7ed2\u6bdb\u5c16)", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u7ed2\u6bdb\u5c16\u7aef", "\u6076\u9b54"), Util.newArrayListOfValues("\u7ed2\u6bdb\u5c16\u7aef", "\u6076\u9b54"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u7c07\u72b6\u6bdb\u53d1"), Util.newArrayListOfValues("\u7c07\u72b6\u6bdb\u53d1"), "#IF(npc.getTailCount()==1)[npc.her]\u5c41\u80a1\u4e0a\u65b9\u957f\u51fa\u4e86\u4e00\u6761\u6076\u9b54\u822c\u7684\u5c3e\u5df4\uff0c\u9876\u90e8\u6709\u7740\u7ed2\u6bdb\uff0c\u4e14\u8fc5\u901f\u53d8\u957f\uff0c\u76f4\u5230\u5927\u7ea6[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4eff\u4f5b\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709#IF(npc.isShortStature())\u4e00\u6761[style.boldImp(\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE\u4e00\u6761[style.boldDemon(\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\uff0c\u5c16\u7aef\u6709\u7740[#npc.getCovering(BODY_COVERING_TYPE_HAIR_DEMON).getFullDescription(npc, true)]\u3002#ELSE[npc.TailCount]\u6761\u6076\u9b54\u5c3e\u5df4\uff0c\u5c16\u7aef\u6709\u4e00\u7c07\u7ed2\u6bdb\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4eff\u4f5b\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761#IF(npc.isShortStature())[style.boldImp(\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE[style.boldDemon(\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\uff0c\u5c16\u7aef\u6709\u7740[#npc.getCovering(BODY_COVERING_TYPE_HAIR_DEMON).getFullDescription(npc, true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761[npc.tailColour(true)]\u7684#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u5c3e\u5df4\uff0c\u5c16\u7aef\u5e26\u6709[#npc.getCovering(BODY_COVERING_TYPE_HAIR_DEMON).getFullDescription(npc, true)]\uff0c[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002#ELSE[npc.tailCount]\u6761[npc.tailColour(true)]\u7684#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u5c3e\u5df4\uff0c\u5c16\u7aef\u5e26\u6709[#npc.getCovering(BODY_COVERING_TYPE_HAIR_DEMON).getFullDescription(npc, true)]\uff0c[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_SKIN, BodyPartTag.TAIL_TAPERING_NONE), false){};
        DEMON_TAPERED = new AbstractTailType(BodyCoveringType.DEMON_COMMON, Race.DEMON, PenetrationGirth.THREE_AVERAGE, 0.75f, "\u6076\u9b54(\u5c16\u5934)", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u5c16\u5934", "\u6076\u9b54"), Util.newArrayListOfValues("\u5c16\u5934", "\u6076\u9b54"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u5c16\u5934"), Util.newArrayListOfValues("\u5c16\u5934"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u5c16\u5934\u7684\u6076\u9b54\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4eff\u4f5b\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709#IF(npc.isShortStature())\u4e00\u6761[style.boldImp(\u5c16\u5934\u7684\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE\u4e00\u6761[style.boldDemon(\u5c16\u5934\u7684\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u5c16\u5934\u7684\u6076\u9b54\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4eff\u4f5b\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761#IF(npc.isShortStature())[style.boldImp(\u5c16\u5934\u7684\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE[style.boldDemon(\u5c16\u5934\u7684\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761\u5c16\u5934\u7684[npc.tailColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u5c3e\u5df4\u3002[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002#ELSE[npc.tailCount]\u6761\u5c16\u5934\u7684[npc.tailColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u5c3e\u5df4\u3002[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_SUITABLE_FOR_PENETRATION, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_SKIN, BodyPartTag.TAIL_TAPERING_LINEAR), false){};
        DEMON_HORSE = new AbstractTailType(BodyCoveringType.HORSE_HAIR, Race.DEMON, PenetrationGirth.THREE_AVERAGE, 0.3f, "\u6076\u9b54(\u9a6c)", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u9a6c\u4e00\u822c"), Util.newArrayListOfValues("\u9a6c\u4e00\u822c"), "\u672b\u7aef", "\u672b\u7aef", Util.newArrayListOfValues("\u84ec\u677e"), Util.newArrayListOfValues("\u84ec\u677e"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u9a6c\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\uff0c\u5782\u8361\u5728\u8eab\u540e\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u5de6\u53f3\u6447\u6446\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709#IF(npc.isShortStature())\u4e00\u6761[style.boldImp(\u9a6c\u4e00\u822c\u7684\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE\u4e00\u6761[style.boldDemon(\u9a6c\u4e00\u822c\u7684\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c\u7531[npc.tailFullDescription(true)]\u5236\u6210\u3002#ELSE[npc.TailCount]\u6761\u9a6c\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\uff0c\u5782\u8361\u5728\u8eab\u540e\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u5de6\u53f3\u6447\u6446\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761#IF(npc.isShortStature())[style.boldImp(\u9a6c\u4e00\u822c\u7684\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE[style.boldDemon(\u9a6c\u4e00\u822c\u7684\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c\u7531[npc.tailFullDescription(true)]\u5236\u6210\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u9a6c\u5c3e\uff0c[npc.she]\u80fd\u591f\u56db\u5904\u6446\u8361\uff0c\u4f46\u6b64\u5916\u4e0d\u80fd\u8fdb\u884c\u66f4\u7cbe\u5bc6\u7684\u63a7\u5236\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u9a6c\u5c3e\uff0c[npc.she]\u80fd\u591f\u56db\u5904\u6446\u8361\uff0c\u4f46\u6b64\u5916\u4e0d\u80fd\u8fdb\u884c\u66f4\u7cbe\u5bc6\u7684\u63a7\u5236\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_TYPE_HAIR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        DEMON_OVIPOSITOR = new AbstractTailType(BodyCoveringType.DEMON_COMMON, Race.DEMON, PenetrationGirth.THREE_AVERAGE, 0.75f, "\u6076\u9b54(\u4ea7\u5375\u5668)", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u53ef\u4ea7\u5375", "\u6076\u9b54"), Util.newArrayListOfValues("\u53ef\u4ea7\u5375", "\u6076\u9b54"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u53ef\u4ea7\u5375"), Util.newArrayListOfValues("\u53ef\u4ea7\u5375"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u5c16\u5934\u7684\u6076\u9b54\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002\u672b\u7aef\u5fae\u5fae\u81a8\u80c0\u6210\u4e00\u4e2a\u5c16\u72b6\u9f13\u5305\uff0c\u800c\u5c16\u7aef\u6709\u7740\u7d27\u7ef7\u7684\u5341\u5b57\u5f62\u72ed\u7f1d\u3002[npc.Name]\u53d1\u51fa\u4e00\u58f0[npc.a_moan]\uff0c\u4eff\u4f5b\u672c\u80fd\u822c\u5f97\u77e5\u8fd9\u6761\u5c3e\u5df4\u53ef\u4ee5\u7528\u505a\u4ea7\u5375\u5668\u3002[npc.she]\u5c06[npc.tail]\u56db\u5904\u6446\u52a8\uff0c\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4eff\u4f5b\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709#IF(npc.isShortStature())\u4e00\u6761[style.boldImp(\u53ef\u4ea7\u5375\u7684\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE\u4e00\u6761[style.boldDemon(\u53ef\u4ea7\u5375\u7684\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u5c16\u5934\u7684\u6076\u9b54\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002\u6bcf\u4e00\u6761\u7684\u672b\u7aef\u90fd\u5fae\u5fae\u81a8\u80c0\u6210\u4e00\u4e2a\u5c16\u72b6\u9f13\u5305\uff0c\u800c\u5c16\u7aef\u6709\u7740\u7d27\u7ef7\u7684\u5341\u5b57\u5f62\u72ed\u7f1d\u3002[npc.Name]\u53d1\u51fa\u4e00\u58f0[npc.a_moan]\uff0c\u4eff\u4f5b\u672c\u80fd\u822c\u5f97\u77e5\u8fd9\u4e9b\u5c3e\u5df4\u53ef\u4ee5\u7528\u505a\u4ea7\u5375\u5668\u3002[npc.she]\u5c06[npc.tails]\u56db\u5904\u6446\u52a8\uff0c\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u968f\u5fc3\u6240\u6b32\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4eff\u4f5b\u62e5\u6709\u4e86\u989d\u5916\u7684\u80a2\u4f53\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761#IF(npc.isShortStature())[style.boldImp(\u53ef\u4ea7\u5375\u7684\u5c0f\u6076\u9b54\u5c3e\u5df4)]#ELSE[style.boldDemon(\u53ef\u4ea7\u5375\u7684\u6076\u9b54\u5c3e\u5df4)]#ENDIF\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761\u5c16\u5934\u7684[npc.tailColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u5c3e\u5df4\u3002[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002\u672b\u7aef\u5fae\u5fae\u81a8\u80c0\u6210\u4e00\u4e2a\u5c16\u72b6\u9f13\u5305\uff0c\u800c\u5c16\u7aef\u6709\u7740\u7d27\u7ef7\u7684\u5341\u5b57\u5f62\u72ed\u7f1d\uff0c\u80fd\u591f\u7528\u4f5c\u4ea7\u5375\u5668\u3002#ELSE[npc.tailCount]\u6761\u5c16\u5934\u7684[npc.tailColour(true)]#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u5c3e\u5df4\u3002[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002\u672b\u7aef\u5fae\u5fae\u81a8\u80c0\u6210\u4e00\u4e2a\u5c16\u72b6\u9f13\u5305\uff0c\u800c\u5c16\u7aef\u6709\u7740\u7d27\u7ef7\u7684\u5341\u5b57\u5f62\u72ed\u7f1d\uff0c\u80fd\u591f\u7528\u4f5c\u4ea7\u5375\u5668\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_SUITABLE_FOR_PENETRATION, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_SKIN, BodyPartTag.TAIL_TAPERING_LINEAR, BodyPartTag.TAIL_OVIPOSITOR), false){};
        ALLIGATOR_MORPH = new AbstractTailType(BodyCoveringType.ALLIGATOR_SCALES, Race.ALLIGATOR_MORPH, PenetrationGirth.FIVE_THICK, 0.6f, "\u9cc4\u9c7c", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u9cc4\u9c7c\u822c"), Util.newArrayListOfValues("\u9cc4\u9c7c\u822c"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "#IF(npc.getTailCount()==1)\u4e00\u6761\u9cde\u7247\u8986\u76d6\u7684\u9cc4\u9c7c\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u4f7f\u5176\u5e26\u7740\u5de8\u5927\u7684\u529b\u91cf\u6446\u52a8\u8d77\u6765\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4e00\u6761[style.boldAlligatorMorph(\u9cc4\u9c7c\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u9cde\u7247\u8986\u76d6\u7684\u9cc4\u9c7c\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u4f7f\u5176\u5e26\u7740\u5de8\u5927\u7684\u529b\u91cf\u6446\u52a8\u8d77\u6765\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldAlligatorMorph(\u9cc4\u9c7c\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u9cc4\u9c7c\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u4f7f\u5176\u5e26\u7740\u5de8\u5927\u7684\u529b\u91cf\u6446\u52a8\u8d77\u6765\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u9cc4\u9c7c\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u4f7f\u5176\u5e26\u7740\u5de8\u5927\u7684\u529b\u91cf\u6446\u52a8\u8d77\u6765\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_SUITABLE_FOR_PENETRATION, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_SCALES, BodyPartTag.TAIL_TAPERING_LINEAR, BodyPartTag.TAIL_ATTACK), false){};
        BAT_MORPH = new AbstractTailType(BodyCoveringType.BAT_SKIN, Race.BAT_MORPH, PenetrationGirth.ONE_SLENDER, 0.2f, "\u8759\u8760", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u8759\u8760\u822c"), Util.newArrayListOfValues("\u8759\u8760\u822c"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u6bdb\u8338\u8338"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u5c0f\u5de7\u7684\u8759\u8760\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u968f\u610f\u8f6c\u5411\u5404\u5904\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709\u4e00\u6761[style.boldBatMorph(\u8759\u8760\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u5c0f\u5de7\u7684\u8759\u8760\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u968f\u610f\u8f6c\u5411\u5404\u5904\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldBatMorph(\u8759\u8760\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u8759\u8760\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u8fc5\u901f\u5730\u5c06\u5176\u4e0a\u4e0b\u79fb\u52a8\uff0c\u6709\u5229\u4e8e\u4fdd\u6301\u5e73\u8861\uff0c\u5e76\u5728\u6218\u6597\u4e2d\u534f\u52a9\u884c\u52a8\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u8759\u8760\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u8fc5\u901f\u5730\u5c06\u5176\u4e0a\u4e0b\u79fb\u52a8\uff0c\u6709\u5229\u4e8e\u4fdd\u6301\u5e73\u8861\uff0c\u5e76\u5728\u6218\u6597\u4e2d\u534f\u52a9\u884c\u52a8\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_TYPE_GENERIC, BodyPartTag.TAIL_TAPERING_NONE), false){};
        CAT_MORPH = new AbstractTailType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, PenetrationGirth.TWO_NARROW, 0.8f, "\u732b\u7c7b", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u732b\u4e00\u822c", "\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u732b\u4e00\u822c", "\u6bdb\u8338\u8338"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u6bdb\u8338\u8338"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6bdb\u8338\u8338\u7684\u732b\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u968f\u610f\u8f6c\u5411\u5404\u5904\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u6bdb\u8338\u8338\u7684\u732b\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u968f\u610f\u8f6c\u5411\u5404\u5904\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u732b\u5c3e\u5df4\uff0c\u80fd\u591f\u6709\u6548\u5730\u5e2e\u52a9[npc.herHim]\u4fdd\u6301\u5e73\u8861\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u732b\u5c3e\u5df4\uff0c\u80fd\u591f\u6709\u6548\u5730\u5e2e\u52a9[npc.herHim]\u4fdd\u6301\u5e73\u8861\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        CAT_MORPH_SHORT = new AbstractTailType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, PenetrationGirth.THREE_AVERAGE, 0.2f, "\u732b\u7c7b(\u77ed)", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u732b\u4e00\u822c", "\u77ed\u5c0f", "\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u732b\u4e00\u822c", "\u77ed\u5c0f", "\u6bdb\u8338\u8338"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u6bdb\u8338\u8338"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6bdb\u8338\u8338\u7684\u732b\u4e00\u822c\u7684\u77ed\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002\u867d\u7136[npc.She]\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4f46\u7531\u4e8e\u592a\u77ed\u4e86\uff0c\u505a\u4e0d\u4e86\u4ec0\u4e48\u4e8b\u60c5\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u77ed\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u6bdb\u8338\u8338\u7684\u732b\u4e00\u822c\u7684\u77ed\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002\u867d\u7136[npc.She]\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u4f46\u7531\u4e8e\u592a\u77ed\u4e86\uff0c\u505a\u4e0d\u4e86\u4ec0\u4e48\u4e8b\u60c5\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u77ed\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u77ed\u732b\u5c3e\uff0c#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u77ed\u732b\u5c3e\uff0c#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        CAT_MORPH_TUFTED = new AbstractTailType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, PenetrationGirth.THREE_AVERAGE, 0.4f, "\u732b\u7c7b(\u7c07\u72b6)", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u732b\u822c", "\u7c07\u72b6", "\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u732b\u822c", "\u7c07\u72b6", "\u6bdb\u8338\u8338"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u7c07\u72b6"), Util.newArrayListOfValues("\u7c07\u72b6"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6bdb\u8338\u8338\u7684\u732b\u4e00\u822c\u7684\u77ed\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002\u672b\u7aef\u6709\u4e00\u7c07\u677e\u8f6f\u7684\u76ae\u6bdb\uff0c[npc.she]\u80fd\u591f\u8fc5\u901f\u5730\u5c06\u5176\u4e0a\u4e0b\u5de6\u53f3\u79fb\u52a8\uff0c\u6709\u5229\u4e8e\u4fdd\u6301\u5e73\u8861\uff0c\u5e76\u5728\u6218\u6597\u4e2d\u534f\u52a9\u884c\u52a8\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c\u672b\u7aef\u957f\u7740\u4e00\u7c07\u76ae\u6bdb\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u6bdb\u8338\u8338\u7684\u732b\u4e00\u822c\u7684\u77ed\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002\u672b\u7aef\u6709\u4e00\u7c07\u677e\u8f6f\u7684\u76ae\u6bdb\uff0c[npc.she]\u80fd\u591f\u8fc5\u901f\u5730\u5c06\u5176\u4e0a\u4e0b\u5de6\u53f3\u79fb\u52a8\uff0c\u6709\u5229\u4e8e\u4fdd\u6301\u5e73\u8861\uff0c\u5e76\u5728\u6218\u6597\u4e2d\u534f\u52a9\u884c\u52a8\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldCatMorph(\u732b\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c\u672b\u7aef\u957f\u7740\u4e00\u7c07\u76ae\u6bdb\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u732b\u5c3e\u5df4\uff0c\u672b\u7aef\u957f\u7740\u4e00\u7c07\u76ae\u6bdb\u3002\u80fd\u591f\u6709\u6548\u5730\u5e2e\u52a9[npc.herHim]\u4fdd\u6301\u5e73\u8861#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u732b\u5c3e\u5df4\uff0c\u672b\u7aef\u957f\u7740\u4e00\u7c07\u76ae\u6bdb\u3002\u80fd\u591f\u6709\u6548\u5730\u5e2e\u52a9[npc.herHim]\u4fdd\u6301\u5e73\u8861#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        COW_MORPH = new AbstractTailType(BodyCoveringType.BOVINE_FUR, Race.COW_MORPH, PenetrationGirth.TWO_NARROW, 0.35f, "\u725b", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u725b\u4e00\u822c"), Util.newArrayListOfValues("\u725b\u4e00\u822c"), "\u672b\u7aef", "\u672b\u7aef", Util.newArrayListOfValues("\u7c07\u72b6\u6bdb\u53d1"), Util.newArrayListOfValues("\u7c07\u72b6\u6bdb\u53d1"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u725b\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\uff0c\u5782\u8361\u5728\u8eab\u540e\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u5de6\u53f3\u6447\u6446\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldCowMorph(\u725b\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u725b\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\uff0c\u5782\u8361\u5728\u8eab\u540e\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u5de6\u53f3\u6447\u6446\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldCowMorph(\u725b\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u725b\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u56db\u5904\u6446\u8361\uff0c\u4f46\u6b64\u5916\u4e0d\u80fd\u8fdb\u884c\u66f4\u7cbe\u5bc6\u7684\u63a7\u5236\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u725b\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u56db\u5904\u6446\u8361\uff0c\u4f46\u6b64\u5916\u4e0d\u80fd\u8fdb\u884c\u66f4\u7cbe\u5bc6\u7684\u63a7\u5236\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        DOG_MORPH = new AbstractTailType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, PenetrationGirth.THREE_AVERAGE, 0.4f, "\u72ac", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u72ac\u4e00\u822c"), Util.newArrayListOfValues("\u72ac\u4e00\u822c"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u6bdb\u8338\u8338"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6bdb\u8338\u8338\u7684\u72ac\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u5f88\u96be\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u53ea\u8981\u4e00\u6fc0\u52a8\u5c31\u4f1a\u4e0d\u53d7\u63a7\u5236\u5730\u6447\u6446\u8d77\u6765\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldDogMorph(\u72ac\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u6bdb\u8338\u8338\u7684\u72ac\u4e00\u822c\u7684\u77ed\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u5f88\u96be\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u53ea\u8981\u4e00\u6fc0\u52a8\u5c31\u4f1a\u4e0d\u53d7\u63a7\u5236\u5730\u6447\u6446\u8d77\u6765\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldDogMorph(\u72ac\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u72d7\u5c3e\u5df4\uff0c\u4e00\u6fc0\u52a8\u5c31\u4f1a\u4e0d\u53d7\u63a7\u5236\u5730\u6447\u6446\u8d77\u6765\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u72d7\u5c3e\u5df4\uff0c\u4e00\u6fc0\u52a8\u5c31\u4f1a\u4e0d\u53d7\u63a7\u5236\u5730\u6447\u6446\u8d77\u6765\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        DOG_MORPH_STUBBY = new AbstractTailType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, PenetrationGirth.THREE_AVERAGE, 0.1f, "\u72ac(\u7c97\u77ed)", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u7c97\u77ed", "\u72ac\u4e00\u822c"), Util.newArrayListOfValues("\u7c97\u77ed", "\u72ac\u4e00\u822c"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u7c97\u77ed"), Util.newArrayListOfValues("\u7c97\u77ed"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6bdb\u8338\u8338\u7684\u72ac\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u5f88\u96be\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u53ea\u8981\u4e00\u6fc0\u52a8\u5c31\u4f1a\u4e0d\u53d7\u63a7\u5236\u5730\u6447\u6446\u8d77\u6765\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldDogMorph(\u72ac\u4e00\u822c\u7684\u7c97\u77ed\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u6bdb\u8338\u8338\u7684\u72ac\u4e00\u822c\u7684\u77ed\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u5f88\u96be\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u53ea\u8981\u4e00\u6fc0\u52a8\u5c31\u4f1a\u4e0d\u53d7\u63a7\u5236\u5730\u6447\u6446\u8d77\u6765\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldDogMorph(\u72ac\u4e00\u822c\u7684\u7c97\u77ed\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF\u7c97\u77ed[npc.tailColour(true)]\u72d7\u5c3e\u5df4\uff0c\u4e00\u6fc0\u52a8\u5c31\u4f1a\u4e0d\u53d7\u63a7\u5236\u5730\u6447\u6446\u8d77\u6765\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF\u7c97\u77ed[npc.tailColour(true)]\u72d7\u5c3e\u5df4\uff0c\u4e00\u6fc0\u52a8\u5c31\u4f1a\u4e0d\u53d7\u63a7\u5236\u5730\u6447\u6446\u8d77\u6765\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        FOX_MORPH = new AbstractTailType(BodyCoveringType.FOX_FUR, Race.FOX_MORPH, PenetrationGirth.FOUR_GIRTHY, 0.6f, "\u72d0\u72f8", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u72d0\u72f8\u822c", "\u677e\u8f6f", "\u6d53\u5bc6"), Util.newArrayListOfValues("\u72d0\u72f8\u822c", "\u677e\u8f6f", "\u6d53\u5bc6"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u6bdb\u8338\u8338"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6d53\u5bc6\u7684\u72d0\u72f8\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u5c06\u8fd9\u6761\u677e\u8f6f\u7684\u4e1c\u897f\u8737\u7f29\u5728\u4e0b\u534a\u8eab\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldFoxMorph(\u72d0\u72f8\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.tailCount]\u6761\u6d53\u5bc6\u7684\u72d0\u72f8\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u5c06\u8fd9\u6761\u677e\u8f6f\u7684\u4e1c\u897f\u8737\u7f29\u5728\u4e0b\u534a\u8eab\u3002<br/>[npc.Name]\u62e5\u6709[npc.tailCount]\u6761[style.boldFoxMorph(\u72d0\u72f8\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u72d0\u72f8\u5c3e\u5df4\uff0c\u80fd\u591f\u968f\u610f\u7529\u52a8\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u72d0\u72f8\u5c3e\u5df4\uff0c\u80fd\u591f\u968f\u610f\u7529\u52a8\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        FOX_MORPH_MAGIC = new AbstractTailType(BodyCoveringType.FOX_FUR, Race.FOX_MORPH, PenetrationGirth.FOUR_GIRTHY, 1.0f, "\u72d0\u72f8(\u5965\u672f)", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u5965\u672f", "\u72d0\u72f8\u822c", "\u677e\u8f6f"), Util.newArrayListOfValues("\u5965\u672f", "\u72d0\u72f8\u822c", "\u677e\u8f6f"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u6bdb\u8338\u8338"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6d53\u5bc6\u7684\u72d0\u72f8\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u5c06\u8fd9\u6761\u677e\u8f6f\u7684\u4e1c\u897f\u8737\u7f29\u5728\u4e0b\u534a\u8eab\u3002[npc.SheIsFull]\u6e05\u695a\u5730\u611f\u53d7\u5230\u5c3e\u5df4\u7ed9\u4e88\u4e86[npc.herHim][style.italicsArcane(\u5965\u672f\u4e4b\u529b)]\uff0c\u800c\u5f97\u5230\u7684\u5c3e\u5df4\u8d8a\u591a\uff0c\u529b\u91cf\u4e5f\u5c31\u8d8a\u5f3a\u5927\uff01<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldFoxMorph(\u72d0\u72f8\u822c\u7684\u5c3e\u5df4)]\uff0c\u5145\u6ee1\u7740[style.boldArcane(\u5965\u672f)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.tailCount]\u6761\u6d53\u5bc6\u7684\u72d0\u72f8\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u5c06\u8fd9\u6761\u677e\u8f6f\u7684\u4e1c\u897f\u8737\u7f29\u5728\u4e0b\u534a\u8eab\u3002#IF(npc.getTailCount()==9)[npc.SheIsFull]\u6e05\u695a\u5730\u611f\u53d7\u5230\u5c3e\u5df4\u7ed9\u4e88\u4e86[npc.herHim][style.italicsExcellent(\u65e0\u7a77\u7684)][style.italicsArcane(\u5965\u672f\u4e4b\u529b)]\uff01#ELSE[npc.SheIsFull]\u6e05\u695a\u5730\u611f\u53d7\u5230\u5c3e\u5df4\u7ed9\u4e88\u4e86[npc.herHim][style.italicsArcane(\u5965\u672f\u4e4b\u529b)]\uff0c\u800c\u5f97\u5230\u7684\u5c3e\u5df4\u8d8a\u591a\uff0c\u529b\u91cf\u4e5f\u5c31\u8d8a\u5f3a\u5927\uff01#ENDIF<br/>[npc.Name]\u62e5\u6709[npc.tailCount]\u6761[style.boldFoxMorph(\u72d0\u72f8\u822c\u7684\u5c3e\u5df4)]\uff0c\u5145\u6ee1\u7740[style.boldArcane(\u5965\u672f)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)][style.boldArcane(\u5965\u672f)]\u72d0\u72f8\u5c3e\u5df4\uff0c\u8d50\u4e88\u4e86[npc.herHim][style.italicsArcane(\u5965\u672f\u4e4b\u529b)]\uff01#ELSE#IF(npc.getTailCount()==9)[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u8759[style.boldArcane(\u5965\u672f)]\u72d0\u72f8\u5c3e\u5df4\uff0c\u8d50\u4e88\u4e86[npc.herHim][style.italicsExcellent(\u65e0\u7a77\u7684)][style.italicsArcane(\u5965\u672f\u4e4b\u529b)]\uff01#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)][style.boldArcane(\u5965\u672f)]\u72d0\u72f8\u5c3e\u5df4\uff0c\u8d50\u4e88\u4e86[npc.herHim][style.italicsArcane(\u5965\u672f\u4e4b\u529b)]\uff01#ENDIF#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        HARPY = new AbstractTailType(BodyCoveringType.FEATHERS, Race.HARPY, PenetrationGirth.FOUR_GIRTHY, 0.5f, "\u54c8\u6bd4(\u5c3e\u7fbd)", "\u7c07", "\u7c07", "\u5c3e\u7fbd", "\u5c3e\u7fbd", Util.newArrayListOfValues("\u534e\u4e3d", "\u9e1f\u4e00\u822c"), Util.newArrayListOfValues("\u534e\u4e3d", "\u9e1f\u4e00\u822c"), "\u672b\u7aef", "\u672b\u7aef", Util.newArrayListOfValues("\u7fbd\u6bdb"), Util.newArrayListOfValues("\u7fbd\u6bdb"), "#IF(npc.getTailCount()==1)\u4e00\u7c07\u6f02\u4eae\u7684\u5c3e\u7fbd\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u53d1\u73b0\u81ea\u5df1\u80fd\u5feb\u901f\u5730\u62ac\u653e\u65b0\u751f\u7684\u9e1f\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u6709\u5229\u4e8e\u4fdd\u6301\u5e73\u8861\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u7c07[style.boldHarpy(\u9e1f\u4e00\u822c\u7684\u54c8\u6bd4\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u7c07\u6f02\u4eae\u7684\u5c3e\u7fbd\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u53d1\u73b0\u81ea\u5df1\u80fd\u5feb\u901f\u5730\u62ac\u653e\u65b0\u751f\u7684\u9e1f\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u6709\u5229\u4e8e\u4fdd\u6301\u5e73\u8861\u3002<br/>[npc.Name]\u62e5\u6709[npc.tailCount]\u7c07[style.boldHarpy(\u9e1f\u4e00\u822c\u7684\u54c8\u6bd4\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u7c07#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF\u6f02\u4eae[npc.tailColour(true)]\u5c3e\u7fbd\uff0c[npc.she]\u80fd\u591f\u8fc5\u901f\u5730\u5c06\u5176\u4e0a\u4e0b\u79fb\u52a8\uff0c\u6709\u5229\u4e8e\u4fdd\u6301\u5e73\u8861\uff0c\u5e76\u5728\u6218\u6597\u4e2d\u534f\u52a9\u884c\u52a8\u3002#ELSE[npc.tailCount]\u7c07#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF\u6f02\u4eae[npc.tailColour(true)]\u5c3e\u7fbd\uff0c[npc.she]\u80fd\u591f\u8fc5\u901f\u5730\u5c06\u5176\u4e0a\u4e0b\u79fb\u52a8\uff0c\u6709\u5229\u4e8e\u4fdd\u6301\u5e73\u8861\uff0c\u5e76\u5728\u6218\u6597\u4e2d\u534f\u52a9\u884c\u52a8\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_FEATHER, BodyPartTag.TAIL_TAPERING_NONE, BodyPartTag.TAIL_NEVER_SUITABLE_FOR_PENETRATION), false){};
        HORSE_MORPH = new AbstractTailType(BodyCoveringType.HAIR_HORSE_HAIR, Race.HORSE_MORPH, PenetrationGirth.THREE_AVERAGE, 0.3f, "\u9a6c", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u9a6c\u4e00\u822c"), Util.newArrayListOfValues("\u9a6c\u4e00\u822c"), "\u672b\u7aef", "\u672b\u7aef", Util.newArrayListOfValues("\u84ec\u677e"), Util.newArrayListOfValues("\u84ec\u677e"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u9a6c\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\uff0c\u5782\u8361\u5728\u8eab\u540e\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u5de6\u53f3\u6447\u6446\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldHorseMorph(\u9a6c\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u9a6c\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\uff0c\u5782\u8361\u5728\u8eab\u540e\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u5de6\u53f3\u6447\u6446\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldHorseMorph(\u9a6c\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u9a6c\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u56db\u5904\u6446\u8361\uff0c\u4f46\u6b64\u5916\u4e0d\u80fd\u8fdb\u884c\u66f4\u7cbe\u5bc6\u7684\u63a7\u5236\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u9a6c\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u56db\u5904\u6446\u8361\uff0c\u4f46\u6b64\u5916\u4e0d\u80fd\u8fdb\u884c\u66f4\u7cbe\u5bc6\u7684\u63a7\u5236\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_TYPE_HAIR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        HORSE_MORPH_ZEBRA = new AbstractTailType(BodyCoveringType.HAIR_HORSE_HAIR, Race.HORSE_MORPH, PenetrationGirth.TWO_NARROW, 0.3f, "\u6591\u9a6c", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u6591\u9a6c\u822c"), Util.newArrayListOfValues("\u6591\u9a6c\u822c"), "\u672b\u7aef", "\u672b\u7aef", Util.newArrayListOfValues("\u7ed2\u6bdb\u5c16\u7aef"), Util.newArrayListOfValues("\u7ed2\u6bdb\u5c16\u7aef"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6591\u9a6c\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\uff0c\u5782\u8361\u5728\u8eab\u540e\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u5de6\u53f3\u6447\u6446\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldHorseMorph(\u6591\u9a6c\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u6591\u9a6c\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\uff0c\u5782\u8361\u5728\u8eab\u540e\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u5de6\u53f3\u6447\u6446\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldHorseMorph(\u6591\u9a6c\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u6591\u9a6c\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u56db\u5904\u6446\u8361\uff0c\u4f46\u6b64\u5916\u4e0d\u80fd\u8fdb\u884c\u66f4\u7cbe\u5bc6\u7684\u63a7\u5236\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u6591\u9a6c\u5c3e\u5df4\uff0c[npc.she]\u80fd\u591f\u56db\u5904\u6446\u8361\uff0c\u4f46\u6b64\u5916\u4e0d\u80fd\u8fdb\u884c\u66f4\u7cbe\u5bc6\u7684\u63a7\u5236\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_TYPE_HAIR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        RAT_MORPH = new AbstractTailType(BodyCoveringType.RAT_SKIN, Race.RAT_MORPH, PenetrationGirth.THREE_AVERAGE, 0.75f, "\u8001\u9f20", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u8001\u9f20\u822c"), Util.newArrayListOfValues("\u8001\u9f20\u822c"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "#IF(npc.getTailCount()==1)\u4e00\u6761\u7c97\u58ee\u7684\u8001\u9f20\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u968f\u610f\u8f6c\u5411\u5404\u5904\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldRatMorph(\u8001\u9f20\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u7c97\u58ee\u7684\u8001\u9f20\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u968f\u610f\u8f6c\u5411\u5404\u5904\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldRatMorph(\u8001\u9f20\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u8001\u9f20\u5c3e\u5df4\u3002[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u8001\u9f20\u5c3e\u5df4\u3002[npc.sheHasFull]\u80fd\u81ea\u5982\u5730\u638c\u63a7\u5176\u8fd0\u52a8\uff0c\u5e2e\u52a9[npc.herHim]\u6293\u63e1\u7269\u4f53\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_PREHENSILE, BodyPartTag.TAIL_SUITABLE_FOR_PENETRATION, BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_SKIN, BodyPartTag.TAIL_TAPERING_LINEAR), false){};
        RABBIT_MORPH = new AbstractTailType(BodyCoveringType.RABBIT_FUR, Race.RABBIT_MORPH, PenetrationGirth.FIVE_THICK, 0.075f, "\u5154\u5b50", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u5154\u5b50\u822c", "\u677e\u8f6f"), Util.newArrayListOfValues("\u5154\u5b50\u822c", "\u677e\u8f6f"), "\u6bdb\u56e2", "\u6bdb\u56e2", Util.newArrayListOfValues("\u677e\u8f6f"), Util.newArrayListOfValues("\u677e\u8f6f"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6bdb\u8338\u8338\u7684\u5154\u5b50\u822c\u7684\u5706\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u6839\u672c\u65e0\u6cd5\u63a7\u5236\u5206\u6beb\uff0c\u4f46\u8bf4\u767d\u4e86\u4e5f\u4e0d\u8fc7\u53ea\u662f\u4e00\u56e2\u6bdb\u7403\u800c\u5df2\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldRabbitMorph(\u5154\u5b50\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u6bdb\u8338\u8338\u7684\u5154\u5b50\u822c\u7684\u5706\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u6839\u672c\u65e0\u6cd5\u63a7\u5236\u5206\u6beb\uff0c\u4f46\u8bf4\u767d\u4e86\u4e5f\u4e0d\u8fc7\u53ea\u662f\u51e0\u56e2\u6bdb\u7403\u800c\u5df2\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldRabbitMorph(\u5154\u5b50\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u5154\u5b50\u5c3e\u5df4\uff0c\u53ea\u4e0d\u8fc7\u662f\u4e00\u5927\u56e2\u6bdb\u7403\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u5154\u5b50\u5c3e\u5df4\uff0c\u53ea\u4e0d\u8fc7\u662f\u51e0\u5927\u56e2\u6bdb\u7403\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE, BodyPartTag.TAIL_NEVER_SUITABLE_FOR_PENETRATION), false){};
        REINDEER_MORPH = new AbstractTailType(BodyCoveringType.REINDEER_FUR, Race.REINDEER_MORPH, PenetrationGirth.FOUR_GIRTHY, 0.05f, "\u9a6f\u9e7f", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u6bdb\u8338\u8338"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u9a6f\u9e7f\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u4e0a\u4e0b\u98a4\u52a8\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldReindeerMorph(\u9a6f\u9e7f\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u9a6f\u9e7f\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u7684\u63a7\u5236\u6709\u9650\uff0c\u53ea\u80fd\u4ee4\u5176\u4e0a\u4e0b\u98a4\u52a8\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldReindeerMorph(\u9a6f\u9e7f\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u9a6f\u9e7f\u5c3e\u5df4\uff0c\u53ea\u80fd\u4e0a\u4e0b\u98a4\u52a8\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u9a6f\u9e7f\u5c3e\u5df4\uff0c\u53ea\u80fd\u4e0a\u4e0b\u98a4\u52a8\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        SQUIRREL_MORPH = new AbstractTailType(BodyCoveringType.SQUIRREL_FUR, Race.SQUIRREL_MORPH, PenetrationGirth.FIVE_THICK, 1.0f, "\u677e\u9f20", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u677e\u9f20\u822c", "\u677e\u8f6f", "\u6d53\u5bc6"), Util.newArrayListOfValues("\u677e\u9f20\u822c", "\u677e\u8f6f", "\u6d53\u5bc6"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u6bdb\u8338\u8338"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6bdb\u8338\u8338\u7684\u677e\u9f20\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709\u60ca\u4eba\u7684[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u5feb\u901f\u79fb\u52a8\u65f6\u53ef\u4ee5\u7528\u6765\u4fdd\u6301\u5e73\u8861\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldSquirrelMorph(\u677e\u9f20\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u6bdb\u8338\u8338\u7684\u677e\u9f20\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709\u60ca\u4eba\u7684[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u80fd\u591f\u9002\u5f53\u5730\u63a7\u5236\u5176\u8fd0\u52a8\uff0c\u5feb\u901f\u79fb\u52a8\u65f6\u53ef\u4ee5\u7528\u6765\u4fdd\u6301\u5e73\u8861\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldSquirrelMorph(\u677e\u9f20\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u641c\u7d22\u90a3\u4e2a\u4e66\u5c3e\u5df4\uff0c\u80fd\u591f\u6709\u6548\u5730\u5e2e\u52a9[npc.herHim]\u4fdd\u6301\u5e73\u8861\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u641c\u7d22\u90a3\u4e2a\u4e66\u5c3e\u5df4\uff0c\u80fd\u591f\u6709\u6548\u5730\u5e2e\u52a9[npc.herHim]\u4fdd\u6301\u5e73\u8861\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        WOLF_MORPH = new AbstractTailType(BodyCoveringType.LYCAN_FUR, Race.WOLF_MORPH, PenetrationGirth.FOUR_GIRTHY, 0.4f, "\u72fc", "", "", "\u5c3e\u5df4", "\u5c3e\u5df4", Util.newArrayListOfValues("\u72fc\u4e00\u822c", "\u677e\u8f6f"), Util.newArrayListOfValues("\u72fc\u4e00\u822c", "\u677e\u8f6f"), "\u5c16\u7aef", "\u5c16\u7aef", Util.newArrayListOfValues("\u6bdb\u8338\u8338"), Util.newArrayListOfValues("\u6bdb\u8338\u8338"), "#IF(npc.getTailCount()==1)\u4e00\u6761\u6bdb\u8338\u8338\u7684\u72fc\u4e00\u822c\u7684\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u5bf9\u5176\u63a7\u5236\u6709\u9650\uff0c\u9700\u8981\u5927\u8d39\u5468\u7ae0\u624d\u80fd\u6297\u62d2\u60c5\u611f\u7684\u8868\u9732\u3002<br/>[npc.Name]\u62e5\u6709\u4e00\u6761[style.boldWolfMorph(\u72fc\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ELSE[npc.TailCount]\u6761\u6bdb\u8338\u8338\u7684\u72fc\u4e00\u822c\u7684\u77ed\u5c3e\u5df4\uff0c\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa\uff0c\u8fc5\u901f\u751f\u957f\u81f3\u5927\u6982\u6709[npc.tailLength]\u957f\u3002[npc.She]\u5f88\u5feb\u610f\u8bc6\u5230\u81ea\u5df1\u5bf9\u5176\u63a7\u5236\u6709\u9650\uff0c\u9700\u8981\u5927\u8d39\u5468\u7ae0\u624d\u80fd\u6297\u62d2\u60c5\u611f\u7684\u8868\u9732\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[npc.tailCount]\u6761[style.boldWolfMorph(\u72fc\u4e00\u822c\u7684\u5c3e\u5df4)]\uff0c[npc.materialDescriptor][npc.tailFullDescription(true)]\u3002#ENDIF", "[npc.sheHasFull]\u4ece\u5c3e\u690e\u5904\u5ef6\u4f38\u800c\u51fa#IF(npc.getTailCount()==1)\u4e00\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u72fc\u5c3e\u5df4\uff0c\u4e00\u6fc0\u52a8\u5c31\u4f1a\u6447\u6446\u8d77\u6765\u3002#ELSE[npc.tailCount]\u6761#IF(npc.isTailFeral())[style.colourFeral(\u517d\u6001\u7684)]#ENDIF[npc.tailColour(true)]\u72fc\u5c3e\u5df4\uff0c\u4e00\u6fc0\u52a8\u5c31\u4f1a\u6447\u6446\u8d77\u6765\u3002#ENDIF", Util.newArrayListOfValues(BodyPartTag.TAIL_SLEEP_HUGGING, BodyPartTag.TAIL_TYPE_FUR, BodyPartTag.TAIL_TAPERING_NONE), false){};
        tailToIdMap = new HashMap<AbstractTailType, String>();
        idToTailMap = new HashMap<String, AbstractTailType>();
        allTailTypes = new ArrayList<AbstractTailType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("tail")) continue;
                try {
                    AbstractTailType type = new AbstractTailType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allTailTypes.add(type);
                    tailToIdMap.put(type, id);
                    idToTailMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("tail")) continue;
                try {
                    AbstractTailType type = new AbstractTailType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allTailTypes.add(type);
                    tailToIdMap.put(type, id);
                    idToTailMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = TailType.class.getFields()) {
            if (!AbstractTailType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractTailType ct = (AbstractTailType)f.get(null);
                tailToIdMap.put(ct, f.getName());
                idToTailMap.put(f.getName(), ct);
                allTailTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allTailTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractTailType>>();
    }
}

