/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.body.abstractTypes.AbstractTongueType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.valueEnums.TongueModifier;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TongueType {
    public static AbstractTongueType HUMAN;
    public static AbstractTongueType ANGEL;
    public static AbstractTongueType DEMON_COMMON;
    public static AbstractTongueType DOG_MORPH;
    public static AbstractTongueType WOLF_MORPH;
    public static AbstractTongueType FOX_MORPH;
    public static AbstractTongueType CAT_MORPH;
    public static AbstractTongueType COW_MORPH;
    public static AbstractTongueType ALLIGATOR_MORPH;
    public static AbstractTongueType HORSE_MORPH;
    public static AbstractTongueType REINDEER_MORPH;
    public static AbstractTongueType HARPY;
    public static AbstractTongueType SQUIRREL_MORPH;
    public static AbstractTongueType RAT_MORPH;
    public static AbstractTongueType RABBIT_MORPH;
    public static AbstractTongueType BAT_MORPH;
    private static List<AbstractTongueType> allTongueTypes;
    private static Map<AbstractTongueType, String> tongueToIdMap;
    private static Map<String, AbstractTongueType> idToTongueMap;
    private static Map<AbstractRace, List<AbstractTongueType>> typesMap;

    public static AbstractTongueType getTongueTypeFromId(String id) {
        if (id.equals("IMP")) {
            return DEMON_COMMON;
        }
        if (id.equals("LYCAN")) {
            return WOLF_MORPH;
        }
        if (id.equals("TENGU")) {
            return HARPY;
        }
        id = Util.getClosestStringMatch(id, idToTongueMap.keySet());
        return idToTongueMap.get(id);
    }

    public static String getIdFromTongueType(AbstractTongueType tongueType) {
        return tongueToIdMap.get(tongueType);
    }

    public static List<AbstractTongueType> getAllTongueTypes() {
        return allTongueTypes;
    }

    public static List<AbstractTongueType> getTongueTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractTongueType> types = new ArrayList<AbstractTongueType>();
        for (AbstractTongueType type : TongueType.getAllTongueTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractTongueType(BodyCoveringType.TONGUE, Race.HUMAN, 3, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(new TongueModifier[0])){};
        ANGEL = new AbstractTongueType(BodyCoveringType.TONGUE, Race.ANGEL, 3, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u5929\u4f7f"), Util.newArrayListOfValues("\u5929\u4f7f"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(new TongueModifier[0])){};
        DEMON_COMMON = new AbstractTongueType(BodyCoveringType.TONGUE, Race.DEMON, 6, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u6076\u9b54"), Util.newArrayListOfValues("\u6076\u9b54"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(new TongueModifier[0])){};
        DOG_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.DOG_MORPH, 8, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u72ac\u4e00\u822c"), Util.newArrayListOfValues("\u72ac\u4e00\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u72ac\u4e00\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(TongueModifier.WIDE, TongueModifier.FLAT)){};
        WOLF_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.WOLF_MORPH, 8, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u72fc\u4e00\u822c"), Util.newArrayListOfValues("\u72fc\u4e00\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u72fc\u4e00\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(TongueModifier.WIDE, TongueModifier.FLAT)){};
        FOX_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.FOX_MORPH, 6, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u72d0\u72f8\u822c"), Util.newArrayListOfValues("\u72d0\u72f8\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u72d0\u72f8\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(TongueModifier.FLAT)){};
        CAT_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.CAT_MORPH, 6, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u732b\u4e00\u822c"), Util.newArrayListOfValues("\u732b\u4e00\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u732b\u4e00\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(TongueModifier.FLAT)){};
        COW_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.COW_MORPH, 12, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u725b\u4e00\u822c"), Util.newArrayListOfValues("\u725b\u4e00\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u725b\u4e00\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(TongueModifier.STRONG)){};
        ALLIGATOR_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.ALLIGATOR_MORPH, 6, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u9cc4\u9c7c\u822c"), Util.newArrayListOfValues("\u9cc4\u9c7c\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u9cc4\u9c7c\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(TongueModifier.STRONG)){};
        HORSE_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.HORSE_MORPH, 8, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u9a6c\u4e00\u822c"), Util.newArrayListOfValues("\u9a6c\u4e00\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u9a6c\u4e00\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(TongueModifier.STRONG)){};
        REINDEER_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.REINDEER_MORPH, 8, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), Util.newArrayListOfValues("\u9a6f\u9e7f\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u9a6f\u9e7f\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(TongueModifier.STRONG)){};
        HARPY = new AbstractTongueType(BodyCoveringType.TONGUE, Race.HARPY, 6, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u9e1f\u4e00\u822c"), Util.newArrayListOfValues("\u9e1f\u4e00\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u9e1f\u4e00\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(TongueModifier.FLAT)){};
        SQUIRREL_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.SQUIRREL_MORPH, 6, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u677e\u9f20\u822c"), Util.newArrayListOfValues("\u677e\u9f20\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u677e\u9f20\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(new TongueModifier[0])){};
        RAT_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.RAT_MORPH, 6, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u8001\u9f20\u822c"), Util.newArrayListOfValues("\u8001\u9f20\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u8001\u9f20\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(new TongueModifier[0])){};
        RABBIT_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.RABBIT_MORPH, 6, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u5154\u5b50\u822c"), Util.newArrayListOfValues("\u5154\u5b50\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u5154\u5b50\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(new TongueModifier[0])){};
        BAT_MORPH = new AbstractTongueType(BodyCoveringType.TONGUE, Race.BAT_MORPH, 6, "\u820c\u5934", "\u820c\u5934", Util.newArrayListOfValues("\u8759\u8760\u822c"), Util.newArrayListOfValues("\u8759\u8760\u822c"), "[npc.Her]\u7684\u5634\u91cc\u6709\u4e00\u6839\u8759\u8760\u822c[npc.a_tongueLength]\u7684[npc.tongue]\uff0c\u5448\u73b0[npc.tongueColour(true)]#IF(npc.isPiercedTongue())\uff0c\u4e14\u5df2\u7ecf\u7a7f\u5b54#ENDIF\u3002", Util.newArrayListOfValues(new TongueModifier[0])){};
        tongueToIdMap = new HashMap<AbstractTongueType, String>();
        idToTongueMap = new HashMap<String, AbstractTongueType>();
        allTongueTypes = new ArrayList<AbstractTongueType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("tongue")) continue;
                try {
                    AbstractTongueType type = new AbstractTongueType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allTongueTypes.add(type);
                    tongueToIdMap.put(type, id);
                    idToTongueMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("tongue")) continue;
                try {
                    AbstractTongueType type = new AbstractTongueType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allTongueTypes.add(type);
                    tongueToIdMap.put(type, id);
                    idToTongueMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = TongueType.class.getFields()) {
            if (!AbstractTongueType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractTongueType ct = (AbstractTongueType)f.get(null);
                tongueToIdMap.put(ct, f.getName());
                idToTongueMap.put(f.getName(), ct);
                allTongueTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allTongueTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractTongueType>>();
    }
}

