/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.types;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractTorsoType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TorsoType {
    public static AbstractTorsoType HUMAN;
    public static AbstractTorsoType DEMON_COMMON;
    public static AbstractTorsoType ANGEL;
    public static AbstractTorsoType COW_MORPH;
    public static AbstractTorsoType DOG_MORPH;
    public static AbstractTorsoType WOLF_MORPH;
    public static AbstractTorsoType FOX_MORPH;
    public static AbstractTorsoType CAT_MORPH;
    public static AbstractTorsoType SQUIRREL_MORPH;
    public static AbstractTorsoType RAT_MORPH;
    public static AbstractTorsoType RABBIT_MORPH;
    public static AbstractTorsoType BAT_MORPH;
    public static AbstractTorsoType ALLIGATOR_MORPH;
    public static AbstractTorsoType HORSE_MORPH;
    public static AbstractTorsoType REINDEER_MORPH;
    public static AbstractTorsoType HARPY;
    private static List<AbstractTorsoType> allTorsoTypes;
    private static Map<AbstractTorsoType, String> torsoToIdMap;
    private static Map<String, AbstractTorsoType> idToTorsoMap;
    private static Map<AbstractRace, List<AbstractTorsoType>> typesMap;

    public static AbstractTorsoType getTorsoTypeFromId(String id) {
        HashMap<String, String> torsoTypeConverterMap = new HashMap<String, String>();
        torsoTypeConverterMap.put("IMP", "DEMON_COMMON");
        torsoTypeConverterMap.put("CANINE_FUR", "DOG_MORPH");
        torsoTypeConverterMap.put("LYCAN_FUR", "LYCAN");
        torsoTypeConverterMap.put("LYCAN", "WOLF_MORPH");
        torsoTypeConverterMap.put("FELINE_FUR", "CAT_MORPH");
        torsoTypeConverterMap.put("SQUIRREL_FUR", "SQUIRREL_MORPH");
        torsoTypeConverterMap.put("HORSE_HAIR", "HORSE_MORPH");
        torsoTypeConverterMap.put("SLIME", "SLIME");
        torsoTypeConverterMap.put("FEATHERS", "HARPY");
        if (torsoTypeConverterMap.containsKey(id)) {
            id = (String)torsoTypeConverterMap.get(id);
        }
        id = Util.getClosestStringMatch(id, idToTorsoMap.keySet());
        return idToTorsoMap.get(id);
    }

    public static String getIdFromTorsoType(AbstractTorsoType torsoType) {
        return torsoToIdMap.get(torsoType);
    }

    public static List<AbstractTorsoType> getAllTorsoTypes() {
        return allTorsoTypes;
    }

    public static List<AbstractTorsoType> getTorsoTypes(AbstractRace r) {
        if (typesMap.containsKey(r)) {
            return typesMap.get(r);
        }
        ArrayList<AbstractTorsoType> types = new ArrayList<AbstractTorsoType>();
        for (AbstractTorsoType type : TorsoType.getAllTorsoTypes()) {
            if (type.getRace() != r) continue;
            types.add(type);
        }
        typesMap.put(r, types);
        return types;
    }

    static {
        Field[] fieldArray;
        HUMAN = new AbstractTorsoType(BodyCoveringType.HUMAN, Race.HUMAN, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u4eba\u7c7b\u76ae\u80a4\u6240\u8986\u76d6\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHuman(\u4eba\u7c7b)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        DEMON_COMMON = new AbstractTorsoType(BodyCoveringType.DEMON_COMMON, Race.DEMON, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab#IF(npc.isShortStature())\u5c0f\u6076\u9b54#ELSE\u6076\u9b54#ENDIF\u76ae\u80a4\u6240\u8986\u76d6\u3002\u6bd4\u901a\u5e38\u4eba\u7c7b\u7684\u76ae\u80a4\u8981\u7ec6\u817b\u8bb8\u591a\uff0c\u5168\u8eab\u7684\u8272\u8c03\u4e5f\u53d8\u5f97\u6781\u5176\u548c\u8c10\uff0c\u80fd\u591f\u51f8\u663e\u51fa[npc.her]\u7684\u8eab\u6750\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709#IF(npc.isShortStature())[style.boldImp(\u5c0f\u6076\u9b54)]#ELSE[style.boldDemon(\u6076\u9b54)]#ENDIF[npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        ANGEL = new AbstractTorsoType(BodyCoveringType.ANGEL, Race.ANGEL, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u5929\u4f7f\u76ae\u80a4\u6240\u8986\u76d6\u3002\u6bd4\u901a\u5e38\u4eba\u7c7b\u7684\u76ae\u80a4\u8981\u7ec6\u817b\u8bb8\u591a\uff0c\u5168\u8eab\u7684\u8272\u8c03\u4e5f\u53d8\u5f97\u6781\u5176\u548c\u8c10\uff0c\u80fd\u591f\u51f8\u663e\u51fa[npc.her]\u7684\u8eab\u6750\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldAngel(\u5929\u4f7f)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        COW_MORPH = new AbstractTorsoType(BodyCoveringType.BOVINE_FUR, Race.COW_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u88ab\u725b\u4e00\u822c\u7a0d\u77ed\u7684\u6bdb\u53d1\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u6bdb\u53d1\u6cb9\u4eae\u5149\u6ed1\uff0c\u867d\u7136\u6478\u4e0a\u53bb\u7a0d\u663e\u7c97\u7cd9\uff0c\u4f46\u80fd\u591f\u51f8\u663e\u51fa[npc.her]\u7684\u8eab\u6750\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldCowMorph(\u725b\u4e00\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        DOG_MORPH = new AbstractTorsoType(BodyCoveringType.CANINE_FUR, Race.DOG_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u72ac\u4e00\u822c\u7684\u76ae\u6bdb\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u76ae\u6bdb\u7d27\u8d34\u7740[npc.her]\u8eab\u6750\u7684\u7ebf\u6761\uff0c\u5149\u6ed1\u67d4\u987a\uff0c\u6478\u8d77\u6765\u5f88\u8212\u670d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldDogMorph(\u72ac\u4e00\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        WOLF_MORPH = new AbstractTorsoType(BodyCoveringType.LYCAN_FUR, Race.WOLF_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u72fc\u4e00\u822c\u7684\u76ae\u6bdb\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u76ae\u6bdb\u5728\u5173\u8282\u5904\u6709\u4e9b\u4e71\u84ec\u84ec\u7684\uff0c\u800c\u4e14\u76f8\u5f53\u5bc6\u96c6\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldWolfMorph(\u72fc\u4e00\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        FOX_MORPH = new AbstractTorsoType(BodyCoveringType.FOX_FUR, Race.FOX_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u72d0\u72f8\u822c\u7684\u76ae\u6bdb\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u76ae\u6bdb\u5728\u5173\u8282\u5904\u6709\u4e9b\u4e71\u84ec\u84ec\u7684\uff0c\u800c\u4e14\u76f8\u5f53\u5bc6\u96c6\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldFoxMorph(\u72d0\u72f8\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        CAT_MORPH = new AbstractTorsoType(BodyCoveringType.FELINE_FUR, Race.CAT_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u732b\u4e00\u822c\u7684\u76ae\u6bdb\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u76ae\u6bdb\u7d27\u8d34\u7740[npc.her]\u8eab\u6750\u7684\u7ebf\u6761\uff0c\u683c\u5916\u5730\u5149\u6ed1\u67d4\u987a\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldCatMorph(\u732b\u4e00\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        SQUIRREL_MORPH = new AbstractTorsoType(BodyCoveringType.SQUIRREL_FUR, Race.SQUIRREL_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u677e\u9f20\u822c\u7684\u76ae\u6bdb\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u76ae\u6bdb\u7d27\u8d34\u7740[npc.her]\u8eab\u6750\u7684\u7ebf\u6761\uff0c\u683c\u5916\u5730\u5149\u6ed1\u67d4\u987a\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldSquirrelMorph(\u677e\u9f20\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        RAT_MORPH = new AbstractTorsoType(BodyCoveringType.RAT_FUR, Race.RAT_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u8001\u9f20\u822c\u7684\u76ae\u6bdb\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u76ae\u6bdb\u7d27\u8d34\u7740[npc.her]\u8eab\u6750\u7684\u7ebf\u6761\uff0c\u4f46\u6478\u8d77\u6765\u6709\u4e9b\u7c97\u7cd9\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldRatMorph(\u8001\u9f20\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        RABBIT_MORPH = new AbstractTorsoType(BodyCoveringType.RABBIT_FUR, Race.RABBIT_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u5154\u5b50\u822c\u7684\u76ae\u6bdb\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u76ae\u6bdb\u7d27\u8d34\u7740[npc.her]\u8eab\u6750\u7684\u7ebf\u6761\uff0c\u683c\u5916\u5730\u5149\u6ed1\u67d4\u987a\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldRabbitMorph(\u5154\u5b50\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        BAT_MORPH = new AbstractTorsoType(BodyCoveringType.BAT_FUR, Race.BAT_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u8759\u8760\u822c\u7684\u76ae\u6bdb\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u76ae\u6bdb\u7d27\u8d34\u7740[npc.her]\u8eab\u6750\u7684\u7ebf\u6761\uff0c\u5149\u6ed1\u67d4\u987a\uff0c\u6478\u8d77\u6765\u5f88\u8212\u670d\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldBatMorph(\u8759\u8760\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        ALLIGATOR_MORPH = new AbstractTorsoType(BodyCoveringType.ALLIGATOR_SCALES, Race.ALLIGATOR_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u91cd\u53e0\u7684\u786c\u8d28\u9cde\u7247\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u9cde\u7247\u7d27\u8d34\u7740[npc.her]\u8eab\u6750\u7684\u7ebf\u6761\uff0c\u6478\u4e0a\u53bb\u5f88\u575a\u786c\uff0c\u987a\u7740\u65b9\u5411\u629a\u6478\u4e5f\u4f1a\u5f88\u5149\u6ed1\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldGatorMorph(\u722c\u884c\u52a8\u7269\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){

            @Override
            public boolean isDefaultPlural(GameCharacter gc) {
                return true;
            }
        };
        HORSE_MORPH = new AbstractTorsoType(BodyCoveringType.HORSE_HAIR, Race.HORSE_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u88ab\u9a6c\u4e00\u822c\u7a0d\u77ed\u7684\u6bdb\u53d1\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u6bdb\u53d1\u6cb9\u4eae\u5149\u6ed1\uff0c\u867d\u7136\u6478\u4e0a\u53bb\u7a0d\u663e\u7c97\u7cd9\uff0c\u4f46\u80fd\u591f\u51f8\u663e\u51fa[npc.her]\u7684\u8eab\u6750\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldHorseMorph(\u9a6c\u4e00\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        REINDEER_MORPH = new AbstractTorsoType(BodyCoveringType.REINDEER_FUR, Race.REINDEER_MORPH, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u88ab\u9a6f\u9e7f\u822c\u7a0d\u77ed\u7684\u6bdb\u53d1\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u6bdb\u53d1\u6cb9\u4eae\u5149\u6ed1\uff0c\u867d\u7136\u6478\u4e0a\u53bb\u7a0d\u663e\u7c97\u7cd9\uff0c\u4f46\u80fd\u591f\u51f8\u663e\u51fa[npc.her]\u7684\u8eab\u6750\u3002<br/>[npc.Name]\u73b0\u5728\u62e5\u6709[style.boldReindeerMorph(\u9a6f\u9e7f\u822c)][npc.skinFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){};
        HARPY = new AbstractTorsoType(BodyCoveringType.FEATHERS, Race.HARPY, Util.newArrayListOfValues(""), Util.newArrayListOfValues(""), "\u6ca1\u8fc7\u591a\u4e45\uff0c\u8f6c\u5316\u5c31\u6b65\u5165\u5c3e\u58f0\uff0c[npc.she]\u611f\u89c9\u7619\u75d2\u611f\u7ec8\u4e8e\u892a\u53bb\uff0c\u957f\u53f9\u4e00\u58f0\uff0c[npc.her]\u7684\u8eaf\u5e72\u73b0\u5728\u88ab\u91cd\u53e0\u7684\u7f8e\u4e3d\u7fbd\u6bdb\u6240\u8986\u76d6\u3002[npc.Her]\u65b0\u751f\u7684\u7fbd\u6bdb\u7d27\u8d34\u7740[npc.her]\u8eab\u6750\u7684\u7ebf\u6761\uff0c\u6478\u8d77\u6765\u683c\u5916\u5730\u5149\u6ed1\u67d4\u987a\u3002<br/>[npc.She]\u73b0\u5728\u62e5\u6709[style.boldHarpy(\u9e1f\u4e00\u822c)][npc.assholeFullDescription]\u3002", "[npc.Her]\u7684\u8eaf\u5e72\u770b\u4e0a\u53bb[npc.a_femininity(true)]\uff0c[npc.materialCompositionDescriptor][npc.skinFullDescription(true)]\u3002"){

            @Override
            public boolean isDefaultPlural(GameCharacter gc) {
                return true;
            }
        };
        torsoToIdMap = new HashMap<AbstractTorsoType, String>();
        idToTorsoMap = new HashMap<String, AbstractTorsoType>();
        allTorsoTypes = new ArrayList<AbstractTorsoType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("torso")) continue;
                try {
                    AbstractTorsoType type = new AbstractTorsoType(innerEntry.getValue(), entry.getKey(), true){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allTorsoTypes.add(type);
                    torsoToIdMap.put(type, id);
                    idToTorsoMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "bodyParts", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(innerEntry.getValue()).equals("torso")) continue;
                try {
                    AbstractTorsoType type = new AbstractTorsoType(innerEntry.getValue(), entry.getKey(), false){};
                    String id = innerEntry.getKey().replaceAll("bodyParts_", "");
                    allTorsoTypes.add(type);
                    torsoToIdMap.put(type, id);
                    idToTorsoMap.put(id, type);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        for (Field f : fieldArray = TorsoType.class.getFields()) {
            if (!AbstractTorsoType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractTorsoType ct = (AbstractTorsoType)f.get(null);
                torsoToIdMap.put(ct, f.getName());
                idToTorsoMap.put(f.getName(), ct);
                allTorsoTypes.add(ct);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(allTorsoTypes, (t1, t2) -> t1.getRace() == Race.NONE ? -1 : (t2.getRace() == Race.NONE ? 1 : t1.getRace().getName(false).compareTo(t2.getRace().getName(false))));
        typesMap = new HashMap<AbstractRace, List<AbstractTorsoType>>();
    }
}

