/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.settings.ContentPreferenceValue;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum AgeCategory {
    TEENS_LATE("\u5341\u516b\u4e5d\u5c81", 18, 20, PresetColour.AGE_TEENS, ContentPreferenceValue.FOUR_HIGH),
    TWENTIES_EARLY("\u4e8c\u5341\u51fa\u5934", 20, 23, PresetColour.AGE_TWENTIES, ContentPreferenceValue.FIVE_ABUNDANT),
    TWENTIES_MIDDLE("\u4e8c\u5341\u4e94\u516d", 23, 27, PresetColour.AGE_TWENTIES, ContentPreferenceValue.FIVE_ABUNDANT),
    TWENTIES_LATE("\u4e0d\u5230\u4e09\u5341", 27, 30, PresetColour.AGE_TWENTIES, ContentPreferenceValue.FOUR_HIGH),
    THIRTIES_EARLY("\u4e09\u5341\u51fa\u5934", 30, 33, PresetColour.AGE_THIRTIES, ContentPreferenceValue.THREE_AVERAGE),
    THIRTIES_MIDDLE("\u4e09\u5341\u4e94\u516d", 33, 37, PresetColour.AGE_THIRTIES, ContentPreferenceValue.THREE_AVERAGE),
    THIRTIES_LATE("\u4e0d\u5230\u56db\u5341", 37, 40, PresetColour.AGE_THIRTIES, ContentPreferenceValue.TWO_LOW),
    FORTIES_EARLY("\u56db\u5341\u51fa\u5934", 40, 43, PresetColour.AGE_FORTIES, ContentPreferenceValue.TWO_LOW),
    FORTIES_MIDDLE("\u56db\u5341\u4e94\u516d", 43, 47, PresetColour.AGE_FORTIES, ContentPreferenceValue.ONE_MINIMAL),
    FORTIES_LATE("\u4e0d\u5230\u4e94\u5341", 47, 50, PresetColour.AGE_FORTIES, ContentPreferenceValue.ONE_MINIMAL),
    FIFTIES_EARLY("\u4e94\u5341\u51fa\u5934", 50, 53, PresetColour.AGE_FIFTIES, ContentPreferenceValue.ONE_MINIMAL),
    FIFTIES_MIDDLE("\u4e94\u5341\u4e94\u516d", 53, 57, PresetColour.AGE_FIFTIES, ContentPreferenceValue.ZERO_NONE),
    FIFTIES_LATE("\u4e0d\u5230\u516d\u5341", 57, 60, PresetColour.AGE_FIFTIES, ContentPreferenceValue.ZERO_NONE),
    SIXTIES_EARLY("\u516d\u5341\u51fa\u5934", 60, 63, PresetColour.AGE_SIXTIES, ContentPreferenceValue.ZERO_NONE),
    SIXTIES_MIDDLE("\u516d\u5341\u4e94\u516d", 63, 67, PresetColour.AGE_SIXTIES, ContentPreferenceValue.ZERO_NONE),
    SIXTIES_LATE("\u4e0d\u5230\u4e03\u5341", 67, 70, PresetColour.AGE_SIXTIES, ContentPreferenceValue.ZERO_NONE),
    SIXTIES_PLUS("\u4e03\u5341\u5c81\u4ee5\u4e0a", 70, 100, PresetColour.AGE_SIXTIES, ContentPreferenceValue.ZERO_NONE);

    private String name;
    private int minimumAge;
    private int maximumAge;
    private Colour colour;
    private ContentPreferenceValue agePreferenceDefault;

    private AgeCategory(String name, int minimumAge, int maximumAge, Colour colour, ContentPreferenceValue agePreferenceDefault) {
        this.name = name;
        this.minimumAge = minimumAge;
        this.maximumAge = maximumAge;
        this.colour = colour;
        this.agePreferenceDefault = agePreferenceDefault;
    }

    public int getMinimumValue() {
        return this.minimumAge;
    }

    public int getMaximumValue() {
        return this.maximumAge;
    }

    public int getMedianValue() {
        return this.minimumAge + (this.maximumAge - this.minimumAge) / 2;
    }

    public static AgeCategory valueOf(int age) {
        if (age < TEENS_LATE.getMinimumValue()) {
            return TEENS_LATE;
        }
        for (AgeCategory f : AgeCategory.values()) {
            if (age < f.getMinimumValue() || age >= f.getMaximumValue()) continue;
            return f;
        }
        return SIXTIES_PLUS;
    }

    public String getName() {
        return this.name;
    }

    public Colour getColour() {
        return this.colour;
    }

    public ContentPreferenceValue getAgePreferenceDefault() {
        return this.agePreferenceDefault;
    }

    public static int getAgeFromPreferences(Gender gender) {
        AgeCategory category;
        try {
            category = Util.getRandomObjectFromWeightedMap(Main.getProperties().agePreferencesMap.get((Object)gender.getType()));
        }
        catch (Exception ex) {
            category = TWENTIES_MIDDLE;
        }
        if (category == null) {
            category = TWENTIES_MIDDLE;
        }
        int lowerBound = category.getMinimumValue();
        int upperBound = category.getMaximumValue();
        return lowerBound + Util.random.nextInt(upperBound - lowerBound);
    }
}

