/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum BodyHair {
    ZERO_NONE(0, "\u65e0", PresetColour.GENERIC_SIZE_ONE),
    ONE_STUBBLE(1, "\u77ed\u832c", PresetColour.GENERIC_SIZE_TWO),
    TWO_MANICURED(2, "\u9f50\u6574", PresetColour.GENERIC_SIZE_THREE),
    THREE_TRIMMED(3, "\u4fee\u526a\u8fc7", PresetColour.GENERIC_SIZE_FOUR),
    FOUR_NATURAL(4, "\u666e\u901a", PresetColour.GENERIC_SIZE_FIVE),
    FIVE_UNKEMPT(5, "\u51cc\u4e71", PresetColour.GENERIC_SIZE_SIX),
    SIX_BUSHY(6, "\u6d53\u5bc6", PresetColour.GENERIC_SIZE_SEVEN),
    SEVEN_WILD(7, "\u91ce\u86ee\u751f\u957f", PresetColour.GENERIC_SIZE_EIGHT);

    private int value;
    private String descriptor;
    private Colour colour;

    private BodyHair(int value, String descriptor, Colour colour) {
        this.value = value;
        this.descriptor = descriptor;
        this.colour = colour;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.descriptor;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static BodyHair getRandomBodyHair() {
        return BodyHair.values()[Util.random.nextInt(BodyHair.values().length)];
    }

    public static BodyHair getBodyHairFromValue(int value) {
        for (BodyHair bh : BodyHair.values()) {
            if (bh.getValue() != value) continue;
            return bh;
        }
        return ZERO_NONE;
    }
}

