/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.character.body.valueEnums.BodySize;
import com.lilithsthrone.game.character.body.valueEnums.Muscle;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.Util;
import java.util.List;
import javafx.scene.paint.Color;

public enum BodyShape {
    SKINNY_SOFT("\u7626\u524a", BodySize.ZERO_SKINNY, Muscle.ZERO_SOFT, Util.newArrayListOfValues("\u7ea4\u7ec6", "\u7ea4\u7626")),
    SKINNY_LIGHTLY_MUSCLED("\u7ea4\u7626", BodySize.ZERO_SKINNY, Muscle.ONE_LIGHTLY_MUSCLED, Util.newArrayListOfValues("\u7ea4\u7ec6", "\u7ea4\u7626")),
    SKINNY_TONED("\u8f7b\u76c8", BodySize.ZERO_SKINNY, Muscle.TWO_TONED, Util.newArrayListOfValues("\u7ea4\u7ec6")),
    SKINNY_MUSCULAR("\u7cbe\u7626", BodySize.ZERO_SKINNY, Muscle.THREE_MUSCULAR, Util.newArrayListOfValues("\u7ea4\u7626", "\u808c\u8089\u5206\u660e")),
    SKINNY_RIPPED("\u5065\u7f8e", BodySize.ZERO_SKINNY, Muscle.FOUR_RIPPED, Util.newArrayListOfValues("\u7ea4\u7ec6", "\u808c\u8089\u5206\u660e")),
    SLENDER_SOFT("\u82d7\u6761", BodySize.ONE_SLENDER, Muscle.ZERO_SOFT, Util.newArrayListOfValues("\u82d7\u6761", "\u7ea4\u7626")),
    SLENDER_LIGHTLY_MUSCLED("\u4fee\u7f8e", BodySize.ONE_SLENDER, Muscle.ONE_LIGHTLY_MUSCLED, Util.newArrayListOfValues("\u82d7\u6761", "\u7ea4\u7626")),
    SLENDER_TONED("\u7cbe\u5e72", BodySize.ONE_SLENDER, Muscle.TWO_TONED, Util.newArrayListOfValues("\u82d7\u6761", "\u7ea4\u7626", "\u808c\u8089\u5206\u660e")),
    SLENDER_MUSCULAR("\u7cbe\u58ee", BodySize.ONE_SLENDER, Muscle.THREE_MUSCULAR, Util.newArrayListOfValues("\u82d7\u6761", "\u808c\u8089\u5206\u660e")),
    SLENDER_RIPPED("\u77eb\u5065", BodySize.ONE_SLENDER, Muscle.FOUR_RIPPED, Util.newArrayListOfValues("\u82d7\u6761", "\u808c\u8089\u5206\u660e")),
    AVERAGE_SOFT("\u5706\u6da6", BodySize.TWO_AVERAGE, Muscle.ZERO_SOFT, Util.newArrayListOfValues("\u5706\u6da6", "\u808c\u8089\u677e\u5f1b")),
    AVERAGE_LIGHTLY_MUSCLED("\u5300\u79f0", BodySize.TWO_AVERAGE, Muscle.ONE_LIGHTLY_MUSCLED, Util.newArrayListOfValues("\u7a0d\u6709\u808c\u8089")),
    AVERAGE_TONED("\u534f\u8c03", BodySize.TWO_AVERAGE, Muscle.TWO_TONED, Util.newArrayListOfValues("\u808c\u8089\u5206\u660e")),
    AVERAGE_MUSCULAR("\u5065\u58ee", BodySize.TWO_AVERAGE, Muscle.THREE_MUSCULAR, Util.newArrayListOfValues("\u808c\u8089\u5206\u660e", "\u7ebf\u6761\u4f18\u7f8e")),
    AVERAGE_RIPPED("\u5f3a\u5065", BodySize.TWO_AVERAGE, Muscle.FOUR_RIPPED, Util.newArrayListOfValues("\u808c\u8089\u5206\u660e", "\u7ebf\u6761\u4f18\u7f8e", "\u5f3a\u58ee")),
    LARGE_SOFT("\u80a5\u80d6", BodySize.THREE_LARGE, Muscle.ZERO_SOFT, Util.newArrayListOfValues("\u5706\u6da6", "\u808c\u8089\u677e\u5f1b", "\u80a5\u80d6")),
    LARGE_LIGHTLY_MUSCLED("\u4e30\u6ee1", BodySize.THREE_LARGE, Muscle.ONE_LIGHTLY_MUSCLED, Util.newArrayListOfValues("\u5706\u6da6", "\u808c\u8089\u677e\u5f1b", "\u4e30\u6ee1")),
    LARGE_TONED("\u7ed3\u5b9e", BodySize.THREE_LARGE, Muscle.TWO_TONED, Util.newArrayListOfValues("\u7855\u5927", "\u5f3a\u58ee")),
    LARGE_MUSCULAR("\u58ee\u5b9e", BodySize.THREE_LARGE, Muscle.THREE_MUSCULAR, Util.newArrayListOfValues("\u7855\u5927", "\u7ebf\u6761\u4f18\u7f8e", "\u5f3a\u58ee")),
    LARGE_RIPPED("\u9b41\u68a7", BodySize.THREE_LARGE, Muscle.FOUR_RIPPED, Util.newArrayListOfValues("\u5e9e\u5927", "\u7ebf\u6761\u4f18\u7f8e", "\u5f3a\u58ee")),
    HUGE_SOFT("\u81c3\u80bf", BodySize.FOUR_HUGE, Muscle.ZERO_SOFT, Util.newArrayListOfValues("\u5706\u6da6", "\u808c\u8089\u677e\u5f1b", "\u80a5\u80d6")),
    HUGE_LIGHTLY_MUSCLED("\u80a5\u7855", BodySize.FOUR_HUGE, Muscle.ONE_LIGHTLY_MUSCLED, Util.newArrayListOfValues("\u80a5\u7855", "\u808c\u8089\u677e\u5f1b", "\u4e30\u6ee1")),
    HUGE_TONED("\u7c97\u58ee", BodySize.FOUR_HUGE, Muscle.TWO_TONED, Util.newArrayListOfValues("\u7855\u5927", "\u5f3a\u58ee")),
    HUGE_MUSCULAR("\u8180\u5927\u8170\u5706", BodySize.FOUR_HUGE, Muscle.THREE_MUSCULAR, Util.newArrayListOfValues("\u7855\u5927", "\u7ebf\u6761\u4f18\u7f8e", "\u5f3a\u58ee")),
    HUGE_RIPPED("\u864e\u80cc\u718a\u8170", BodySize.FOUR_HUGE, Muscle.FOUR_RIPPED, Util.newArrayListOfValues("\u5e9e\u5927", "\u7ebf\u6761\u4f18\u7f8e", "\u5f3a\u58ee"));

    private String name;
    private List<String> limbDescriptors;
    private BodySize relatedBodySize;
    private Muscle relatedMuscle;

    private BodyShape(String name, BodySize relatedBodySize, Muscle relatedMuscle, List<String> limbDescriptors) {
        this.name = name;
        this.relatedBodySize = relatedBodySize;
        this.relatedMuscle = relatedMuscle;
        this.limbDescriptors = limbDescriptors;
    }

    public String getName(boolean withDeterminer) {
        if (withDeterminer) {
            return UtilText.generateSingularDeterminer(this.name) + this.name;
        }
        return this.name;
    }

    public BodySize getRelatedBodySize() {
        return this.relatedBodySize;
    }

    public Muscle getRelatedMuscle() {
        return this.relatedMuscle;
    }

    public static BodyShape valueOf(Muscle muscle, BodySize bodySize) {
        for (BodyShape bs : BodyShape.values()) {
            if (muscle != bs.getRelatedMuscle() || bodySize != bs.getRelatedBodySize()) continue;
            return bs;
        }
        return AVERAGE_LIGHTLY_MUSCLED;
    }

    public Color getDerivedColor() {
        return Util.midpointColor(this.relatedBodySize.getColour().getColor(), this.relatedMuscle.getColour().getColor());
    }

    public String toWebHexStringColour() {
        return Util.toWebHexString(this.getDerivedColor());
    }

    public List<String> getLimbDescriptors() {
        return this.limbDescriptors;
    }
}

