/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum BodySize {
    ZERO_SKINNY("\u7626\u524a", 0, 20, PresetColour.BODY_SIZE_ZERO),
    ONE_SLENDER("\u82d7\u6761", 20, 40, PresetColour.BODY_SIZE_ONE),
    TWO_AVERAGE("\u5300\u79f0", 40, 60, PresetColour.BODY_SIZE_TWO),
    THREE_LARGE("\u7855\u5927", 60, 80, PresetColour.BODY_SIZE_THREE),
    FOUR_HUGE("\u5e9e\u5927", 80, 100, PresetColour.BODY_SIZE_FOUR);

    private String name;
    private int minimumBodySize;
    private int maximumBodySize;
    private Colour colour;

    private BodySize(String name, int minimumBodySize, int maximumBodySize, Colour colour) {
        this.name = name;
        this.minimumBodySize = minimumBodySize;
        this.maximumBodySize = maximumBodySize;
        this.colour = colour;
    }

    public int getMinimumValue() {
        return this.minimumBodySize;
    }

    public int getMaximumValue() {
        return this.maximumBodySize;
    }

    public int getMedianValue() {
        return this.minimumBodySize + (this.maximumBodySize - this.minimumBodySize) / 2;
    }

    public static BodySize valueOf(int bodySize) {
        for (BodySize f : BodySize.values()) {
            if (bodySize < f.getMinimumValue() || bodySize >= f.getMaximumValue()) continue;
            return f;
        }
        return FOUR_HUGE;
    }

    public String getName(boolean withDeterminer) {
        if (withDeterminer) {
            return UtilText.generateSingularDeterminer(this.name) + this.name;
        }
        return this.name;
    }

    public Colour getColour() {
        return this.colour;
    }
}

