/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.character.body.valueEnums.OrificeElasticity;
import com.lilithsthrone.game.character.body.valueEnums.OrificeModifier;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Capacity {
    ZERO_IMPENETRABLE("\u6781\u7d27", "\u7d27\u81f4", 0.0f, 1.0f, PresetColour.GENERIC_SIZE_ONE, false),
    ONE_EXTREMELY_TIGHT("\u7d27\u81f4", "\u7d27\u81f4", 1.0f, 2.0f, PresetColour.GENERIC_SIZE_TWO, false),
    TWO_TIGHT("\u7a0d\u7d27", "\u7d27\u81f4", 2.0f, 4.0f, PresetColour.GENERIC_SIZE_THREE, false),
    THREE_SLIGHTLY_LOOSE("\u7565\u677e", "\u677e\u57ae", 4.0f, 6.0f, PresetColour.GENERIC_SIZE_FOUR, false),
    FOUR_LOOSE("\u677e\u57ae", "\u677e\u57ae", 6.0f, 9.0f, PresetColour.GENERIC_SIZE_FIVE, false),
    FIVE_ROOMY("\u5f88\u677e", "\u677e\u57ae", 9.0f, 12.0f, PresetColour.GENERIC_SIZE_SIX, true){

        @Override
        public String getDescriptor() {
            if (!Main.game.isGapeContentEnabled()) {
                return FOUR_LOOSE.getDescriptor();
            }
            return super.getDescriptor();
        }

        @Override
        public Colour getColour() {
            if (!Main.game.isGapeContentEnabled()) {
                return FOUR_LOOSE.getColour();
            }
            return super.getColour();
        }
    }
    ,
    SIX_STRETCHED_OPEN("\u5f20\u5f00", "\u5f20\u5f00", 12.0f, 16.0f, PresetColour.GENERIC_SIZE_SEVEN, true){

        @Override
        public String getDescriptor() {
            if (!Main.game.isGapeContentEnabled()) {
                return FOUR_LOOSE.getDescriptor();
            }
            return super.getDescriptor();
        }

        @Override
        public Colour getColour() {
            if (!Main.game.isGapeContentEnabled()) {
                return FOUR_LOOSE.getColour();
            }
            return super.getColour();
        }
    }
    ,
    SEVEN_GAPING("\u5927\u5f20", "\u5f20\u5f00", 16.0f, 25.0f, PresetColour.GENERIC_SIZE_EIGHT, true){

        @Override
        public String getDescriptor() {
            if (!Main.game.isGapeContentEnabled()) {
                return FOUR_LOOSE.getDescriptor();
            }
            return super.getDescriptor();
        }

        @Override
        public Colour getColour() {
            if (!Main.game.isGapeContentEnabled()) {
                return FOUR_LOOSE.getColour();
            }
            return super.getColour();
        }
    };

    private String descriptor;
    private String speechDescriptor;
    private float minimumSizeComfortable;
    private float maximumSizeComfortable;
    private Colour colour;
    private boolean gapeContentRestricted;

    private Capacity(String descriptor, String speechDescriptor, float minimumSizeComfortable, float maximumSizeComfortable, Colour colour, boolean gapeContentRestricted) {
        this.descriptor = descriptor;
        this.speechDescriptor = speechDescriptor;
        this.minimumSizeComfortable = minimumSizeComfortable;
        this.maximumSizeComfortable = maximumSizeComfortable;
        this.colour = colour;
        this.gapeContentRestricted = gapeContentRestricted;
    }

    public float getMinimumValue() {
        return this.minimumSizeComfortable;
    }

    public float getMaximumValue(boolean withLube) {
        return this.maximumSizeComfortable * (withLube ? 1.05f : 1.0f);
    }

    public float getMedianValue() {
        return (this.minimumSizeComfortable + this.maximumSizeComfortable) / 2.0f;
    }

    public static Capacity getCapacityFromValue(float capacity) {
        for (Capacity c : Capacity.values()) {
            if (!(capacity >= c.getMinimumValue()) || !(capacity < c.getMaximumValue(false))) continue;
            return c;
        }
        return SEVEN_GAPING;
    }

    public static boolean isPenetrationDiameterTooSmall(Set<OrificeModifier> orificeModifiers, float capacity, float diameter) {
        return !orificeModifiers.contains((Object)OrificeModifier.MUSCLE_CONTROL) && diameter <= capacity * 0.6f;
    }

    public static boolean isPenetrationDiameterTooBig(OrificeElasticity elasticity, float capacity, float diameter, boolean lubed) {
        float maximumComfortableDiameter = Capacity.getMaximumComfortableDiameter(elasticity, capacity, lubed);
        return diameter > maximumComfortableDiameter;
    }

    public static float getMaximumComfortableDiameter(OrificeElasticity elasticity, float capacity, boolean lubed) {
        float tolerance = 1.01f + elasticity.getSizeTolerancePercentage();
        if (lubed) {
            tolerance += 0.1f;
        }
        return capacity * tolerance;
    }

    public String getDescriptor() {
        if (UtilText.isInSpeech()) {
            return this.speechDescriptor;
        }
        return this.descriptor;
    }

    public String getDescriptor(boolean coloured) {
        if (coloured) {
            return "<span style='color:" + this.getColour().toWebHexString() + ";'>" + this.getDescriptor() + "</span>";
        }
        return this.getDescriptor();
    }

    public Colour getColour() {
        return this.colour;
    }

    public static List<Capacity> getCapacityListFromPreferences() {
        ArrayList<Capacity> capacities = new ArrayList<Capacity>();
        for (Capacity value : Capacity.values()) {
            if (value.gapeContentRestricted && !Main.game.isGapeContentEnabled()) continue;
            capacities.add(value);
        }
        return capacities;
    }
}

