/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.List;

public enum Femininity {
    MASCULINE_STRONG(Util.newArrayListOfValues("\u5c3d\u663e\u7537\u6027\u98ce\u5ea6", "\u5341\u5206\u9633\u521a"), 0, 19, PresetColour.MASCULINE_PLUS, PresetColour.MASCULINE_PLUS_NPC),
    MASCULINE(Util.newArrayListOfValues("\u7565\u5e26\u7537\u6027\u98ce\u5ea6", "\u5145\u6ee1\u7537\u5b50\u6c14"), 20, 39, PresetColour.MASCULINE, PresetColour.MASCULINE_NPC),
    ANDROGYNOUS(Util.newArrayListOfValues("\u5341\u5206\u4e2d\u6027"), 40, 59, PresetColour.ANDROGYNOUS, PresetColour.ANDROGYNOUS_NPC),
    FEMININE(Util.newArrayListOfValues("\u7565\u6709\u5973\u6027\u97f5\u5473", "\u5145\u6ee1\u5973\u5b50\u6c14"), 60, 79, PresetColour.FEMININE, PresetColour.FEMININE_NPC),
    FEMININE_STRONG(Util.newArrayListOfValues("\u5145\u6ee1\u5973\u6027\u97f5\u5473", "\u5341\u5206\u9634\u67d4"), 80, 100, PresetColour.FEMININE_PLUS, PresetColour.FEMININE_PLUS_NPC);

    private List<String> names;
    private int minimumFemininity;
    private int maximumFemininity;
    private Colour colour;
    private Colour speechColour;

    private Femininity(List<String> names, int minimumFemininity, int maximumFemininity, Colour colour, Colour speechColour) {
        this.names = names;
        this.minimumFemininity = minimumFemininity;
        this.maximumFemininity = maximumFemininity;
        this.colour = colour;
        this.speechColour = speechColour;
    }

    public String getName(boolean withDeterminer) {
        String name = Util.randomItemFrom(this.names);
        if (withDeterminer) {
            return UtilText.generateSingularDeterminer(name) + name;
        }
        return name;
    }

    public List<String> getNames() {
        return this.names;
    }

    public int getMinimumFemininity() {
        return this.minimumFemininity;
    }

    public int getMaximumFemininity() {
        return this.maximumFemininity;
    }

    public int getMedianFemininity() {
        return this.minimumFemininity + (this.maximumFemininity - this.minimumFemininity) / 2;
    }

    public Colour getColour() {
        return this.colour;
    }

    public Colour getSpeechColour() {
        return this.speechColour;
    }

    public static Femininity valueOf(int femininity) {
        for (Femininity f : Femininity.values()) {
            if (femininity < f.getMinimumFemininity() || femininity > f.getMaximumFemininity()) continue;
            return f;
        }
        return FEMININE_STRONG;
    }

    public static String getFemininityName(int femininity, boolean withDeterminer) {
        return Femininity.valueOf(femininity).getName(withDeterminer);
    }

    public boolean isFeminine() {
        return this != MASCULINE && this != MASCULINE_STRONG;
    }
}

