/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum FluidExpulsion {
    ZERO_NONE("\u5fae\u91cf", 0, 20, PresetColour.GENERIC_SIZE_ONE),
    ONE_SMALL("\u5c11\u91cf", 20, 40, PresetColour.GENERIC_SIZE_TWO),
    TWO_MODERATE("\u4e2d\u91cf", 40, 60, PresetColour.GENERIC_SIZE_THREE),
    THREE_LARGE("\u5927\u91cf", 60, 80, PresetColour.GENERIC_SIZE_FOUR),
    FOUR_HUGE("\u5de8\u91cf", 80, 100, PresetColour.GENERIC_SIZE_FIVE);

    private int minimumValue;
    private int maximumValue;
    private String descriptor;
    private Colour colour;

    private FluidExpulsion(String descriptor, int minimumValue, int maximumValue, Colour colour) {
        this.descriptor = descriptor;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return this.minimumValue + (this.maximumValue - this.minimumValue) / 2;
    }

    public static FluidExpulsion getFluidExpulsionFromInt(int value) {
        for (FluidExpulsion expulsion : FluidExpulsion.values()) {
            if (value < expulsion.getMinimumValue() || value >= expulsion.getMaximumValue()) continue;
            return expulsion;
        }
        return FOUR_HUGE;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Colour getColour() {
        return this.colour;
    }
}

