/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.FluidInterface;
import com.lilithsthrone.game.character.effects.Addiction;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FluidModifier {
    VISCOUS(PresetColour.BASE_PURPLE_DARK, false, "\u7c98\u7a20", "\u5341\u5206\u7c98\u7a20\uff0c\u4f1a\u7f13\u6162\u5730\u6210\u5757\u6ef4\u843d\u800c\u4e0b\uff0c\u5982\u540c\u6d53\u539a\u7684\u7cd6\u871c\u4e00\u822c\u3002", "\u4f7f\u5f97\u8be5\u6db2\u4f53\u62e5\u6709\u56fa\u4f53\u548c\u6db2\u4f53\u4e4b\u95f4\u7684\u7c98\u7a20\u5ea6\u3002"),
    STICKY(PresetColour.BASE_YELLOW_LIGHT, false, "\u9ecf\u7cca\u7cca", "\u5341\u5206\u9ecf\u7cca\uff0c\u4e0d\u4f7f\u7528\u80a5\u7682\u5c31\u4e0d\u80fd\u6e05\u6d17\u5e72\u51c0\u3002", "\u4f7f\u5f97\u8be5\u6db2\u4f53\u80fd\u591f\u9ecf\u4f4f\u63a5\u89e6\u7684\u4efb\u4f55\u4e1c\u897f\u3002"),
    SLIMY(PresetColour.BASE_BLUE_LIGHT, false, "\u7c98\u6ed1", "\u62e5\u6709\u7c98\u6ed1\u3001\u6cb9\u8d28\u7684\u8d28\u611f\u3002", "\u4f7f\u5f97\u8be5\u6db2\u4f53\u611f\u89c9\u50cf\u7c98\u6db2\u3002"),
    BUBBLING(PresetColour.BASE_LILAC_LIGHT, false, "\u8d77\u6ce1", "\u5982\u78b3\u9178\u996e\u6599\u4e00\u822c\u4f1a\u8d77\u6c14\u6ce1\u3002", "\u4f7f\u5f97\u8be5\u6db2\u4f53\u4f1a\u50cf\u78b3\u9178\u996e\u6599\u4e00\u6837\u8d77\u6ce1\u3002"),
    MUSKY(PresetColour.BASE_TAN, true, "\u6c14\u5473\u6d53\u91cd", "\u62e5\u6709\u5f3a\u70c8\u7684\u6deb\u5473\u3002", "\u6c14\u5473\u6d53\u91cd\u7684\u7cbe\u6db2\u6216\u7231\u6db2\u5982\u679c\u5728\u6027\u4ea4\u4e2d\u6cbe\u67d3\u5728\u67d0\u4eba\u8eab\u4e0a\uff0c\u5219\u4f1a\u4f7f\u5176\u83b7\u5f97\u201c\u88ab\u6deb\u5473\u6807\u8bb0\u201d\u7684\u6548\u679c\u3002"),
    MINERAL_OIL(PresetColour.BASE_BLACK, true, "\u77ff\u7269\u6cb9", "\u5bcc\u542b\u4f1a\u6ecb\u6da6\u76ae\u80a4\u4f46\u8150\u8680\u6a61\u80f6\u5236\u54c1\u7684\u77ff\u7269\u8d28\u3002", "\u6df7\u5165\u77ff\u7269\u6cb9\u7684\u6db2\u4f53\u80fd\u591f\u8fc5\u901f\u878d\u5316\u907f\u5b55\u5957\uff0c\u5bfc\u81f4\u5176\u5728\u9ad8\u6f6e\u65f6\u7834\u88c2\u3002"),
    ALCOHOLIC(PresetColour.BASE_ORANGE, true, "\u9ad8\u5ea6\u9152\u7cbe", "\u542b\u6709\u9ad8\u5ea6\u9152\u7cbe\uff0c\u4f1a\u4f7f\u5f97\u559d\u4e0b\u8be5\u6db2\u4f53\u7684\u89d2\u8272\u9189\u9152\u3002", "\u542b\u9ad8\u5ea6\u9152\u7cbe\u7684\u6db2\u4f53\u4f1a\u6025\u5267\u589e\u52a0\u559d\u4e0b\u8be5\u6db2\u4f53\u89d2\u8272\u7684\u9189\u9152\u7b49\u7ea7\u3002"){

        @Override
        public String applyEffects(GameCharacter target, GameCharacter fluidProvider, float millilitres, FluidInterface fluid) {
            return target.incrementAlcoholLevel(millilitres * 0.001f);
        }
    }
    ,
    ALCOHOLIC_WEAK(PresetColour.BASE_ORANGE_LIGHT, true, "\u542b\u9152\u7cbe", "\u9152\u7cbe\u542b\u91cf\u8f83\u4f4e\uff0c\u4f46\u4e5f\u4f1a\u4f7f\u4eba\u9189\u9152\u3002", "\u542b\u9152\u7cbe\u7684\u6db2\u4f53\u4f1a\u589e\u52a0\u996e\u7528\u8005\u7684\u9189\u9152\u7b49\u7ea7\u3002"){

        @Override
        public String applyEffects(GameCharacter target, GameCharacter fluidProvider, float millilitres, FluidInterface fluid) {
            return target.incrementAlcoholLevel(millilitres * 1.0E-4f);
        }
    }
    ,
    ADDICTIVE(PresetColour.BASE_PINK, true, "\u6210\u763e\u6027", "\u6709\u6781\u9ad8\u7684\u6210\u763e\u6027\uff0c\u65e0\u8bba\u8c01\u53ea\u8981\u559d\u4e86\u592a\u591a\uff0c\u5c31\u4f1a\u8fc5\u901f\u5bf9\u5176\u4ea7\u751f\u4f9d\u8d56\u3002", "\u6210\u763e\u6027\u6db2\u4f53\u4f1a\u8ba9\u4efb\u4f55\u996e\u7528\u5b83\u4eec\u7684\u4eba\u5bf9\u8fd9\u79cd\u7279\u5b9a\u7c7b\u578b\u7684\u6db2\u4f53\u4e0a\u763e\u3002"){

        @Override
        public String applyEffects(GameCharacter target, GameCharacter fluidProvider, float millilitres, FluidInterface fluid) {
            boolean appendAddiction;
            if (target == null || fluidProvider == null) {
                return "";
            }
            if (target.isDoll()) {
                return "";
            }
            boolean curedWithdrawal = target.getAddiction(fluid.getType()) != null && Main.game.getMinutesPassed() - target.getAddiction(fluid.getType()).getLastTimeSatisfied() >= 1440L;
            boolean bl = appendAddiction = !Main.game.isInSex() || curedWithdrawal;
            if (target.addAddiction(new Addiction(fluid.getType(), Main.game.getMinutesPassed(), fluidProvider.getId()))) {
                return UtilText.parse(target, "<p style='padding:0; margin:0; text-align:center;'>\u7531\u4e8e" + (fluidProvider == null ? "" : (fluidProvider.equals(target) ? "[npc.her]\u7684" : UtilText.parse(fluidProvider, "[npc.namePos]\u7684", new ParserTag[0]))) + fluid.getName(fluidProvider) + "\uff0c[npc.name]\u53d1\u89c9\u81ea\u5df1\u6781\u5176[style.colourArcane(\u6e34\u671b)]<span style='color:" + fluid.getType().getRace().getColour().toWebHexString() + ";'>" + fluid.getType().getRace().getName(fluidProvider.getBody(), fluid.isFeral(fluidProvider)) + "</span>\u7684" + fluid.getName(fluidProvider) + "\uff01</p>", new ParserTag[0]);
            }
            target.setLastTimeSatisfiedAddiction(fluid.getType(), Main.game.getMinutesPassed());
            if (appendAddiction) {
                return UtilText.parse(target, fluidProvider, "<p style='padding:0; margin:0; text-align:center;'>[npc.NamePos]\u5bf9\u4e8e<span style='color:" + fluid.getType().getRace().getColour().toWebHexString() + ";'>" + fluid.getType().getRace().getName(fluidProvider.getBody(), fluid.isFeral(fluidProvider)) + "</span>" + fluid.getName(fluidProvider) + "\u7684[style.colourArcane(\u6e34\u6c42)]\u5f97\u5230\u4e86\u6ee1\u8db3\uff01" + (curedWithdrawal ? "[npc.She]\u611f\u6fc0\u7740" + (fluidProvider == null ? "" : UtilText.parse(fluidProvider, "[npc.name]", new ParserTag[0])) + "\uff0c\u80fd\u591f\u63d0\u4f9b\u7ed9[npc.herHim]\u6700\u9700\u8981\u7684\u4e1c\u897f\u2026\u2026" + (target.isSlave() ? target.incrementObedience(5.0f) : "") : "[npc.She]\u5e76\u6ca1\u6709\u53d7\u5230\u6212\u65ad\u53cd\u5e94\u7684\u5f71\u54cd\uff0c\u4f46\u4ecd\u65e7\u611f\u6fc0" + (fluidProvider == null ? "" : UtilText.parse(fluidProvider, "[npc.name]", new ParserTag[0])) + "\uff0c\u80fd\u591f\u7f13\u89e3[npc.her]\u7684\u763e\u611f\u2026\u2026") + "</p>", new ParserTag[0]);
            }
            return "";
        }
    }
    ,
    HALLUCINOGENIC(PresetColour.BASE_PINK_DEEP, true, "\u81f4\u5e7b\u6027", "\u4efb\u4f55\u6444\u5165\u8be5\u6db2\u4f53\u7684\u89d2\u8272\u90fd\u4f1a\u53d7\u5230\u81f4\u5e7b\u6548\u679c\uff0c\u8868\u73b0\u4e3a\u6ccc\u4e73\u76f8\u5173\u7684\u5e7b\u89c9\u6216\u6613\u53d7\u50ac\u7720\u6697\u793a\u7684\u5f71\u54cd\u3002", "\u62e5\u6709\u81f4\u5e7b\u6027\u7684\u6db2\u4f53\u4f1a\u5bfc\u81f4\u6444\u5165\u7684\u89d2\u8272\u7ecf\u5386\u4e00\u6bb5\u5e7b\u89c9\uff0c\u4f7f\u5176\u6027\u9ad8\u6f6e\u7684\u4f53\u9a8c\u88ab\u626d\u66f2\uff0c\u5e76\u4e14\u6709\u53ef\u80fd\u88ab\u50ac\u7720\u64cd\u63a7\u3002"){

        @Override
        public String applyEffects(GameCharacter target, GameCharacter fluidProvider, float millilitres, FluidInterface fluid) {
            if (target.hasPerkAnywhereInTree(Perk.DOLL_PHYSICAL_3)) {
                return "";
            }
            target.addPsychoactiveFluidIngested(fluid.getType());
            boolean appendPsychoactive = !target.hasStatusEffect(StatusEffect.PSYCHOACTIVE);
            target.addStatusEffect(StatusEffect.PSYCHOACTIVE, 21600);
            if (appendPsychoactive) {
                return UtilText.parse(target, "<p style='padding:0; margin:0; text-align:center;'>\u7531\u4e8e" + (fluidProvider == null ? "" : (fluidProvider.equals(target) ? "[npc.her]\u7684" : UtilText.parse(fluidProvider, "[npc.namePos]\u7684", new ParserTag[0]))) + fluid.getName(fluidProvider) + "\u81f4\u5e7b\u5c5e\u6027\uff0c[npc.name]<span style='color:" + PresetColour.PSYCHOACTIVE.toWebHexString() + ";'>\u9677\u5165\u5e7b\u89c9</span>\u4e86\uff01</p>", new ParserTag[0]);
            }
            return "";
        }
    };

    private Colour colour;
    private boolean specialEffects;
    private String name;
    private String description;
    private String briefDescription;

    private FluidModifier(Colour colour, boolean specialEffects, String name, String briefDescription, String description) {
        this.colour = colour;
        this.specialEffects = specialEffects;
        this.name = name;
        this.briefDescription = briefDescription;
        this.description = description;
    }

    public Colour getColour() {
        return this.colour;
    }

    public boolean isSpecialEffects() {
        return this.specialEffects;
    }

    public String getName() {
        return this.name;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAppliesSpecialEffects() {
        return this.description != null;
    }

    public String applyEffects(GameCharacter target, GameCharacter fluidProvider, float millilitres, FluidInterface fluid) {
        return "";
    }
}

