/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum FluidRegeneration {
    ZERO_SLOW("\u7f13\u6162", 0, 250, "\u7f13\u6162", PresetColour.GENERIC_SIZE_ONE),
    ONE_AVERAGE("\u9002\u4e2d", 250, 750, "", PresetColour.GENERIC_SIZE_TWO),
    TWO_FAST("\u5feb\u901f", 750, 5000, "\u5feb\u901f", PresetColour.GENERIC_SIZE_THREE),
    THREE_RAPID("\u6025\u901f", 5000, 100000, "\u6025\u901f", PresetColour.GENERIC_SIZE_FOUR),
    FOUR_VERY_RAPID("\u98de\u901f", 100000, 500000, "\u98de\u901f", PresetColour.GENERIC_SIZE_FIVE);

    private int minimumValue;
    private int maximumValue;
    private String name;
    private String verb;
    private Colour colour;
    public static int CUM_REGEN_DEFAULT;

    private FluidRegeneration(String name, int minimumValue, int maximumValue, String verb, Colour colour) {
        this.name = name;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.verb = verb;
        this.colour = colour;
    }

    public String getName() {
        return this.name;
    }

    public String getVerb() {
        return this.verb;
    }

    public static FluidRegeneration getFluidRegenerationFromInt(int value) {
        for (FluidRegeneration regeneration : FluidRegeneration.values()) {
            if (value < regeneration.getMinimumRegenerationValuePerDay() || value >= regeneration.getMaximumRegenerationValuePerDay()) continue;
            return regeneration;
        }
        return FOUR_VERY_RAPID;
    }

    public Colour getColour() {
        return this.colour;
    }

    public int getMinimumRegenerationValuePerDay() {
        return this.minimumValue;
    }

    public int getMaximumRegenerationValuePerDay() {
        return this.maximumValue;
    }

    public int getMedianRegenerationValuePerDay() {
        return this.minimumValue + (this.maximumValue - this.minimumValue) / 2;
    }

    static {
        CUM_REGEN_DEFAULT = 10000;
    }
}

