/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.body.valueEnums.HairLength;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HairStyle {
    NONE("\u81ea\u7136", Femininity.ANDROGYNOUS, HairLength.ZERO_BALD){

        @Override
        public String getName(Body body) {
            if (body != null && body.isFeral()) {
                if (body.getLegConfiguration() == LegConfiguration.AVIAN) {
                    return "\u7fbd\u72b6";
                }
                return "\u9b03\u6bdb\u72b6";
            }
            return super.getName(body);
        }
    }
    ,
    MESSY("\u51cc\u4e71", Femininity.ANDROGYNOUS, HairLength.ONE_VERY_SHORT),
    LOOSE("\u677e\u6563", Femininity.ANDROGYNOUS, HairLength.ONE_VERY_SHORT),
    CURLY("\u5377\u53d1", Femininity.ANDROGYNOUS, HairLength.ONE_VERY_SHORT),
    STRAIGHT("\u76f4\u53d1", Femininity.ANDROGYNOUS, HairLength.ONE_VERY_SHORT),
    SLICKED_BACK("\u5927\u80cc\u5934", Femininity.ANDROGYNOUS, HairLength.ONE_VERY_SHORT),
    SIDE_PARTED("\u4fa7\u5243", Femininity.ANDROGYNOUS, HairLength.ONE_VERY_SHORT),
    SIDECUT("\u4fa7\u5243", Femininity.ANDROGYNOUS, HairLength.TWO_SHORT),
    MOHAWK("\u83ab\u970d\u514b", Femininity.ANDROGYNOUS, HairLength.TWO_SHORT),
    DREADLOCKS("\u810f\u8fab", Femininity.ANDROGYNOUS, HairLength.TWO_SHORT),
    AFRO("\u7206\u70b8\u5934", Femininity.MASCULINE, HairLength.ONE_VERY_SHORT),
    TOPKNOT("\u9afb\u53d1", Femininity.MASCULINE, HairLength.THREE_SHOULDER_LENGTH),
    PIXIE("\u7cbe\u7075\u77ed\u53d1", Femininity.FEMININE, HairLength.TWO_SHORT),
    BUN("\u4e38\u5b50\u5934", Femininity.FEMININE, HairLength.THREE_SHOULDER_LENGTH),
    BOB_CUT("\u6ce2\u6ce2\u5934", Femininity.FEMININE, HairLength.THREE_SHOULDER_LENGTH),
    CHONMAGE("\u6708\u4ee3\u5934", Femininity.FEMININE, HairLength.THREE_SHOULDER_LENGTH),
    WAVY("\u6ce2\u6d6a\u957f\u53d1", Femininity.FEMININE, HairLength.THREE_SHOULDER_LENGTH),
    PONYTAIL("\u9a6c\u5c3e\u8fab", Femininity.FEMININE, HairLength.THREE_SHOULDER_LENGTH),
    LOW_PONYTAIL("\u4f4e\u9a6c\u5c3e", Femininity.FEMININE, HairLength.THREE_SHOULDER_LENGTH),
    TWIN_TAILS("\u53cc\u9a6c\u5c3e", Femininity.FEMININE, HairLength.THREE_SHOULDER_LENGTH),
    SIDE_BRAIDS("\u4fa7\u9ebb\u82b1\u8fab", Femininity.FEMININE, HairLength.THREE_SHOULDER_LENGTH),
    CHIGNON("\u4f4e\u9afb", Femininity.FEMININE, HairLength.FOUR_MID_BACK),
    BRAIDED("\u9ebb\u82b1\u8fab", Femininity.FEMININE, HairLength.FOUR_MID_BACK),
    TWIN_BRAIDS("\u53cc\u9ebb\u82b1\u8fab", Femininity.FEMININE, HairLength.FOUR_MID_BACK),
    CROWN_BRAID("\u51a0\u8fab\u53d1", Femininity.FEMININE, HairLength.FOUR_MID_BACK),
    DRILLS("\u516c\u4e3b\u5377\u53d1", Femininity.FEMININE, HairLength.FOUR_MID_BACK),
    HIME_CUT("\u59ec\u53d1", Femininity.FEMININE, HairLength.FOUR_MID_BACK),
    BIRD_CAGE("\u9e1f\u7b3c\u53d1", Femininity.FEMININE, HairLength.SEVEN_TO_FLOOR);

    private String descriptor;
    private Femininity femininity;
    private int minimumLengthRequired;

    private HairStyle(String descriptor, Femininity femininity, HairLength minimumLengthRequired) {
        this.descriptor = descriptor;
        this.femininity = femininity;
        this.minimumLengthRequired = minimumLengthRequired.getMinimumValue();
    }

    public String getName(GameCharacter owner) {
        if (owner == null) {
            return this.descriptor;
        }
        return this.getName(owner.getBody());
    }

    public String getName(Body body) {
        return this.descriptor;
    }

    public Femininity getFemininity() {
        return this.femininity;
    }

    public int getMinimumLengthRequired() {
        return this.minimumLengthRequired;
    }

    public static HairStyle getRandomHairStyle(boolean feminine, int hairLength) {
        ArrayList<HairStyle> availableStyles = new ArrayList<HairStyle>();
        for (HairStyle hs : HairStyle.values()) {
            if (hs.getFemininity() != Femininity.ANDROGYNOUS && hs.getFemininity().isFeminine() != feminine || hs.getMinimumLengthRequired() > hairLength) continue;
            availableStyles.add(hs);
        }
        if (Math.random() > (double)0.1f) {
            availableStyles.remove((Object)AFRO);
            availableStyles.remove((Object)SIDECUT);
            availableStyles.remove((Object)MOHAWK);
            availableStyles.remove((Object)HIME_CUT);
            availableStyles.remove((Object)CHONMAGE);
            availableStyles.remove((Object)DREADLOCKS);
            availableStyles.remove((Object)BIRD_CAGE);
            availableStyles.remove((Object)DRILLS);
        }
        return (HairStyle)((Object)availableStyles.get(Util.random.nextInt(availableStyles.size())));
    }
}

