/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum Height {
    NEGATIVE_THREE_MINIMUM("\u5996\u7cbe\u5927\u5c0f", 15, 61, PresetColour.GENERIC_SIZE_ONE),
    NEGATIVE_TWO_MINIMUM("\u5341\u5206\u8f83\u5c0f", 61, 106, PresetColour.GENERIC_SIZE_ONE),
    NEGATIVE_ONE_TINY("\u5a07\u5c0f", 106, 122, PresetColour.GENERIC_SIZE_ONE),
    ZERO_TINY("\u77ee\u5c0f", 122, 152, PresetColour.GENERIC_SIZE_ONE),
    ONE_SHORT("\u7a0d\u663e\u77ee\u5c0f", 152, 166, PresetColour.GENERIC_SIZE_TWO),
    TWO_AVERAGE("\u4e00\u822c\u8eab\u9ad8", 166, 183, PresetColour.GENERIC_SIZE_THREE),
    THREE_TALL("\u9ad8\u6311", 183, 198, PresetColour.GENERIC_SIZE_FOUR),
    FOUR_VERY_TALL("\u9ad8\u5927", 198, 214, PresetColour.GENERIC_SIZE_FIVE),
    FIVE_ENORMOUS("\u9ad8\u8038", 214, 228, PresetColour.GENERIC_SIZE_SIX),
    SIX_GIANT("\u5de8\u5927", 228, 274, PresetColour.GENERIC_SIZE_SEVEN),
    SEVEN_COLOSSAL("\u5e9e\u5927", 274, 366, PresetColour.GENERIC_SIZE_EIGHT);

    private int minimumValue;
    private int maximumValue;
    private String descriptor;
    private Colour colour;

    private Height(String descriptor, int minimumValue, int maximumValue, Colour colour) {
        this.descriptor = descriptor;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.colour = colour;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return (this.minimumValue + this.maximumValue) / 2;
    }

    public int getRandomValue() {
        return this.minimumValue + Util.random.nextInt(this.maximumValue - this.minimumValue);
    }

    public static int getShortStatureCutOff() {
        return ZERO_TINY.getMinimumValue();
    }

    public boolean isShortStature() {
        return this.getMinimumValue() < Height.getShortStatureCutOff();
    }

    public static int getFairySizeCutOff() {
        return NEGATIVE_TWO_MINIMUM.getMinimumValue();
    }

    public boolean isFairySized() {
        return this.getMinimumValue() < Height.getFairySizeCutOff();
    }

    public static int getMaximumHeightForCharacterCreation() {
        return 215;
    }

    public static Height getHeightFromInt(int centimeters) {
        for (Height cs : Height.values()) {
            if (centimeters < cs.getMinimumValue() || centimeters >= cs.getMaximumValue()) continue;
            return cs;
        }
        return SEVEN_COLOSSAL;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Colour getColour() {
        return this.colour;
    }
}

