/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum LipSize {
    ZERO_THIN(0, "\u7ea4\u8584", PresetColour.GENERIC_SIZE_ONE, false),
    ONE_AVERAGE(1, "\u4e2d\u7b49\u5927\u5c0f", PresetColour.GENERIC_SIZE_TWO, false),
    TWO_FULL(2, "\u9971\u6ee1", PresetColour.GENERIC_SIZE_THREE, false),
    THREE_PLUMP(3, "\u4e30\u6ee1", PresetColour.GENERIC_SIZE_FOUR, false),
    FOUR_HUGE(4, "\u8f83\u5927", PresetColour.GENERIC_SIZE_FIVE, false),
    FIVE_MASSIVE(5, "\u6781\u5927", PresetColour.GENERIC_SIZE_SIX, false),
    SIX_GIGANTIC(6, "\u5de8\u5927", PresetColour.GENERIC_SIZE_SEVEN, true),
    SEVEN_ABSURD(7, "\u5927\u5230\u79bb\u8c31", PresetColour.GENERIC_SIZE_EIGHT, true);

    private int value;
    private String descriptor;
    private Colour colour;
    private boolean impedesSpeech;

    private LipSize(int value, String descriptor, Colour colour, boolean impedesSpeech) {
        this.value = value;
        this.descriptor = descriptor;
        this.colour = colour;
        this.impedesSpeech = impedesSpeech;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.descriptor;
    }

    public static LipSize getLipSizeFromInt(int index) {
        for (LipSize ls : LipSize.values()) {
            if (index != ls.getValue()) continue;
            return ls;
        }
        return ZERO_THIN;
    }

    public static int getLargest() {
        int largest = LipSize.ZERO_THIN.value;
        for (LipSize ls : LipSize.values()) {
            largest = Math.max(largest, ls.value);
        }
        return largest;
    }

    public Colour getColour() {
        return this.colour;
    }

    public boolean isImpedesSpeech() {
        return this.impedesSpeech;
    }
}

