/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum Muscle {
    ZERO_SOFT("\u808c\u8089\u677e\u5f1b", 0, 20, PresetColour.MUSCLE_ZERO),
    ONE_LIGHTLY_MUSCLED("\u7a0d\u6709\u808c\u8089", 20, 40, PresetColour.MUSCLE_ONE),
    TWO_TONED("\u7565\u6709\u808c\u8089", 40, 60, PresetColour.MUSCLE_TWO),
    THREE_MUSCULAR("\u808c\u8089\u7d27\u81f4", 60, 80, PresetColour.MUSCLE_THREE),
    FOUR_RIPPED("\u808c\u8089\u53d1\u8fbe", 80, 100, PresetColour.MUSCLE_FOUR);

    private String name;
    private int minimumMuscle;
    private int maximumMuscle;
    private Colour colour;

    private Muscle(String name, int minimumMuscle, int maximumMuscle, Colour colour) {
        this.name = name;
        this.minimumMuscle = minimumMuscle;
        this.maximumMuscle = maximumMuscle;
        this.colour = colour;
    }

    public int getMinimumValue() {
        return this.minimumMuscle;
    }

    public int getMaximumValue() {
        return this.maximumMuscle;
    }

    public int getMedianValue() {
        return this.minimumMuscle + (this.maximumMuscle - this.minimumMuscle) / 2;
    }

    public static Muscle valueOf(int muscle) {
        for (Muscle f : Muscle.values()) {
            if (muscle < f.getMinimumValue() || muscle >= f.getMaximumValue()) continue;
            return f;
        }
        return FOUR_RIPPED;
    }

    public String getName(boolean withDeterminer) {
        if (withDeterminer) {
            return UtilText.generateSingularDeterminer(this.name) + this.name;
        }
        return this.name;
    }

    public Colour getColour() {
        return this.colour;
    }
}

