/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum OrificeDepth {
    ZERO_EXTREMELY_SHALLOW("\u6781\u6d45", 0, 0.5f, PresetColour.GENERIC_SIZE_ONE),
    ONE_SHALLOW("\u8f83\u6d45", 1, 0.75f, PresetColour.GENERIC_SIZE_TWO),
    TWO_AVERAGE("\u5e73\u5747\u6df1\u5ea6", 2, 1.0f, PresetColour.GENERIC_SIZE_THREE),
    THREE_SPACIOUS("\u8f83\u6df1", 3, 1.5f, PresetColour.GENERIC_SIZE_FOUR),
    FOUR_DEEP("\u8fc7\u6df1", 4, 2.0f, PresetColour.GENERIC_SIZE_FIVE),
    FIVE_VERY_DEEP("\u6781\u6df1", 5, 2.5f, PresetColour.GENERIC_SIZE_SIX),
    SIX_CAVERNOUS("\u6df1\u4e0d\u89c1\u5e95", 6, 3.0f, PresetColour.GENERIC_SIZE_SEVEN),
    SEVEN_FATHOMLESS("\u6df1\u4e0d\u53ef\u6d4b", 7, 4.0f, PresetColour.GENERIC_SIZE_EIGHT);

    private String descriptor;
    private int value;
    private float depthPercentage;
    private Colour colour;

    private OrificeDepth(String descriptor, int value, float depthPercentage, Colour colour) {
        this.descriptor = descriptor;
        this.value = value;
        this.depthPercentage = depthPercentage;
        this.colour = colour;
    }

    public static OrificeDepth getDepthFromInt(int value) {
        for (OrificeDepth oe : OrificeDepth.values()) {
            if (value != oe.getValue()) continue;
            return oe;
        }
        return SEVEN_FATHOMLESS;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getValue() {
        return this.value;
    }

    public float getDepthPercentage() {
        return this.depthPercentage;
    }

    public Colour getColour() {
        return this.colour;
    }
}

