/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

public enum OrificeElasticity {
    ZERO_UNYIELDING("\u50f5\u786c\u4e0d\u8212", 0, 0.025f, 0.0f, false, PresetColour.GENERIC_SIZE_ONE),
    ONE_RIGID("\u7d27\u7ef7\u96be\u5165", 1, 0.05f, 0.05f, false, PresetColour.GENERIC_SIZE_TWO),
    TWO_FIRM("\u7d27\u81f4\u8d34\u5408", 2, 0.1f, 0.1f, false, PresetColour.GENERIC_SIZE_THREE),
    THREE_FLEXIBLE("\u67d4\u97e7\u6709\u5ea6", 3, 0.15f, 0.15f, false, PresetColour.GENERIC_SIZE_FOUR),
    FOUR_LIMBER("\u7075\u6d3b\u67d4\u8f6f", 4, 0.2f, 0.2f, true, PresetColour.GENERIC_SIZE_FIVE),
    FIVE_STRETCHY("\u6269\u5f20\u81ea\u5982", 5, 0.25f, 0.25f, true, PresetColour.GENERIC_SIZE_SIX),
    SIX_SUPPLE("\u5f39\u6027\u5341\u8db3", 6, 0.3f, 0.25f, true, PresetColour.GENERIC_SIZE_SEVEN),
    SEVEN_ELASTIC("\u5f39\u6027\u65e0\u9650", 7, 0.5f, 0.25f, true, PresetColour.GENERIC_SIZE_EIGHT);

    private String descriptor;
    private int value;
    private float stretchModifier;
    private float sizeTolerancePercentage;
    private boolean extendingUncomfortableDepth;
    private Colour colour;

    private OrificeElasticity(String descriptor, int value, float stretchModifier, float sizeTolerancePercentage, boolean extendingUncomfortableDepth, Colour colour) {
        this.descriptor = descriptor;
        this.value = value;
        this.stretchModifier = stretchModifier;
        this.sizeTolerancePercentage = sizeTolerancePercentage;
        this.extendingUncomfortableDepth = extendingUncomfortableDepth;
        this.colour = colour;
    }

    public static OrificeElasticity getElasticityFromInt(int value) {
        for (OrificeElasticity oe : OrificeElasticity.values()) {
            if (value != oe.getValue()) continue;
            return oe;
        }
        return SEVEN_ELASTIC;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getValue() {
        return this.value;
    }

    public float getStretchModifier() {
        return this.stretchModifier;
    }

    public float getSizeTolerancePercentage() {
        return this.sizeTolerancePercentage;
    }

    public boolean isExtendingUncomfortableDepth() {
        return this.extendingUncomfortableDepth;
    }

    public Colour getColour() {
        return this.colour;
    }
}

