/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.body.valueEnums;

public enum TongueLength {
    ZERO_NORMAL("\u6b63\u5e38\u5927\u5c0f", 0, 5),
    ONE_LONG("\u8f83\u957f", 5, 10),
    TWO_VERY_LONG("\u5f88\u957f", 10, 20),
    THREE_EXTREMELY_LONG("\u6781\u957f", 20, 30),
    FOUR_ABSURDLY_LONG("\u957f\u5230\u79bb\u8c31", 30, 60);

    private int minimumValue;
    private int maximumValue;
    private String descriptor;

    private TongueLength(String descriptor, int minimumValue, int maximumValue) {
        this.descriptor = descriptor;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMedianValue() {
        return this.minimumValue + (this.maximumValue - this.minimumValue) / 2;
    }

    public static TongueLength getTongueLengthFromInt(int cm) {
        for (TongueLength ps : TongueLength.values()) {
            if (cm < ps.getMinimumValue() || cm >= ps.getMaximumValue()) continue;
            return ps;
        }
        return FOUR_ABSURDLY_LONG;
    }

    public String getDescriptor() {
        return this.descriptor;
    }
}

