/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.effects;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.CorruptionLevel;
import com.lilithsthrone.game.character.effects.PerkCategory;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.combat.spells.SpellSchool;
import com.lilithsthrone.game.combat.spells.SpellUpgrade;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPerk {
    private int renderingPriority;
    protected String name;
    private List<Colour> colours;
    private boolean equippableTrait;
    private Spell spell;
    private SpellUpgrade spellUpgrade;
    private SpellSchool school;
    private HashMap<AbstractAttribute, Integer> attributeModifiers;
    private PerkCategory perkCategory;
    protected String pathName;
    private String SVGString;
    private List<String> extraEffects;
    private List<String> modifiersList;

    public AbstractPerk(int renderingPriority, boolean major, String name, PerkCategory perkCategory, String pathName, Colour colour, HashMap<AbstractAttribute, Integer> attributeModifiers, List<String> extraEffects) {
        this(renderingPriority, major, name, perkCategory, pathName, colour, attributeModifiers, extraEffects, null, null, null);
    }

    public AbstractPerk(int renderingPriority, boolean major, String name, PerkCategory perkCategory, String pathName, Colour colour, HashMap<AbstractAttribute, Integer> attributeModifiers, List<String> extraEffects, Spell spell, SpellUpgrade spellUpgrade, SpellSchool school) {
        this(renderingPriority, major, name, perkCategory, pathName, Util.newArrayListOfValues(colour), attributeModifiers, extraEffects, spell, spellUpgrade, school);
    }

    public AbstractPerk(int renderingPriority, boolean major, String name, PerkCategory perkCategory, String pathName, List<Colour> colours, HashMap<AbstractAttribute, Integer> attributeModifiers, List<String> extraEffects, Spell spell, SpellUpgrade spellUpgrade, SpellSchool school) {
        this.renderingPriority = renderingPriority;
        this.name = name;
        this.colours = colours;
        this.equippableTrait = major;
        this.perkCategory = perkCategory;
        this.attributeModifiers = attributeModifiers;
        this.extraEffects = extraEffects != null ? extraEffects : new ArrayList<String>();
        this.pathName = pathName;
        if (pathName != null) {
            this.generateSVGImage(pathName, colours);
        }
        this.modifiersList = new ArrayList<String>();
        this.spell = spell;
        this.spellUpgrade = spellUpgrade;
        this.school = school;
    }

    public boolean equals(Object o) {
        return o instanceof AbstractPerk && ((AbstractPerk)o).getName(null).equals(this.getName(null)) && ((AbstractPerk)o).getAttributeModifiers(null) == this.getAttributeModifiers(null);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getName(null).hashCode();
        if (this.getAttributeModifiers(null) != null) {
            result = 31 * result + this.getAttributeModifiers(null).hashCode();
        }
        return result;
    }

    protected void generateSVGImage(String pathName, List<Colour> colours) {
        try {
            InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/" + pathName + ".svg");
            if (is == null) {
                System.err.println("Error! Perk icon file does not exist (Trying to read from '" + pathName + "')!");
            }
            this.SVGString = Util.inputStreamToString(is);
            this.SVGString = SvgUtil.colourReplacement(this.name.replaceAll(" ", ""), colours.get(0), colours.size() >= 2 ? colours.get(1) : null, colours.size() >= 3 ? colours.get(2) : null, this.SVGString);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isAlwaysAvailable() {
        return false;
    }

    public boolean isHiddenPerk() {
        return false;
    }

    public boolean isBackgroundPerk() {
        return false;
    }

    public String getName(GameCharacter owner) {
        return this.name;
    }

    public Colour getColour() {
        return this.colours.get(0);
    }

    public boolean isEquippableTrait() {
        return this.equippableTrait;
    }

    public abstract String getDescription(GameCharacter var1);

    public List<String> getModifiersAsStringList(GameCharacter character) {
        this.modifiersList.clear();
        if (this.getAttributeModifiers(character) != null) {
            for (Map.Entry<AbstractAttribute, Integer> e : this.getAttributeModifiers(character).entrySet()) {
                this.modifiersList.add(e.getKey().getFormattedValue(e.getValue().intValue()));
            }
        }
        return Util.mergeLists(this.modifiersList, this.getExtraEffects());
    }

    public final Map<AbstractAttribute, Integer> getAttributeModifiers(GameCharacter character) {
        return this.attributeModifiers;
    }

    public String applyPerkGained(GameCharacter character) {
        return "";
    }

    public String applyPerkLost(GameCharacter character) {
        return "";
    }

    public CorruptionLevel getAssociatedCorruptionLevel() {
        return CorruptionLevel.ZERO_PURE;
    }

    public int getRenderingPriority() {
        return this.renderingPriority;
    }

    public List<String> getExtraEffects() {
        return this.extraEffects;
    }

    public String getSVGString(GameCharacter owner) {
        return this.SVGString;
    }

    public PerkCategory getPerkCategory() {
        return this.perkCategory;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public SpellUpgrade getSpellUpgrade() {
        return this.spellUpgrade;
    }

    public SpellSchool getSchool() {
        return this.school;
    }
}

