/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.effects;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.valueEnums.BreastShape;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.effects.EffectBenefit;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffectCategory;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.moves.CombatMove;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.sex.LubricationType;
import com.lilithsthrone.game.sex.SexAreaInterface;
import com.lilithsthrone.game.sex.SexAreaOrifice;
import com.lilithsthrone.game.sex.SexAreaPenetration;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.script.ScriptException;
import org.w3c.dom.Document;

public abstract class AbstractStatusEffect {
    private boolean mod;
    private boolean fromExternalFile;
    private int renderingPriority;
    private StatusEffectCategory category;
    private EffectBenefit beneficial;
    private boolean renderInEffectsPanel;
    private boolean combatEffect;
    private boolean sexEffect;
    private boolean removeAtEndOfSex;
    private String name;
    private String description;
    private String pathName;
    private List<Colour> colourShades;
    private boolean requiresApplicationCheck;
    private int effectInterval;
    private int applicationLength;
    private boolean constantRefresh;
    private boolean shortConditionalCheck;
    private String applicationCondition;
    private String applyEffectString;
    private String applyRemovalString;
    private String applyPostRemovalString;
    private Map<AbstractAttribute, Float> attributeModifiers;
    private List<String> combatMoveIds;
    private List<String> spellIds;
    private List<ItemTag> tags;
    protected String SVGString;
    protected String pathNameUsedForRender;
    protected List<String> extraEffects;

    public AbstractStatusEffect(int renderingPriority, String name, String pathName, Colour colourShade, boolean beneficial, Map<AbstractAttribute, Float> attributeModifiers, List<String> extraEffects) {
        this(renderingPriority, name, pathName, colourShade, colourShade, colourShade, beneficial, attributeModifiers, extraEffects);
    }

    public AbstractStatusEffect(int renderingPriority, String name, String pathName, Colour colourShade, Colour colourShadeSecondary, boolean beneficial, Map<AbstractAttribute, Float> attributeModifiers, List<String> extraEffects) {
        this(renderingPriority, name, pathName, colourShade, colourShadeSecondary, colourShade, beneficial, attributeModifiers, extraEffects);
    }

    public AbstractStatusEffect(int renderingPriority, String name, String pathName, Colour colourShade, Colour colourShadeSecondary, Colour colourShadeTertiary, boolean beneficial, Map<AbstractAttribute, Float> attributeModifiers, List<String> extraEffects) {
        this(StatusEffectCategory.DEFAULT, renderingPriority, name, pathName, colourShade, colourShadeSecondary, colourShadeTertiary, beneficial, attributeModifiers, extraEffects);
    }

    public AbstractStatusEffect(StatusEffectCategory category, int renderingPriority, String name, String pathName, Colour colourShade, Colour colourShadeSecondary, Colour colourShadeTertiary, boolean beneficial, Map<AbstractAttribute, Float> attributeModifiers, List<String> extraEffects) {
        this.mod = false;
        this.fromExternalFile = false;
        this.category = category;
        this.renderingPriority = renderingPriority;
        this.name = name;
        this.description = "";
        this.pathName = pathName;
        this.SVGString = null;
        this.pathNameUsedForRender = null;
        this.colourShades = Util.newArrayListOfValues(colourShade, colourShadeSecondary, colourShadeTertiary);
        this.beneficial = beneficial ? EffectBenefit.BENEFICIAL : EffectBenefit.DETRIMENTAL;
        this.requiresApplicationCheck = true;
        this.renderInEffectsPanel = true;
        this.combatEffect = false;
        this.sexEffect = false;
        this.effectInterval = 0;
        this.applicationLength = -1;
        this.constantRefresh = false;
        this.shortConditionalCheck = false;
        this.applicationCondition = null;
        this.attributeModifiers = attributeModifiers == null ? new HashMap<AbstractAttribute, Float>() : attributeModifiers;
        this.spellIds = null;
        this.combatMoveIds = null;
        this.tags = new ArrayList<ItemTag>();
        this.extraEffects = extraEffects == null ? new ArrayList<String>() : extraEffects;
    }

    public AbstractStatusEffect(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.category = StatusEffectCategory.DEFAULT;
                if (coreElement.getOptionalFirstOf("category").isPresent()) {
                    try {
                        this.category = StatusEffectCategory.valueOf(coreElement.getMandatoryFirstOf("category").getTextContent());
                    }
                    catch (Exception ex) {
                        System.err.println("StatusEffect loading error in '" + XMLFile.getName() + "': category not recognised! (Set to DEFAULT)");
                    }
                }
                this.mod = mod;
                this.fromExternalFile = true;
                this.renderingPriority = Integer.valueOf(coreElement.getMandatoryFirstOf("renderingPriority").getTextContent());
                this.beneficial = EffectBenefit.valueOf(coreElement.getMandatoryFirstOf("beneficial").getTextContent());
                this.renderInEffectsPanel = Boolean.valueOf(coreElement.getMandatoryFirstOf("renderInEffectsPanel").getTextContent());
                this.combatEffect = Boolean.valueOf(coreElement.getMandatoryFirstOf("combatEffect").getTextContent());
                this.sexEffect = Boolean.valueOf(coreElement.getMandatoryFirstOf("sexEffect").getTextContent());
                this.tags = new ArrayList<ItemTag>();
                if (coreElement.getOptionalFirstOf("tags").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("tags").getAllOf("tag")) {
                        try {
                            this.tags.add(ItemTag.valueOf(e.getTextContent()));
                        }
                        catch (Exception ex) {
                            System.err.println("StatusEffect loading error in '" + XMLFile.getName() + "': ItemTag '" + e.getTextContent() + "' not recognised! (Not added)");
                        }
                    }
                }
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.description = coreElement.getMandatoryFirstOf("description").getTextContent();
                this.pathName = XMLFile.getParentFile().getAbsolutePath() + "/" + coreElement.getMandatoryFirstOf("imageName").getTextContent();
                this.SVGString = null;
                this.pathNameUsedForRender = null;
                Colour colourShade = PresetColour.getColourFromId(coreElement.getMandatoryFirstOf("colourPrimary").getTextContent());
                Colour colourShadeSecondary = null;
                if (coreElement.getOptionalFirstOf("colourSecondary").isPresent() && !coreElement.getMandatoryFirstOf("colourSecondary").getTextContent().isEmpty()) {
                    colourShadeSecondary = PresetColour.getColourFromId(coreElement.getMandatoryFirstOf("colourSecondary").getTextContent());
                }
                Colour colourShadeTertiary = null;
                if (coreElement.getOptionalFirstOf("colourTertiary").isPresent() && !coreElement.getMandatoryFirstOf("colourTertiary").getTextContent().isEmpty()) {
                    colourShadeTertiary = PresetColour.getColourFromId(coreElement.getMandatoryFirstOf("colourTertiary").getTextContent());
                }
                this.colourShades = Util.newArrayListOfValues(colourShade, colourShadeSecondary, colourShadeTertiary);
                this.attributeModifiers = new HashMap<AbstractAttribute, Float>();
                if (coreElement.getOptionalFirstOf("attributeModifiers").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("attributeModifiers").getAllOf("modifier")) {
                        this.attributeModifiers.put(Attribute.getAttributeFromId(e.getTextContent()), Float.valueOf(e.getAttribute("value")));
                    }
                }
                this.combatMoveIds = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("combatMoves").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("combatMoves").getAllOf("move")) {
                        this.combatMoveIds.add(e.getTextContent());
                    }
                }
                this.spellIds = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("spells").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("spells").getAllOf("spell")) {
                        this.spellIds.add(e.getTextContent());
                    }
                }
                this.extraEffects = new ArrayList<String>();
                if (coreElement.getOptionalFirstOf("extraEffects").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("extraEffects").getAllOf("effect")) {
                        this.extraEffects.add(e.getTextContent());
                    }
                }
                this.shortConditionalCheck = Boolean.valueOf(coreElement.getMandatoryFirstOf("applicationCondition").getAttribute("shortConditionalCheck"));
                this.applicationCondition = coreElement.getMandatoryFirstOf("applicationCondition").getTextContent();
                this.requiresApplicationCheck = !this.applicationCondition.trim().equals("false");
                if (coreElement.getOptionalFirstOf("applicationLength").isPresent()) {
                    this.applicationLength = Integer.valueOf(coreElement.getMandatoryFirstOf("applicationLength").getTextContent());
                    this.constantRefresh = Boolean.valueOf(coreElement.getMandatoryFirstOf("applicationLength").getAttribute("constantRefresh"));
                } else {
                    this.applicationLength = -1;
                    this.constantRefresh = false;
                }
                this.effectInterval = !coreElement.getMandatoryFirstOf("applyEffect").getAttribute("interval").isEmpty() ? Integer.valueOf(coreElement.getMandatoryFirstOf("applyEffect").getAttribute("interval")) : 0;
                this.applyEffectString = coreElement.getMandatoryFirstOf("applyEffect").getTextContent();
                this.applyRemovalString = coreElement.getMandatoryFirstOf("applyRemovalEffect").getTextContent();
                this.applyPostRemovalString = coreElement.getMandatoryFirstOf("applyPostRemovalEffect").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("StatusEffect was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public String getId() {
        return StatusEffect.getIdFromStatusEffect(this);
    }

    protected List<String> attributeModifiersToStringList(Map<AbstractAttribute, Float> attributeMap) {
        ArrayList<String> attributeModifiersList = new ArrayList<String>();
        if (attributeMap != null) {
            for (Map.Entry<AbstractAttribute, Float> e : attributeMap.entrySet()) {
                attributeModifiersList.add(e.getKey().getFormattedValue(e.getValue().floatValue()));
            }
        }
        return attributeModifiersList;
    }

    public boolean isRequiresApplicationCheck() {
        return this.requiresApplicationCheck;
    }

    public boolean isConditionsMet(GameCharacter target) {
        if (this.isFromExternalFile() && target != null && Main.game.isStarted()) {
            if (!this.shortConditionalCheck) {
                String parsedResult = UtilText.parse(Util.newArrayListOfValues(target), this.applicationCondition, true, new ArrayList<ParserTag>());
                parsedResult = parsedResult.replaceAll("\\s", "");
                return Boolean.valueOf(parsedResult.trim());
            }
            try {
                return UtilText.evaluateConditional(Util.newArrayListOfValues(target), null, this.applicationCondition, true);
            }
            catch (ScriptException e) {
                System.err.println("Conditional parsing (from status effect) error: " + this.applicationCondition);
                e.printStackTrace();
            }
        }
        if (!this.isFromExternalFile()) {
            this.requiresApplicationCheck = false;
        }
        return false;
    }

    public int getApplicationLength(GameCharacter target) {
        return this.applicationLength;
    }

    public boolean isConstantRefresh() {
        return this.constantRefresh;
    }

    public boolean renderInEffectsPanel() {
        return this.renderInEffectsPanel;
    }

    public boolean isCombatEffect() {
        return this.combatEffect;
    }

    public boolean isSexEffect() {
        return this.sexEffect;
    }

    public boolean isRemoveAtEndOfSex() {
        return this.removeAtEndOfSex;
    }

    public List<ItemTag> getTags() {
        return this.tags;
    }

    public boolean forceLoad() {
        return false;
    }

    public String applyAdditionEffect(GameCharacter target) {
        return "";
    }

    public String applyEffect(GameCharacter target, int secondsPassed, long totalSecondsPassed) {
        if (this.isFromExternalFile() && target != null) {
            String parsedResult = UtilText.parse(target, this.applyEffectString.replaceAll("TOTAL_SECONDS_PASSED", String.valueOf(totalSecondsPassed)).replaceAll("SECONDS_PASSED", String.valueOf(secondsPassed)), new ParserTag[0]);
            if (parsedResult.trim().length() > 0) {
                return parsedResult;
            }
            return "";
        }
        return "";
    }

    public final String applyRemoveStatusEffect(GameCharacter target) {
        return this.extraRemovalEffects(target);
    }

    protected String extraRemovalEffects(GameCharacter target) {
        if (this.isFromExternalFile() && target != null) {
            String parsedResult = UtilText.parse(target, this.applyRemovalString, new ParserTag[0]);
            if (parsedResult.trim().length() > 0) {
                return parsedResult;
            }
            return "";
        }
        return "";
    }

    public String applyPostRemovalStatusEffect(GameCharacter target) {
        if (this.isFromExternalFile() && target != null) {
            String parsedResult = UtilText.parse(target, this.applyPostRemovalString, new ParserTag[0]);
            if (parsedResult.trim().length() > 0) {
                return parsedResult;
            }
            return "";
        }
        return "";
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public StatusEffectCategory getCategory() {
        return this.category;
    }

    public int getRenderingPriority() {
        return this.renderingPriority;
    }

    public String getName(GameCharacter target) {
        if (target != null) {
            return UtilText.parse(target, this.name, new ParserTag[0]);
        }
        return this.name;
    }

    public String getDescription(GameCharacter target) {
        if (this.description != null && target != null) {
            return UtilText.parse(target, this.description, new ParserTag[0]);
        }
        return "";
    }

    protected Util.Value<Integer, String> getAdditionalDescription(GameCharacter target) {
        return null;
    }

    public List<Util.Value<Integer, String>> getAdditionalDescriptions(GameCharacter target) {
        Util.Value<Integer, String> additional = this.getAdditionalDescription(target);
        if (additional != null) {
            return Util.newArrayListOfValues(additional);
        }
        return null;
    }

    public List<String> getModifiersAsStringList(GameCharacter target) {
        ArrayList<String> fullModList = new ArrayList<String>(this.attributeModifiersToStringList(this.getAttributeModifiers(target)));
        fullModList.addAll(this.getExtraEffects(target));
        for (ItemTag tag : this.getTags()) {
            fullModList.addAll(tag.getClothingTooltipAdditions());
        }
        return fullModList;
    }

    public EffectBenefit getBeneficialStatus() {
        return this.beneficial;
    }

    public Map<AbstractAttribute, Float> getAttributeModifiers(GameCharacter target) {
        return this.attributeModifiers;
    }

    public List<AbstractCombatMove> getCombatMoves() {
        if (this.isFromExternalFile()) {
            ArrayList<AbstractCombatMove> combatMoves = new ArrayList<AbstractCombatMove>();
            for (String moveID : this.combatMoveIds) {
                combatMoves.add(CombatMove.getCombatMoveFromId(moveID));
            }
            return combatMoves;
        }
        return new ArrayList<AbstractCombatMove>();
    }

    public List<Spell> getSpells() {
        if (this.isFromExternalFile()) {
            ArrayList<Spell> spells = new ArrayList<Spell>();
            for (String spellID : this.spellIds) {
                spells.add(Spell.valueOf(spellID));
            }
            return spells;
        }
        return new ArrayList<Spell>();
    }

    public Colour getColour() {
        return this.colourShades.get(0);
    }

    public List<Colour> getColourShades() {
        return this.colourShades;
    }

    public int getEffectInterval() {
        return this.effectInterval;
    }

    public List<String> getExtraEffects(GameCharacter target) {
        return this.extraEffects;
    }

    public String getPathName(GameCharacter owner) {
        return this.pathName;
    }

    public String getSVGString(GameCharacter owner) {
        if (this.SVGString == null || this.pathNameUsedForRender != this.getPathName(owner)) {
            if (this.getPathName(owner) != null && !this.getPathName(owner).isEmpty()) {
                try {
                    if (this.isFromExternalFile()) {
                        List<String> lines = Files.readAllLines(Paths.get(this.getPathName(owner), new String[0]));
                        StringBuilder sb = new StringBuilder();
                        for (String line : lines) {
                            sb.append(line);
                        }
                        this.SVGString = sb.toString();
                        this.SVGString = SvgUtil.colourReplacement(this.getId(), this.colourShades, null, this.SVGString);
                    } else {
                        InputStream is;
                        String path = "/com/lilithsthrone/res/statusEffects/" + this.getPathName(owner) + ".svg";
                        if (this.getPathName(owner).startsWith("res/")) {
                            path = "/com/lilithsthrone/" + this.getPathName(owner) + ".svg";
                        }
                        if ((is = this.getClass().getResourceAsStream(path)) == null) {
                            System.err.println("Error! StatusEffect icon file does not exist (Trying to read from '" + this.getPathName(owner) + "')!");
                        }
                        this.SVGString = SvgUtil.colourReplacement(this.getId(), this.colourShades, null, Util.inputStreamToString(is));
                        is.close();
                    }
                    this.pathNameUsedForRender = this.getPathName(owner);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.SVGString = "";
            }
        }
        return this.SVGString;
    }

    public float getArousalPerTurnSelf(GameCharacter self) {
        return 0.0f;
    }

    public float getArousalPerTurnPartner(GameCharacter self, GameCharacter target) {
        return 0.0f;
    }

    public static float getPenetrationArousalPerTurn(GameCharacter target, SexAreaPenetration penetration) {
        float arousal = 0.0f;
        if (!Main.sex.getOngoingSexAreas(target, penetration).isEmpty()) {
            arousal += penetration.getBaseArousalWhenPenetrating();
            if (!Main.sex.hasLubricationTypeFromAnyone(target, penetration)) {
                arousal += penetration.getArousalChangePenetratingDry();
            }
        }
        return arousal;
    }

    public List<String> getPenetrationModifiersAsStringList(GameCharacter target, SexAreaPenetration penetration) {
        ArrayList<String> modifiersList = new ArrayList<String>();
        String penetrationName = UtilText.parse(target, "[npc.NamePos]", new ParserTag[0]) + penetration.getName(target);
        if (!Main.sex.hasLubricationTypeFromAnyone(target, penetration)) {
            modifiersList.add(penetrationName + "\u5f88[style.boldWetness1(\u5e72\u71e5)]\uff01");
        } else {
            modifiersList.add(penetrationName + "\u88ab[style.boldWetness(\u6da6\u6ed1)]\uff1a");
            int i = 0;
            ArrayList<String> lubricants = new ArrayList<String>();
            for (GameCharacter lubricantProvider : Main.sex.getAllParticipants()) {
                for (LubricationType lt : Main.sex.getWetAreas(target).get(penetration).get(lubricantProvider)) {
                    if (i == 0) {
                        lubricants.add(lubricantProvider == null ? Util.capitaliseSentence(lt.getName(lubricantProvider)) : UtilText.parse(lubricantProvider, "[npc.NamePos]" + lt.getName(lubricantProvider, true), new ParserTag[0]));
                    } else {
                        lubricants.add(lubricantProvider == null ? lt.getName(lubricantProvider) : UtilText.parse(lubricantProvider, "[npc.namePos]" + lt.getName(lubricantProvider, true), new ParserTag[0]));
                    }
                    ++i;
                }
            }
            for (LubricationType lt : Main.sex.getWetAreas(target).get(penetration).get(null)) {
                if (i == 0) {
                    lubricants.add(Util.capitaliseSentence(lt.getName(null)));
                } else {
                    lubricants.add(lt.getName(null));
                }
                ++i;
            }
            modifiersList.add(Util.stringsToStringList(lubricants, false) + "\u3002");
        }
        if (!Main.sex.getOngoingSexAreas(target, penetration).isEmpty() && !Collections.disjoint((Collection)Main.sex.getOngoingSexAreas(target, penetration).get(Main.sex.getCharacterOngoingSexArea(target, penetration).get(0)), Util.newArrayListOfValues(SexAreaPenetration.values()))) {
            modifiersList.add("[style.boldSex(\u5feb\u611f/\u56de\u5408:)]");
            String targetName = target.isPlayer() ? "\u4f60" : UtilText.parse(target, "[npc.Name]", new ParserTag[0]);
            modifiersList.add("+" + penetration.getBaseArousalWhenPenetrating() + "<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>(" + targetName + "</b>-[style.boldSex(\u6027\u7231)])");
            if (!Main.sex.hasLubricationTypeFromAnyone(target, penetration)) {
                modifiersList.add(penetration.getArousalChangePenetratingDry() + "<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>(" + targetName + "</b>-[style.boldBad(\u5e72\u71e5)])");
            }
        }
        return modifiersList;
    }

    public static float getOrificeArousalPerTurnSelf(GameCharacter target, SexAreaOrifice orifice) {
        float arousal = 0.0f;
        if (!Main.sex.getOngoingSexAreas(target, orifice).isEmpty()) {
            arousal += orifice.getBaseArousalWhenPenetrated();
            if (Main.sex.getAreasCurrentlyStretching(target).contains(orifice)) {
                arousal = target.hasFetish(Fetish.FETISH_MASOCHIST) || target.hasFetish(Fetish.FETISH_SIZE_QUEEN) ? (arousal += Math.abs(orifice.getArousalChangePenetratedStretching())) : (arousal += orifice.getArousalChangePenetratedStretching());
            }
            if (Main.sex.getAreasTooLoose(target).contains(orifice)) {
                arousal += orifice.getArousalChangePenetratedTooLoose();
            }
            if (!Main.sex.hasLubricationTypeFromAnyone(target, orifice)) {
                arousal += orifice.getArousalChangePenetratedDry();
            }
            if (Main.game.isPenetrationLimitationsEnabled() && orifice.isInternalOrifice()) {
                if (!Main.sex.getCharactersPenetratingTooDeep(target, orifice).isEmpty()) {
                    arousal = target.hasFetish(Fetish.FETISH_MASOCHIST) || target.hasFetish(Fetish.FETISH_SIZE_QUEEN) ? (arousal += 2.5f) : (arousal -= 10.0f);
                } else if (!Main.sex.getCharactersPenetratingFarTooShallow(target, orifice).isEmpty()) {
                    arousal -= 2.0f;
                }
            }
        }
        return arousal;
    }

    public float getOrificeArousalPerTurnPartner(GameCharacter self, GameCharacter target, SexAreaOrifice orifice) {
        float arousal = 0.0f;
        if (Main.sex.getOngoingSexAreas(self, orifice).containsKey(target)) {
            for (SexAreaInterface sArea : Main.sex.getOngoingSexAreas(self, orifice).get(target)) {
                if (sArea.isPenetration()) {
                    arousal += ((SexAreaPenetration)sArea).getBaseArousalWhenPenetrating();
                    continue;
                }
                if (!sArea.isOrifice()) continue;
                arousal += ((SexAreaOrifice)sArea).getBaseArousalWhenPenetrated();
            }
            if (Main.sex.getAreasCurrentlyStretching(self).contains(orifice)) {
                arousal += orifice.getArousalChangePenetratingStretching();
            }
            if (Main.sex.getAreasTooLoose(self).contains(orifice)) {
                arousal += orifice.getArousalChangePenetratingTooLoose();
            }
            if (!Main.sex.hasLubricationTypeFromAnyone(self, orifice)) {
                arousal += orifice.getArousalChangePenetratingDry();
            }
        }
        return arousal;
    }

    public List<String> getOrificeModifiersAsStringList(GameCharacter target, SexAreaOrifice orifice) {
        ArrayList<String> modifiersList = new ArrayList<String>();
        String targetName = target.isPlayer() ? "\u4f60" : UtilText.parse(target, "[npc.Name]", new ParserTag[0]);
        boolean orificePlural = orifice.isPlural();
        String orificeName = UtilText.parse(target, "[npc.NamePos]", new ParserTag[0]) + orifice.getName(target);
        if (Main.sex.getAreasCurrentlyStretching(target).contains(orifice)) {
            if (Main.sex.getFirstOngoingSexAreaPenetration(target, orifice) == null) {
                modifiersList.add(orificeName + "\u88ab<b style='color:" + PresetColour.BASE_PINK_DEEP.toWebHexString() + ";'>\u6269\u5f20\u4e86</b>\uff01");
            } else {
                modifiersList.add(orificeName + "\u6b63\u5728\u88ab<b style='color:" + PresetColour.BASE_PINK_DEEP.toWebHexString() + ";'>\u6269\u5f20</b>\uff01");
            }
        } else if (Main.sex.getAreasTooLoose(target).contains(orifice)) {
            modifiersList.add(orificeName + "<b style='color:" + PresetColour.BASE_RED.toWebHexString() + ";'>\u592a\u8fc7\u677e\u57ae\u4e86</b>\uff01");
        } else if (Main.sex.getAreasStretched(target).contains(orifice)) {
            modifiersList.add(orificeName + "\u88ab<b style='color:" + PresetColour.BASE_PINK_DEEP.toWebHexString() + ";'>\u6269\u5f20\u4e86</b>\uff01");
        }
        if (Main.game.isPenetrationLimitationsEnabled() && orifice.isInternalOrifice()) {
            if (!Main.sex.getCharactersPenetratingTooDeep(target, orifice).isEmpty()) {
                if (target.hasFetish(Fetish.FETISH_MASOCHIST) || target.hasFetish(Fetish.FETISH_SIZE_QUEEN)) {
                    modifiersList.add(orificeName + "\u88ab\u63d2\u5165\u5f97[style.boldSex(\u592a\u6df1\u4e86)]\uff01");
                } else {
                    modifiersList.add(orificeName + "\u88ab\u63d2\u5165\u5f97[style.boldTerrible(\u592a\u6df1\u4e86)]\uff01");
                }
            } else if (!Main.sex.getCharactersPenetratingFarTooShallow(target, orifice).isEmpty()) {
                modifiersList.add(orificeName + "\u88ab\u63d2\u5165\u5f97[style.boldPinkLight(\u592a\u6d45\u4e86)]\uff01");
            }
        }
        if (!Main.sex.hasLubricationTypeFromAnyone(target, orifice)) {
            modifiersList.add(orificeName + "\u5f88[style.boldWetness1(\u5e72\u71e5)]\uff01");
        } else {
            modifiersList.add(orificeName + "\u88ab[style.boldWetness(\u6da6\u6ed1)]\uff1a");
            int i = 0;
            ArrayList<String> lubricants = new ArrayList<String>();
            for (GameCharacter lubricantProvider : Main.sex.getAllParticipants()) {
                for (LubricationType lt : Main.sex.getWetAreas(target).get(orifice).get(lubricantProvider)) {
                    if (i == 0) {
                        lubricants.add(lubricantProvider == null ? Util.capitaliseSentence(lt.getName(lubricantProvider)) : UtilText.parse(lubricantProvider, "[npc.NamePos]" + lt.getName(lubricantProvider, true), new ParserTag[0]));
                    } else {
                        lubricants.add(lubricantProvider == null ? lt.getName(lubricantProvider) : UtilText.parse(lubricantProvider, "[npc.namePos]" + lt.getName(lubricantProvider, true), new ParserTag[0]));
                    }
                    ++i;
                }
            }
            for (LubricationType lt : Main.sex.getWetAreas(target).get(orifice).get(null)) {
                if (i == 0) {
                    lubricants.add(Util.capitaliseSentence(lt.getName(null)));
                } else {
                    lubricants.add(lt.getName(null));
                }
                ++i;
            }
            modifiersList.add(Util.stringsToStringList(lubricants, false) + "\u3002");
        }
        if (!Main.sex.getOngoingSexAreas(target, orifice).isEmpty()) {
            modifiersList.add("[style.boldSex(\u5feb\u611f/\u56de\u5408:)]");
            modifiersList.add("+" + orifice.getBaseArousalWhenPenetrated() + "(<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>" + targetName + "</b>-[style.boldSex(\u6027\u7231)])");
            if (Main.sex.getAreasCurrentlyStretching(target).contains(orifice)) {
                float arousalIncrement = orifice.getArousalChangePenetratedStretching();
                if (target.hasFetish(Fetish.FETISH_MASOCHIST) || target.hasFetish(Fetish.FETISH_SIZE_QUEEN)) {
                    modifiersList.add(((arousalIncrement = Math.abs(arousalIncrement)) > 0.0f ? "+" : "") + arousalIncrement + "(<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>" + targetName + "</b>-[style.boldSex(\u6269\u5f20)])");
                } else {
                    modifiersList.add((arousalIncrement > 0.0f ? "+" : "") + arousalIncrement + "(<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>" + targetName + "</b>-[style.boldBad(\u6269\u5f20)])");
                }
            }
            if (Main.sex.getAreasTooLoose(target).contains(orifice)) {
                modifiersList.add((orifice.getArousalChangePenetratedTooLoose() > 0.0f ? "+" : "") + orifice.getArousalChangePenetratedTooLoose() + "(<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>" + targetName + "</b>-[style.boldBad(\u8fc7\u677e)])");
            }
            if (!Main.sex.hasLubricationTypeFromAnyone(target, orifice)) {
                modifiersList.add((orifice.getArousalChangePenetratedDry() > 0.0f ? "+" : "") + orifice.getArousalChangePenetratedDry() + "(<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>" + targetName + "</b>-[style.boldBad(\u5e72\u71e5)])");
            }
            if (Main.game.isPenetrationLimitationsEnabled() && orifice.isInternalOrifice()) {
                if (!Main.sex.getCharactersPenetratingTooDeep(target, orifice).isEmpty()) {
                    if (target.hasFetish(Fetish.FETISH_MASOCHIST) || target.hasFetish(Fetish.FETISH_SIZE_QUEEN)) {
                        modifiersList.add("+2.5(<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>" + targetName + "</b>-[style.boldSex(\u8fc7\u6df1)])");
                    } else {
                        modifiersList.add("-10(<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>" + targetName + "</b>-[style.boldBad(\u8fc7\u6df1)])");
                    }
                } else if (!Main.sex.getCharactersPenetratingFarTooShallow(target, orifice).isEmpty()) {
                    modifiersList.add("-2(<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>" + targetName + "</b>-[style.boldBad(\u8fc7\u6d45)])");
                }
            }
            for (GameCharacter penetrator : Main.sex.getOngoingSexAreas(target, orifice).keySet()) {
                String penetratorName;
                String string = penetratorName = penetrator.isPlayer() ? "\u4f60" : UtilText.parse(penetrator, "[npc.Name]", new ParserTag[0]);
                if (Main.sex.getOngoingSexAreas(target, orifice).isEmpty()) continue;
                modifiersList.add("+" + this.getOrificeArousalPerTurnPartner(target, penetrator, orifice) + "(<b style='color:" + penetrator.getFemininity().getColour().toWebHexString() + ";'>" + penetratorName + "</b>-[style.boldSex(\u6027\u7231)])");
                if (Main.sex.getAreasCurrentlyStretching(target).contains(orifice)) {
                    modifiersList.add((orifice.getArousalChangePenetratingStretching() > 0.0f ? "+" : "") + orifice.getArousalChangePenetratingStretching() + "(<b style='color:" + penetrator.getFemininity().getColour().toWebHexString() + ";'>" + penetratorName + "</b>-[style.boldGood(\u7d27\u81f4)])");
                }
                if (Main.sex.getAreasTooLoose(target).contains(orifice)) {
                    modifiersList.add((orifice.getArousalChangePenetratingTooLoose() > 0.0f ? "+" : "") + orifice.getArousalChangePenetratingTooLoose() + "(<b style='color:" + penetrator.getFemininity().getColour().toWebHexString() + ";'>" + penetratorName + "</b>-[style.boldBad(\u8fc7\u677e)])");
                }
                if (Main.sex.hasLubricationTypeFromAnyone(target, orifice)) continue;
                modifiersList.add((orifice.getArousalChangePenetratingDry() > 0.0f ? "+" : "") + orifice.getArousalChangePenetratingDry() + "(<b style='color:" + penetrator.getFemininity().getColour().toWebHexString() + ";'>" + penetratorName + "</b>-[style.boldBad(\u5e72\u71e5)])");
            }
        }
        return modifiersList;
    }

    protected static List<Util.Value<Integer, String>> getInternalOrificeExtraDescriptions(GameCharacter target, SexAreaOrifice orifice) {
        if (Main.sex.getCharactersHavingOngoingActionWith(target, orifice).isEmpty()) {
            return null;
        }
        List<GameCharacter> ongoingCharacters = Main.sex.getCharactersHavingOngoingActionWith(target, orifice);
        GameCharacter partner = ongoingCharacters.get(Util.random.nextInt(ongoingCharacters.size()));
        ArrayList<Util.Value<Integer, String>> additionalDescriptions = new ArrayList<Util.Value<Integer, String>>();
        StringBuilder sb = new StringBuilder();
        sb.append(UtilText.parse(target, "<b style='color:" + target.getFemininity().getColour().toWebHexString() + ";'>[npc.NamePos]</b>[style.boldSex(" + Util.capitaliseSentence(orifice.getName(target, true)) + ")]\uff1a<br/>\u5bb9\u91cf: " + Units.size(Units.round(orifice.getCapacity(target, true), 1)) + (String)(Main.game.isPenetrationLimitationsEnabled() ? "<br/>\u8212\u9002\u6df1\u5ea6/\u4e0d\u9002\u6df1\u5ea6: " + Units.size(Units.round(orifice.getMaximumPenetrationDepthComfortable(target), 1)) + " / " + Units.size(Units.round(orifice.getMaximumPenetrationDepthUncomfortable(target), 1)) : ""), new ParserTag[0]));
        additionalDescriptions.add(new Util.Value<Integer, String>(Main.game.isPenetrationLimitationsEnabled() ? 3 : 2, sb.toString()));
        for (GameCharacter character : ongoingCharacters) {
            SexAreaPenetration penetration = (SexAreaPenetration)Main.sex.getOngoingActionsMap(target).get(orifice).get(partner).iterator().next();
            if (!penetration.appliesStretchEffects(character)) continue;
            sb = new StringBuilder();
            int length = (int)character.getPenetrationLengthInserted(penetration, target, orifice);
            boolean knotting = Objects.equals(Main.sex.getCharacterKnotting(character), target) && penetration == SexAreaPenetration.PENIS;
            sb.append(UtilText.parse(character, "<b style='color:" + character.getFemininity().getColour().toWebHexString() + ";'>[npc.NamePos]</b>\u7684[style.boldSex(" + Util.capitaliseSentence(penetration.getName(character, true)) + ")]:<br/>\u76f4\u5f84" + (knotting ? "[style.boldSex(\u6839\u90e8\u7ed3\u5904*2)]" : "") + ": " + Units.size(Units.round(penetration.getDiameter(character, penetration.getLength(character, true) - length) * (float)(knotting ? 2 : 1), 1)) + (String)(Main.game.isPenetrationLimitationsEnabled() ? "<br/>\u53ef\u63d2\u5165/\u603b\u957f\u5ea6: " + Units.size(length) + " / " + Units.size(penetration.getLength(character, true)) : ""), new ParserTag[0]));
            additionalDescriptions.add(new Util.Value<Integer, String>(Main.game.isPenetrationLimitationsEnabled() ? 3 : 2, sb.toString()));
        }
        return additionalDescriptions;
    }

    public void appendPenetrationAdditionGenericDescriptions(GameCharacter owner, SexAreaPenetration penetration, String penetrationName, StringBuilder stringBuilderToAppendTo) {
        List<GameCharacter> ongoingCharacters = Main.sex.getCharactersHavingOngoingActionWith(owner, penetration);
        if (!ongoingCharacters.isEmpty()) {
            GameCharacter partner = ongoingCharacters.get(Util.random.nextInt(ongoingCharacters.size()));
            stringBuilderToAppendTo.append("<br/>" + Main.sex.formatPenetration(owner.getPenetrationDescription(false, owner, penetration, partner, Main.sex.getOngoingActionsMap(owner).get(penetration).get(partner).iterator().next())));
        }
    }

    public void appendOrificeAdditionGenericDescriptions(GameCharacter owner, SexAreaOrifice orificeType, String orificeName, StringBuilder stringBuilderToAppendTo) {
        List<GameCharacter> ongoingCharacters = Main.sex.getCharactersHavingOngoingActionWith(owner, orificeType);
        if (!ongoingCharacters.isEmpty()) {
            GameCharacter partner = ongoingCharacters.get(Util.random.nextInt(ongoingCharacters.size()));
            stringBuilderToAppendTo.append("<br/>" + Main.sex.formatPenetration(owner.getPenetrationDescription(false, partner, (SexAreaPenetration)Main.sex.getOngoingActionsMap(owner).get(orificeType).get(partner).iterator().next(), owner, orificeType)));
        }
    }

    public String getPenetrationSVGString(GameCharacter owner, SexAreaInterface penetration, String baseSVG) {
        StringBuilder SVGImageSB = new StringBuilder();
        if (!Main.sex.getOngoingSexAreas(owner, penetration).isEmpty()) {
            SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getActiveSexBackground() + "</div>");
        }
        SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + baseSVG + "</div>");
        if (!Main.sex.getOngoingSexAreas(owner, penetration).isEmpty()) {
            Enum firstPenetration = null;
            block7: for (Map.Entry<GameCharacter, Set<SexAreaInterface>> entry : Main.sex.getOngoingSexAreas(owner, penetration).entrySet()) {
                for (SexAreaInterface sArea : entry.getValue()) {
                    if (!sArea.isPenetration()) continue;
                    firstPenetration = (SexAreaPenetration)sArea;
                    break block7;
                }
            }
            if (firstPenetration != null) {
                switch (1.$SwitchMap$com$lilithsthrone$game$sex$SexAreaPenetration[firstPenetration.ordinal()]) {
                    case 1: {
                        SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeFinger() + "</div>");
                        break;
                    }
                    case 2: {
                        SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypePenis() + "</div>");
                        break;
                    }
                    case 3: {
                        SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeTail(owner.getLegConfiguration() == LegConfiguration.TAIL_LONG) + "</div>");
                        break;
                    }
                    case 4: {
                        SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeTongue() + "</div>");
                        break;
                    }
                    case 5: {
                        SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeTentacle() + "</div>");
                        break;
                    }
                }
            }
        }
        if (!Main.sex.hasLubricationTypeFromAnyone(owner, penetration)) {
            SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationDry() + "</div>");
        } else {
            SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationWet() + "</div>");
        }
        return SVGImageSB.toString();
    }

    public String getOrificeSVGString(GameCharacter owner, SexAreaInterface orifice, String baseSVG) {
        return this.getOrificeSVGString(owner, orifice, baseSVG, null);
    }

    public String getOrificeSVGString(GameCharacter owner, SexAreaInterface orifice, String baseSVG, List<SexAreaInterface> limitInteractionsTo) {
        StringBuilder SVGImageSB = new StringBuilder();
        if (!Main.sex.getOngoingSexAreas(owner, orifice).isEmpty()) {
            SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getActiveSexBackground() + "</div>");
        }
        SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + baseSVG + "</div>");
        if (!Main.sex.getOngoingSexAreas(owner, orifice).isEmpty()) {
            int rightOffset = 0;
            for (Map.Entry<GameCharacter, Set<SexAreaInterface>> entry : Main.sex.getOngoingSexAreas(owner, orifice).entrySet()) {
                for (SexAreaInterface sArea : entry.getValue()) {
                    if (!sArea.isPenetration()) continue;
                    GameCharacter penetrationOwner = Main.sex.getOngoingCharactersUsingAreas(owner, orifice, sArea).iterator().next();
                    if (limitInteractionsTo != null && !limitInteractionsTo.contains(sArea)) continue;
                    switch ((SexAreaPenetration)sArea) {
                        case FINGER: {
                            SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:" + rightOffset + "%;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeFinger() + "</div>");
                            break;
                        }
                        case PENIS: {
                            SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:" + rightOffset + "%;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypePenis() + "</div>");
                            break;
                        }
                        case TAIL: {
                            SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:" + rightOffset + "%;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeTail(penetrationOwner.getLegConfiguration() == LegConfiguration.TAIL_LONG) + "</div>");
                            break;
                        }
                        case TONGUE: {
                            SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:" + rightOffset + "%;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeTongue() + "</div>");
                            break;
                        }
                        case CLIT: {
                            SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:" + rightOffset + "%;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeClit() + "</div>");
                            break;
                        }
                        case FOOT: {
                            SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:" + rightOffset + "%;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeFoot() + "</div>");
                            break;
                        }
                        case TENTACLE: {
                            SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:" + rightOffset + "%;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypeTentacle() + "</div>");
                        }
                    }
                    rightOffset += 8;
                }
            }
            if (Main.game.isPenetrationLimitationsEnabled() && orifice.isOrifice() && ((SexAreaOrifice)orifice).isInternalOrifice()) {
                if (!Main.sex.getCharactersPenetratingTooDeep(owner, (SexAreaOrifice)orifice).isEmpty()) {
                    SVGImageSB.append("<div style='width:45%;height:45%;position:absolute;left:2.5%;bottom:2.5%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationDepthMaximum() + "</div>");
                } else if (!Main.sex.getCharactersPenetratingFarTooShallow(owner, (SexAreaOrifice)orifice).isEmpty()) {
                    SVGImageSB.append("<div style='width:45%;height:45%;position:absolute;left:2.5%;bottom:2.5%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationDepthMinimum() + "</div>");
                }
            }
        }
        if (Main.sex.getAreasCurrentlyStretching(owner).contains(orifice)) {
            SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationStretching() + "</div>");
        }
        if (Main.sex.getAreasTooLoose(owner).contains(orifice)) {
            SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationTooLoose() + "</div>");
        }
        if (Main.game.isPenetrationLimitationsEnabled()) {
            if (Main.sex.hasLubricationTypeFromAnyone(owner, orifice)) {
                SVGImageSB.append("<div style='width:20%;height:20%;position:absolute;left:2%;top:2%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationWet() + "</div>");
            }
        } else if (!Main.sex.hasLubricationTypeFromAnyone(owner, orifice)) {
            SVGImageSB.append("<div style='width:45%;height:45%;position:absolute;left:2.5%;bottom:2.5%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationDry() + "</div>");
        } else {
            SVGImageSB.append("<div style='width:45%;height:45%;position:absolute;left:2.5%;bottom:2.5%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationWet() + "</div>");
        }
        return SVGImageSB.toString();
    }

    public String getCreampieSVGString(GameCharacter owner, SexAreaOrifice orifice) {
        StringBuilder SVGImageSB = new StringBuilder();
        boolean justCum = owner.isOnlyCumInArea(orifice);
        if (AbstractStatusEffect.isCumEffectPositive(owner)) {
            SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + (justCum ? SVGImages.SVG_IMAGE_PROVIDER.getCreampieMasochist() : SVGImages.SVG_IMAGE_PROVIDER.getFluidIngestedMasochist()) + "</div>");
        } else {
            SVGImageSB.append(justCum ? SVGImages.SVG_IMAGE_PROVIDER.getCreampie() : SVGImages.SVG_IMAGE_PROVIDER.getFluidIngested());
        }
        switch (orifice) {
            case ANUS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaAnus() + "</div>");
                break;
            }
            case ASS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaAnus() + "</div>");
                break;
            }
            case ARMPITS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaArmpits() + "</div>");
                break;
            }
            case BREAST: {
                if (owner.hasBreasts()) {
                    SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaBreasts() + "</div>");
                    break;
                }
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaBreastsFlat() + "</div>");
                break;
            }
            case NIPPLE: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaNipple() + "</div>");
                break;
            }
            case BREAST_CROTCH: {
                if (owner.getBreastCrotchShape() == BreastShape.UDDERS) {
                    SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaUdders() + "</div>");
                    break;
                }
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaBreastsCrotch() + "</div>");
                break;
            }
            case NIPPLE_CROTCH: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaNippleCrotch() + "</div>");
                break;
            }
            case MOUTH: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaMouth() + "</div>");
                break;
            }
            case THIGHS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaThighs() + "</div>");
                break;
            }
            case URETHRA_PENIS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaUrethraPenis() + "</div>");
                break;
            }
            case URETHRA_VAGINA: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaUrethraVagina() + "</div>");
                break;
            }
            case VAGINA: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaVagina() + "</div>");
                break;
            }
            case SPINNERET: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaSpinneret() + "</div>");
            }
        }
        return SVGImageSB.toString();
    }

    public String getIncubationSVGString(GameCharacter owner, SexAreaOrifice orifice, int stage) {
        StringBuilder SVGImageSB = new StringBuilder();
        SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getEggIncubation(stage) + "</div>");
        switch (orifice) {
            case ANUS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaAss() + "</div>");
                break;
            }
            case ASS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaAss() + "</div>");
                break;
            }
            case ARMPITS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaArmpits() + "</div>");
                break;
            }
            case BREAST: {
                if (owner.hasBreasts()) {
                    SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaBreasts() + "</div>");
                    break;
                }
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaBreastsFlat() + "</div>");
                break;
            }
            case NIPPLE: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaNipple() + "</div>");
                break;
            }
            case BREAST_CROTCH: {
                if (owner.getBreastCrotchShape() == BreastShape.UDDERS) {
                    SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaUdders() + "</div>");
                    break;
                }
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaBreastsCrotch() + "</div>");
                break;
            }
            case NIPPLE_CROTCH: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaNippleCrotch() + "</div>");
                break;
            }
            case MOUTH: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaMouth() + "</div>");
                break;
            }
            case THIGHS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaThighs() + "</div>");
                break;
            }
            case URETHRA_PENIS: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaUrethraPenis() + "</div>");
                break;
            }
            case URETHRA_VAGINA: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaUrethraVagina() + "</div>");
                break;
            }
            case VAGINA: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaVagina() + "</div>");
                break;
            }
            case SPINNERET: {
                SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;left:0;top:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaSpinneret() + "</div>");
            }
        }
        return SVGImageSB.toString();
    }

    protected static boolean isCumEffectPositive(GameCharacter target) {
        return target.hasFetish(Fetish.FETISH_MASOCHIST) || target.hasFetish(Fetish.FETISH_CUM_ADDICT);
    }

    public static boolean isExposedParts(GameCharacter target, boolean requiresBreastsExposed, boolean requiresGenitalsExposed) {
        boolean genitalsExposed;
        boolean breastsExposed = (target.hasBreasts() || target.isFeminine()) && target.isCoverableAreaVisible(CoverableArea.NIPPLES) || target.hasBreastsCrotch() && target.isCoverableAreaVisible(CoverableArea.NIPPLES_CROTCH);
        boolean bl = genitalsExposed = target.isCoverableAreaVisible(CoverableArea.ANUS) || target.isCoverableAreaVisible(CoverableArea.PENIS) && target.hasPenis() || target.isCoverableAreaVisible(CoverableArea.VAGINA) && target.hasVagina();
        return !Main.game.isInSex() && target.getLegConfiguration().isGenitalsExposed(target) && (requiresBreastsExposed ? breastsExposed : !breastsExposed) && (requiresGenitalsExposed ? genitalsExposed : !genitalsExposed);
    }

    public static String getExposedPartsNamesList(GameCharacter owner) {
        ArrayList<String> names = new ArrayList<String>();
        if (owner.hasBreasts() && owner.isCoverableAreaVisible(CoverableArea.NIPPLES)) {
            names.add("\u4e73\u623f");
        } else if (owner.isFeminine() && owner.isCoverableAreaVisible(CoverableArea.NIPPLES)) {
            names.add("\u4e73\u5934");
        }
        if (owner.hasBreastsCrotch() && owner.isCoverableAreaVisible(CoverableArea.NIPPLES_CROTCH)) {
            names.add(UtilText.parse(owner, "[npc.crotchBoobs]", new ParserTag[0]));
        }
        if (owner.isCoverableAreaVisible(CoverableArea.ANUS)) {
            names.add("\u809b\u95e8");
        }
        if (owner.hasPenis() && owner.isCoverableAreaVisible(CoverableArea.PENIS)) {
            names.add("\u9634\u830e");
        }
        if (owner.hasVagina() && owner.isCoverableAreaVisible(CoverableArea.VAGINA)) {
            names.add("\u9634\u90e8");
        }
        if (!owner.hasPenis() && !owner.hasVagina() && owner.isCoverableAreaVisible(CoverableArea.VAGINA)) {
            names.add("\u65e0\u6027\u522b\u7684\u4e0b\u4f53");
        }
        return Util.stringsToStringChoice(names, false);
    }

    public static String getExposedStatus(GameCharacter owner, String baseSVG) {
        StringBuilder SVGImageSB = new StringBuilder();
        SVGImageSB.append("<div style='width:100%;height:100%;position:absolute;left:0;top:0;'>" + baseSVG + "</div>");
        boolean breastsExposed = owner.hasBreasts() && owner.isCoverableAreaVisible(CoverableArea.NIPPLES);
        boolean nipplesExposed = !breastsExposed && owner.isFeminine() && owner.isCoverableAreaVisible(CoverableArea.NIPPLES);
        boolean crotchBoobsExposed = owner.hasBreastsCrotch() && owner.isCoverableAreaVisible(CoverableArea.NIPPLES_CROTCH);
        boolean anusExposed = owner.isCoverableAreaVisible(CoverableArea.ANUS);
        boolean penisExposed = owner.hasPenis() && owner.isCoverableAreaVisible(CoverableArea.PENIS);
        boolean vaginaExposed = owner.hasVagina() && owner.isCoverableAreaVisible(CoverableArea.VAGINA);
        boolean moundExposed = !owner.hasPenis() && !owner.hasVagina() && owner.isCoverableAreaVisible(CoverableArea.VAGINA);
        int exposedAreas = 0;
        exposedAreas = moundExposed ? ++exposedAreas : (exposedAreas += (penisExposed ? 1 : 0) + (vaginaExposed ? 1 : 0));
        int size = Math.min(50, 100 / ((exposedAreas += (anusExposed ? 1 : 0) + (breastsExposed || nipplesExposed ? 1 : 0) + (crotchBoobsExposed ? 1 : 0)) + 1));
        int marginTop = (100 - exposedAreas * size) / 2;
        int marginLeft = (50 - size) / 2;
        if (breastsExposed) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaBreasts() + "</div>");
            marginTop += size;
        } else if (nipplesExposed) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaBreastsFlat() + "</div>");
            marginTop += size;
        }
        if (crotchBoobsExposed) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaBreastsCrotch() + "</div>");
            marginTop += size;
        }
        if (anusExposed) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaAnus() + "</div>");
            marginTop += size;
        }
        if (moundExposed) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaMound() + "</div>");
            marginTop += size;
        }
        if (penisExposed) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getPenetrationTypePenis() + "</div>");
            marginTop += size;
        }
        if (vaginaExposed) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaVagina() + "</div>");
            marginTop += size;
        }
        return SVGImageSB.toString();
    }

    public static String getRecoveringOrificeStatus(GameCharacter owner, String baseSVG) {
        StringBuilder SVGImageSB = new StringBuilder();
        SVGImageSB.append("<div style='width:50%;height:50%;position:absolute;right:0;top:25%;'>" + baseSVG + "</div>");
        boolean vaginaRecovering = owner.hasVagina() && owner.getVaginaRawCapacityValue() != owner.getVaginaStretchedCapacity();
        boolean anusRecovering = owner.getAssRawCapacityValue() != owner.getAssStretchedCapacity();
        boolean throatRecovering = owner.getFaceRawCapacityValue() != owner.getFaceStretchedCapacity();
        boolean nipplesRecovering = owner.getNippleRawCapacityValue() != owner.getNippleStretchedCapacity();
        boolean nipplesCrotchRecovering = owner.hasBreastsCrotch() && owner.getNippleCrotchRawCapacityValue() != owner.getNippleCrotchStretchedCapacity();
        boolean penileUrethraRecovering = owner.hasPenis() && owner.getPenisRawCapacityValue() != owner.getPenisStretchedCapacity();
        boolean vaginalUrethraRecovering = owner.hasVagina() && owner.getVaginaUrethraRawCapacityValue() != owner.getVaginaUrethraStretchedCapacity();
        int exposedAreas = (vaginaRecovering ? 1 : 0) + (anusRecovering ? 1 : 0) + (throatRecovering ? 1 : 0) + (nipplesRecovering ? 1 : 0) + (nipplesCrotchRecovering ? 1 : 0) + (penileUrethraRecovering ? 1 : 0) + (vaginalUrethraRecovering ? 1 : 0);
        int size = Math.min(50, 100 / (exposedAreas + 1));
        int marginTop = (100 - exposedAreas * size) / 2;
        int marginLeft = (50 - size) / 2;
        if (vaginaRecovering) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaVagina() + "</div>");
            marginTop += size;
        }
        if (anusRecovering) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaAnus() + "</div>");
            marginTop += size;
        }
        if (throatRecovering) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaMouth() + "</div>");
            marginTop += size;
        }
        if (nipplesRecovering) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaNipple() + "</div>");
            marginTop += size;
        }
        if (nipplesCrotchRecovering) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaNippleCrotch() + "</div>");
            marginTop += size;
        }
        if (penileUrethraRecovering) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaUrethraPenis() + "</div>");
            marginTop += size;
        }
        if (vaginalUrethraRecovering) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaUrethraVagina() + "</div>");
            marginTop += size;
        }
        return SVGImageSB.toString();
    }

    public static String getStretchingOrificeStatus(GameCharacter owner, boolean stretch, boolean stretchRecoveryPrevented, boolean tooDeep, Set<SexAreaOrifice> orifices) {
        StringBuilder SVGImageSB = new StringBuilder();
        int iconSize = stretch && stretchRecoveryPrevented && tooDeep ? 33 : 50;
        int iconRight = stretch && stretchRecoveryPrevented && tooDeep ? 8 : 0;
        int topMargin = 0;
        if (stretch) {
            SVGImageSB.append("<div style='width:" + iconSize + "%;height:" + iconSize + "%;position:absolute;right:" + iconRight + ";top:" + (tooDeep || stretchRecoveryPrevented ? "0" : "25%") + ";'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationStretching() + "</div>");
            topMargin += iconSize;
        }
        if (stretchRecoveryPrevented) {
            SVGImageSB.append("<div style='width:" + iconSize + "%;height:" + iconSize + "%;position:absolute;right:" + iconRight + ";top:" + (String)(stretch || tooDeep ? topMargin + "%" : "25%") + ";'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationStretchRecoveryPrevented() + "</div>");
            topMargin += iconSize;
        }
        if (tooDeep) {
            SVGImageSB.append("<div style='width:" + iconSize + "%;height:" + iconSize + "%;position:absolute;right:" + iconRight + ";top:" + (String)(stretch || stretchRecoveryPrevented ? topMargin + "%" : "25%") + ";'>" + SVGImages.SVG_IMAGE_PROVIDER.getCombinationDepthMaximum() + "</div>");
        }
        int size = Math.min(50, 100 / (orifices.size() + 1));
        int marginTop = (100 - orifices.size() * size) / 2;
        int marginLeft = (50 - size) / 2;
        if (orifices.contains(SexAreaOrifice.VAGINA)) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaVagina() + "</div>");
            marginTop += size;
        }
        if (orifices.contains(SexAreaOrifice.ANUS)) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaAnus() + "</div>");
            marginTop += size;
        }
        if (orifices.contains(SexAreaOrifice.NIPPLE)) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaNipple() + "</div>");
            marginTop += size;
        }
        if (orifices.contains(SexAreaOrifice.MOUTH)) {
            SVGImageSB.append("<div style='width:" + size + "%;height:" + size + "%;position:absolute;left:" + marginLeft + "%;top:" + marginTop + "%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaMouth() + "</div>");
            marginTop += size;
        }
        return SVGImageSB.toString();
    }
}

