/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.effects;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.effects.AbstractPerk;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.PerkCategory;
import com.lilithsthrone.game.character.effects.TreeEntry;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.npc.misc.Elemental;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Pathing;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public enum PerkManager {
    MANAGER;

    private StringBuilder treeSB = new StringBuilder();
    private StringBuilder lineSB = new StringBuilder();
    private StringBuilder entrySB = new StringBuilder();
    private Map<Integer, Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>>> perkTree;
    private Map<Integer, Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>>> elementalPerkTree;
    private Map<Integer, Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>>> dollPerkTree;
    private List<TreeEntry<PerkCategory, AbstractPerk>> elementalStartingPerks = new ArrayList<TreeEntry<PerkCategory, AbstractPerk>>();
    private List<TreeEntry<PerkCategory, AbstractPerk>> standardStartingPerks = new ArrayList<TreeEntry<PerkCategory, AbstractPerk>>();
    private List<TreeEntry<PerkCategory, AbstractPerk>> dollStartingPerks = new ArrayList<TreeEntry<PerkCategory, AbstractPerk>>();
    public static final int ROWS = 20;

    private PerkManager() {
        int i;
        this.perkTree = new HashMap<Integer, Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>>>();
        for (int i2 = 0; i2 < 20; ++i2) {
            this.perkTree.put(i2, new HashMap());
            for (PerkCategory category : PerkCategory.values()) {
                this.perkTree.get(i2).put(category, new ArrayList());
            }
        }
        TreeEntry<PerkCategory, AbstractPerk> physical1 = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 1, Perk.PHYSICAL_BASE, new TreeEntry[0]);
        this.standardStartingPerks.add(physical1);
        TreeEntry<PerkCategory, AbstractPerk> arcane1 = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 1, Perk.ARCANE_BASE, new TreeEntry[0]);
        this.standardStartingPerks.add(arcane1);
        TreeEntry<PerkCategory, AbstractPerk> both1 = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 1, Perk.LEWD_KNOWLEDGE, physical1, arcane1);
        this.standardStartingPerks.add(both1);
        TreeEntry<PerkCategory, AbstractPerk> leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 2, Perk.PHYSIQUE_BOOST, physical1);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 2, Perk.OBSERVANT, physical1);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 2, Perk.HEAVY_SLEEPER, physical1);
        TreeEntry<PerkCategory, AbstractPerk> leftC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 2, Perk.ENCHANTMENT_STABILITY, physical1);
        TreeEntry<PerkCategory, AbstractPerk> leftB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 3, Perk.PHYSICAL_DEFENCE, leftA);
        leftB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 4, Perk.PHYSICAL_DEFENCE, leftB);
        TreeEntry<PerkCategory, AbstractPerk> leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 3, Perk.ENERGY_BOOST, leftA);
        leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 4, Perk.ENERGY_BOOST, leftMidA);
        TreeEntry<PerkCategory, AbstractPerk> rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 3, Perk.PHYSICAL_DAMAGE, leftA);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 4, Perk.PHYSICAL_DAMAGE, rightA);
        leftC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 3, Perk.ENCHANTMENT_STABILITY, leftC);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 4, Perk.WEAPON_ENCHANTER, leftC);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 5, Perk.RUNNER_2, leftB, leftMidA);
        TreeEntry<PerkCategory, AbstractPerk> rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 5, Perk.UNARMED_TRAINING, new TreeEntry[0]);
        rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 5, Perk.CRITICAL_BOOST, rightB);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 5, Perk.UNARMED_DAMAGE, rightA, rightB);
        TreeEntry<PerkCategory, AbstractPerk> connectorLeft = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 6, Perk.PHYSIQUE_BOOST_MAJOR, leftA, rightA);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 6, Perk.HYPERMOBILITY, connectorLeft);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 7, Perk.PHYSICAL_DAMAGE, connectorLeft);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 7, Perk.UNARMED_DAMAGE, leftA);
        leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 7, Perk.ENERGY_BOOST_DRAIN_DAMAGE, new TreeEntry[0]);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 7, Perk.ENERGY_BOOST, connectorLeft);
        leftMidA.addLink(rightA);
        leftB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 8, Perk.PHYSICAL_DAMAGE, leftA);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 8, Perk.MELEE_DAMAGE, leftB);
        leftB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 9, Perk.PHYSICAL_DAMAGE, leftB);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 9, Perk.RANGED_DAMAGE, leftB);
        leftB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 10, Perk.FEROCIOUS_WARRIOR, leftB);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 10, Perk.BESERK, leftB);
        TreeEntry<PerkCategory, AbstractPerk> rightC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 8, Perk.PHYSICAL_DEFENCE, rightA);
        rightC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 9, Perk.PHYSICAL_DEFENCE, rightC);
        rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 8, Perk.ENERGY_BOOST, rightA);
        rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 9, Perk.ENERGY_BOOST, rightB);
        rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 10, Perk.COMBAT_REGENERATION, rightB, rightC);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 11, Perk.MELEE_DAMAGE, new TreeEntry[0]);
        connectorLeft = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 11, Perk.PHYSIQUE_BOOST_MAJOR, leftB, rightB);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 11, Perk.RANGED_DAMAGE, connectorLeft);
        leftA.addLink(connectorLeft);
        connectorLeft = PerkManager.addPerkEntry(this.perkTree, PerkCategory.PHYSICAL, 12, Perk.ELEMENTAL_BOOST, connectorLeft);
        leftC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 2, Perk.VIRILITY_BOOST, both1);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 2, Perk.FIRING_BLANKS, both1);
        leftC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 3, Perk.VIRILITY_MAJOR_BOOST, leftC);
        leftC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 4, Perk.FETISH_SEEDER, leftC);
        leftC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 5, Perk.VIRILITY_BOOST, leftC);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 5, Perk.VIRILITY_MAJOR_BOOST, leftC);
        leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 2, Perk.SEDUCTION_BOOST, both1);
        TreeEntry<PerkCategory, AbstractPerk> leftMidB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 3, Perk.SEDUCTION_BOOST, leftMidA);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 3, Perk.ORGASMIC_LEVEL_DRAIN, leftMidA);
        TreeEntry<PerkCategory, AbstractPerk> rightMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 3, Perk.SEDUCTION_DEFENCE_BOOST, leftMidA);
        leftMidB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 4, Perk.SEDUCTION_BOOST, leftMidB);
        TreeEntry<PerkCategory, AbstractPerk> connectorMid = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 4, Perk.AHEGAO, leftMidB);
        rightMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 4, Perk.SEDUCTION_DEFENCE_BOOST, rightMidA);
        rightMidA.addLink(connectorMid);
        rightMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 5, Perk.CRITICAL_BOOST_LUST, leftMidB, rightMidA);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 2, Perk.BARREN, both1);
        rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 2, Perk.FERTILITY_BOOST, both1);
        rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 3, Perk.FERTILITY_MAJOR_BOOST, rightB);
        rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 4, Perk.FETISH_BROODMOTHER, rightB);
        rightC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 5, Perk.FERTILITY_MAJOR_BOOST, new TreeEntry[0]);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 5, Perk.FERTILITY_BOOST, rightB, rightC);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 6, Perk.MALE_ATTRACTION, new TreeEntry[0]);
        connectorMid = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 6, Perk.SEDUCTION_BOOST_MAJOR, rightMidA);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 6, Perk.FEMALE_ATTRACTION, connectorMid);
        leftA.addLink(connectorMid);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 7, Perk.SEDUCTION_BOOST, connectorMid);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 8, Perk.SEDUCTION_BOOST, leftA);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 9, Perk.SEDUCTION_BOOST, leftA);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 10, Perk.LUSTPYRE, leftA);
        leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 7, Perk.SEDUCTION_BOOST_ALT, connectorMid);
        leftMidB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 8, Perk.CONVINCING_REQUESTS, new TreeEntry[0]);
        leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 8, Perk.SEDUCTION_BOOST_MAJOR, leftMidA);
        leftMidB.addLink(leftMidA);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 8, Perk.OBJECT_OF_DESIRE, leftMidA);
        leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 9, Perk.SEDUCTION_BOOST_ALT, leftMidA);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 10, Perk.NYMPHOMANIAC, leftMidA);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 7, Perk.SEDUCTION_DEFENCE_BOOST, connectorMid);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 8, Perk.SEDUCTION_DEFENCE_BOOST, rightA);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 9, Perk.SEDUCTION_DEFENCE_BOOST, rightA);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 10, Perk.PURE_MIND, rightA);
        connectorMid = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 11, Perk.SEDUCTION_BOOST_MAJOR, leftA, rightA);
        connectorMid = PerkManager.addPerkEntry(this.perkTree, PerkCategory.LUST, 12, Perk.ELEMENTAL_BOOST_ALT, connectorMid);
        rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 2, Perk.ENCHANTMENT_STABILITY_ALT, arcane1);
        rightB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 3, Perk.ENCHANTMENT_STABILITY_ALT, rightB);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 4, Perk.CLOTHING_ENCHANTER, rightB);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 2, Perk.ARCANE_CRITICALS, arcane1);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 2, Perk.ARCANE_BOOST, arcane1);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 3, Perk.SPELL_DAMAGE, rightA);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 4, Perk.SPELL_DAMAGE, leftA);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 5, Perk.ELEMENTAL_BOOST, leftA);
        leftB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 5, Perk.CRITICAL_BOOST_ARCANE, leftA);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 5, Perk.CHUUNI, leftB);
        leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 3, Perk.AURA_BOOST, rightA);
        leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 4, Perk.AURA_BOOST, leftMidA);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 3, Perk.SPELL_EFFICIENCY, rightA);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 4, Perk.SPELL_EFFICIENCY, rightA);
        rightA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 5, Perk.ARCANE_COMBATANT, leftMidA, rightA);
        TreeEntry<PerkCategory, AbstractPerk> connectorRight = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 6, Perk.ARCANE_BOOST_MAJOR, leftA, rightA);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 7, Perk.AURA_BOOST, connectorRight);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 8, Perk.AURA_BOOST, leftA);
        leftMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 7, Perk.SPELL_EFFICIENCY, connectorRight);
        leftMidB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 8, Perk.SPELL_EFFICIENCY, leftMidA);
        TreeEntry<PerkCategory, AbstractPerk> leftMidC = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 9, Perk.AURA_BOOST, new TreeEntry[0]);
        leftMidB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 9, Perk.SPELL_EFFICIENCY, leftMidB);
        leftMidC.addLink(leftMidB);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 10, Perk.SACRIFICIAL_SHIELDING, leftMidC);
        leftMidB = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 10, Perk.SPELL_EFFICIENCY, leftMidB);
        rightMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 7, Perk.SPELL_DAMAGE, leftMidA);
        rightMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 8, Perk.SPELL_DAMAGE, rightMidA);
        rightMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 9, Perk.SPELL_DAMAGE_MAJOR, rightMidA);
        rightMidA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 10, Perk.ARCANE_VAMPYRISM, rightMidA);
        leftA = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 11, Perk.ELEMENTAL_DEFENCE_BOOST, new TreeEntry[0]);
        connectorRight = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 11, Perk.ARCANE_BOOST_MAJOR, leftMidB);
        PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 11, Perk.ELEMENTAL_BOOST, connectorRight);
        leftA.addLink(connectorRight);
        connectorRight = PerkManager.addPerkEntry(this.perkTree, PerkCategory.ARCANE, 12, Perk.ELEMENTAL_BOOST_ALT_2, connectorRight);
        connectorLeft.addLink(connectorMid);
        connectorRight.addLink(connectorMid);
        this.elementalPerkTree = new HashMap<Integer, Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>>>();
        for (i = 0; i < 20; ++i) {
            this.elementalPerkTree.put(i, new HashMap());
            for (PerkCategory category : PerkCategory.values()) {
                this.elementalPerkTree.get(i).put(category, new ArrayList());
            }
        }
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 0, Perk.ELEMENTAL_EARTH_SPELL_1, new TreeEntry[0]);
        this.elementalStartingPerks.add(physical1);
        TreeEntry<PerkCategory, AbstractPerk> physical3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 1, Perk.ELEMENTAL_EARTH_SPELL_1_1, physical1);
        TreeEntry<PerkCategory, AbstractPerk> physical4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 2, Perk.ELEMENTAL_EARTH_SPELL_1_2, physical3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 3, Perk.ELEMENTAL_EARTH_SPELL_1_3, physical4);
        TreeEntry<PerkCategory, AbstractPerk> physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 1, Perk.ELEMENTAL_EARTH_BOOST_MINOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 2, Perk.ELEMENTAL_EARTH_BOOST, physical2);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 3, Perk.ELEMENTAL_EARTH_BOOST_MAJOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 4, Perk.ELEMENTAL_EARTH_SPELL_2, physical2);
        physical3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 5, Perk.ELEMENTAL_EARTH_SPELL_2_1, physical1);
        physical4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 6, Perk.ELEMENTAL_EARTH_SPELL_2_2, physical3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 7, Perk.ELEMENTAL_EARTH_SPELL_2_3, physical4);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 5, Perk.ELEMENTAL_EARTH_BOOST_MINOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 6, Perk.ELEMENTAL_EARTH_BOOST, physical2);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 7, Perk.ELEMENTAL_EARTH_BOOST_MAJOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 8, Perk.ELEMENTAL_EARTH_SPELL_3, physical2);
        physical3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 9, Perk.ELEMENTAL_EARTH_SPELL_3_1, physical1);
        physical4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 10, Perk.ELEMENTAL_EARTH_SPELL_3_2, physical3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 11, Perk.ELEMENTAL_EARTH_SPELL_3_3, physical4);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 9, Perk.ELEMENTAL_EARTH_BOOST_MINOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 10, Perk.ELEMENTAL_EARTH_BOOST, physical2);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 11, Perk.ELEMENTAL_EARTH_BOOST_MAJOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 12, Perk.ELEMENTAL_EARTH_BOOST_ULTIMATE, physical2);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 0, Perk.ELEMENTAL_WATER_SPELL_1, new TreeEntry[0]);
        this.elementalStartingPerks.add(physical1);
        physical3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 1, Perk.ELEMENTAL_WATER_SPELL_1_1, physical1);
        physical4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 2, Perk.ELEMENTAL_WATER_SPELL_1_2, physical3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 3, Perk.ELEMENTAL_WATER_SPELL_1_3, physical4);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 1, Perk.ELEMENTAL_WATER_BOOST_MINOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 2, Perk.ELEMENTAL_WATER_BOOST, physical2);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 3, Perk.ELEMENTAL_WATER_BOOST_MAJOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 4, Perk.ELEMENTAL_WATER_SPELL_2, physical2);
        physical3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 5, Perk.ELEMENTAL_WATER_SPELL_2_1, physical1);
        physical4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 6, Perk.ELEMENTAL_WATER_SPELL_2_2, physical3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 7, Perk.ELEMENTAL_WATER_SPELL_2_3, physical4);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 5, Perk.ELEMENTAL_WATER_BOOST_MINOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 6, Perk.ELEMENTAL_WATER_BOOST, physical2);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 7, Perk.ELEMENTAL_WATER_BOOST_MAJOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 8, Perk.ELEMENTAL_WATER_SPELL_3, physical2);
        physical3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 9, Perk.ELEMENTAL_WATER_SPELL_3_1, physical1);
        physical4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 10, Perk.ELEMENTAL_WATER_SPELL_3_2, physical3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 11, Perk.ELEMENTAL_WATER_SPELL_3_3, physical4);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 9, Perk.ELEMENTAL_WATER_BOOST_MINOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 10, Perk.ELEMENTAL_WATER_BOOST, physical2);
        physical2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 11, Perk.ELEMENTAL_WATER_BOOST_MAJOR, physical1);
        physical1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.PHYSICAL, 12, Perk.ELEMENTAL_WATER_BOOST_ULTIMATE, physical2);
        both1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 0, Perk.ELEMENTAL_ARCANE_SPELL_1, new TreeEntry[0]);
        this.elementalStartingPerks.add(both1);
        TreeEntry<PerkCategory, AbstractPerk> both3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 1, Perk.ELEMENTAL_ARCANE_SPELL_1_1, both1);
        TreeEntry<PerkCategory, AbstractPerk> both4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 2, Perk.ELEMENTAL_ARCANE_SPELL_1_2, both3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 3, Perk.ELEMENTAL_ARCANE_SPELL_1_3, both4);
        TreeEntry<PerkCategory, AbstractPerk> both2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 1, Perk.ELEMENTAL_ARCANE_BOOST_MINOR, both1);
        both1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 2, Perk.ELEMENTAL_ARCANE_BOOST, both2);
        both2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 3, Perk.ELEMENTAL_ARCANE_BOOST_MAJOR, both1);
        both1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 4, Perk.ELEMENTAL_ARCANE_SPELL_2, both2);
        both3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 5, Perk.ELEMENTAL_ARCANE_SPELL_2_1, both1);
        both4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 6, Perk.ELEMENTAL_ARCANE_SPELL_2_2, both3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 7, Perk.ELEMENTAL_ARCANE_SPELL_2_3, both4);
        both2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 5, Perk.ELEMENTAL_ARCANE_BOOST_MINOR, both1);
        both1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 6, Perk.ELEMENTAL_ARCANE_BOOST, both2);
        both2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 7, Perk.ELEMENTAL_ARCANE_BOOST_MAJOR, both1);
        both1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 8, Perk.ELEMENTAL_ARCANE_SPELL_3, both2);
        both3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 9, Perk.ELEMENTAL_ARCANE_SPELL_3_1, both1);
        both4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 10, Perk.ELEMENTAL_ARCANE_SPELL_3_2, both3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 11, Perk.ELEMENTAL_ARCANE_SPELL_3_3, both4);
        both2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 9, Perk.ELEMENTAL_ARCANE_BOOST_MINOR, both1);
        both1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 10, Perk.ELEMENTAL_ARCANE_BOOST, both2);
        both2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 11, Perk.ELEMENTAL_ARCANE_BOOST_MAJOR, both1);
        both1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.LUST, 12, Perk.ELEMENTAL_ARCANE_BOOST_ULTIMATE, both2);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 0, Perk.ELEMENTAL_FIRE_SPELL_1, new TreeEntry[0]);
        this.elementalStartingPerks.add(arcane1);
        TreeEntry<PerkCategory, AbstractPerk> arcane3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 1, Perk.ELEMENTAL_FIRE_SPELL_1_1, arcane1);
        TreeEntry<PerkCategory, AbstractPerk> arcane4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 2, Perk.ELEMENTAL_FIRE_SPELL_1_2, arcane3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 3, Perk.ELEMENTAL_FIRE_SPELL_1_3, arcane4);
        TreeEntry<PerkCategory, AbstractPerk> arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 1, Perk.ELEMENTAL_FIRE_BOOST_MINOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 2, Perk.ELEMENTAL_FIRE_BOOST, arcane2);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 3, Perk.ELEMENTAL_FIRE_BOOST_MAJOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 4, Perk.ELEMENTAL_FIRE_SPELL_2, arcane2);
        arcane3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 5, Perk.ELEMENTAL_FIRE_SPELL_2_1, arcane1);
        arcane4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 6, Perk.ELEMENTAL_FIRE_SPELL_2_2, arcane3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 7, Perk.ELEMENTAL_FIRE_SPELL_2_3, arcane4);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 5, Perk.ELEMENTAL_FIRE_BOOST_MINOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 6, Perk.ELEMENTAL_FIRE_BOOST, arcane2);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 7, Perk.ELEMENTAL_FIRE_BOOST_MAJOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 8, Perk.ELEMENTAL_FIRE_SPELL_3, arcane2);
        arcane3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 9, Perk.ELEMENTAL_FIRE_SPELL_3_1, arcane1);
        arcane4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 10, Perk.ELEMENTAL_FIRE_SPELL_3_2, arcane3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 11, Perk.ELEMENTAL_FIRE_SPELL_3_3, arcane4);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 9, Perk.ELEMENTAL_FIRE_BOOST_MINOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 10, Perk.ELEMENTAL_FIRE_BOOST, arcane2);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 11, Perk.ELEMENTAL_FIRE_BOOST_MAJOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 12, Perk.ELEMENTAL_FIRE_BOOST_ULTIMATE, arcane2);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 0, Perk.ELEMENTAL_AIR_SPELL_1, new TreeEntry[0]);
        this.elementalStartingPerks.add(arcane1);
        arcane3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 1, Perk.ELEMENTAL_AIR_SPELL_1_1, arcane1);
        arcane4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 2, Perk.ELEMENTAL_AIR_SPELL_1_2, arcane3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 3, Perk.ELEMENTAL_AIR_SPELL_1_3, arcane4);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 1, Perk.ELEMENTAL_AIR_BOOST_MINOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 2, Perk.ELEMENTAL_AIR_BOOST, arcane2);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 3, Perk.ELEMENTAL_AIR_BOOST_MAJOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 4, Perk.ELEMENTAL_AIR_SPELL_2, arcane2);
        arcane3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 5, Perk.ELEMENTAL_AIR_SPELL_2_1, arcane1);
        arcane4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 6, Perk.ELEMENTAL_AIR_SPELL_2_2, arcane3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 7, Perk.ELEMENTAL_AIR_SPELL_2_3, arcane4);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 5, Perk.ELEMENTAL_AIR_BOOST_MINOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 6, Perk.ELEMENTAL_AIR_BOOST, arcane2);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 7, Perk.ELEMENTAL_AIR_BOOST_MAJOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 8, Perk.ELEMENTAL_AIR_SPELL_3, arcane2);
        arcane3 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 9, Perk.ELEMENTAL_AIR_SPELL_3_1, arcane1);
        arcane4 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 10, Perk.ELEMENTAL_AIR_SPELL_3_2, arcane3);
        PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 11, Perk.ELEMENTAL_AIR_SPELL_3_3, arcane4);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 9, Perk.ELEMENTAL_AIR_BOOST_MINOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 10, Perk.ELEMENTAL_AIR_BOOST, arcane2);
        arcane2 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 11, Perk.ELEMENTAL_AIR_BOOST_MAJOR, arcane1);
        arcane1 = PerkManager.addPerkEntry(this.elementalPerkTree, PerkCategory.ARCANE, 12, Perk.ELEMENTAL_AIR_BOOST_ULTIMATE, arcane2);
        this.dollPerkTree = new HashMap<Integer, Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>>>();
        for (i = 0; i < 20; ++i) {
            this.dollPerkTree.put(i, new HashMap());
            for (PerkCategory category : PerkCategory.values()) {
                this.dollPerkTree.get(i).put(category, new ArrayList());
            }
        }
        physical1 = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.PHYSICAL, 1, Perk.DOLL_PHYSICAL_CORE, new TreeEntry[0]);
        this.dollStartingPerks.add(physical1);
        TreeEntry<PerkCategory, AbstractPerk> dollPerk = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.PHYSICAL, 2, Perk.DOLL_PHYSICAL_1, physical1);
        this.dollStartingPerks.add(dollPerk);
        dollPerk = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.PHYSICAL, 2, Perk.DOLL_PHYSICAL_2, physical1);
        this.dollStartingPerks.add(dollPerk);
        dollPerk = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.PHYSICAL, 2, Perk.DOLL_PHYSICAL_3, physical1);
        this.dollStartingPerks.add(dollPerk);
        arcane1 = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.ARCANE, 1, Perk.DOLL_ARCANE_CORE, new TreeEntry[0]);
        this.dollStartingPerks.add(arcane1);
        dollPerk = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.ARCANE, 2, Perk.DOLL_ARCANE_1, arcane1);
        this.dollStartingPerks.add(dollPerk);
        dollPerk = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.ARCANE, 2, Perk.DOLL_ARCANE_2, arcane1);
        this.dollStartingPerks.add(dollPerk);
        dollPerk = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.ARCANE, 2, Perk.DOLL_ARCANE_3, arcane1);
        this.dollStartingPerks.add(dollPerk);
        both1 = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.LUST, 1, Perk.DOLL_LUST_CORE, physical1, arcane1);
        this.dollStartingPerks.add(both1);
        dollPerk = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.LUST, 2, Perk.DOLL_LUST_1, both1);
        this.dollStartingPerks.add(dollPerk);
        dollPerk = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.LUST, 2, Perk.DOLL_LUST_2, both1);
        this.dollStartingPerks.add(dollPerk);
        dollPerk = PerkManager.addPerkEntry(this.dollPerkTree, PerkCategory.LUST, 2, Perk.DOLL_LUST_3, both1);
        this.dollStartingPerks.add(dollPerk);
    }

    @SafeVarargs
    private static TreeEntry<PerkCategory, AbstractPerk> addPerkEntry(Map<Integer, Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>>> perkTree, PerkCategory category, int row, AbstractPerk perk, TreeEntry<PerkCategory, AbstractPerk> ... links) {
        TreeEntry<PerkCategory, AbstractPerk> entry = new TreeEntry<PerkCategory, AbstractPerk>(category, row, perk);
        perkTree.get(row).get((Object)category).add(entry);
        for (TreeEntry<PerkCategory, AbstractPerk> linkEntry : links) {
            entry.addLink(linkEntry);
        }
        return entry;
    }

    public boolean isPerkAnywhereInAvailableTree(AbstractPerk perk, GameCharacter character) {
        for (Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>> entry : this.getPerkTree(character).values()) {
            for (List<TreeEntry<PerkCategory, AbstractPerk>> treeListEntry : entry.values()) {
                for (TreeEntry<PerkCategory, AbstractPerk> treeEntry : treeListEntry) {
                    if (treeEntry.getEntry() != perk) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Map<Integer, Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>>> getPerkTree(GameCharacter character) {
        if (character.isElemental()) {
            return this.elementalPerkTree;
        }
        if (character.isDoll()) {
            return this.dollPerkTree;
        }
        return this.perkTree;
    }

    public static List<TreeEntry<PerkCategory, AbstractPerk>> getStartingPerks(GameCharacter character) {
        if (character.isElemental()) {
            return PerkManager.MANAGER.elementalStartingPerks;
        }
        if (character.isDoll()) {
            return PerkManager.MANAGER.dollStartingPerks;
        }
        return PerkManager.MANAGER.standardStartingPerks;
    }

    public static int getInitialPerkCount(GameCharacter character) {
        return PerkManager.getStartingPerks(character).size();
    }

    public static int getInitialPerkCount(GameCharacter character, PerkCategory category) {
        int count = 0;
        for (TreeEntry<PerkCategory, AbstractPerk> entry : PerkManager.getStartingPerks(character)) {
            if (entry.getCategory() != category) continue;
            ++count;
        }
        return count;
    }

    public static void initialiseSpecialPerksUponCreation(GameCharacter character) {
        Random rnd = new Random(character.getId().hashCode());
        if (!character.isUnique() && !character.isElemental() && rnd.nextInt(100) <= 50) {
            HashMap<PerkCategory, Integer> perkWeightingMap = character.getBody() != null && character.getSubspecies() != null ? new HashMap<PerkCategory, Integer>(character.getSubspecies().getPerkWeighting(character)) : Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1));
            PerkCategory pc = Util.getRandomObjectFromWeightedMap(perkWeightingMap, rnd);
            Set<AbstractPerk> specialPerks = character.getSpecialPerks();
            for (AbstractPerk perk : new HashSet<AbstractPerk>(specialPerks)) {
                if (!perk.isBackgroundPerk()) continue;
                character.removeSpecialPerk(perk);
            }
            switch (pc) {
                case ARCANE: {
                    character.addSpecialPerk(Perk.SPECIAL_ARCANE_TRAINING);
                    break;
                }
                case ARCANE_AIR: {
                    break;
                }
                case ARCANE_FIRE: {
                    break;
                }
                case JOB: {
                    break;
                }
                case LUST: {
                    if (!(character.getFetishDesire(Fetish.FETISH_PURE_VIRGIN).isPositive() || character.hasPenisIgnoreDildo() && character.isPenisVirgin() || character.hasVagina() && character.isVaginaVirgin())) {
                        character.addSpecialPerk(Perk.SPECIAL_SLUT);
                        break;
                    }
                    character.addSpecialPerk(Perk.SPECIAL_DIRTY_MINDED);
                    break;
                }
                case PHYSICAL: {
                    if (Math.random() < 0.5) {
                        character.addSpecialPerk(Perk.SPECIAL_MARTIAL_BACKGROUND);
                        break;
                    }
                    character.addSpecialPerk(Perk.SPECIAL_HEALTH_FANATIC);
                    break;
                }
                case PHYSICAL_EARTH: {
                    break;
                }
            }
            if (Math.random() < (double)0.05f && !character.isPerfectVision()) {
                character.addSpecialPerk(Perk.SPECIAL_SHORT_SIGHTED);
            }
        }
    }

    public static Set<AbstractPerk> initialisePerks(GameCharacter character) {
        return PerkManager.initialisePerks(character, true, null, null);
    }

    public static Set<AbstractPerk> initialisePerks(GameCharacter character, boolean autoSelectPerks) {
        return PerkManager.initialisePerks(character, autoSelectPerks, null, null);
    }

    public static Set<AbstractPerk> initialisePerks(GameCharacter character, boolean autoSelectPerks, List<AbstractPerk> requiredPerks) {
        return PerkManager.initialisePerks(character, autoSelectPerks, requiredPerks, null);
    }

    public static Set<AbstractPerk> initialisePerks(GameCharacter character, List<AbstractPerk> requiredPerks, Map<PerkCategory, Integer> perkWeightingOverride) {
        return PerkManager.initialisePerks(character, true, requiredPerks, perkWeightingOverride);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<AbstractPerk> initialisePerks(GameCharacter character, boolean autoSelectPerks, List<AbstractPerk> requiredPerks, Map<PerkCategory, Integer> perkWeightingOverride) {
        HashSet<AbstractPerk> perksAdded;
        block35: {
            block36: {
                perksAdded = new HashSet<AbstractPerk>();
                if (character.isDoll()) {
                    requiredPerks = null;
                    perkWeightingOverride = null;
                }
                for (TreeEntry<PerkCategory, AbstractPerk> perk : PerkManager.getStartingPerks(character)) {
                    if (!character.addPerk(perk.getRow(), perk.getEntry())) continue;
                    perksAdded.add(perk.getEntry());
                }
                if (!character.isElemental()) break block36;
                if (((Elemental)character).getSummoner() == null || ((Elemental)character).getSummoner().isPlayer()) break block35;
                Object associatedPerkCategory = PerkCategory.LUST;
                switch (((Elemental)character).getCurrentSchool()) {
                    case AIR: {
                        associatedPerkCategory = PerkCategory.ARCANE_AIR;
                        break;
                    }
                    case ARCANE: {
                        associatedPerkCategory = PerkCategory.LUST;
                        break;
                    }
                    case EARTH: {
                        associatedPerkCategory = PerkCategory.PHYSICAL_EARTH;
                        break;
                    }
                    case FIRE: {
                        associatedPerkCategory = PerkCategory.ARCANE_FIRE;
                        break;
                    }
                    case WATER: {
                        associatedPerkCategory = PerkCategory.PHYSICAL_WATER;
                    }
                }
                for (Map.Entry entry2 : PerkManager.MANAGER.elementalPerkTree.entrySet()) {
                    for (Map.Entry innerEntry : ((Map)entry2.getValue()).entrySet()) {
                        for (TreeEntry treeEntry : (List)innerEntry.getValue()) {
                            if (((AbstractPerk)treeEntry.getEntry()).getPerkCategory() != associatedPerkCategory) continue;
                            if (character.getPerkPoints() > 0) {
                                character.addPerk(treeEntry.getRow(), (AbstractPerk)treeEntry.getEntry());
                                continue;
                            }
                            break block35;
                        }
                    }
                }
                break block35;
            }
            if (!character.isPlayer() && autoSelectPerks) {
                void var7_12;
                if (requiredPerks != null) {
                    for (AbstractPerk requiredPerk : requiredPerks) {
                        for (TreeEntry<PerkCategory, AbstractPerk> entry3 : Pathing.aStarPathingPerkTree(character, MANAGER.getFirstPerkEntry(character, requiredPerk))) {
                            if (character.addPerk(entry3.getRow(), entry3.getEntry())) {
                                perksAdded.add(entry3.getEntry());
                            }
                            if (!entry3.getEntry().isEquippableTrait()) continue;
                            character.addTrait(entry3.getEntry());
                        }
                    }
                }
                ArrayList<AbstractPerk> deniedPerks = new ArrayList<AbstractPerk>();
                deniedPerks.add(Perk.OBSERVANT);
                deniedPerks.add(Perk.ORGASMIC_LEVEL_DRAIN);
                deniedPerks.add(Perk.CHUUNI);
                deniedPerks.add(Perk.BARREN);
                deniedPerks.add(Perk.FIRING_BLANKS);
                deniedPerks.add(Perk.HYPERMOBILITY);
                if (character.isUnique()) {
                    deniedPerks.add(Perk.AHEGAO);
                    deniedPerks.add(Perk.HEAVY_SLEEPER);
                }
                if ((float)character.getEnchantmentPointsUsedTotal() <= character.getAttributeValue(Attribute.ENCHANTMENT_LIMIT) || !Main.game.isEnchantmentCapacityEnabled()) {
                    deniedPerks.add(Perk.ENCHANTMENT_STABILITY);
                    deniedPerks.add(Perk.ENCHANTMENT_STABILITY_ALT);
                }
                if (character.getSexualOrientation() == SexualOrientation.GYNEPHILIC) {
                    deniedPerks.add(Perk.MALE_ATTRACTION);
                }
                if (character.getSexualOrientation() == SexualOrientation.ANDROPHILIC) {
                    deniedPerks.add(Perk.FEMALE_ATTRACTION);
                }
                if (!character.getFetishDesire(Fetish.FETISH_IMPREGNATION).isPositive()) {
                    deniedPerks.add(Perk.VIRILITY_BOOST);
                }
                if (!character.getFetishDesire(Fetish.FETISH_PREGNANCY).isPositive()) {
                    deniedPerks.add(Perk.FERTILITY_BOOST);
                }
                Random rnd = new Random(character.getId().hashCode());
                if (perkWeightingOverride != null) {
                    HashMap<PerkCategory, Integer> hashMap = new HashMap<PerkCategory, Integer>(perkWeightingOverride);
                } else if (character.getBody() != null && character.getSubspecies() != null) {
                    HashMap<PerkCategory, Integer> hashMap = new HashMap<PerkCategory, Integer>(character.getSubspecies().getPerkWeighting(character));
                } else {
                    LinkedHashMap linkedHashMap = Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1));
                }
                var7_12.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
                ArrayList<TreeEntry> traits = new ArrayList<TreeEntry>();
                while (character.getPerkPoints() > 0) {
                    PerkCategory category = (PerkCategory)((Object)Util.getRandomObjectFromWeightedMap(var7_12, rnd));
                    HashMap<TreeEntry<PerkCategory, AbstractPerk>, Integer> weightedAvailabilityMap = new HashMap<TreeEntry<PerkCategory, AbstractPerk>, Integer>();
                    for (Map<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>> map : PerkManager.MANAGER.perkTree.values()) {
                        for (TreeEntry<PerkCategory, AbstractPerk> perkEntry : map.get((Object)category)) {
                            if (perkEntry.getRow() <= 0 || !MANAGER.isPerkAvailable(character, perkEntry) || deniedPerks.contains(perkEntry.getEntry())) continue;
                            if ((perkEntry.getEntry().equals(Perk.ENCHANTMENT_STABILITY) || perkEntry.getEntry().equals(Perk.ENCHANTMENT_STABILITY_ALT)) && (float)character.getEnchantmentPointsUsedTotal() > character.getAttributeValue(Attribute.ENCHANTMENT_LIMIT)) {
                                weightedAvailabilityMap.put(perkEntry, 1000);
                                continue;
                            }
                            weightedAvailabilityMap.put(perkEntry, 1);
                        }
                    }
                    if (weightedAvailabilityMap.isEmpty()) {
                        var7_12.remove((Object)category);
                        if (!var7_12.isEmpty()) continue;
                        break;
                    }
                    TreeEntry entryToAdd = (TreeEntry)Util.getRandomObjectFromWeightedMap(weightedAvailabilityMap, rnd);
                    if (character.addPerk(entryToAdd.getRow(), (AbstractPerk)entryToAdd.getEntry())) {
                        perksAdded.add((AbstractPerk)entryToAdd.getEntry());
                    }
                    if (!((AbstractPerk)entryToAdd.getEntry()).isEquippableTrait()) continue;
                    traits.add(entryToAdd);
                }
                traits.sort((t1, t2) -> t1.getRow() > t2.getRow() ? -1 : (t1.getRow() < t2.getRow() ? 1 : 0));
                for (TreeEntry trait : traits) {
                    character.addTrait((AbstractPerk)trait.getEntry());
                }
            }
        }
        return perksAdded;
    }

    public String getPerkTreeDisplay(GameCharacter character, boolean includePointsRemaining) {
        int i;
        this.treeSB.setLength(0);
        this.treeSB.append("<div class='container-full-width' style='padding:8px; text-align:center;'><h6 style='text-align:center;'>\u751f\u6548\u7279\u6027</h6>");
        this.treeSB.append("<div id='OCCUPATION_" + Perk.getIdFromPerk(character.getHistory().getAssociatedPerk()) + "' class='square-button small' style='width:8%; display:inline-block; float:none; border:2px solid " + PresetColour.GENERIC_EXCELLENT.toWebHexString() + ";'><div class='square-button-content'>" + character.getHistory().getAssociatedPerk().getSVGString(character) + "</div></div>");
        for (i = 0; i < 6; ++i) {
            AbstractPerk p = null;
            if (i < character.getTraits().size()) {
                p = character.getTraits().get(i);
            }
            if (p != null) {
                this.treeSB.append("<div id='TRAIT_" + Perk.getIdFromPerk(p) + "' class='square-button small' style='width:8%; display:inline-block; float:none; border:2px solid " + PresetColour.TRAIT.toWebHexString() + ";'><div class='square-button-content'>" + p.getSVGString(character) + "</div></div>");
                continue;
            }
            this.treeSB.append("<div id='TRAIT_" + i + "' class='square-button small' style='display:inline-block; float:none;'></div>");
        }
        this.treeSB.append("<div class='container-full-width' style='text-align:center;'>");
        if (includePointsRemaining) {
            this.treeSB.append("<h6 style='text-align:center;'>\u53ef\u7528\u5929\u8d4b\u70b9: ");
            this.treeSB.append(character.getPerkPoints());
            StringBuilder extraPerkPoints = new StringBuilder();
            for (PerkCategory category : PerkCategory.values()) {
                int points = character.getAdditionalPerkCategoryPoints(category) - Math.max(0, character.getPerksInCategory(category) - PerkManager.getInitialPerkCount(character, category));
                if (points <= 0) continue;
                extraPerkPoints.append(" <span style='color:" + category.getColour().toWebHexString() + ";'>" + points + "</span>");
            }
            if (extraPerkPoints.length() > 0) {
                this.treeSB.append("<br/>\u7279\u5b9a\u5206\u7c7b\u5929\u8d4b\u70b9:" + extraPerkPoints.toString());
            }
            this.treeSB.append("</h6>");
        }
        if (character.getSpecialPerks().size() > 0) {
            ArrayList<AbstractPerk> subspeciesKnowledgePerks = new ArrayList<AbstractPerk>();
            this.treeSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'>");
            for (AbstractPerk hiddenPerk : Perk.getHiddenPerks()) {
                if (!character.hasPerkAnywhereInTree(hiddenPerk)) continue;
                if (Perk.getSubspeciesKnowledgePerks().contains(hiddenPerk)) {
                    subspeciesKnowledgePerks.add(hiddenPerk);
                    continue;
                }
                this.treeSB.append("<div id='HIDDEN_PERK_" + Perk.getIdFromPerk(hiddenPerk) + "' class='square-button round small' style='width:6%; display:inline-block; float:none; border-color:" + PresetColour.GENERIC_EXCELLENT.toWebHexString() + "; cursor:default;'><div class='square-button-content'>" + hiddenPerk.getSVGString(character) + "</div></div>");
            }
            this.treeSB.append("</div>");
            Collections.sort(subspeciesKnowledgePerks, (p1, p2) -> p1.getName(character).compareTo(p2.getName(character)));
            this.treeSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'>");
            for (AbstractPerk hiddenPerk : subspeciesKnowledgePerks) {
                this.treeSB.append("<div id='HIDDEN_PERK_" + Perk.getIdFromPerk(hiddenPerk) + "' class='square-button round small' style='width:6%; padding:0; left:12px; margin:0 0 0 -24px; display:inline-block; float:none; border-color:" + hiddenPerk.getColour().toWebHexString() + "; cursor:default;'><div class='square-button-content'>" + hiddenPerk.getSVGString(character) + "</div></div>");
            }
            this.treeSB.append("</div>");
        }
        for (i = 0; i < 20; ++i) {
            this.treeSB.append("<div class='container-full-width' style='width:100%; padding:0; margin:0; display: -ms-flex; display: -webkit-flex; display: flex;'>");
            this.appendPerkColumn(character, i, PerkCategory.PHYSICAL);
            this.appendPerkColumn(character, i, PerkCategory.LUST);
            this.appendPerkColumn(character, i, PerkCategory.ARCANE);
            this.treeSB.append("</div>");
        }
        this.treeSB.append("</div>");
        return this.treeSB.toString();
    }

    private void appendPerkColumn(GameCharacter character, int row, PerkCategory category) {
        this.treeSB.append("<div class='container-full-width' style='width: 33.3%; padding:0; margin:0; flex:1;'>");
        List<TreeEntry<PerkCategory, AbstractPerk>> perkList = this.getPerkTree(character).get(row).get((Object)category);
        int size = perkList.size();
        this.treeSB.append(this.getHorizontalLine(character, perkList));
        for (TreeEntry<PerkCategory, AbstractPerk> entry : perkList) {
            this.treeSB.append(this.getPerkEntry(character, entry, size));
        }
        this.treeSB.append("</div>");
    }

    private String getHorizontalLine(GameCharacter character, List<TreeEntry<PerkCategory, AbstractPerk>> perkList) {
        this.lineSB.setLength(0);
        for (TreeEntry<PerkCategory, AbstractPerk> entry : perkList) {
            float entryX = this.getX(character, entry.getRow(), entry);
            for (TreeEntry<PerkCategory, AbstractPerk> siblingEntry : entry.getSiblingLinks()) {
                float siblingX = this.getX(character, siblingEntry.getRow(), siblingEntry) + this.siblingDifference(entry.getCategory(), siblingEntry.getCategory());
                this.lineSB.append("<div style='width:100%; height:100%; padding:0; margin:0; top:0; left:0; position:absolute; pointer-events:none;'><svg width='100%' height='100%'><line x1='" + siblingX + "%' y1='50%' x2='" + entryX + "%' y2='50%' stroke='" + this.getPerkLineSiblingColour(character, entry).toWebHexString() + "' stroke-width='2px'/></svg></div>");
            }
            for (TreeEntry<PerkCategory, AbstractPerk> parentEntry : entry.getParentLinks()) {
                float parentX = this.getX(character, parentEntry.getRow(), parentEntry);
                String colour = this.getPerkLineParentColour(character, entry).toWebHexString();
                if (!(Math.abs(entryX - parentX) > 0.01f)) continue;
                this.lineSB.append("<div style='width:100%; padding:0; margin:0; top:0; left:0; position:absolute; pointer-events: none;'><svg style='padding:0; margin:0;' width='100%'><line x1='" + entryX + "%' y1='0' x2='" + parentX + "%' y2='0' stroke='" + colour + "' stroke-width='4px'/></svg></div>");
            }
        }
        return this.lineSB.toString();
    }

    private float siblingDifference(PerkCategory entryCategory, PerkCategory siblingCategory) {
        float entryX = 0.0f;
        float siblingX = 0.0f;
        switch (entryCategory) {
            case ARCANE: 
            case ARCANE_AIR: 
            case ARCANE_FIRE: {
                entryX = 300.0f;
                break;
            }
            case LUST: {
                entryX = 200.0f;
                break;
            }
            case PHYSICAL: 
            case PHYSICAL_EARTH: 
            case PHYSICAL_WATER: {
                entryX = 100.0f;
                break;
            }
        }
        switch (siblingCategory) {
            case ARCANE: 
            case ARCANE_AIR: 
            case ARCANE_FIRE: {
                siblingX = 300.0f;
                break;
            }
            case LUST: {
                siblingX = 200.0f;
                break;
            }
            case PHYSICAL: 
            case PHYSICAL_EARTH: 
            case PHYSICAL_WATER: {
                siblingX = 100.0f;
                break;
            }
        }
        return siblingX - entryX;
    }

    private float getMargin(int size) {
        return (float)(100 - size * 16) / ((float)size * 2.0f);
    }

    private float getX(GameCharacter character, int row, TreeEntry<PerkCategory, AbstractPerk> entry) {
        List<TreeEntry<PerkCategory, AbstractPerk>> list = this.getPerkTree(character).get(row).get((Object)entry.getCategory());
        int size = list.size();
        float marginSize = this.getMargin(size);
        int column = list.indexOf(entry);
        return marginSize * (float)column * 2.0f + (float)(column * 16) + 8.0f + marginSize;
    }

    private String getPerkEntry(GameCharacter character, TreeEntry<PerkCategory, AbstractPerk> perkEntry, int size) {
        this.entrySB.setLength(0);
        boolean disabled = !this.isPerkOwned(character, perkEntry) && !this.isPerkAvailable(character, perkEntry);
        Colour borderColour = perkEntry.getCategory().getColour();
        switch (perkEntry.getEntry().getPerkCategory()) {
            case ARCANE: 
            case JOB: 
            case LUST: 
            case PHYSICAL: {
                break;
            }
            case ARCANE_AIR: 
            case ARCANE_FIRE: 
            case PHYSICAL_EARTH: 
            case PHYSICAL_WATER: {
                borderColour = perkEntry.getEntry().getPerkCategory().getColour();
            }
        }
        float entryX = this.getX(character, perkEntry.getRow(), perkEntry);
        if (!perkEntry.getParentLinks().isEmpty()) {
            this.entrySB.append("<div style='width:100%; height:100%; padding:0; margin:0; top:0; left:0; position:absolute; pointer-events:none;'><svg width='100%' height='100%'><line x1='" + entryX + "%' y1='0%' x2='" + entryX + "%' y2='50%' stroke='" + this.getPerkLineParentColour(character, perkEntry).toWebHexString() + "' stroke-width='2px'/></svg></div>");
        }
        if (!perkEntry.getChildLinks().isEmpty()) {
            this.entrySB.append("<div style='width:100%; height:100%; padding:0; margin:0; top:0; left:0; position:absolute; pointer-events:none;'><svg width='100%' height='100%'><line x1='" + entryX + "%' y1='100%' x2='" + entryX + "%' y2='50%' stroke='" + this.getPerkLineChildColour(character, perkEntry).toWebHexString() + "' stroke-width='2px'/></svg></div>");
        }
        this.entrySB.append("<div class='square-button" + (perkEntry.getEntry().isEquippableTrait() ? "" : " round") + (disabled ? " disabled" : "") + "' style='width:16%; margin:16px " + this.getMargin(size) + "%; " + (String)(this.isPerkOwned(character, perkEntry) ? (character.hasTraitActivated(perkEntry.getEntry()) ? "border-color:" + PresetColour.TRAIT.toWebHexString() + ";" : "border-color:" + borderColour.toWebHexString() + ";") : "") + "' id='" + perkEntry.getRow() + "_" + String.valueOf((Object)perkEntry.getCategory()) + "_" + Perk.getIdFromPerk(perkEntry.getEntry()) + "'><div class='square-button-content'>" + perkEntry.getEntry().getSVGString(character) + "</div>" + (String)(disabled ? "<div style='position:absolute; left:0; top:0; margin:0; padding:0; width:100%; height:100%; background-color:rgba(0,0,0,0.8); " + (perkEntry.getEntry().isEquippableTrait() ? "border-radius:5px;" : " border-radius:50%;") + "'></div>" : (!this.isPerkOwned(character, perkEntry) ? "<div style='position:absolute; left:0; top:0; margin:0; padding:0; width:100%; height:100%; background-color:rgba(0,0,0,0.6); " + (perkEntry.getEntry().isEquippableTrait() ? "border-radius:5px;" : " border-radius:50%;") + "'></div>" : "")) + "</div>");
        return this.entrySB.toString();
    }

    public boolean isPerkOwned(GameCharacter character, TreeEntry<PerkCategory, AbstractPerk> perkEntry) {
        return character.hasPerkInTree(perkEntry.getRow(), perkEntry.getEntry());
    }

    public boolean isPerkOwned(GameCharacter character, int row, AbstractPerk perk) {
        return character.hasPerkInTree(row, perk);
    }

    public boolean isPerkAvailable(GameCharacter character, TreeEntry<PerkCategory, AbstractPerk> perkEntry) {
        if (perkEntry.getEntry().isAlwaysAvailable()) {
            return true;
        }
        if (!this.isPerkOwned(character, perkEntry)) {
            for (TreeEntry<PerkCategory, AbstractPerk> linkedEntry : perkEntry.getLinks()) {
                if (perkEntry.getRow() < linkedEntry.getRow() || !character.hasPerkInTree(linkedEntry.getRow(), linkedEntry.getEntry())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPerkAvailable(GameCharacter character, int row, AbstractPerk perk) {
        if (perk.isAlwaysAvailable()) {
            return true;
        }
        if (!this.isPerkOwned(character, row, perk)) {
            TreeEntry<PerkCategory, AbstractPerk> perkEntry = null;
            block0: for (Map.Entry<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>> entry : this.getPerkTree(character).get(row).entrySet()) {
                for (TreeEntry<PerkCategory, AbstractPerk> pe : entry.getValue()) {
                    if (pe.getEntry() != perk) continue;
                    perkEntry = pe;
                    break block0;
                }
            }
            if (perkEntry == null) {
                return false;
            }
            for (TreeEntry treeEntry : perkEntry.getLinks()) {
                if (perkEntry.getRow() < treeEntry.getRow() || !character.hasPerkInTree(treeEntry.getRow(), (AbstractPerk)treeEntry.getEntry())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPerkEndOfTreeBranch(GameCharacter character, int row, AbstractPerk perk, boolean onlyCheckOwnedPerks) {
        if (perk.isAlwaysAvailable()) {
            return true;
        }
        TreeEntry<PerkCategory, AbstractPerk> perkEntry = null;
        block0: for (Map.Entry<PerkCategory, List<TreeEntry<PerkCategory, AbstractPerk>>> entry : this.getPerkTree(character).get(row).entrySet()) {
            for (TreeEntry<PerkCategory, AbstractPerk> pe : entry.getValue()) {
                if (pe.getEntry() != perk) continue;
                perkEntry = pe;
                break block0;
            }
        }
        if (perkEntry == null) {
            System.err.println("PerkManager.isPerkEndOfTreeBranch() cannot find an entry for: " + character.getId() + ", " + row + ", " + perk.getName(character));
            return false;
        }
        if (perkEntry.getLinks().size() == 1) {
            return true;
        }
        int siblingLinks = 0;
        for (TreeEntry linkedEntry : perkEntry.getLinks()) {
            if (onlyCheckOwnedPerks && !character.hasPerkInTree(linkedEntry.getRow(), (AbstractPerk)linkedEntry.getEntry())) continue;
            if (perkEntry.getRow() < linkedEntry.getRow()) {
                return false;
            }
            if (linkedEntry.getLinks().size() == 1) {
                return false;
            }
            if (perkEntry.getRow() != linkedEntry.getRow()) continue;
            ++siblingLinks;
        }
        return siblingLinks <= 1;
    }

    private Colour getPerkLineParentColour(GameCharacter character, TreeEntry<PerkCategory, AbstractPerk> entry) {
        boolean parentOwned = false;
        for (TreeEntry<PerkCategory, AbstractPerk> parent : entry.getParentLinks()) {
            if (!character.hasPerkInTree(parent.getRow(), parent.getEntry())) continue;
            parentOwned = true;
            break;
        }
        return this.isPerkOwned(character, entry) && parentOwned ? (character.isElemental() ? entry.getEntry().getColour() : entry.getCategory().getColour()) : (this.isPerkAvailable(character, entry) ? PresetColour.BASE_GREY : PresetColour.TEXT_GREY_DARK);
    }

    private Colour getPerkLineChildColour(GameCharacter character, TreeEntry<PerkCategory, AbstractPerk> entry) {
        boolean childOwned = false;
        boolean childAvailable = false;
        for (TreeEntry<PerkCategory, AbstractPerk> child : entry.getChildLinks()) {
            if (character.hasPerkInTree(child.getRow(), child.getEntry())) {
                childOwned = true;
            }
            if (!this.isPerkOwned(character, entry) || !this.isPerkAvailable(character, child)) continue;
            childAvailable = true;
        }
        return this.isPerkOwned(character, entry) && childOwned ? (character.isElemental() ? entry.getEntry().getColour() : entry.getCategory().getColour()) : (childAvailable ? PresetColour.BASE_GREY : PresetColour.TEXT_GREY_DARK);
    }

    private Colour getPerkLineSiblingColour(GameCharacter character, TreeEntry<PerkCategory, AbstractPerk> entry) {
        boolean siblingOwned = false;
        boolean siblingAvailable = false;
        for (TreeEntry<PerkCategory, AbstractPerk> sibling : entry.getSiblingLinks()) {
            if (character.hasPerkInTree(sibling.getRow(), sibling.getEntry())) {
                siblingOwned = true;
            }
            if ((!this.isPerkAvailable(character, sibling) || !this.isPerkOwned(character, entry)) && (!this.isPerkAvailable(character, entry) || !this.isPerkOwned(character, sibling))) continue;
            siblingAvailable = true;
        }
        return this.isPerkOwned(character, entry) && siblingOwned ? (character.isElemental() ? entry.getEntry().getColour() : entry.getCategory().getColour()) : (siblingAvailable ? PresetColour.BASE_GREY : PresetColour.TEXT_GREY_DARK);
    }

    public TreeEntry<PerkCategory, AbstractPerk> getFirstPerkEntry(GameCharacter character, AbstractPerk perk) {
        for (int i = 0; i < 20; ++i) {
            for (PerkCategory category : PerkCategory.values()) {
                for (TreeEntry<PerkCategory, AbstractPerk> entry : this.getPerkTree(character).get(i).get((Object)category)) {
                    if (entry.getEntry() != perk) continue;
                    return entry;
                }
            }
        }
        return null;
    }

    public int getPerkRow(GameCharacter character, AbstractPerk perk) {
        for (int i = 0; i < 20; ++i) {
            for (PerkCategory category : PerkCategory.values()) {
                for (TreeEntry<PerkCategory, AbstractPerk> entry : this.getPerkTree(character).get(i).get((Object)category)) {
                    if (entry.getEntry() != perk) continue;
                    return i;
                }
            }
        }
        System.err.println("PerkManager.getPerkRow(): Could not find Perk in any row! " + perk.getName(character));
        return 0;
    }
}

