/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.fetishes;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.CorruptionLevel;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.fetishes.FetishDesire;
import com.lilithsthrone.game.character.fetishes.FetishExperience;
import com.lilithsthrone.game.character.fetishes.FetishPreference;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractFetish {
    private int renderingPriority;
    protected String name;
    protected String shortDescriptor;
    private int experienceGainFromSexAction;
    private HashMap<AbstractAttribute, Integer> attributeModifiers;
    private String pathName;
    private String SVGString;
    private List<Colour> colourShades;
    private List<String> extraEffects;
    private List<String> modifiersList;
    private List<AbstractFetish> fetishesForAutomaticUnlock;
    protected static List<String> perkRequirementsList;
    protected static String bimboString;
    protected static String broString;

    public AbstractFetish(int renderingPriority, String name, String shortDescriptor, String pathName, FetishExperience experienceGainFromSexAction, Colour colourShades, HashMap<AbstractAttribute, Integer> attributeModifiers, List<String> extraEffects, List<AbstractFetish> fetishesForAutomaticUnlock) {
        this(renderingPriority, name, shortDescriptor, pathName, experienceGainFromSexAction, Util.newArrayListOfValues(colourShades), attributeModifiers, extraEffects, fetishesForAutomaticUnlock);
    }

    public AbstractFetish(int renderingPriority, String name, String shortDescriptor, String pathName, FetishExperience experienceGainFromSexAction, List<Colour> colourShades, HashMap<AbstractAttribute, Integer> attributeModifiers, List<String> extraEffects, List<AbstractFetish> fetishesForAutomaticUnlock) {
        this.renderingPriority = renderingPriority;
        this.name = name;
        this.shortDescriptor = shortDescriptor;
        this.experienceGainFromSexAction = experienceGainFromSexAction.getExperience();
        this.attributeModifiers = attributeModifiers;
        this.extraEffects = extraEffects;
        this.fetishesForAutomaticUnlock = fetishesForAutomaticUnlock == null ? new ArrayList<AbstractFetish>() : fetishesForAutomaticUnlock;
        this.colourShades = colourShades;
        this.pathName = pathName;
        this.modifiersList = new ArrayList<String>();
        if (attributeModifiers != null) {
            for (Map.Entry<AbstractAttribute, Integer> e : attributeModifiers.entrySet()) {
                this.modifiersList.add("<b>" + (e.getValue() > 0 ? "+" : "") + String.valueOf(e.getValue()) + "</b><b style='color: " + e.getKey().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(e.getKey().getAbbreviatedName()) + "</b>");
            }
        }
    }

    public String getId() {
        return Fetish.getIdFromFetish(this);
    }

    public List<AbstractFetish> getFetishesForAutomaticUnlock() {
        return this.fetishesForAutomaticUnlock;
    }

    public boolean isAvailable(GameCharacter character) {
        return true;
    }

    public List<String> getPerkRequirements(GameCharacter character) {
        perkRequirementsList.clear();
        return perkRequirementsList;
    }

    public String getName(GameCharacter owner) {
        return this.name;
    }

    public String getShortDescriptor(GameCharacter target) {
        return this.shortDescriptor;
    }

    public abstract String getDescription(GameCharacter var1);

    public abstract String getFetishDesireDescription(GameCharacter var1, FetishDesire var2);

    protected static String getGenericFetishDesireDescription(GameCharacter target, FetishDesire desire, String descriptor) {
        switch (desire) {
            case ZERO_HATE: {
                return UtilText.parse(target, "\u4f60\u6781\u5176\u538c\u6076" + descriptor + "\u3002", new ParserTag[0]);
            }
            case ONE_DISLIKE: {
                return UtilText.parse(target, "\u4f60\u4e0d\u559c\u6b22" + descriptor + "\u3002", new ParserTag[0]);
            }
            case TWO_NEUTRAL: {
                return UtilText.parse(target, "\u4f60\u5bf9" + descriptor + "\u65e0\u611f\u3002", new ParserTag[0]);
            }
            case THREE_LIKE: {
                return UtilText.parse(target, "\u4f60\u559c\u6b22" + descriptor + "\u3002", new ParserTag[0]);
            }
            case FOUR_LOVE: {
                return UtilText.parse(target, "\u4f60\u70ed\u7231" + descriptor + "\u3002", new ParserTag[0]);
            }
        }
        return "";
    }

    public int getExperienceGainFromSexAction() {
        return this.experienceGainFromSexAction;
    }

    public int getCost() {
        return 5;
    }

    public List<String> getModifiersAsStringList(GameCharacter owner) {
        ArrayList<String> modList = new ArrayList<String>(this.modifiersList);
        if (this.getExtraEffects(owner) != null) {
            modList.addAll(this.getExtraEffects(owner));
        }
        return modList;
    }

    public HashMap<AbstractAttribute, Integer> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public String getAppliedFetishLevelEffectDescription(GameCharacter character) {
        return null;
    }

    public String applyPerkGained(GameCharacter character) {
        return "";
    }

    public String applyPerkLost(GameCharacter character) {
        return "";
    }

    public Fetish getPreviousLevelPerk() {
        return null;
    }

    public Perk getNextLevelPerk() {
        return null;
    }

    public CorruptionLevel getAssociatedCorruptionLevel() {
        return CorruptionLevel.ZERO_PURE;
    }

    public boolean isContentEnabled() {
        return true;
    }

    public AbstractFetish getOpposite() {
        return null;
    }

    public boolean isTopFetish() {
        return false;
    }

    public TFModifier getAssociatedTFModifier() {
        for (TFModifier mod : TFModifier.getTFBehaviouralFetishList()) {
            if (mod.getFetish() != this) continue;
            return TFModifier.TF_MOD_FETISH_BEHAVIOUR;
        }
        return TFModifier.TF_MOD_FETISH_BODY_PART;
    }

    public int getRenderingPriority() {
        return this.renderingPriority;
    }

    public List<String> getExtraEffects(GameCharacter owner) {
        return this.extraEffects;
    }

    public Colour getColour() {
        return this.colourShades.get(0);
    }

    public List<Colour> getColourShades() {
        return this.colourShades;
    }

    public String getSVGString(GameCharacter owner) {
        if (this.SVGString == null) {
            if (this.pathName != null && !this.pathName.isEmpty()) {
                try {
                    InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/fetishes/" + this.pathName + ".svg");
                    if (is == null) {
                        System.err.println("Error! Fetish icon file does not exist (Trying to read from '" + this.pathName + "')!");
                    }
                    this.SVGString = Util.inputStreamToString(is);
                    this.SVGString = SvgUtil.colourReplacement(this.getId(), this.colourShades, null, this.SVGString);
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.SVGString = "";
            }
        }
        return this.SVGString;
    }

    public static int getExperienceGainFromTakingVaginalVirginity(GameCharacter owner) {
        return owner.getLevel() * 2;
    }

    public static int getExperienceGainFromTakingOtherVirginity(GameCharacter owner) {
        return owner.getLevel();
    }

    public FetishPreference getFetishPreferenceDefault() {
        return FetishPreference.THREE_NEUTRAL;
    }

    static {
        InputStream is;
        perkRequirementsList = new ArrayList<String>();
        bimboString = "";
        broString = "";
        try {
            is = Subspecies.class.getClassLoader().getResourceAsStream("com/lilithsthrone/res/fetishes/fetish_bimbo.svg");
            if (is == null) {
                System.err.println("Error! Fetish icon file does not exist (Trying to read from 'com/lilithsthrone/res/fetishes/fetish_bimbo')!");
            }
            bimboString = Util.inputStreamToString(is);
            bimboString = SvgUtil.colourReplacement("FETISH_BIMBO", PresetColour.BASE_PINK, bimboString);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            is = Subspecies.class.getClassLoader().getResourceAsStream("com/lilithsthrone/res/fetishes/fetish_bro.svg");
            broString = Util.inputStreamToString(is);
            broString = SvgUtil.colourReplacement("FETISH_BRO", PresetColour.BASE_BLUE, broString);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

