/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.fetishes;

import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public enum FetishDesire {
    ZERO_HATE(0, "\u538c\u6076", "\u538c\u6076", "\u538c\u6076", "fondness1", PresetColour.BASE_CRIMSON),
    ONE_DISLIKE(1, "\u8ba8\u538c", "\u8ba8\u538c", "\u8ba8\u538c", "fondness2", PresetColour.BASE_RED),
    TWO_NEUTRAL(2, "\u65e0\u6240\u8c13", "\u4e0d\u5728\u4e4e", "\u4e0d\u5728\u4e4e", "fondness3", PresetColour.BASE_BLUE_STEEL),
    THREE_LIKE(3, "\u559c\u6b22", "\u559c\u6b22", "\u559c\u6b22", "fondness4", PresetColour.BASE_PINK_LIGHT),
    FOUR_LOVE(4, "\u70ed\u7231", "\u70ed\u7231", "\u70ed\u7231", "fondness5", PresetColour.BASE_PINK);

    private int value;
    private String name;
    private String nameAsPlayerVerb;
    private String nameAsVerb;
    private String SVGImage;
    private String SVGImageDesaturated;
    private Colour colour;
    private List<String> modifiersList;

    private FetishDesire(int value, String name, String nameAsPlayerVerb, String nameAsVerb, String pathName, Colour colour) {
        this.value = value;
        this.name = name;
        this.nameAsPlayerVerb = nameAsPlayerVerb;
        this.nameAsVerb = nameAsVerb;
        this.colour = colour;
        this.modifiersList = new ArrayList<String>();
        this.modifiersList.add("\u5f71\u54cd\u6027\u52a8\u4f5c\u7684[style.boldLust(" + Util.capitaliseSentence(Attribute.LUST.getAbbreviatedName()) + "\u589e\u957f)]");
        try {
            String base;
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/com/lilithsthrone/res/fetishes/" + pathName + ".svg");
            if (is == null) {
                System.err.println("Error! FetishDesire icon file does not exist (Trying to read from '" + pathName + "')!");
            }
            this.SVGImage = base = Util.inputStreamToString(is);
            this.SVGImage = SvgUtil.colourReplacement(this.toString(), colour, this.SVGImage);
            this.SVGImageDesaturated = base;
            this.SVGImageDesaturated = SvgUtil.colourReplacement(this.toString(), PresetColour.BASE_GREY, this.SVGImageDesaturated);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isNegative() {
        return this == ZERO_HATE || this == ONE_DISLIKE;
    }

    public boolean isPositive() {
        return this == THREE_LIKE || this == FOUR_LOVE;
    }

    public static int getCostToChange() {
        return 0;
    }

    public static FetishDesire getDesireFromValue(int value) {
        for (FetishDesire desire : FetishDesire.values()) {
            if (desire.getValue() != value) continue;
            return desire;
        }
        if (value <= ZERO_HATE.getValue()) {
            return ZERO_HATE;
        }
        return FOUR_LOVE;
    }

    public FetishDesire getPreviousDesire() {
        switch (this) {
            case ZERO_HATE: {
                return ZERO_HATE;
            }
            case ONE_DISLIKE: {
                return ZERO_HATE;
            }
            case TWO_NEUTRAL: {
                return ONE_DISLIKE;
            }
            case THREE_LIKE: {
                return TWO_NEUTRAL;
            }
            case FOUR_LOVE: {
                return THREE_LIKE;
            }
        }
        return TWO_NEUTRAL;
    }

    public FetishDesire getNextDesire() {
        switch (this) {
            case ZERO_HATE: {
                return ONE_DISLIKE;
            }
            case ONE_DISLIKE: {
                return TWO_NEUTRAL;
            }
            case TWO_NEUTRAL: {
                return THREE_LIKE;
            }
            case THREE_LIKE: {
                return FOUR_LOVE;
            }
            case FOUR_LOVE: {
                return FOUR_LOVE;
            }
        }
        return TWO_NEUTRAL;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getNameAsPlayerVerb() {
        return this.nameAsPlayerVerb;
    }

    public String getNameAsVerb() {
        return this.nameAsVerb;
    }

    public String getSVGImage() {
        return this.SVGImage;
    }

    public String getSVGImageDesaturated() {
        return this.SVGImageDesaturated;
    }

    public Colour getColour() {
        return this.colour;
    }

    public List<String> getModifiersAsStringList() {
        return this.modifiersList;
    }
}

