/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.fetishes;

import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.IOException;
import java.io.InputStream;

public enum FetishLevel {
    ZERO_NO_EXPERIENCE("\u751f\u6da9", "I", "", "overlay1", 0.0f, 0, 0, 10, PresetColour.DESIRE_STAGE_ZERO),
    ONE_AMATEUR("\u5165\u95e8", "II", "", "overlay2", 0.5f, 1, 10, 50, PresetColour.DESIRE_STAGE_ONE),
    TWO_EXPERIENCED("\u719f\u7ec3", "III", "", "overlay3", 1.0f, 2, 50, 100, PresetColour.DESIRE_STAGE_TWO),
    THREE_EXPERT("\u4e13\u5bb6", "IV", "", "overlay4", 2.0f, 3, 100, 200, PresetColour.DESIRE_STAGE_THREE),
    FOUR_MASTERFUL("\u5927\u5e08", "V", "", "overlay5", 2.5f, 4, 200, 200, PresetColour.DESIRE_STAGE_FOUR);

    private String name;
    private String numeral;
    private String description;
    private String SVGImageOverlay;
    private float bonusArousalIncrease;
    private int bonusTeaseDamage;
    private int minimumExperience;
    private int maximumExperience;
    private Colour colour;

    private FetishLevel(String name, String numeral, String description, String pathName, float bonusArousalIncrease, int bonusTeaseDamage, int minimumExperience, int maximumExperience, Colour colour) {
        this.name = name;
        this.numeral = numeral;
        this.description = description;
        this.bonusArousalIncrease = bonusArousalIncrease;
        this.bonusTeaseDamage = bonusTeaseDamage;
        this.minimumExperience = minimumExperience;
        this.maximumExperience = maximumExperience;
        this.colour = colour;
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/com/lilithsthrone/res/fetishes/" + pathName + ".svg");
            if (is == null) {
                System.err.println("Error! FetishLevel icon file does not exist (Trying to read from '" + pathName + "')!");
            }
            this.SVGImageOverlay = Util.inputStreamToString(is);
            this.SVGImageOverlay = SvgUtil.colourReplacement(this.toString(), PresetColour.BASE_PINK, this.SVGImageOverlay);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNumeral() {
        return this.numeral;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSVGImageOverlay() {
        return this.SVGImageOverlay;
    }

    public float getBonusArousalIncrease() {
        return this.bonusArousalIncrease;
    }

    public float getBonusArousalIncreasePartner() {
        return (float)Math.round(this.bonusArousalIncrease / 2.0f * 100.0f) / 100.0f;
    }

    public int getBonusTeaseDamage() {
        return this.bonusTeaseDamage;
    }

    public int getMinimumExperience() {
        return this.minimumExperience;
    }

    public int getMaximumExperience() {
        return this.maximumExperience;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static FetishLevel getFetishLevelFromValue(int value) {
        for (FetishLevel fl : FetishLevel.values()) {
            if (value < fl.getMinimumExperience() || value >= fl.getMaximumExperience()) continue;
            return fl;
        }
        return FOUR_MASTERFUL;
    }
}

