/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.markings;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.controller.xmlParsing.XMLMissingTagException;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.markings.TattooType;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.item.SvgInformation;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.ColourListPresets;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractTattooType
extends AbstractCoreType {
    private static List<InventorySlot> standardInventorySlots = new ArrayList<InventorySlot>(InventorySlot.getClothingSlots());
    private boolean isMod;
    private int value;
    private List<InventorySlot> slotAvailability;
    private String name;
    private String description;
    private String bodyOverviewDescription;
    private List<Colour> availablePrimaryColours;
    private List<Colour> availableSecondaryColours;
    private List<Colour> availableTertiaryColours;
    private Colour defaultPrimaryColour;
    private Colour defaultSecondaryColour;
    private Colour defaultTertiaryColour;
    private List<SvgInformation> svgPathInformation;
    private Map<Colour, Map<Colour, Map<Colour, String>>> SVGStringMap;
    private String availabilityRequirements;
    private boolean unique;

    public AbstractTattooType(String pathName, String name, String description, String bodyOverviewDescription, List<Colour> availablePrimaryColours, List<Colour> availableSecondaryColours, List<Colour> availableTertiaryColours, List<InventorySlot> slotAvailability) {
        this.isMod = false;
        this.unique = false;
        this.value = 500;
        this.svgPathInformation = Util.newArrayListOfValues(new SvgInformation(1, pathName == null ? "" : pathName, 100, 0, new HashMap<String, String>()));
        this.name = name;
        this.description = description;
        this.bodyOverviewDescription = bodyOverviewDescription;
        this.availablePrimaryColours = new ArrayList<Colour>();
        if (availablePrimaryColours == null) {
            this.availablePrimaryColours.add(PresetColour.CLOTHING_BLACK);
        } else {
            this.availablePrimaryColours.addAll(availablePrimaryColours);
        }
        this.availableSecondaryColours = new ArrayList<Colour>();
        if (availableSecondaryColours != null) {
            this.availableSecondaryColours.addAll(availableSecondaryColours);
        }
        this.availableTertiaryColours = new ArrayList<Colour>();
        if (availableTertiaryColours != null) {
            this.availableTertiaryColours.addAll(availableTertiaryColours);
        }
        this.defaultPrimaryColour = this.availablePrimaryColours.get(0);
        this.defaultSecondaryColour = this.availableSecondaryColours.size() > 0 ? this.availableSecondaryColours.get(0) : this.defaultPrimaryColour;
        this.defaultTertiaryColour = this.availableTertiaryColours.size() > 0 ? this.availableTertiaryColours.get(0) : this.defaultPrimaryColour;
        this.SVGStringMap = new HashMap<Colour, Map<Colour, Map<Colour, String>>>();
        this.slotAvailability = slotAvailability == null ? standardInventorySlots : slotAvailability;
    }

    public AbstractTattooType(File tattooXMLFile) {
        if (tattooXMLFile.exists()) {
            try {
                Element tattooElement = Element.getDocumentRootElement(tattooXMLFile);
                Element coreAttributes = null;
                try {
                    coreAttributes = tattooElement.getMandatoryFirstOf("coreAtributes");
                }
                catch (XMLMissingTagException ex) {
                    coreAttributes = tattooElement.getMandatoryFirstOf("coreAttributes");
                }
                ArrayList<InventorySlot> slotAvailability = new ArrayList<InventorySlot>();
                if (coreAttributes.getOptionalFirstOf("slotAvailability").isPresent()) {
                    for (Element slotElement : coreAttributes.getMandatoryFirstOf("slotAvailability").getAllOf("slot")) {
                        slotAvailability.add(InventorySlot.valueOf(slotElement.getTextContent()));
                    }
                }
                this.slotAvailability = slotAvailability.isEmpty() ? new ArrayList<InventorySlot>(standardInventorySlots) : slotAvailability;
                this.isMod = true;
                this.svgPathInformation = new ArrayList<SvgInformation>();
                for (Element imagePathElement : coreAttributes.getAllOf("imageName")) {
                    String rawPath = imagePathElement.getTextContent();
                    Object pathName = rawPath.contains("res/") ? rawPath : tattooXMLFile.getParentFile().getAbsolutePath() + "/" + rawPath;
                    int zLayer = 1;
                    int imageSize = 100;
                    int imageRotation = 0;
                    HashMap<String, String> replacements = new HashMap<String, String>();
                    if (!imagePathElement.getAttribute("zLayer").isEmpty()) {
                        try {
                            zLayer = Integer.valueOf(imagePathElement.getAttribute("zLayer"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!imagePathElement.getAttribute("imageSize").isEmpty()) {
                        try {
                            imageSize = Math.min(100, Math.max(1, Integer.valueOf(imagePathElement.getAttribute("imageSize"))));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!imagePathElement.getAttribute("imageRotation").isEmpty()) {
                        try {
                            imageRotation = Math.min(360, Math.max(-360, Integer.valueOf(imagePathElement.getAttribute("imageRotation"))));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    int i = 1;
                    while (!imagePathElement.getAttribute("target" + i).isEmpty()) {
                        replacements.put(imagePathElement.getAttribute("target" + i), imagePathElement.getAttribute("replacement" + i));
                        ++i;
                    }
                    this.svgPathInformation.add(new SvgInformation(zLayer, (String)pathName, imageSize, imageRotation, replacements));
                }
                this.value = Integer.valueOf(coreAttributes.getMandatoryFirstOf("value").getTextContent());
                this.name = coreAttributes.getMandatoryFirstOf("name").getTextContent();
                this.description = coreAttributes.getMandatoryFirstOf("description").getTextContent();
                this.bodyOverviewDescription = "";
                if (coreAttributes.getOptionalFirstOf("bodyOverviewDescription").isPresent()) {
                    this.bodyOverviewDescription = coreAttributes.getMandatoryFirstOf("bodyOverviewDescription").getTextContent();
                }
                this.unique = false;
                this.availabilityRequirements = "";
                if (coreAttributes.getOptionalFirstOf("availabilityRequirements").isPresent()) {
                    this.unique = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("availabilityRequirements").getAttribute("unique"));
                    this.availabilityRequirements = coreAttributes.getMandatoryFirstOf("availabilityRequirements").getTextContent();
                }
                List<Object> importedPrimaryColours = new ArrayList();
                try {
                    importedPrimaryColours = this.readColoursFromElement(coreAttributes, "primaryColours");
                }
                catch (Exception ex) {
                    System.err.println("AbstractTattooType loading failed. Cause: 'primaryColours' element unable to be parsed. (" + tattooXMLFile.getName() + ")\n" + String.valueOf(ex));
                }
                List<Object> importedSecondaryColours = new ArrayList();
                try {
                    importedSecondaryColours = this.readColoursFromElement(coreAttributes, "secondaryColours");
                }
                catch (Exception ex) {
                    System.err.println("AbstractTattooType loading failed. Cause: 'secondaryColours' element unable to be parsed. (" + tattooXMLFile.getName() + ")\n" + String.valueOf(ex));
                }
                List<Object> importedTertiaryColours = new ArrayList();
                try {
                    importedTertiaryColours = this.readColoursFromElement(coreAttributes, "tertiaryColours");
                }
                catch (Exception ex) {
                    System.err.println("AbstractTattooType loading failed. Cause: 'tertiaryColours' element unable to be parsed. (" + tattooXMLFile.getName() + ")\n" + String.valueOf(ex));
                }
                this.availablePrimaryColours = new ArrayList<Colour>(importedPrimaryColours);
                this.availableSecondaryColours = new ArrayList<Colour>(importedSecondaryColours);
                this.availableTertiaryColours = new ArrayList<Colour>(importedTertiaryColours);
                this.defaultPrimaryColour = this.availablePrimaryColours.get(0);
                String defaultColour = coreAttributes.getMandatoryFirstOf("primaryColours").getAttribute("defaultColour");
                if (!defaultColour.isEmpty()) {
                    this.defaultPrimaryColour = PresetColour.getColourFromId(defaultColour);
                }
                this.defaultSecondaryColour = this.availableSecondaryColours.size() > 0 ? this.availableSecondaryColours.get(0) : this.defaultPrimaryColour;
                defaultColour = coreAttributes.getMandatoryFirstOf("secondaryColours").getAttribute("defaultColour");
                if (!defaultColour.isEmpty()) {
                    this.defaultSecondaryColour = PresetColour.getColourFromId(defaultColour);
                }
                this.defaultTertiaryColour = this.availableTertiaryColours.size() > 0 ? this.availableTertiaryColours.get(0) : this.defaultPrimaryColour;
                defaultColour = coreAttributes.getMandatoryFirstOf("tertiaryColours").getAttribute("defaultColour");
                if (!defaultColour.isEmpty()) {
                    this.defaultTertiaryColour = PresetColour.getColourFromId(defaultColour);
                }
                this.SVGStringMap = new HashMap<Colour, Map<Colour, Map<Colour, String>>>();
            }
            catch (Exception ex) {
                System.err.println("TattooType was unable to be loaded from file! (" + tattooXMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    private List<Colour> readColoursFromElement(Element coreAttributes, String elementTagName) throws XMLMissingTagException {
        Element coloursElement = coreAttributes.getMandatoryFirstOf(elementTagName);
        if (coloursElement.getAttribute("values").isEmpty()) {
            ArrayList<Colour> result = new ArrayList<Colour>();
            for (Element colourElement : coloursElement.getAllOf("colour")) {
                result.add(PresetColour.getColourFromId(colourElement.getTextContent()));
            }
            return result;
        }
        return ColourListPresets.getColourListFromId(coloursElement.getAttribute("values"));
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof AbstractTattooType && ((AbstractTattooType)o).isMod() == this.isMod && ((AbstractTattooType)o).getSlotAvailability().equals(this.getSlotAvailability()) && ((AbstractTattooType)o).getName().equals(this.getName()) && ((AbstractTattooType)o).getDescription().equals(this.getDescription()) && ((AbstractTattooType)o).getAvailablePrimaryColours().equals(this.getAvailablePrimaryColours()) && ((AbstractTattooType)o).getAvailableSecondaryColours().equals(this.getAvailableSecondaryColours()) && ((AbstractTattooType)o).getAvailableTertiaryColours().equals(this.getAvailableTertiaryColours()) && ((AbstractTattooType)o).getPathName().equals(this.getPathName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isMod() ? 1 : 0);
        result = 31 * result + this.getSlotAvailability().hashCode();
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.getDescription().hashCode();
        result = 31 * result + this.getAvailablePrimaryColours().hashCode();
        result = 31 * result + this.getAvailableSecondaryColours().hashCode();
        result = 31 * result + this.getAvailableTertiaryColours().hashCode();
        result = 31 * result + this.getPathName().hashCode();
        return result;
    }

    public boolean isMod() {
        return this.isMod;
    }

    public int getValue() {
        return this.value;
    }

    public List<SvgInformation> getSvgPathInformation() {
        return this.svgPathInformation;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBodyOverviewDescription() {
        return this.bodyOverviewDescription;
    }

    public List<Colour> getAvailablePrimaryColours() {
        return this.availablePrimaryColours;
    }

    public List<Colour> getAvailableSecondaryColours() {
        return this.availableSecondaryColours;
    }

    public List<Colour> getAvailableTertiaryColours() {
        return this.availableTertiaryColours;
    }

    public Colour getDefaultPrimaryColour() {
        return this.defaultPrimaryColour;
    }

    public Colour getDefaultSecondaryColour() {
        return this.defaultSecondaryColour;
    }

    public Colour getDefaultTertiaryColour() {
        return this.defaultTertiaryColour;
    }

    public List<InventorySlot> getSlotAvailability() {
        return new ArrayList<InventorySlot>(this.slotAvailability);
    }

    public boolean isLimitedSlotAvailability() {
        return !this.slotAvailability.containsAll(standardInventorySlots);
    }

    public boolean isAvailable(GameCharacter target) {
        if (this.availabilityRequirements != null && !this.availabilityRequirements.isEmpty()) {
            return Boolean.valueOf(UtilText.parse(target, ("[#" + this.availabilityRequirements + "]").replaceAll("\u200b", ""), new ParserTag[0]));
        }
        return true;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getId() {
        return TattooType.getIdFromTattooType(this);
    }

    public int getEnchantmentLimit() {
        return 100;
    }

    public AbstractItemEffectType getEnchantmentEffect() {
        return ItemEffectType.TATTOO;
    }

    private void addSVGStringMapping(Colour colour, Colour colourSecondary, Colour colourTertiary, String s) {
        if (this.SVGStringMap.get(colour) == null) {
            this.SVGStringMap.put(colour, new HashMap());
            this.SVGStringMap.get(colour).put(colourSecondary, new HashMap());
        } else if (this.SVGStringMap.get(colour).get(colourSecondary) == null) {
            this.SVGStringMap.get(colour).put(colourSecondary, new HashMap());
        }
        this.SVGStringMap.get(colour).get(colourSecondary).put(colourTertiary, s);
    }

    private String getSVGStringFromMap(Colour colour, Colour colourSecondary, Colour colourTertiary) {
        if (this.SVGStringMap.get(colour) == null) {
            return null;
        }
        if (this.SVGStringMap.get(colour).get(colourSecondary) == null) {
            return null;
        }
        return this.SVGStringMap.get(colour).get(colourSecondary).get(colourTertiary);
    }

    public String getSVGImage(GameCharacter character) {
        return this.getSVGImage(character, this.getDefaultPrimaryColour(), this.getDefaultSecondaryColour(), this.getDefaultTertiaryColour());
    }

    public String getSVGImage(GameCharacter character, Colour colour, Colour colourSecondary, Colour colourTertiary) {
        if (this.svgPathInformation == null || this.svgPathInformation.isEmpty()) {
            return "";
        }
        String stringFromMap = this.getSVGStringFromMap(colour, colourSecondary, colourTertiary);
        if (stringFromMap != null) {
            return stringFromMap;
        }
        try {
            String s;
            if (this.isMod) {
                Collections.sort(this.svgPathInformation, (i1, i2) -> i1.getZLayer() - i2.getZLayer());
                StringBuilder svgBuilder = new StringBuilder();
                for (SvgInformation info : this.getSvgPathInformation()) {
                    List<String> lines = Files.readAllLines(Paths.get(info.getPathName(), new String[0]));
                    StringBuilder sb = new StringBuilder();
                    for (String line : lines) {
                        sb.append(line);
                    }
                    int sizeOffset = (100 - info.getImageSize()) / 2;
                    svgBuilder.append("<div style='width:" + info.getImageSize() + "%;height:" + info.getImageSize() + "%;transform:rotate(" + info.getImageRotation() + "deg);position:absolute;left:" + sizeOffset + "%;bottom:" + sizeOffset + "%;padding:0;margin:0;'>");
                    String finalSvg = sb.toString();
                    for (Map.Entry<String, String> entry : info.getReplacements().entrySet()) {
                        finalSvg = finalSvg.replaceAll(entry.getKey(), entry.getValue());
                    }
                    svgBuilder.append(finalSvg);
                    svgBuilder.append("</div>");
                }
                s = svgBuilder.toString();
            } else {
                InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/tattoos/" + this.getPathName() + ".svg");
                s = Util.inputStreamToString(is);
                is.close();
            }
            s = SvgUtil.colourReplacement(this.getId(), colour, colourSecondary, colourTertiary, s);
            this.addSVGStringMapping(colour, colourSecondary, colourTertiary, s);
            return s;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getPathName() {
        return this.svgPathInformation.get(0).getPathName();
    }
}

