/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.markings;

import com.lilithsthrone.utils.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TattooCountType {
    NUMBERS("\u6570\u5b57"){

        @Override
        public String convertInt(int input) {
            return String.valueOf(input);
        }
    }
    ,
    TALLY("\u8ba1\u6570\u7b26\u53f7"){

        @Override
        public String convertInt(int input) {
            return Util.intToTally(input, 50);
        }
    }
    ,
    NUMERALS("\u7f57\u9a6c\u6570\u5b57"){

        @Override
        public String convertInt(int input) {
            return Util.intToNumerals(input);
        }
    }
    ,
    WRITTEN("\u4e66\u5199\u6587\u5b57"){

        @Override
        public String convertInt(int input) {
            return Util.capitaliseSentence(Util.intToString(input));
        }
    }
    ,
    CHINESE("\u6c49\u5b57\u8ba1\u6570"){

        @Override
        public String convertInt(int input) {
            return Util.intToZheng(input, 50);
        }
    };

    private String name;

    private TattooCountType(String name) {
        this.name = name;
    }

    public abstract String convertInt(int var1);

    public String getName() {
        return this.name;
    }
}

