/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.markings;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.markings.TattooCountType;
import com.lilithsthrone.game.character.markings.TattooCounterType;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.ColourListPresets;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TattooCounter
implements XMLSaving {
    private TattooCounterType type;
    private TattooCountType countType;
    private Colour colour;
    private boolean glow;
    private int retroactiveApplicationOffset;

    public TattooCounter(TattooCounter counterToCopy) {
        this(counterToCopy.type, counterToCopy.countType, counterToCopy.colour, counterToCopy.glow, counterToCopy.retroactiveApplicationOffset);
    }

    public TattooCounter(TattooCounterType type, TattooCountType countType, Colour colour, boolean glow, GameCharacter bearer) {
        this.type = type;
        this.countType = countType;
        this.colour = colour;
        this.glow = glow;
        this.retroactiveApplicationOffset = type.getNonRetroactiveOffset(bearer);
    }

    public TattooCounter(TattooCounterType type, TattooCountType countType, Colour colour, boolean glow, int retroactiveApplicationOffset) {
        this.type = type;
        this.countType = countType;
        this.colour = colour;
        this.glow = glow;
        this.retroactiveApplicationOffset = retroactiveApplicationOffset;
    }

    public static List<Colour> getAvailableColours() {
        return ColourListPresets.ALL;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof TattooCounter && ((TattooCounter)o).getType().equals((Object)this.getType()) && ((TattooCounter)o).getCountType().equals((Object)this.getCountType()) && ((TattooCounter)o).getColour().equals(this.getColour()) && ((TattooCounter)o).isGlow() == this.glow && ((TattooCounter)o).getRetroactiveApplicationOffset() == this.getRetroactiveApplicationOffset();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + this.getCountType().hashCode();
        result = 31 * result + this.getColour().hashCode();
        result = 31 * result + (this.isGlow() ? 1 : 0);
        result = 31 * result + this.getRetroactiveApplicationOffset();
        return result;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("tattooCounter");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "type", this.getType().toString());
        XMLUtil.addAttribute(doc, element, "countType", this.getCountType().toString());
        XMLUtil.addAttribute(doc, element, "colour", this.getColour().getId());
        XMLUtil.addAttribute(doc, element, "glow", String.valueOf(this.isGlow()));
        XMLUtil.addAttribute(doc, element, "retroactiveApplicationOffset", String.valueOf(this.getRetroactiveApplicationOffset()));
        return element;
    }

    public static TattooCounter loadFromXML(Element parentElement, Document doc) {
        try {
            int loadedRetroactiveApplicationOffset = 0;
            String loadedRAOString = parentElement.getAttribute("retroactiveApplicationOffset");
            if (!loadedRAOString.isEmpty()) {
                loadedRetroactiveApplicationOffset = Integer.valueOf(loadedRAOString);
            }
            return new TattooCounter(TattooCounterType.valueOf(parentElement.getAttribute("type")), TattooCountType.valueOf(parentElement.getAttribute("countType")), PresetColour.getColourFromId(parentElement.getAttribute("colour")), (boolean)Boolean.valueOf(parentElement.getAttribute("glow")), loadedRetroactiveApplicationOffset);
        }
        catch (Exception ex) {
            System.err.println("Warning: An instance of TattooCounter was unable to be imported!");
            return null;
        }
    }

    public TattooCounterType getType() {
        return this.type;
    }

    public TattooCountType getCountType() {
        return this.countType;
    }

    public Colour getColour() {
        return this.colour;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public void setType(TattooCounterType type, GameCharacter bearer) {
        this.type = type;
        if (!type.isRetroactiveApplicationAvailable()) {
            this.setRetroactiveApplicationOffset(0);
        } else if (this.getRetroactiveApplicationOffset() < 0) {
            this.setRetroactiveApplicationOffset(type.getNonRetroactiveOffset(bearer));
        }
    }

    public void setCountType(TattooCountType countType) {
        this.countType = countType;
    }

    public void setColour(Colour colour) {
        this.colour = colour;
    }

    public void setGlow(boolean glow) {
        this.glow = glow;
    }

    public int getRetroactiveApplicationOffset() {
        return this.retroactiveApplicationOffset;
    }

    public void setRetroactiveApplicationOffset(int retroactiveApplicationOffset) {
        this.retroactiveApplicationOffset = retroactiveApplicationOffset;
    }

    public void setRetroactiveApplicationOffset(GameCharacter bearer) {
        this.retroactiveApplicationOffset = this.getType().getNonRetroactiveOffset(bearer);
    }

    public boolean isRetroactiveApplication() {
        return this.getRetroactiveApplicationOffset() != 0;
    }
}

