/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.markings;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.markings.TattooWritingStyle;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.ColourListPresets;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TattooWriting
implements XMLSaving {
    private String text;
    private Colour colour;
    private boolean glow;
    private List<TattooWritingStyle> styles;

    public TattooWriting(TattooWriting tattooWritingToCopy) {
        this(tattooWritingToCopy.text, tattooWritingToCopy.colour, tattooWritingToCopy.glow, new ArrayList<TattooWritingStyle>(tattooWritingToCopy.styles));
    }

    public TattooWriting(String text, Colour colour, boolean glow, TattooWritingStyle ... styles) {
        this(text, colour, glow, new ArrayList<TattooWritingStyle>());
        this.styles = new ArrayList<TattooWritingStyle>();
        Collections.addAll(this.styles, styles);
        this.styles.removeIf(e -> e == null);
    }

    public TattooWriting(String text, Colour colour, boolean glow, List<TattooWritingStyle> styles) {
        this.text = text;
        this.colour = colour;
        this.glow = glow;
        this.styles = new ArrayList<TattooWritingStyle>();
        if (styles != null) {
            this.styles.addAll(styles);
        }
    }

    public static List<Colour> getAvailableColours() {
        return ColourListPresets.ALL;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof TattooWriting && ((TattooWriting)o).getText().equals(this.getText()) && ((TattooWriting)o).getColour().equals(this.getColour()) && ((TattooWriting)o).isGlow() == this.glow && ((TattooWriting)o).getStyles().equals(this.getStyles());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getText().hashCode();
        result = 31 * result + this.getColour().hashCode();
        result = 31 * result + (this.isGlow() ? 1 : 0);
        result = 31 * result + this.getStyles().hashCode();
        return result;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("tattooWriting");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "colour", this.getColour().getId());
        XMLUtil.addAttribute(doc, element, "glow", String.valueOf(this.isGlow()));
        element.appendChild(doc.createCDATASection(this.getText().trim()));
        Element innerElement = doc.createElement("styles");
        element.appendChild(innerElement);
        for (TattooWritingStyle style : this.getStyles()) {
            Element styleElement = doc.createElement("style");
            innerElement.appendChild(styleElement);
            XMLUtil.addAttribute(doc, styleElement, "value", style.toString());
        }
        return element;
    }

    public static TattooWriting loadFromXML(Element parentElement, Document doc) {
        try {
            ArrayList<TattooWritingStyle> importedStyles = new ArrayList<TattooWritingStyle>();
            try {
                NodeList stylesList = ((Element)parentElement.getElementsByTagName("styles").item(0)).getElementsByTagName("style");
                for (int i = 0; i < stylesList.getLength(); ++i) {
                    Element e = (Element)stylesList.item(i);
                    TattooWritingStyle style = TattooWritingStyle.valueOf(e.getAttribute("value"));
                    importedStyles.add(style);
                }
            }
            catch (Exception stylesList) {
                // empty catch block
            }
            String text = parentElement.getTextContent();
            TattooWriting tw = new TattooWriting(text.trim(), PresetColour.getColourFromId(parentElement.getAttribute("colour")), (boolean)Boolean.valueOf(parentElement.getAttribute("glow")), new TattooWritingStyle[0]);
            tw.styles = importedStyles;
            return tw;
        }
        catch (Exception ex) {
            System.err.println("Warning: An instance of TattooWriting was unable to be imported!");
            return null;
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Colour getColour() {
        return this.colour;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public List<TattooWritingStyle> getStyles() {
        return this.styles;
    }

    public void addStyle(TattooWritingStyle style) {
        this.styles.add(style);
    }

    public void removeStyle(TattooWritingStyle style) {
        this.styles.remove((Object)style);
    }

    public void setColour(Colour colour) {
        this.colour = colour;
    }

    public void setGlow(boolean glow) {
        this.glow = glow;
    }
}

