/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.dominion;

import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.attributes.ObedienceLevel;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.valueEnums.BodySize;
import com.lilithsthrone.game.character.body.valueEnums.Muscle;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.persona.PersonalityTrait;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Ashley
extends NPC {
    private AbstractItemType[] itemsForSale = new AbstractItemType[]{ItemType.GIFT_CHOCOLATES, ItemType.GIFT_PERFUME, ItemType.GIFT_ROSE_BOUQUET, ItemType.GIFT_TEDDY_BEAR};

    public Ashley() {
        this(false);
    }

    public Ashley(boolean isImported) {
        super(isImported, new NameTriplet("\u827e\u4ec0\u5229"), "\u7c73\u5185\u7279", "\u827e\u4ec0\u5229\u662f\u201c\u68a6\u4e4b\u7231\u4fa3\u201d\u5546\u5e97\u7684\u5e97\u4e3b\uff0c\u800c\u4ece\u8868\u9762\u4e0a\u770b\uff0c\u4e5f\u662f\u552f\u4e00\u7684\u5e97\u5458\u3002\u5bf9\u65b9\u975e\u5e38\u51b7\u6f20\uff0c\u538c\u6076\u5e2e\u52a9\u987e\u5ba2\uff0c\u751a\u81f3\u5b81\u613f\u76ef\u7740\u5899\u58c1\uff0c\u4e5f\u4e0d\u613f\u63d0\u4f9b\u4efb\u4f55\u5e2e\u52a9\u3002", 200, Month.AUGUST, 14, 10, Gender.N_P_TRAP, Subspecies.ANGEL, RaceStage.GREATER, new CharacterInventory(false, 10), WorldType.SHOPPING_ARCADE, PlaceType.SHOPPING_ARCADE_ASHLEYS_SHOP, true, new NPCGenerationFlag[0]);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        Ashley.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.2.10.5")) {
            this.resetBodyAfterVersion_2_10_5();
        }
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.3.5.1")) {
            this.setPersonalityTraits(PersonalityTrait.PRUDE);
        }
    }

    @Override
    public void setStartingBody(boolean setPersona) {
        this.setRaceConcealed(true);
        if (setPersona) {
            this.setPersonalityTraits(PersonalityTrait.PRUDE);
            this.setSexualOrientation(SexualOrientation.AMBIPHILIC);
        }
        this.setAgeAppearanceAbsolute(25);
        this.setHeight(186);
        this.setFemininity(50);
        this.setMuscle(Muscle.TWO_TONED.getMedianValue());
        this.setBodySize(BodySize.ONE_SLENDER.getMedianValue());
        this.setEyeCovering(new Covering(BodyCoveringType.EYE_ANGEL, PresetColour.EYE_BLUE));
        this.setSkinCovering(new Covering(BodyCoveringType.ANGEL, PresetColour.SKIN_LIGHT), true);
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.unequipAllClothingIntoVoid(true, true);
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_torsoOver_hooded_cloak", PresetColour.CLOTHING_BLACK, PresetColour.CLOTHING_SILVER, null, false), true, this);
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getCharacterInformationScreen(boolean includePerkTree) {
        this.infoScreenSB.setLength(0);
        this.infoScreenSB.append("<h4>\u80cc\u666f</h4><p>" + this.getDescription() + "</p><br/><h4>\u4eba\u7269\u5173\u7cfb</h4><p>[style.boldAffection(\u597d\u611f:)]<br/>" + AffectionLevel.getDescription(this, Main.game.getPlayer(), true));
        for (Map.Entry<String, Float> entry : this.getAffectionMap().entrySet()) {
            try {
                GameCharacter target = Main.game.getNPCById(entry.getKey());
                if (target.isPlayer()) continue;
                this.infoScreenSB.append("<br/>" + AffectionLevel.getDescription(this, target, true));
            }
            catch (Exception e) {
                Util.logGetNpcByIdError("Ashley.getCharacterInformationScreen()", entry.getKey());
            }
        }
        this.infoScreenSB.append("<br/><br/>[style.boldObedience(\u670d\u4ece\uff1a)]<br/>" + UtilText.parse((GameCharacter)this, "[npc.Name][style.boldGood(\u4e0d\u662f\u5974\u96b6)]\u3002", new ParserTag[0]) + "<br/>" + ObedienceLevel.getDescription(this, ObedienceLevel.getObedienceLevelFromValue(this.getObedienceValue()), true, true) + "</p><br/><h4>\u5916\u8c8c</h4><p>" + (Main.game.getPlayer().hasTraitActivated(Perk.OBSERVANT) ? "\u5c3d\u7ba1\u4f60\u7684\u89c2\u5bdf\u529b\u5f88\u654f\u9510\uff0c\u4f46\u4e5f\u6ca1\u627e\u5230\u80fd\u6697\u793a\u827e\u4ec0\u5229\u6027\u522b\u7684\u7ebf\u7d22\u3002" : "\u4f60\u5b8c\u5168\u4e0d\u77e5\u9053\u827e\u4ec0\u5229\u662f\u4ec0\u4e48\u6027\u522b\u3002") + "\u8eab\u5b50\u7ad9\u76f4\uff0c\u8eab\u9ad8\u6d4b\u91cf\u7ea6\u4e3a6'1\" (186cm)\u3002</p><p>\u6597\u7bf7\u7684\u515c\u5e3d\u62c9\u8d77\uff0c\u5b8c\u5168\u906e\u4f4f\u4e86\u5bf9\u65b9\u7684\u9762\u90e8\u7279\u5f81\u3002\u4f60\u80fd\u786e\u5b9a\u7684\uff0c\u53ea\u6709\u515c\u5e3d\u5e95\u4e0b\u90a3\u7247\u9ed1\u6697\u91cc\uff0c\u9690\u7ea6\u5448\u73b0\u51fa\u4e00\u5bf9\u6df1\u84dd\u8272\u53cc\u773c\u7684\u5149\u6cfd\u3002</p><p>\u963f\u4ec0\u5229\u7684\u6597\u7bf7\u906e\u4f4f\u4e86\u6574\u5177\u8eaf\u4f53\uff0c\u8ba9\u4f60\u5b8c\u5168\u770b\u4e0d\u5230\u8eab\u4f53\u7684\u4efb\u4f55\u90e8\u4f4d\u3002\u4f60\u6839\u672c\u4e0d\u77e5\u9053\u5bf9\u65b9\u7684\u79cd\u65cf\u662f\u4ec0\u4e48\uff0c\u66f4\u522b\u63d0\u80f8\u90e8\u548c\u6027\u5f81\u7684\u60c5\u51b5\u4e86\u3002</p>");
        return this.infoScreenSB.toString();
    }

    @Override
    public void dailyUpdate() {
        this.clearNonEquippedInventory(false);
        for (AbstractItemType item : this.itemsForSale) {
            for (int i = 0; i < 3 + Util.random.nextInt(6); ++i) {
                this.addItem(Main.game.getItemGen().generateItem(item), false);
            }
        }
        this.addWeapon(Main.game.getItemGen().generateWeapon("innoxia_cleaning_feather_duster"), false);
    }

    @Override
    public void turnUpdate() {
        if (!Main.game.getCharactersPresent().contains(this)) {
            if (Main.game.isExtendedWorkTime()) {
                this.returnToHome();
            } else {
                this.setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false);
            }
        }
    }

    @Override
    public boolean willBuy(AbstractCoreItem item) {
        return false;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }

    @Override
    public boolean isTrader() {
        return true;
    }
}

