/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.dominion;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.character.race.SubspeciesSpawnRarity;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.AlleywayAttackerDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.AlleywayProstituteDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.StormStreetAttackerDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.Season;
import com.lilithsthrone.world.Weather;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DominionAlleywayAttacker
extends NPC {
    public DominionAlleywayAttacker() {
        this(Gender.getGenderFromUserPreferences(false, false), false, new NPCGenerationFlag[0]);
    }

    public DominionAlleywayAttacker(Gender gender) {
        this(gender, false, new NPCGenerationFlag[0]);
    }

    public DominionAlleywayAttacker(boolean isImported) {
        this(Gender.F_V_B_FEMALE, isImported, new NPCGenerationFlag[0]);
    }

    public DominionAlleywayAttacker(Gender gender, boolean isImported, NPCGenerationFlag ... generationFlags) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 3, null, null, null, new CharacterInventory(false, 10), WorldType.DOMINION, PlaceType.DOMINION_BACK_ALLEYS, false, generationFlags);
        if (!isImported) {
            boolean canalSpecies = false;
            AbstractPlaceType pt = Main.game.getPlayerCell().getPlace().getPlaceType();
            if (pt.equals(PlaceType.DOMINION_ALLEYS_CANAL_CROSSING) || pt.equals(PlaceType.DOMINION_CANAL) || pt.equals(PlaceType.DOMINION_CANAL_END)) {
                canalSpecies = true;
            }
            this.setLevel(Util.random.nextInt(3) + 1);
            HashMap<AbstractSubspecies, Integer> availableRaces = new HashMap<AbstractSubspecies, Integer>();
            for (AbstractSubspecies s : Subspecies.getAllSubspecies()) {
                if (s.getSubspeciesOverridePriority() > 0) continue;
                if (s == Subspecies.REINDEER_MORPH) {
                    if (Main.game.getSeason() != Season.WINTER || !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.hasSnowedThisWinter)) continue;
                    AbstractSubspecies.addToSubspeciesMap((int)((float)(canalSpecies ? 500 : 10000) * SubspeciesSpawnRarity.FIVE.getChanceMultiplier()), gender, s, availableRaces);
                    continue;
                }
                if (Subspecies.getWorldSpecies(WorldType.DOMINION, pt, false, new AbstractSubspecies[0]).containsKey(s)) {
                    AbstractSubspecies.addToSubspeciesMap((int)((float)(canalSpecies ? 2500 : 10000) * Subspecies.getWorldSpecies(WorldType.DOMINION, pt, false, new AbstractSubspecies[0]).get(s).getChanceMultiplier()), gender, s, availableRaces);
                }
                if (!canalSpecies || !Subspecies.getWorldSpecies(WorldType.SUBMISSION, pt, false, new AbstractSubspecies[0]).containsKey(s)) continue;
                AbstractSubspecies.addToSubspeciesMap((int)(10000.0f * Subspecies.getWorldSpecies(WorldType.SUBMISSION, pt, false, new AbstractSubspecies[0]).get(s).getChanceMultiplier()), gender, s, availableRaces);
            }
            this.setBodyFromSubspeciesPreference(gender, availableRaces, true, true);
            if ((Main.game.getCurrentWeather() != Weather.MAGIC_STORM || canalSpecies || pt == PlaceType.DOMINION_BACK_ALLEYS) && Math.random() < (double)((float)Main.getProperties().halfDemonSpawnRate / 100.0f) && this.getSubspecies() != Subspecies.SLIME) {
                this.setBody(Main.game.getCharacterUtils().generateHalfDemonBody(this, gender, this.getBody().getFleshSubspecies(), true), true);
            }
            if (Math.random() < (double)((float)Main.getProperties().taurSpawnRate / 100.0f) && this.getLegConfiguration() != LegConfiguration.QUADRUPEDAL) {
                if (this.getSubspecies() == Subspecies.HALF_DEMON && this.getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                } else if (this.getRace().getRacialBody().getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    this.setLegType(this.getRace().getRacialBody().getLegType());
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                }
            }
            this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            this.setName(Name.getRandomTriplet(this.getSubspecies()));
            this.setPlayerKnowsName(false);
            this.setDescription(UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u4e2a\u5fa1\u57ce\u533a\u5c45\u6c11\uff0c\u51fa\u4e8e\u79c1\u4eba\u539f\u56e0\uff0c[npc.her]\u6f5c\u884c\u5728\u80cc\u8857\u5c0f\u5df7\u4e2d\u5bfb\u627e\u730e\u7269\u3002", new ParserTag[0]));
            Main.game.getCharacterUtils().setHistoryAndPersonality(this, true);
            if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                this.setHistory(Occupation.NPC_MUGGER);
                this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            }
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.resetInventory(true);
            this.inventory.setMoney(10 + Util.random.nextInt(this.getLevel() * 10) + 1);
            Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
            if (!Arrays.asList(generationFlags).contains((Object)NPCGenerationFlag.NO_CLOTHING_EQUIP)) {
                this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            }
            Main.game.getCharacterUtils().applyMakeup(this, true);
            Main.game.getCharacterUtils().applyTattoos(this, true);
            if ((Arrays.asList(generationFlags).contains((Object)NPCGenerationFlag.DIRTY) || this.hasFetish(Fetish.FETISH_CUM_ADDICT)) && Math.random() < 0.1) {
                Main.game.getCharacterUtils().applyDirtiness(this);
            }
            this.initPerkTreeAndBackgroundPerks();
            this.setStartingCombatMoves();
            this.loadImages();
            this.initHealthAndManaToMax();
            if (this.isStormAttacker() && !this.isVulnerableToArcaneStorm()) {
                this.addSpecialPerk(Perk.SPECIAL_ARCANE_ALLERGY);
            }
        }
        this.setEnslavementDialogue(SlaveDialogue.DEFAULT_ENSLAVEMENT_DIALOGUE, true);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        DominionAlleywayAttacker.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.incrementMoney((long)((float)this.getInventory().getNonEquippedValue() * 0.5f));
        this.clearNonEquippedInventory(false);
        Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
        if (this.getHistory() == Occupation.NPC_PROSTITUTE) {
            Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.PROSTITUTE, settings);
        } else {
            Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.MUGGER, settings);
        }
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        if (this.isSlave() && this.isDoll()) {
            return super.getDescription();
        }
        if (this.getHistory() == Occupation.NPC_PROSTITUTE) {
            if (this.isSlave()) {
                return UtilText.parse((GameCharacter)this, "[npc.NamePos]\u5728\u5fa1\u57ce\u533a\u80cc\u8857\u5df7\u5b50\u91cc\u5356\u6deb\u7684\u65e5\u5b50\u7ed3\u675f\u4e86\u3002[npc.sheIs]\u56e0\u89e6\u72af\u6cd5\u5f8b\u6210\u4e3a\u4e86\u5974\u96b6\uff0c\u4e0d\u8fc7\u662f[npc.her]\u4e3b\u4eba\u7684\u8d22\u4ea7\u800c\u5df2\u3002", new ParserTag[0]);
            }
            if (this.getLocationPlace().getPlaceType().equals(PlaceType.ANGELS_KISS_BEDROOM)) {
                return UtilText.parse((GameCharacter)this, "\u4f60\u6700\u521d\u5728\u5fa1\u57ce\u533a\u7684\u5c0f\u5df7\u4e2d\u9047\u89c1\u4e86\u975e\u6cd5\u5356\u6deb\u7684[npc.name]\u3002\u4f60\u5f15\u8350[npc.herHim]\u53bb\u5929\u4f7f\u4e4b\u543b\u5de5\u4f5c\uff0c[npc.she]\u6b23\u7136\u63a5\u53d7\u3002", new ParserTag[0]);
            }
            return UtilText.parse((GameCharacter)this, "[npc.name]\u662f\u5356\u6deb\u8005\uff0c\u5728\u5fa1\u57ce\u533a\u540e\u5df7\u51fa\u5356\u8eab\u4f53\u3002", new ParserTag[0]);
        }
        if (this.isSlave()) {
            return UtilText.parse((GameCharacter)this, "[npc.NamePos]\u5728\u5fa1\u57ce\u533a\u7684\u540e\u5df7\u6e38\u8361\u548c\u62a2\u52ab\u65e0\u8f9c\u8fc7\u8def\u4eba\u7684\u65e5\u5b50\u5df2\u7ecf\u7ed3\u675f\u3002[npc.sheIs]\u56e0\u89e6\u72af\u6cd5\u5f8b\u6210\u4e3a\u4e86\u5974\u96b6\uff0c\u4e0d\u8fc7\u662f[npc.her]\u4e3b\u4eba\u7684\u8d22\u4ea7\u800c\u5df2\u3002", new ParserTag[0]);
        }
        if (Main.game.getPlayer().getFriendlyOccupants().contains(this.getId())) {
            return UtilText.parse((GameCharacter)this, "[npc.name]\u5728\u5fa1\u57ce\u533a\u540e\u5df7\u6e38\u8361\u3001\u62a2\u52ab\u65e0\u8f9c\u8fc7\u8def\u4eba\u7684\u65e5\u5b50\u5df2\u7ecf\u7ed3\u675f\u3002\u4f60\u4e0e[npc.herHim]\u6210\u4e3a\u670b\u53cb\uff0c\u9080\u8bf7[npc.name]\u642c\u5230\u4f60\u5bb6\uff0c\u5e2e\u52a9[npc.herHim]\u5f00\u59cb\u65b0\u751f\u6d3b\u3002", new ParserTag[0]);
        }
        return UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u5fa1\u57ce\u533a\u5c45\u6c11\uff0c\u5728\u540e\u5df7\u6f5c\u884c\uff0c\u6355\u98df\u65e0\u8f9c\u7684\u8fc7\u8def\u4eba\u3002", new ParserTag[0]);
    }

    @Override
    public boolean isClothingStealable() {
        return true;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        if (!this.isStormAttacker()) {
            if (this.getHistory() == Occupation.NPC_PROSTITUTE) {
                this.setPlayerKnowsName(true);
                return AlleywayProstituteDialogue.ALLEY_PROSTITUTE;
            }
            return AlleywayAttackerDialogue.ALLEY_ATTACK;
        }
        return StormStreetAttackerDialogue.STORM_ATTACK;
    }

    @Override
    public void applyEscapeCombatEffects() {
        if (this.isStormAttacker()) {
            Main.game.banishNPC(this);
        }
    }

    @Override
    public Response endCombat(boolean applyEffects, boolean victory) {
        if (this.getHistory() == Occupation.NPC_PROSTITUTE) {
            if (victory) {
                return new Response("", "", AlleywayProstituteDialogue.AFTER_COMBAT_VICTORY);
            }
            return new Response("", "", AlleywayProstituteDialogue.AFTER_COMBAT_DEFEAT);
        }
        if (this.isStormAttacker()) {
            if (victory) {
                return new Response("", "", StormStreetAttackerDialogue.AFTER_COMBAT_VICTORY);
            }
            return new Response("", "", StormStreetAttackerDialogue.AFTER_COMBAT_DEFEAT);
        }
        if (victory) {
            return new Response("", "", AlleywayAttackerDialogue.AFTER_COMBAT_VICTORY);
        }
        return new Response("", "", AlleywayAttackerDialogue.AFTER_COMBAT_DEFEAT);
    }

    public boolean isStormAttacker() {
        AbstractPlaceType pt = this.getLocationPlace().getPlaceType();
        return this.getWorldLocation().equals(WorldType.DOMINION) && !pt.equals(PlaceType.DOMINION_BACK_ALLEYS) && !pt.equals(PlaceType.DOMINION_ALLEYS_CANAL_CROSSING) && !pt.equals(PlaceType.DOMINION_CANAL) && !pt.equals(PlaceType.DOMINION_CANAL_END) && !Main.game.getPlayer().getFriendlyOccupants().contains(this.getId()) && (!this.isSlave() || !this.getOwner().isPlayer());
    }
}

