/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.dominion;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DominionClubNPC
extends NPC {
    public DominionClubNPC() {
        this(Gender.getGenderFromUserPreferences(false, false), Subspecies.DOG_MORPH, RaceStage.GREATER, false);
    }

    public DominionClubNPC(boolean isImported) {
        this(Gender.F_V_B_FEMALE, Subspecies.DOG_MORPH, RaceStage.GREATER, isImported);
    }

    public DominionClubNPC(Gender gender, AbstractSubspecies subspecies, RaceStage raceStage, boolean isImported) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 3, null, null, null, new CharacterInventory(false, 10), WorldType.EMPTY, PlaceType.GENERIC_CLUB_HOLDING_CELL, false, new NPCGenerationFlag[0]);
        if (!isImported) {
            this.setLocation(Main.game.getPlayer(), false);
            this.setLevel(Util.random.nextInt(5) + 5);
            this.setBody(gender, subspecies, raceStage, true);
            this.setName(Name.getRandomTriplet(this.getSubspecies()));
            this.setPlayerKnowsName(true);
            this.setDescription(UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u5fa1\u57ce\u533a\u7684\u5c45\u6c11\uff0c\u4f60\u4eec\u66fe\u5728\u591c\u751f\u6d3b\u533a\u91cc\u7684\u4e00\u5bb6\u591c\u603b\u4f1a\u9047\u89c1\u8fc7\u3002", new ParserTag[0]));
            Main.game.getCharacterUtils().setHistoryAndPersonality(this, false);
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.resetInventory(true);
            this.inventory.setMoney(10 + Util.random.nextInt(this.getLevel() * 10) + 1);
            this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            Main.game.getCharacterUtils().applyMakeup(this, true);
            Main.game.getCharacterUtils().applyTattoos(this, true);
            this.initPerkTreeAndBackgroundPerks();
            this.setStartingCombatMoves();
            this.loadImages();
            this.initHealthAndManaToMax();
        }
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        DominionClubNPC.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        if (this.getHomeWorldLocation() == WorldType.DOMINION) {
            this.setHomeLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL);
        }
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.CLUBBING, settings);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }
}

