/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.dominion;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.FurryPreference;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.character.race.SubspeciesSpawnRarity;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.HarpyAttackerDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HarpyNestsAttacker
extends NPC {
    public HarpyNestsAttacker() {
        this(Gender.getGenderFromUserPreferences(Femininity.FEMININE), false);
    }

    public HarpyNestsAttacker(Gender gender) {
        this(gender, false);
    }

    public HarpyNestsAttacker(boolean isImported) {
        this(Gender.F_V_B_FEMALE, isImported);
    }

    public HarpyNestsAttacker(Gender gender, boolean isImported) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 4, null, null, null, new CharacterInventory(false, 10), WorldType.HARPY_NEST, PlaceType.HARPY_NESTS_WALKWAYS, false, new NPCGenerationFlag[0]);
        if (!isImported) {
            this.setLocation(Main.game.getPlayer(), true);
            this.setLevel(Util.random.nextInt(4) + 2);
            HashMap<AbstractSubspecies, Integer> subspeciesMap = new HashMap<AbstractSubspecies, Integer>();
            for (Map.Entry<AbstractSubspecies, SubspeciesSpawnRarity> entry : Subspecies.getWorldSpecies(WorldType.HARPY_NEST, PlaceType.HARPY_NESTS_WALKWAYS, false, new AbstractSubspecies[0]).entrySet()) {
                if (entry.getKey().getRace() != Race.HARPY) continue;
                AbstractSubspecies.addToSubspeciesMap((int)(1000.0f * entry.getValue().getChanceMultiplier()), gender, entry.getKey(), subspeciesMap);
            }
            this.setBodyFromSubspeciesPreference(gender, subspeciesMap, true, false);
            if (Math.random() < (double)((float)Main.getProperties().halfDemonSpawnRate / 100.0f)) {
                this.setBody(Main.game.getCharacterUtils().generateHalfDemonBody(this, this.getGender(), this.getBody().getFleshSubspecies(), true), true);
            }
            this.setName(Name.getRandomTriplet(Subspecies.HARPY));
            this.setPlayerKnowsName(false);
            Main.game.getCharacterUtils().setHistoryAndPersonality(this, true);
            this.setHistory(Occupation.NPC_HARPY_FLOCK_MEMBER);
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.resetInventory(true);
            this.inventory.setMoney(10 + Util.random.nextInt(this.getLevel() * 10) + 1);
            Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
            this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            Main.game.getCharacterUtils().applyMakeup(this, true);
            Main.game.getCharacterUtils().applyTattoos(this, true);
            if (this.hasFetish(Fetish.FETISH_CUM_ADDICT) && Math.random() < 0.1) {
                Main.game.getCharacterUtils().applyDirtiness(this);
            }
            this.initHealthAndManaToMax();
        }
        this.setEnslavementDialogue(SlaveDialogue.DEFAULT_ENSLAVEMENT_DIALOGUE, true);
    }

    @Override
    public void setBodyFromSubspeciesPreference(Gender gender, Map<AbstractSubspecies, Integer> subspeciesMap, boolean additionalSetups, boolean includeHumanChance) {
        if (gender.isFeminine()) {
            for (Map.Entry<AbstractSubspecies, FurryPreference> entry : Main.getProperties().getSubspeciesFeminineFurryPreferencesMap().entrySet()) {
                if (entry.getValue() != FurryPreference.HUMAN) continue;
                subspeciesMap.remove(entry.getKey());
            }
        } else {
            for (Map.Entry<AbstractSubspecies, FurryPreference> entry : Main.getProperties().getSubspeciesMasculineFurryPreferencesMap().entrySet()) {
                if (entry.getValue() != FurryPreference.HUMAN) continue;
                subspeciesMap.remove(entry.getKey());
            }
        }
        int total = 0;
        for (Integer i : subspeciesMap.values()) {
            total += i.intValue();
        }
        AbstractSubspecies species = Subspecies.HARPY;
        if (!subspeciesMap.isEmpty() && total > 0) {
            species = Util.getRandomObjectFromWeightedMap(subspeciesMap);
        }
        this.setBody(gender, species, RaceStage.LESSER, true);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        HarpyNestsAttacker.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public String getDescription() {
        if (this.isSlave()) {
            return UtilText.parse((GameCharacter)this, "[npc.nameIsFull]\u56e0\u89e6\u72af\u6cd5\u5f8b\u6210\u4e3a\u4e86\u5974\u96b6\uff0c\u4e0d\u8fc7\u662f[npc.her]\u4e3b\u4eba\u7684\u8d22\u4ea7\u800c\u5df2\u3002", new ParserTag[0]);
        }
        if (this.getAffectionLevel(Main.game.getPlayer()).isLessThan(AffectionLevel.POSITIVE_ONE_FRIENDLY)) {
            return UtilText.parse((GameCharacter)this, "[npc.Name]\u5bf9\u4f60\u8fdb\u5165'[npc.her]\u7684'\u9886\u5730\u611f\u5230\u6124\u6012\u3002\u770b\u8d77\u6765\u5979\u5df2\u7ecf\u51c6\u5907\u597d\u4e0e\u4f60\u6218\u6597\uff0c\u597d\u597d\u7ed9\u4f60\u4e00\u4e2a\u6559\u8bad\u2026\u2026", new ParserTag[0]);
        }
        return UtilText.parse((GameCharacter)this, "\u867d\u7136\u4f60\u4e0e[npc.name]\u7684\u7b2c\u4e00\u6b21\u76f8\u9047\u65f6\u5f7c\u6b64\u9488\u950b\u76f8\u5bf9\uff0c\u4f46\u540e\u6765\u4f60\u8bbe\u6cd5\u4e0e\u8fd9\u4f4d\u597d\u6597\u7684[npc.race]\u6210\u4e3a\u670b\u53cb\uff0c\u4f60\u53ef\u4ee5\u80af\u5b9a[npc.herHim]\u603b\u4f1a\u70ed\u70c8\u6b22\u8fce\u4f60\u3002", new ParserTag[0]);
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.incrementMoney((long)((float)this.getInventory().getNonEquippedValue() * 0.5f));
        this.clearNonEquippedInventory(false);
        Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
        Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.CASUAL, settings);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public void endSex() {
        if (!this.isSlave()) {
            this.setPendingClothingDressing(true);
        }
    }

    @Override
    public boolean isClothingStealable() {
        return true;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return HarpyAttackerDialogue.HARPY_ATTACK;
    }

    @Override
    public Response endCombat(boolean applyEffects, boolean victory) {
        if (victory) {
            return new Response("", "", HarpyAttackerDialogue.AFTER_COMBAT_VICTORY);
        }
        return new Response("", "", HarpyAttackerDialogue.AFTER_COMBAT_DEFEAT);
    }
}

