/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.fields;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.body.valueEnums.AssSize;
import com.lilithsthrone.game.character.body.valueEnums.BodyHair;
import com.lilithsthrone.game.character.body.valueEnums.BodySize;
import com.lilithsthrone.game.character.body.valueEnums.Capacity;
import com.lilithsthrone.game.character.body.valueEnums.CoveringModifier;
import com.lilithsthrone.game.character.body.valueEnums.CoveringPattern;
import com.lilithsthrone.game.character.body.valueEnums.HairLength;
import com.lilithsthrone.game.character.body.valueEnums.HairStyle;
import com.lilithsthrone.game.character.body.valueEnums.HipSize;
import com.lilithsthrone.game.character.body.valueEnums.HornLength;
import com.lilithsthrone.game.character.body.valueEnums.LipSize;
import com.lilithsthrone.game.character.body.valueEnums.Muscle;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.body.valueEnums.TesticleSize;
import com.lilithsthrone.game.character.body.valueEnums.TongueLength;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.PerkCategory;
import com.lilithsthrone.game.character.effects.PerkManager;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.fetishes.FetishDesire;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.PersonalityTrait;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Imsu
extends NPC {
    public Imsu() {
        this(false);
    }

    public Imsu(boolean isImported) {
        super(isImported, new NameTriplet("\u56e0\u82cf"), "\u8389\u7d22\u83f2\u4e9a\u9a6c\u5c14\u56fe", "\u56e0\u82cf\u662f\u4f0a\u5229\u65af\u5546\u4e1a\u533a\u201c\u4e5d\u70bc\u201d\u94c1\u5320\u94fa\u7684\u5df4\u98ce\u7279\u94c1\u5320\u4e8c\u4eba\u4e4b\u4e00\u3002\u867d\u7136\u4ed6\u7684\u4e3b\u8981\u5de5\u4f5c\u90fd\u662f\u751f\u4ea7\u6216\u4fee\u7406\u5c0f\u4e1c\u897f\u548c\u673a\u68b0\uff0c\u4f46\u4ed6\u771f\u6b63\u70ed\u7231\u7684\u662f\u5236\u9020\u8fd1\u6218\u6b66\u5668\u3002", 43, Month.FEBRUARY, 4, 25, Gender.M_P_MALE, Subspecies.getSubspeciesFromId("innoxia_goat_subspecies_goat"), RaceStage.GREATER, new CharacterInventory(false, 10), WorldType.getWorldTypeFromId("innoxia_fields_elis_shops"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_shops_blacksmith"), true, new NPCGenerationFlag[0]);
        this.setGenericName("\u9ed1\u6bdb\u5df4\u98ce\u7279");
        if (!isImported) {
            this.dailyUpdate();
            this.setPlayerKnowsName(false);
            this.addSpell(Spell.FIREBALL);
            this.addSpell(Spell.FLASH);
            this.addSpell(Spell.SLAM);
            this.addSpell(Spell.STONE_SHELL);
        }
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        Imsu.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public void setupPerks(boolean autoSelectPerks) {
        this.addSpecialPerk(Perk.SPECIAL_ARCANE_TRAINING);
        this.addSpecialPerk(Perk.SPECIAL_MELEE_EXPERT);
        this.addSpecialPerk(Perk.SPECIAL_HEALTH_FANATIC);
        PerkManager.initialisePerks((GameCharacter)this, Util.newArrayListOfValues(Perk.WEAPON_ENCHANTER), Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 0), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)));
    }

    @Override
    public void setStartingBody(boolean setPersona) {
        if (setPersona) {
            this.setPersonalityTraits(PersonalityTrait.CONFIDENT, PersonalityTrait.BRAVE);
            this.setSexualOrientation(SexualOrientation.AMBIPHILIC);
            this.setHistory(Occupation.NPC_STORE_OWNER);
            this.addFetish(Fetish.FETISH_DOMINANT);
            this.addFetish(Fetish.FETISH_BREASTS_OTHERS);
            this.setFetishDesire(Fetish.FETISH_ARMPIT_GIVING, FetishDesire.THREE_LIKE);
            this.setFetishDesire(Fetish.FETISH_ORAL_RECEIVING, FetishDesire.THREE_LIKE);
        }
        this.setBody(Main.game.getCharacterUtils().generateHalfDemonBody(this, Gender.M_P_MALE, Subspecies.getSubspeciesFromId("innoxia_goat_subspecies_goat"), true, RaceStage.GREATER), false);
        this.setWingType(WingType.NONE);
        this.setHornType(HornType.CURLED);
        this.setHornLength(HornLength.TWO_LONG.getMedianValue());
        this.setHeight(186);
        this.setFemininity(5);
        this.setMuscle(Muscle.FOUR_RIPPED.getMedianValue());
        this.setBodySize(BodySize.THREE_LARGE.getMedianValue());
        this.setEyeCovering(new Covering(BodyCoveringType.getBodyCoveringTypeFromId("innoxia_goat_eye"), CoveringPattern.EYE_IRISES, PresetColour.EYE_RED, true, PresetColour.EYE_RED, true));
        this.setEyeCovering(new Covering(BodyCoveringType.EYE_DEMON_COMMON, CoveringPattern.EYE_IRISES, PresetColour.EYE_RED, true, PresetColour.EYE_RED, true));
        this.setSkinCovering(new Covering(BodyCoveringType.getBodyCoveringTypeFromId("innoxia_goat_fur"), CoveringPattern.MARKED, CoveringModifier.SHORT, PresetColour.COVERING_BLACK, false, PresetColour.COVERING_WHITE, false), true);
        this.setSkinCovering(new Covering(BodyCoveringType.HUMAN, PresetColour.SKIN_EBONY), true);
        this.setSkinCovering(new Covering(BodyCoveringType.HORN, PresetColour.COVERING_DARK_GREY), false);
        this.setHairCovering(new Covering(BodyCoveringType.getBodyCoveringTypeFromId("innoxia_goat_hair"), PresetColour.COVERING_BLACK), true);
        this.setHairLength(HairLength.ZERO_BALD.getMinimumValue());
        this.setHairStyle(HairStyle.NONE);
        this.setHairCovering(new Covering(BodyCoveringType.getBodyCoveringTypeFromId("innoxia_goat_body_hair"), PresetColour.COVERING_BLACK), false);
        this.setUnderarmHair(BodyHair.FOUR_NATURAL);
        this.setAssHair(BodyHair.FOUR_NATURAL);
        this.setPubicHair(BodyHair.FOUR_NATURAL);
        this.setFacialHair(BodyHair.ZERO_NONE);
        this.setFaceVirgin(true);
        this.setLipSize(LipSize.ONE_AVERAGE);
        this.setFaceCapacity(Capacity.TWO_TIGHT, true);
        this.setTongueLength(TongueLength.ZERO_NORMAL.getMedianValue());
        this.setAssVirgin(true);
        this.setAssBleached(false);
        this.setAssSize(AssSize.TWO_SMALL);
        this.setHipSize(HipSize.TWO_NARROW);
        this.setPenisVirgin(false);
        this.setPenisGirth(PenetrationGirth.FIVE_THICK);
        this.setPenisSize(24);
        this.setTesticleSize(TesticleSize.THREE_LARGE);
        this.setPenisCumStorage(250);
        this.setPenisCumExpulsion(75);
        this.fillCumToMaxStorage();
        this.setTesticleCount(2);
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.unequipAllClothingIntoVoid(true, true);
        this.setMoney(5000L);
        this.setEssenceCount(250);
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_eye_safety_glasses", PresetColour.CLOTHING_BLUE_NAVY, PresetColour.CLOTHING_BLUE_NAVY, PresetColour.CLOTHING_WHITE, false), true, this);
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_leg_jeans", PresetColour.CLOTHING_BLUE_NAVY, PresetColour.CLOTHING_STEEL, null, false), true, this);
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_groin_boxers", PresetColour.CLOTHING_GREEN_DRAB, false), true, this);
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getSpeechColour() {
        return "#d18484";
    }

    @Override
    public void dailyUpdate() {
        this.clearNonEquippedInventory(false);
        ArrayList<AbstractWeaponType> weaponTypesToSell = new ArrayList<AbstractWeaponType>();
        ArrayList<AbstractClothingType> clothingTypesToSell = new ArrayList<AbstractClothingType>();
        ArrayList<AbstractItemType> itemTypesToSell = new ArrayList<AbstractItemType>();
        for (AbstractWeaponType abstractWeaponType : WeaponType.getAllWeapons()) {
            if (!abstractWeaponType.getItemTags().contains((Object)ItemTag.SOLD_BY_VICKY) || !abstractWeaponType.isMelee() || abstractWeaponType.getItemTags().contains((Object)ItemTag.SILLY_MODE) && !Main.game.isSillyMode()) continue;
            weaponTypesToSell.add(abstractWeaponType);
        }
        while ((double)weaponTypesToSell.size() >= (double)this.getMaximumInventorySpace() * 0.8) {
            weaponTypesToSell.remove(Util.random.nextInt(weaponTypesToSell.size()));
        }
        for (AbstractWeaponType abstractWeaponType : weaponTypesToSell) {
            this.addWeapon(Main.game.getItemGen().generateWeapon(abstractWeaponType), 1 + Util.random.nextInt(3), false, false);
        }
        for (AbstractItemType abstractItemType : ItemType.getAllItems()) {
            if (!abstractItemType.getItemTags().contains((Object)ItemTag.SOLD_BY_VICKY) || abstractItemType.getItemTags().contains((Object)ItemTag.SILLY_MODE) && !Main.game.isSillyMode()) continue;
            itemTypesToSell.add(abstractItemType);
        }
        while ((double)itemTypesToSell.size() >= (double)this.getMaximumInventorySpace() * 0.8) {
            itemTypesToSell.remove(Util.random.nextInt(itemTypesToSell.size()));
        }
        for (AbstractItemType abstractItemType : itemTypesToSell) {
            this.addItem(Main.game.getItemGen().generateItem(abstractItemType), 1 + Util.random.nextInt(3), false, false);
        }
        this.addItem(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER), 5 + Util.random.nextInt(6), false, false);
        for (AbstractClothingType abstractClothingType : ClothingType.getAllClothing()) {
            if (!abstractClothingType.getDefaultItemTags().contains((Object)ItemTag.SOLD_BY_VICKY) || abstractClothingType.getDefaultItemTags().contains((Object)ItemTag.SILLY_MODE) && !Main.game.isSillyMode()) continue;
            clothingTypesToSell.add(abstractClothingType);
        }
        while ((double)clothingTypesToSell.size() >= (double)this.getMaximumInventorySpace() * 0.8) {
            clothingTypesToSell.remove(Util.random.nextInt(clothingTypesToSell.size()));
        }
        for (AbstractClothingType abstractClothingType : clothingTypesToSell) {
            this.addClothing(Main.game.getItemGen().generateClothing(abstractClothingType, false), false);
        }
    }

    @Override
    public void turnUpdate() {
        if (!Main.game.getCharactersPresent().contains(this)) {
            if (Main.game.isHourBetween(7.0f, 20.0f)) {
                this.returnToHome();
            } else {
                this.setLocation(WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false);
            }
        }
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }

    @Override
    public String getTraderDescription() {
        return UtilText.parseFromXMLFile("places/fields/elis/shops/blacksmith", "IMSU_TRANSACTION_START");
    }

    @Override
    public boolean isTrader() {
        return true;
    }

    @Override
    public boolean willBuy(AbstractCoreItem item) {
        if (item.getItemTags().contains((Object)ItemTag.CONTRABAND_LIGHT) || item.getItemTags().contains((Object)ItemTag.CONTRABAND_MEDIUM) || item.getItemTags().contains((Object)ItemTag.CONTRABAND_HEAVY)) {
            return false;
        }
        if (item instanceof AbstractWeapon) {
            return true;
        }
        if (item instanceof AbstractItem || item instanceof AbstractClothing) {
            return item.getItemTags().contains((Object)ItemTag.SOLD_BY_VICKY);
        }
        return false;
    }

    @Override
    public void applyItemTransactionEffects(AbstractCoreItem itemSold, int quantity, int individualPrice, boolean soldToPlayer) {
        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.removeTraderDescription, true);
        UtilText.addSpecialParsingString(itemSold.getName(), true);
        UtilText.addSpecialParsingString(Util.intToString(quantity * individualPrice), false);
        if (soldToPlayer) {
            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/fields/elis/shops/blacksmith", "IMSU_BUY_TRANSACTION_COMPLETE"));
        } else {
            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile("places/fields/elis/shops/blacksmith", "IMSU_SELL_TRANSACTION_COMPLETE"));
        }
    }

    @Override
    public void endSex() {
    }
}

