/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.fields;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.PersonalityTrait;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.character.race.SubspeciesSpawnRarity;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.moves.CombatMoveType;
import com.lilithsthrone.game.dialogue.DialogueManager;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SillyModeLARPAttacker
extends NPC {
    public SillyModeLARPAttacker() {
        this(Gender.getGenderFromUserPreferences(false, false), false, new NPCGenerationFlag[0]);
    }

    public SillyModeLARPAttacker(Gender gender) {
        this(gender, false, new NPCGenerationFlag[0]);
    }

    public SillyModeLARPAttacker(boolean isImported) {
        this(Gender.M_P_MALE, isImported, new NPCGenerationFlag[0]);
    }

    public SillyModeLARPAttacker(Gender gender, boolean isImported, NPCGenerationFlag ... generationFlags) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 3, null, null, null, new CharacterInventory(false, 10), WorldType.getWorldTypeFromId("dsg_fields_elis_eisek_sillymode_dungeon"), PlaceType.getPlaceTypeFromId("dsg_fields_elis_eisek_sillymode_dungeon_passage"), false, generationFlags);
        if (!isImported) {
            this.setLevel(Util.random.nextInt(6) + 1);
            HashMap<AbstractSubspecies, Integer> availableRaces = new HashMap<AbstractSubspecies, Integer>();
            for (AbstractSubspecies s : Subspecies.getAllSubspecies()) {
                Map<AbstractSubspecies, SubspeciesSpawnRarity> subMap;
                if (s.getSubspeciesOverridePriority() > 0 || !(subMap = Subspecies.getWorldSpecies(WorldType.getWorldTypeFromId("innoxia_fields_elis_town"), PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_alley"), false, new AbstractSubspecies[0])).containsKey(s)) continue;
                AbstractSubspecies.addToSubspeciesMap((int)(10000.0f * subMap.get(s).getChanceMultiplier()), gender, s, availableRaces);
            }
            this.setBodyFromSubspeciesPreference(gender, availableRaces, true, true);
            if (Math.random() < (double)((float)Main.getProperties().halfDemonSpawnRate / 100.0f) && this.getSubspecies() != Subspecies.SLIME) {
                this.setBody(Main.game.getCharacterUtils().generateHalfDemonBody(this, gender, this.getBody().getFleshSubspecies(), true), true);
            }
            if (Math.random() < (double)((float)Main.getProperties().taurSpawnRate / 100.0f) && this.getLegConfiguration() != LegConfiguration.QUADRUPEDAL) {
                if (this.getSubspecies() == Subspecies.HALF_DEMON && this.getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                } else if (this.getRace().getRacialBody().getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    this.setLegType(this.getRace().getRacialBody().getLegType());
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                }
            }
            this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            this.setName(Name.getRandomTriplet(this.getSubspecies()));
            this.setPlayerKnowsName(false);
            this.setHistory(Occupation.NPC_UNEMPLOYED);
            if (Math.random() < 0.25) {
                this.addPersonalityTrait(PersonalityTrait.SLOVENLY);
            }
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.setMuscle(Util.random.nextInt(40));
            this.resetInventory(true);
            this.inventory.setMoney(10 + Util.random.nextInt(this.getLevel() * 10) + 1);
            Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
            if (!Arrays.asList(generationFlags).contains((Object)NPCGenerationFlag.NO_CLOTHING_EQUIP)) {
                this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            }
            this.initPerkTreeAndBackgroundPerks();
            this.setStartingCombatMoves();
            this.loadImages();
            this.initHealthAndManaToMax();
        }
        this.setEnslavementDialogue(SlaveDialogue.DEFAULT_ENSLAVEMENT_DIALOGUE, true);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        SillyModeLARPAttacker.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public void setStartingCombatMoves() {
        this.clearEquippedMoves();
        this.equipMove("strike");
        this.equipMove("twin-strike");
    }

    @Override
    public float getMoveWeight(AbstractCombatMove move, List<GameCharacter> enemies, List<GameCharacter> allies) {
        if (move.getType() == CombatMoveType.TEASE || move.getType() == CombatMoveType.DEFEND) {
            return 0.0f;
        }
        return super.getMoveWeight(move, enemies, allies);
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.incrementMoney((long)((float)this.getInventory().getNonEquippedValue() * 1.0f));
        this.clearNonEquippedInventory(false);
        Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
        Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.JOB_LABOUR, settings);
        if (this.getClothingInSlot(InventorySlot.TORSO_OVER) != null) {
            this.unequipClothingIntoVoid(InventorySlot.TORSO_OVER, true, (GameCharacter)this);
        }
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("dsg_sm_cboard_cbarmor", false), InventorySlot.TORSO_OVER, true, this);
        this.equipMainWeaponFromNowhere(Main.game.getItemGen().generateWeapon("dsg_sm_cboard_cbsword"));
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        return UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u4e00\u4e2a\u70ed\u7231\u771f\u4eba\u89d2\u8272\u626e\u6f14\u7684\u4f0a\u5229\u65af\u5c45\u6c11\u3002", new ParserTag[0]);
    }

    @Override
    public boolean isClothingStealable() {
        return true;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return DialogueManager.getDialogueFromId("dsg_encounters_fields_elis_eisek_sillymode_dungeon_combat");
    }

    @Override
    public void applyEscapeCombatEffects() {
    }

    @Override
    public Response endCombat(boolean applyEffects, boolean victory) {
        if (victory) {
            return new Response("", "", DialogueManager.getDialogueFromId("dsg_encounters_fields_elis_eisek_sillymode_dungeon_combat_won"));
        }
        return new Response("", "", DialogueManager.getDialogueFromId("dsg_encounters_fields_elis_eisek_sillymode_dungeon_combat_lost"));
    }

    @Override
    public boolean isLootingPlayerAfterCombat() {
        return false;
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }
}

