/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.misc;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LodgerImport
extends NPC {
    public LodgerImport() {
        this(false);
    }

    public LodgerImport(boolean isImported) {
        super(isImported, new NameTriplet("\u623f\u5ba2"), "", "-", 18, Month.JUNE, 10, 1, Gender.F_V_B_FEMALE, Subspecies.HUMAN, RaceStage.HUMAN, new CharacterInventory(false, 0), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false, new NPCGenerationFlag[0]);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        LodgerImport.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        this.setLastTimeEncountered(-1L);
        if (!this.getId().endsWith("LodgerImport")) {
            this.setId(Main.game.getNextNPCId(LodgerImport.class));
        }
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
    }

    public void applyNewlyImportedLodgerVariables() {
        this.endPregnancy(false);
        this.washAllOrifices(true);
        this.calculateStatusEffects(0);
        this.cleanAllDirtySlots(true);
        this.cleanAllClothing(true, false);
        this.clearAffectionMap();
        this.getSlavesOwned().clear();
        this.setPlayerKnowsName(true);
        this.setLocation(WorldType.CITY_HALL, PlaceType.CITY_HALL_WAITING_AREA, true);
    }

    @Override
    public String getDescription() {
        if (this.isSlave() && this.isDoll()) {
            return super.getDescription();
        }
        return UtilText.parse((GameCharacter)this, "\u4f60\u5728\u5fa1\u57ce\u533a\u7684\u5e02\u653f\u5385\u7b2c\u4e00\u6b21\u89c1\u5230[npc.name]\uff0c\u5f53\u65f6[npc.she]\u6b63\u5728\u5bfb\u627e\u5730\u65b9\u79df\u4f4f\u2026\u2026", new ParserTag[0]);
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }
}

