/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.misc;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.Season;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModdedCharacter
extends NPC {
    protected boolean isTrader;
    protected boolean isClothingStealable;
    protected boolean isAbleToBeImpregnated;
    protected Set<ItemTag> itemTagsToBuy;

    public ModdedCharacter() {
        this(Gender.getGenderFromUserPreferences(false, false), WorldType.EMPTY, new Vector2i(0, 0), false);
    }

    public ModdedCharacter(boolean isImported) {
        this(Gender.getGenderFromUserPreferences(false, false), WorldType.EMPTY, new Vector2i(0, 0), isImported);
    }

    public ModdedCharacter(Gender gender, AbstractWorldType worldLocation, Vector2i location, boolean isImported) {
        this(gender, worldLocation, location, isImported, null);
    }

    public ModdedCharacter(Gender gender, AbstractWorldType worldLocation, AbstractPlaceType placeType, boolean isImported, Predicate<AbstractSubspecies> subspeciesRemovalFilter) {
        this(gender, worldLocation, Main.game.getWorlds().get(worldLocation).getCell(placeType).getLocation(), isImported, subspeciesRemovalFilter);
    }

    public ModdedCharacter(Gender gender, AbstractWorldType worldLocation, Vector2i location, boolean isImported, Predicate<AbstractSubspecies> subspeciesRemovalFilter) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 3, null, null, null, new CharacterInventory(false, 10), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false, new NPCGenerationFlag[0]);
        if (!isImported) {
            this.setLocation(worldLocation, location, false);
            this.setLevel(Util.random.nextInt(5) + 5);
            HashMap<AbstractSubspecies, Integer> availableRaces = new HashMap<AbstractSubspecies, Integer>();
            ArrayList<AbstractSubspecies> availableSubspecies = new ArrayList<AbstractSubspecies>(Subspecies.getAllSubspecies());
            if (subspeciesRemovalFilter != null) {
                availableSubspecies.removeIf(subspeciesRemovalFilter);
            }
            for (AbstractSubspecies s : availableSubspecies) {
                if (s.getSubspeciesOverridePriority() > 0) continue;
                if (s == Subspecies.REINDEER_MORPH && Main.game.getSeason() == Season.WINTER && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.hasSnowedThisWinter)) {
                    AbstractSubspecies.addToSubspeciesMap(50, gender, s, availableRaces);
                }
                if (Subspecies.getWorldSpecies(WorldType.DOMINION, null, false, new AbstractSubspecies[0]).containsKey(s)) {
                    AbstractSubspecies.addToSubspeciesMap((int)(1000.0f * Subspecies.getWorldSpecies(WorldType.DOMINION, null, false, new AbstractSubspecies[0]).get(s).getChanceMultiplier()), gender, s, availableRaces);
                    continue;
                }
                if (!Subspecies.getWorldSpecies(WorldType.SUBMISSION, null, false, new AbstractSubspecies[0]).containsKey(s)) continue;
                AbstractSubspecies.addToSubspeciesMap((int)(1000.0f * Subspecies.getWorldSpecies(WorldType.SUBMISSION, null, false, new AbstractSubspecies[0]).get(s).getChanceMultiplier()), gender, s, availableRaces);
            }
            this.setBodyFromSubspeciesPreference(gender, availableRaces, true, subspeciesRemovalFilter == null);
            this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            this.setName(Name.getRandomTriplet(this.getSubspecies()));
            this.setPlayerKnowsName(false);
            this.setDescription(UtilText.parse((GameCharacter)this, "[npc.Name]\u662f[npc.a_fullRace]\u3002", new ParserTag[0]));
            this.initPerkTreeAndBackgroundPerks();
            this.setStartingCombatMoves();
            this.loadImages();
            this.initHealthAndManaToMax();
            this.isTrader = false;
            this.itemTagsToBuy = new HashSet<ItemTag>();
            this.isAbleToBeImpregnated = false;
            this.isClothingStealable = false;
        }
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        ModdedCharacter.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        this.isTrader = false;
        this.itemTagsToBuy = new HashSet<ItemTag>();
        this.isAbleToBeImpregnated = false;
        this.isClothingStealable = false;
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }

    public void setAbleToBeImpregnated(boolean ableToBeImpregnated) {
        this.isAbleToBeImpregnated = ableToBeImpregnated;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return this.isAbleToBeImpregnated;
    }

    public void setClothingStealable(boolean clothingStealable) {
        this.isClothingStealable = clothingStealable;
    }

    @Override
    public boolean isClothingStealable() {
        return this.isClothingStealable;
    }

    public void setTrader(boolean trader) {
        this.isTrader = trader;
    }

    @Override
    public boolean isTrader() {
        return this.isTrader;
    }

    public void setItemTagsToBuy(ItemTag[] itemTagsToBuy) {
        Collections.addAll(this.itemTagsToBuy, itemTagsToBuy);
    }

    @Override
    public boolean willBuy(AbstractCoreItem item) {
        return !Collections.disjoint(item.getItemTags(), this.itemTagsToBuy);
    }
}

