/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.misc;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.npc.dominion.Finch;
import com.lilithsthrone.game.character.persona.NameTriplet;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SlaveImport
extends NPC {
    public SlaveImport() {
        this(false);
    }

    public SlaveImport(boolean isImported) {
        super(isImported, new NameTriplet("\u5974\u96b6"), "", "-", 18, Month.JUNE, 10, 1, Gender.F_V_B_FEMALE, Subspecies.HUMAN, RaceStage.HUMAN, new CharacterInventory(false, 0), WorldType.EMPTY, PlaceType.GENERIC_HOLDING_CELL, false, new NPCGenerationFlag[0]);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        SlaveImport.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
        this.setLastTimeEncountered(-1L);
        if (!this.getId().endsWith("SlaveImport")) {
            this.setId(Main.game.getNextNPCId(SlaveImport.class));
        }
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
    }

    public void applyNewlyImportedSlaveVariables() {
        Main.game.getNpc(Finch.class).addSlave(this);
        this.setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_AUCTIONING_BLOCK, true);
        this.endPregnancy(false);
        this.washAllOrifices(true);
        this.calculateStatusEffects(0);
        this.cleanAllDirtySlots(true);
        this.cleanAllClothing(true, false);
        this.clearNonEquippedInventory(true);
        if (this.getClothingInSlot(InventorySlot.NECK) != null) {
            this.getClothingInSlot(InventorySlot.NECK).setSealed(false);
            this.unequipClothingIntoInventory(this.getClothingInSlot(InventorySlot.NECK), true, this);
        }
        this.equipClothingFromNowhere(Main.game.getItemGen().generateClothing("innoxia_bdsm_metal_collar", false), true, this);
        this.getClothingInSlot(InventorySlot.NECK).setSealed(true);
        this.clearAffectionMap();
        this.setObedience(Math.round(-25.0 + Math.random() * 50.0));
        this.getSlavesOwned().clear();
        this.setPlayerKnowsName(true);
        this.setHistory(Occupation.NPC_SLAVE);
    }

    @Override
    public String getDescription() {
        if (this.isSlave() && this.isDoll()) {
            return super.getDescription();
        }
        return UtilText.parse((GameCharacter)this, "[npc.name]\u8eab\u4e3a\u4e00\u540d\u5974\u96b6\uff0c\u53ea\u4e0d\u8fc7\u662f\u67d0\u4eba\u7684\u8d22\u4ea7\u3002\u4f60\u7b2c\u4e00\u6b21\u9047\u89c1[npc.herHim]\u65f6\uff0c[npc.she]\u6b63\u5728\u5974\u96b6\u5df7\u5f85\u552e\u3002", new ParserTag[0]);
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        return null;
    }
}

