/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.npc.submission;

import com.lilithsthrone.game.character.CharacterImportSetting;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.fetishes.AbstractFetish;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCGenerationFlag;
import com.lilithsthrone.game.character.persona.Name;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.character.persona.PersonalityTrait;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.character.race.SubspeciesPreference;
import com.lilithsthrone.game.character.race.SubspeciesSpawnRarity;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.submission.TunnelAttackDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.submission.TunnelSlimeDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubmissionAttacker
extends NPC {
    public SubmissionAttacker() {
        this(Gender.getGenderFromUserPreferences(false, false), false);
    }

    public SubmissionAttacker(Gender gender) {
        this(gender, false);
    }

    public SubmissionAttacker(boolean isImported) {
        this(Gender.F_V_B_FEMALE, isImported);
    }

    public SubmissionAttacker(Gender gender, boolean isImported) {
        super(isImported, null, null, "", Util.random.nextInt(28) + 18, Util.randomItemFrom(Month.values()), 1 + Util.random.nextInt(25), 3, null, null, null, new CharacterInventory(false, 10), WorldType.SUBMISSION, PlaceType.SUBMISSION_TUNNELS, false, new NPCGenerationFlag[0]);
        if (!isImported) {
            this.setLevel(5 + Util.random.nextInt(4));
            int slimeChance = 800;
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.slimeQueenHelped) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_SLIME_QUEEN)) {
                slimeChance *= 3;
            } else if (!Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_ONE)) {
                slimeChance *= 4;
            }
            HashMap<AbstractSubspecies, Integer> availableRaces = new HashMap<AbstractSubspecies, Integer>();
            for (AbstractSubspecies s : Subspecies.getAllSubspecies()) {
                Map<AbstractSubspecies, SubspeciesSpawnRarity> worldSpeciesMap = Subspecies.getWorldSpecies(WorldType.SUBMISSION, PlaceType.SUBMISSION_TUNNELS, false, new AbstractSubspecies[0]);
                if (s == Subspecies.SLIME) {
                    AbstractSubspecies.addToSubspeciesMap(slimeChance, gender, s, availableRaces, SubspeciesPreference.FOUR_ABUNDANT);
                    continue;
                }
                if (!worldSpeciesMap.containsKey(s)) continue;
                if (s == Subspecies.IMP || s == Subspecies.IMP_ALPHA) {
                    AbstractSubspecies.addToSubspeciesMap((int)(1000.0f * worldSpeciesMap.get(s).getChanceMultiplier()), gender, s, availableRaces, SubspeciesPreference.FOUR_ABUNDANT);
                    continue;
                }
                AbstractSubspecies.addToSubspeciesMap((int)(1000.0f * worldSpeciesMap.get(s).getChanceMultiplier()), gender, s, availableRaces);
            }
            AbstractSubspecies randomSpecies = (AbstractSubspecies)Util.getRandomObjectFromWeightedMap(availableRaces);
            if (randomSpecies == Subspecies.SLIME || randomSpecies == Subspecies.IMP || randomSpecies == Subspecies.IMP_ALPHA) {
                this.setBody(gender, randomSpecies, RaceStage.GREATER, true);
            } else {
                availableRaces = Util.newHashMapOfValues(new Util.Value<AbstractSubspecies, Integer>(randomSpecies, 1));
                this.setBodyFromSubspeciesPreference(gender, availableRaces, true, true);
            }
            if (Math.random() < (double)((float)Main.getProperties().halfDemonSpawnRate / 100.0f) && !this.getRace().equals(Race.DEMON) && this.getSubspecies() != Subspecies.SLIME) {
                this.setBody(Main.game.getCharacterUtils().generateHalfDemonBody(this, gender, this.getBody().getFleshSubspecies(), true), true);
            }
            if (Math.random() < (double)((float)Main.getProperties().taurSpawnRate / 100.0f) && this.getLegConfiguration() != LegConfiguration.QUADRUPEDAL) {
                if (this.getSubspecies() == Subspecies.HALF_DEMON && this.getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                } else if (this.getRace().getRacialBody().getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL)) {
                    this.setLegType(this.getRace().getRacialBody().getLegType());
                    Main.game.getCharacterUtils().applyTaurConversion(this);
                }
            }
            this.setSexualOrientation(RacialBody.valueOfRace(this.getRace()).getSexualOrientation(gender));
            this.setName(Name.getRandomTriplet(this.getSubspecies()));
            this.setPlayerKnowsName(false);
            this.setDescription(UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u5c48\u57ce\u533a\u7684\u5c45\u6c11\uff0c\u5728\u4e0b\u6c34\u9053\u91cc\u5bfb\u627e\u53ef\u4ee5\u62a2\u52ab\u548c\u88ad\u51fb\u7684\u964c\u751f\u4eba\u2026\u2026", new ParserTag[0]));
            Main.game.getCharacterUtils().setHistoryAndPersonality(this, true);
            this.setOccupation(Occupation.NPC_MUGGER);
            if ((this.getSubspecies() == Subspecies.IMP || this.getSubspecies() == Subspecies.IMP_ALPHA) && !this.hasPersonalityTrait(PersonalityTrait.MUTE) && Math.random() < (double)0.9f) {
                this.addPersonalityTrait(PersonalityTrait.SLOVENLY);
            }
            Main.game.getCharacterUtils().addFetishes(this, new AbstractFetish[0]);
            if (this.getBodyMaterial() == BodyMaterial.SLIME && Main.game.getPlayer().getQuest(QuestLine.SIDE_SLIME_QUEEN) == Quest.SLIME_QUEEN_ONE) {
                this.addFetish(Fetish.FETISH_TRANSFORMATION_GIVING);
                this.setSexualOrientation(SexualOrientation.AMBIPHILIC);
            }
            Main.game.getCharacterUtils().randomiseBody(this, true);
            this.resetInventory(true);
            this.inventory.setMoney(10 + Util.random.nextInt(this.getLevel() * 10) + 1);
            Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
            this.equipClothing(EquipClothingSetting.getAllClothingSettings());
            Main.game.getCharacterUtils().applyMakeup(this, true);
            Main.game.getCharacterUtils().applyTattoos(this, true);
            if (this.hasFetish(Fetish.FETISH_CUM_ADDICT) && Math.random() < 0.1) {
                Main.game.getCharacterUtils().applyDirtiness(this);
            }
            this.initPerkTreeAndBackgroundPerks();
            this.setStartingCombatMoves();
            this.loadImages();
            this.initHealthAndManaToMax();
        }
        this.setEnslavementDialogue(SlaveDialogue.DEFAULT_ENSLAVEMENT_DIALOGUE, true);
    }

    @Override
    public void loadFromXML(Element parentElement, Document doc, CharacterImportSetting ... settings) {
        SubmissionAttacker.loadNPCVariablesFromXML(this, null, parentElement, doc, settings);
    }

    @Override
    public void setStartingBody(boolean setPersona) {
    }

    @Override
    public void equipClothing(List<EquipClothingSetting> settings) {
        this.incrementMoney((long)((float)this.getInventory().getNonEquippedValue() * 0.5f));
        this.clearNonEquippedInventory(false);
        Main.game.getCharacterUtils().generateItemsInInventory(this, true, true, true);
        Main.game.getCharacterUtils().equipClothingFromOutfitType(this, OutfitType.MUGGER, settings);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        if (this.isSlave() && this.isDoll()) {
            return super.getDescription();
        }
        if (this.getHistory() == Occupation.NPC_PROSTITUTE) {
            if (this.isSlave()) {
                return UtilText.parse((GameCharacter)this, "[npc.NamePos]\u5728\u5c48\u57ce\u533a\u96a7\u9053\u91cc\u5356\u6deb\u7684\u65e5\u5b50\u7ed3\u675f\u4e86\u3002[npc.sheIs]\u56e0\u89e6\u72af\u6cd5\u5f8b\u6210\u4e3a\u4e86\u5974\u96b6\uff0c\u4e0d\u8fc7\u662f[npc.her]\u4e3b\u4eba\u7684\u8d22\u4ea7\u800c\u5df2\u3002", new ParserTag[0]);
            }
            if (this.getLocationPlace().getPlaceType().equals(PlaceType.ANGELS_KISS_BEDROOM)) {
                return UtilText.parse((GameCharacter)this, "\u4f60\u6700\u521d\u5728\u5fa1\u5c48\u57ce\u533a\u7684\u96a7\u9053\u4e2d\u9047\u89c1\u4e86\u975e\u6cd5\u5356\u6deb\u7684[npc.name]\u3002\u4f60\u5f15\u8350[npc.herHim]\u53bb\u5929\u4f7f\u4e4b\u543b\u5de5\u4f5c\uff0c[npc.she]\u6b23\u7136\u63a5\u53d7\u3002", new ParserTag[0]);
            }
            return UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u5356\u6deb\u8005\uff0c\u5728\u5c48\u57ce\u533a\u7684\u4e0b\u6c34\u9053\u91cc\u51fa\u5356\u8eab\u4f53\u3002", new ParserTag[0]);
        }
        if (this.isSlave()) {
            return UtilText.parse((GameCharacter)this, "[npc.NamePos]\u5728\u5c48\u57ce\u533a\u96a7\u9053\u91cc\u9a9a\u6270\u548c\u52ab\u63a0\u65e0\u8f9c\u8def\u4eba\u7684\u65e5\u5b50\u7ed3\u675f\u4e86\u3002[npc.sheIs]\u56e0\u89e6\u72af\u6cd5\u5f8b\u6210\u4e3a\u4e86\u5974\u96b6\uff0c\u4e0d\u8fc7\u662f[npc.her]\u4e3b\u4eba\u7684\u8d22\u4ea7\u800c\u5df2\u3002", new ParserTag[0]);
        }
        if (Main.game.getPlayer().getFriendlyOccupants().contains(this.getId())) {
            return UtilText.parse((GameCharacter)this, "[npc.name]\u5728\u5c48\u57ce\u533a\u96a7\u9053\u6e38\u8361\u3001\u62a2\u52ab\u65e0\u8f9c\u8fc7\u8def\u4eba\u7684\u65e5\u5b50\u5df2\u7ecf\u7ed3\u675f\u3002\u4f60\u4e0e[npc.herHim]\u6210\u4e3a\u670b\u53cb\uff0c\u9080\u8bf7[npc.name]\u642c\u5230\u4f60\u5bb6\uff0c\u5e2e\u52a9[npc.herHim]\u5f00\u59cb\u65b0\u751f\u6d3b\u3002", new ParserTag[0]);
        }
        return UtilText.parse((GameCharacter)this, "[npc.Name]\u662f\u5c48\u57ce\u533a\u7684\u5c45\u6c11\uff0c\u5728\u4e0b\u6c34\u9053\u91cc\u5bfb\u627e\u53ef\u4ee5\u62a2\u52ab\u548c\u5f3a\u5978\u7684\u65e0\u8f9c\u8def\u4eba\u3002", new ParserTag[0]);
    }

    @Override
    public void endSex() {
        if (!this.isSlave()) {
            this.setPendingClothingDressing(true);
        }
    }

    @Override
    public boolean isClothingStealable() {
        return true;
    }

    @Override
    public boolean isAbleToBeImpregnated() {
        return true;
    }

    @Override
    public void changeFurryLevel() {
    }

    @Override
    public DialogueNode getEncounterDialogue() {
        if (this.getBodyMaterial() == BodyMaterial.SLIME) {
            if (this.getLastTimeEncountered() == -1L) {
                if (this.hasFetish(Fetish.FETISH_TRANSFORMATION_GIVING) && Main.game.getPlayer().getBodyMaterial() != BodyMaterial.SLIME) {
                    if (Main.game.getPlayer().getQuest(QuestLine.SIDE_SLIME_QUEEN) == Quest.SLIME_QUEEN_ONE) {
                        Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/submission/tunnelSlime", "ATTACK_TRANSFORMER_SLIME_QUEEN"));
                    } else {
                        Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/submission/tunnelSlime", "ATTACK_TRANSFORMER"));
                    }
                }
                if (Main.game.getPlayer().getQuest(QuestLine.SIDE_SLIME_QUEEN) == Quest.SLIME_QUEEN_ONE) {
                    Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_SLIME_QUEEN, Quest.SLIME_QUEEN_TWO));
                }
                return TunnelSlimeDialogue.ATTACK;
            }
            if (!this.isCharacterReactedToPregnancy(Main.game.getPlayer()) && this.isVisiblyPregnant()) {
                this.setCharacterReactedToPregnancy(Main.game.getPlayer(), true);
                return TunnelSlimeDialogue.ATTACK_PREGNANCY_REVEAL;
            }
            return TunnelSlimeDialogue.ATTACK_REPEAT;
        }
        return TunnelAttackDialogue.TUNNEL_ATTACK;
    }

    @Override
    public Response endCombat(boolean applyEffects, boolean victory) {
        if (victory) {
            if (this.getBodyMaterial() == BodyMaterial.SLIME) {
                return new Response("", "", TunnelSlimeDialogue.AFTER_COMBAT_PLAYER_VICTORY);
            }
            return new Response("", "", TunnelAttackDialogue.AFTER_COMBAT_VICTORY);
        }
        if (this.getBodyMaterial() == BodyMaterial.SLIME) {
            return new Response("", "", TunnelSlimeDialogue.AFTER_COMBAT_PLAYER_DEFEAT);
        }
        return new Response("", "", TunnelAttackDialogue.AFTER_COMBAT_DEFEAT);
    }
}

