/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.persona;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.effects.AbstractPerk;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.persona.OccupationTag;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Occupation {
    ELEMENTAL(Perk.ELEMENTAL_CORE_OCCUPATION, "\u5143\u7d20", "[npc.NameIsFull]\u7531\u7eaf\u7cb9\u7684\u5965\u672f\u80fd\u91cf\u6784\u6210\uff0c\u7ecf\u7531\u53ec\u5524\u8005\u7684\u7075\u6c14\u83b7\u5f97\u7269\u7406\u663e\u73b0\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_ENFORCER_PATROL_INSPECTOR(Perk.JOB_NPC_ENFORCER_PATROL_INSPECTOR, "\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u6267\u6cd5\u8005\u4e2d\u7684\u4e00\u5458\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_PATROL),
    NPC_ENFORCER_PATROL_SERGEANT(Perk.JOB_NPC_ENFORCER_PATROL_SERGEANT, "\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u6267\u6cd5\u8005\u4e2d\u7684\u4e00\u5458\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_PATROL),
    NPC_ENFORCER_PATROL_CONSTABLE(Perk.JOB_NPC_ENFORCER_PATROL_CONSTABLE, "\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u6267\u6cd5\u8005\u4e2d\u7684\u4e00\u5458\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_PATROL),
    NPC_ENFORCER_SWORD_SUPER(Perk.JOB_NPC_ENFORCER_SWORD_SUPER, "SWORD\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u4e00\u540d\u6267\u6cd5\u8005\uff0cSWORD\u6210\u5458\u4e4b\u4e00\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_SWORD),
    NPC_ENFORCER_SWORD_CHIEF_INSPECTOR(Perk.JOB_NPC_ENFORCER_SWORD_CHIEF_INSPECTOR, "SWORD\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u4e00\u540d\u6267\u6cd5\u8005\uff0cSWORD\u6210\u5458\u4e4b\u4e00\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_SWORD),
    NPC_ENFORCER_SWORD_INSPECTOR(Perk.JOB_NPC_ENFORCER_SWORD_INSPECTOR, "SWORD\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u4e00\u540d\u6267\u6cd5\u8005\uff0cSWORD\u6210\u5458\u4e4b\u4e00\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_SWORD),
    NPC_ENFORCER_SWORD_SERGEANT(Perk.JOB_NPC_ENFORCER_SWORD_SERGEANT, "SWORD\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u4e00\u540d\u6267\u6cd5\u8005\uff0cSWORD\u6210\u5458\u4e4b\u4e00\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_SWORD),
    NPC_ENFORCER_SWORD_CONSTABLE(Perk.JOB_NPC_ENFORCER_SWORD_CONSTABLE, "SWORD\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u4e00\u540d\u6267\u6cd5\u8005\uff0cSWORD\u6210\u5458\u4e4b\u4e00\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_SWORD),
    NPC_ENFORCER_ORICL_INSPECTOR(Perk.JOB_NPC_ENFORCER_ORICL_INSPECTOR, "ORICL\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u4e00\u540d\u6267\u6cd5\u8005\uff0cORICL\u6210\u5458\u4e4b\u4e00\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_ORICL),
    NPC_ENFORCER_ORICL_SERGEANT(Perk.JOB_NPC_ENFORCER_ORICL_SERGEANT, "ORICLORICL\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u4e00\u540d\u6267\u6cd5\u8005\uff0cORICL\u6210\u5458\u4e4b\u4e00\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_ORICL),
    NPC_ENFORCER_ORICL_CONSTABLE(Perk.JOB_NPC_ENFORCER_ORICL_CONSTABLE, "ORICLORICL\u6267\u6cd5\u8005", "[npc.NameIs]\u662f\u4e00\u540d\u6267\u6cd5\u8005\uff0cORICL\u6210\u5458\u4e4b\u4e00\u3002", OccupationTag.HAS_PREREQUISITES, OccupationTag.ENFORCER_ORICL),
    NPC_HARPY_MATRIARCH(Perk.JOB_NPC_HARPY_MATRIARCH, "\u54c8\u6bd4\u65cf\u957f", "[npc.NameIsFull]\u662f\u54c8\u6bd4\u90e8\u65cf\u7684\u65cf\u957f\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_HARPY_FLOCK_MEMBER(Perk.JOB_NPC_HARPY_FLOCK_MEMBER, "\u54c8\u6bd4\u90e8\u65cf\u6210\u5458", "[npc.NameIsFull]\u662f\u54c8\u6bd4\u90e8\u65cf\u7684\u4e00\u5458\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_CULTIST(Perk.JOB_NPC_CULTIST, "\u72c2\u4fe1\u8005", "[npc.NameIs]\u662f\u201c\u8389\u8389\u4e1d\u5f02\u6559\u201d\u7684\u5168\u804c\u6210\u5458\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_SLAVER_ADMIN(Perk.JOB_NPC_SLAVER_ADMIN, "\u5974\u96b6\u7ba1\u7406\u5c40\u76d1\u7763\u5458", "[npc.NameIsFull]\u662f\u5974\u96b6\u7ba1\u7406\u5c40\u7684\u4e00\u540d\u76d1\u7763\u5458\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_NIGHTCLUB_OWNER(Perk.JOB_NPC_NIGHTCLUB_OWNER, "\u591c\u5e97\u8001\u677f", "[npc.Name]\u62e5\u6709\u5e76\u7ba1\u7406\u4e00\u5bb6\u53d7\u6b22\u8fce\u7684\u591c\u5e97\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_BAR_TENDER(Perk.JOB_NPC_BARMAID, "\u9152\u4fdd", "[npc.Name]\u7684\u5de5\u4f5c\u662f\u9152\u4fdd\u3002", OccupationTag.EVENING_SHIFT),
    NPC_BOUNCER(Perk.JOB_NPC_BOUNCER, "\u4fdd\u5b89", "[npc.NameIsFull]\u662f\u4e00\u540d\u4fdd\u5b89\uff0c\u5de5\u4f5c\u5185\u5bb9\u662f\u8ba9\u6d41\u6c13\u4eec\u8fdc\u79bb\u591c\u5e97\u548c\u9152\u5427\u3002", new OccupationTag[0]),
    NPC_BEAUTICIAN(Perk.JOB_NPC_BEAUTICIAN, "\u7f8e\u5bb9\u5e08", "[npc.Name]\u7684\u5de5\u4f5c\u662f\u7f8e\u5bb9\u5e08\u3002", new OccupationTag[0]),
    NPC_ARCANE_RESEARCHER(Perk.JOB_NPC_ARCANE_RESEARCHER, "\u5965\u672f\u7814\u7a76\u8005", "[npc.Name]\u5c06[npc.her]\u6240\u6709\u7684\u65f6\u95f4\u82b1\u5728\u7814\u7a76\u5965\u672f\u4e0a\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_CLOTHING_STORE_OWNER(Perk.JOB_NPC_SHOP_MANAGER, "\u670d\u88c5\u5e97\u8001\u677f", "[npc.NameIs]\u62e5\u6709\u4e00\u5bb6\u670d\u88c5\u5e97\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_GYM_OWNER(Perk.JOB_NPC_SHOP_MANAGER, "\u5065\u8eab\u623f\u8001\u677f", "[npc.NameIs]\u62e5\u6709\u4e00\u5bb6\u5065\u8eab\u623f\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_STORE_OWNER(Perk.JOB_NPC_SHOP_MANAGER, "\u5546\u5e97\u8001\u677f", "[npc.NameIs]\u62e5\u6709\u4e00\u5bb6\u5546\u5e97\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_CASINO_OWNER(Perk.JOB_NPC_SHOP_MANAGER, "\u8d4c\u573a\u8001\u677f", "[npc.NameIs]\u62e5\u6709\u4e00\u5bb6\u8d4c\u573a\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_BUSINESS_OWNER(Perk.JOB_NPC_SHOP_MANAGER, "\u516c\u53f8\u8001\u677f", "[npc.NameIs]\u7ecf\u8425\u81ea\u5df1\u7684\u4e8b\u4e1a\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_TAVERN_OWNER(Perk.JOB_NPC_SHOP_MANAGER, "\u65c5\u5e97\u8001\u677f", "[npc.NameIs]\u62e5\u6709\u4e00\u5bb6\u65c5\u5e97\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_FARMER(Perk.JOB_NPC_FARMER, "\u519c\u6c11", "[npc.NameIs]\u662f\u4e00\u540d\u519c\u6c11\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_JOURNALIST(Perk.JOB_NPC_JOURNALIST, "\u65b0\u95fb\u8bb0\u8005", "[npc.NameIs]\u662f\u4e00\u4f4d\u65b0\u95fb\u8bb0\u8005\u3002", OccupationTag.HAS_PREREQUISITES),
    REINDEER_OVERSEER(Perk.JOB_NPC_REINDEER_OVERSEER, "\u76d1\u5de5", "[npc.NameIs]\u662f\u9a6f\u9e7f\u5de5\u56e2\u7684\u76d1\u5de5\uff0c\u8be5\u5de5\u56e2\u4f1a\u5728\u51ac\u5b63\u8fc1\u5f99\u5230\u5fa1\u57ce\u533a\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_SLIME_QUEEN(Perk.JOB_NPC_SLIME_QUEEN, "\u53f2\u83b1\u59c6\u5973\u738b", "[npc.NameHas]\u79f0\u547c\u81ea\u5df1\u4e3a\u201c\u53f2\u83b1\u59c6\u5973\u738b\u201d\uff0c\u5e76\u4e14\u5bf9\u5c06\u5927\u91cf\u5c48\u57ce\u533a\u5e02\u6c11\u8f6c\u5316\u6210\u53f2\u83b1\u59c6\u8d1f\u8d23\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_SLIME_QUEEN_GUARD(Perk.JOB_NPC_SLIME_QUEEN_GUARD, "\u53f2\u83b1\u59c6\u5973\u738b\u7684\u62a4\u536b", "[npc.NameIs]\u662f\u4fdd\u62a4[slimeQueen.namePos]\u4e4b\u5854\u7684\u4e09\u53ea\u53f2\u83b1\u59c6\u4e4b\u4e00\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_EPONA(Perk.JOB_EPONA, "\u6000\u5b55\u8f6e\u76d8\u8d4c\u7ecf\u7406", "[npc.NameIs]\u5728\u5c48\u57ce\u533a\u7684\u8d4c\u573a\u5185\u7ba1\u7406\u201c\u6000\u5b55\u8f6e\u76d8\u8d4c\u201d\u9879\u76ee\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_GANG_LEADER(Perk.JOB_GANG_LEADER, "\u5e2e\u6d3e\u5934\u76ee", "[npc.NameIsFull]\u662f\u81ed\u540d\u662d\u8457\u7684\u72af\u7f6a\u5e2e\u6d3e\u5934\u76ee\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_GANG_BODY_GUARD(Perk.JOB_GANG_BODY_GUARD, "\u5e2e\u6d3e\u4fdd\u9556", "[npc.NameIsFull]\u662f\u5979\u7684\u5e2e\u6d3e\u5934\u76ee\u7684\u79c1\u4eba\u4fdd\u9556\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_GANG_MEMBER(Perk.JOB_GANG_MEMBER, "\u5e2e\u6d3e\u6210\u5458", "[npc.NameIsFull]\u662f\u81ed\u540d\u662d\u8457\u7684\u72af\u7f6a\u5e2e\u6d3e\u7684\u4e00\u5458\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_STABLE_MISTRESS(Perk.JOB_NPC_STABLE_MISTRESS, "\u9a6c\u573a\u4e3b\u4eba", "[npc.NameIsFull]\u8d1f\u8d23\u8bad\u7ec3\u548c\u7167\u987e\u5927\u91cf\u534a\u4eba\u9a6c\u5974\u96b6\u3002", new OccupationTag[]{OccupationTag.HAS_PREREQUISITES}){

        @Override
        public String getName(GameCharacter character) {
            if (character == null) {
                return "\u9a6c\u573a\u7ecf\u7406";
            }
            if (character.isFeminine()) {
                return "\u9a6c\u573a\u4e3b";
            }
            return "\u9a6c\u573a\u7537\u4e3b\u4eba";
        }
    }
    ,
    NPC_LYSSIETH_GUARD(Perk.JOB_LYSSIETH_GUARD, "\u8389\u897f\u4e1d\u7684\u62a4\u536b", "[npc.NameIsFull]\u662f\u8389\u897f\u4e1d\u4e0d\u88ab\u627f\u8ba4\u7684\u5973\u513f\u5176\u4e2d\u4e00\u5458\uff0c\u88ab\u6307\u6d3e\u4e0e\u4fdd\u62a4\u5979\u6bcd\u4eb2\u7684\u4f4f\u6240\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_ELDER_LILIN(Perk.JOB_ELDER_LILIN, "\u8389\u7433\u957f\u8001", "[npc.NameIsFull]\u662f\u4e03\u4f4d\u8389\u7433\u957f\u8001\u4e4b\u4e00\uff0c\u88ab\u8389\u8389\u4e1d\u627f\u8ba4\u7684\u5973\u513f\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_TAUR_TRANSPORT(Perk.JOB_TAUR_TRANSPORT, "\u534a\u517d\u8eab\u4eba\u8fd0\u8f93\u8005", "[npc.Name]\u4f7f\u7528[npc.her]\u517d\u5316\u8eab\u4f53\u7684\u5de8\u5927\u6f5c\u529b\u62c9\u8f66\u548c\u8fd0\u9001\u5546\u54c1\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_ELIS_MAYOR(Perk.JOB_NPC_MAYOR, "\u4f0a\u5229\u65af\u9547\u957f", "[npc.NameIs]\u662f\u4f0a\u5229\u65af\u7684\u9547\u957f\uff0c\u8d1f\u8d23\u57ce\u9547\u5185\u90e8\u4e0e\u5f17\u6d1b\u4f0a\u7530\u91ce\u5468\u8fb9\u7684\u5e78\u798f\u4e0e\u5b89\u5b81\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_ASSISTANT(Perk.JOB_NPC_ASSISTANT, "\u4e2a\u4eba\u52a9\u7406", "[npc.NameIs]\u662f\u4e00\u540d\u534f\u52a9[npc.her]\u7684\u8001\u677f\u5b8c\u6210\u5404\u7c7b\u65e5\u7a0b\u7684\u52a9\u7406\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_LUNETTE_HERD(Perk.JOB_LUNETTE_HERD, "\u9732\u5185\u7279\u7684\u5973\u513f", "[npc.NameIsFull]\u9732\u5185\u7279\u7684\u5973\u513f\u4e4b\u4e00\uff0c\u7ee7\u627f\u4e86[npc.her]\u6bcd\u4eb2\u5bf9\u9a9a\u4e71\u4e0e\u6d69\u52ab\u7684\u949f\u7231\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_MUSHROOM_FORAGER(Perk.JOB_NPC_MUSHROOM_FORAGER, "\u8611\u83c7\u5bfb\u89c5\u8005", "[npc.Name]\u5728\u5c48\u57ce\u533a\u7684\u8759\u8760\u6d1e\u7a74\u5185\u5bfb\u89c5\u5e76\u8d29\u5356\u81f4\u5e7b\u8611\u83c7\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_LUNETTE_RECOGNISED_DAUGHTER(Perk.JOB_LUNETTE_RECOGNISED_DAUGHTER, "\u9732\u5185\u7279\u88ab\u627f\u8ba4\u7684\u5973\u513f", "[npc.NameIsFull]\u662f\u88ab\u9732\u5185\u7279\u627f\u8ba4\u7684\u5973\u513f\uff0c\u56e0\u6b64\u5979\u4e0e\u5bfb\u5e38\u6076\u9b54\u76f8\u6bd4\u6781\u4e3a\u5f3a\u5927\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_AMAZONIAN_QUEEN(Perk.JOB_AMAZONIAN_QUEEN, "\u4e9a\u9a6c\u900a\u5973\u738b", "[npc.NameIsFull]\u662f\u4e9a\u9a6c\u900a\u4e00\u65cf\u7684\u5973\u738b\uff0c\u56e0\u6b64\u5979\u5177\u6709\u76f8\u5f53\u5f3a\u5927\u7684\u529b\u91cf\u4e0e\u6218\u6597\u80fd\u529b\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_AMAZONIAN(Perk.JOB_AMAZONIAN, "\u4e9a\u9a6c\u900a\u4eba", "[npc.NameIsFull]\u4e00\u4f4d\u4e9a\u9a6c\u900a\u4eba\uff0c\u5728\u6218\u6597\u8bad\u7ec3\u4e2d\u6295\u5165\u4e86\u5f88\u591a\u65f6\u95f4\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_PUGILIST(Perk.JOB_PUGILIST, "\u62f3\u51fb\u8fd0\u52a8\u5458", "[npc.NameIsFull]\u662f\u4e00\u4f4d\u804c\u4e1a\u62f3\u51fb\u624b\uff0c\u5728\u6218\u6597\u4e2d\u5c06\u662f\u4e00\u4f4d\u53ef\u6015\u7684\u5bf9\u624b\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_LILIN_PAWN(Perk.JOB_ELDER_LILIN_PAWN, "\u8389\u7433\u957f\u8001\u7684\u52a9\u624b", "[[npc.NameIsFull]\u4ee3\u8868\u8389\u7433\u643a\u5e26\u547d\u4ee4\u800c\u6765\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_SEX_DOLL(Perk.JOB_SEX_DOLL, "\u6027\u7231\u73a9\u5076", "[npc.NameIsFull]\u662f\u4e2a\u5916\u8868\u5341\u5206\u771f\u5b9e\u7684\u6027\u7231\u73a9\u5076\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_UNEMPLOYED(Perk.JOB_UNEMPLOYED, "\u65e0\u4e1a\u6e38\u6c11", "[npc.NameIsFull]\u6ca1\u6709\u5de5\u4f5c\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_SLAVE(Perk.JOB_SLAVE, "\u5974\u96b6", "[npc.NameIsFull]\u662f\u4e00\u540d\u5974\u96b6\uff0c\u5fc5\u987b\u627f\u8f7d\u7740[npc.her]\u4e3b\u4eba\u7684\u610f\u5fd7\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_CAPTIVE(Perk.JOB_CAPTIVE, "\u4fd8\u864f", "[npc.NameHasFull]\u88ab\u4eba\u7ed1\u67b6\uff0c\u5e76\u88ab\u975e\u6cd5\u76d1\u7981\u7740\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_REBEL_FIGHTER(Perk.JOB_NPC_REBEL_FIGHTER, "\u53cd\u6297\u519b\u6597\u58eb", "[npc.NameIsFull]\u662f\u4e00\u540d\u6548\u529b\u4e8e\u53cd\u6297\u519b\u7684\u6218\u58eb\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_PROSTITUTE(Perk.JOB_PROSTITUTE, "\u5a3c\u5993", "[npc.NameIsFull]\u662f\u4e00\u540d\u5a3c\u5993\uff0c\u9760\u51fa\u5356[npc.her]\u7684\u8089\u4f53\u8d5a\u94b1\u3002", OccupationTag.LOWLIFE),
    NPC_STRIPPER(Perk.JOB_MISC, "\u8131\u8863\u821e\u5a18", "[npc.Name]\u662f\u4e00\u540d\u8131\u8863\u821e\u5a18\u3002", new OccupationTag[]{OccupationTag.EVENING_SHIFT}){

        @Override
        public DayOfWeek getStartDay() {
            return DayOfWeek.TUESDAY;
        }

        @Override
        public DayOfWeek getEndDay() {
            return DayOfWeek.SATURDAY;
        }
    }
    ,
    NPC_MASSAGE_THERAPIST(Perk.JOB_MISC, "\u6309\u6469\u7406\u7597\u5e08", "[npc.Name]\u5728\u4e00\u5bb6\u6c34\u7597\u4e2d\u5fc3\u91cc\u5f53\u6309\u6469\u7406\u7597\u5e08\u3002", new OccupationTag[0]),
    NPC_WAITRESS(Perk.JOB_MISC, "\u5973\u670d\u52a1\u5458", "[npc.Name]\u5728\u4e00\u5bb6\u996d\u5e97\u91cc\u5f53\u5973\u670d\u52a1\u5458\u3002", new OccupationTag[0]){

        @Override
        public boolean isAvailable(GameCharacter character) {
            return character.isFeminine();
        }
    }
    ,
    NPC_MUSICIAN(Perk.JOB_MISC, "\u97f3\u4e50\u5bb6", "[npc.Name]\u662f\u4e00\u540d\u97f3\u4e50\u5bb6\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_FITNESS_INSTRUCTOR(Perk.JOB_MISC, "\u5065\u8eab\u6559\u7ec3", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_MUGGER(Perk.JOB_MUGGER, "\u62a2\u52ab\u72af", "[npc.NameIsFull]\u662f\u4e00\u540d\u62a2\u52ab\u72af\uff0c\u9760\u5077\u5176\u4ed6\u4eba\u7684\u8d22\u7269\u4e3a\u751f\u3002", OccupationTag.LOWLIFE),
    NPC_BOUNTY_HUNTER(Perk.JOB_BOUNTY_HUNTER, "\u8d4f\u91d1\u730e\u4eba", "[npc.NameIsFull]\u662f\u4e00\u540d\u8d4f\u91d1\u730e\u4eba\uff0c\u9760\u8ffd\u8e2a\u5e76\u6293\u6355\u901a\u7f09\u72af\u83b7\u5f97\u5de5\u8d44\u3002", OccupationTag.HAS_PREREQUISITES),
    NPC_CONSTRUCTION_WORKER(Perk.JOB_CONSTRUCTION_WORKER, "\u5efa\u7b51\u5de5\u4eba", "-", new OccupationTag[0]),
    NPC_CONSTRUCTION_WORKER_ARCANE(Perk.JOB_CONSTRUCTION_WORKER_ARCANE, "\u5965\u672f\u5efa\u7b51\u5de5\u4eba", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_MECHANIC(Perk.JOB_MISC, "\u673a\u68b0\u5e08", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_TEACHER(Perk.JOB_MISC, "\u6559\u5e08", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_LIBRARIAN(Perk.JOB_MISC, "\u56fe\u4e66\u7ba1\u7406\u5458", "-", new OccupationTag[0]),
    NPC_UNIVERSITY_STUDENT(Perk.JOB_MISC, "\u5927\u5b66\u751f", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_WRITER(Perk.JOB_MISC, "\u4f5c\u5bb6", "-", new OccupationTag[0]),
    NPC_ENGINEER(Perk.JOB_MISC, "\u5de5\u7a0b\u5e08", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_ARCHITECT(Perk.JOB_MISC, "\u5efa\u7b51\u5e08", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_DOCTOR(Perk.JOB_MISC, "\u533b\u751f", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_MAID(Perk.JOB_MISC, "\u5973\u4ec6", "-", new OccupationTag[0]){

        @Override
        public boolean isAvailable(GameCharacter character) {
            return character.isFeminine();
        }

        @Override
        public DayOfWeek getStartDay() {
            return DayOfWeek.MONDAY;
        }

        @Override
        public DayOfWeek getEndDay() {
            return DayOfWeek.SATURDAY;
        }
    }
    ,
    NPC_BUTLER(Perk.JOB_MISC, "\u7ba1\u5bb6", "-", new OccupationTag[0]){

        @Override
        public boolean isAvailable(GameCharacter character) {
            return !character.isFeminine();
        }

        @Override
        public DayOfWeek getStartDay() {
            return DayOfWeek.MONDAY;
        }

        @Override
        public DayOfWeek getEndDay() {
            return DayOfWeek.SATURDAY;
        }
    }
    ,
    NPC_OFFICE_WORKER(Perk.JOB_NPC_OFFICE_WORKER, "\u529e\u516c\u5ba4\u804c\u5458", "[npc.Name]\u4e3a\u5927\u516c\u53f8\u5de5\u4f5c\uff0c\u6bcf\u5929\u90fd\u5728\u4e0e[npc.her]\u7684\u4e0b\u5c5e\u3001\u516c\u53f8\u8d22\u653f\u4ee5\u53ca\u96be\u641e\u7684\u5ba2\u6237\u6253\u4ea4\u9053\u3002", new OccupationTag[0]){

        @Override
        public String getName(GameCharacter character) {
            if (character == null) {
                return "\u529e\u516c\u5ba4\u804c\u5458";
            }
            if (character.isFeminine()) {
                return "\u5973\u4f01\u4e1a\u5bb6";
            }
            return "\u7537\u4f01\u4e1a\u5bb6";
        }
    }
    ,
    NPC_RECEPTIONIST(Perk.JOB_MISC, "\u63a5\u5f85\u5458", "[npc.Name]\u662f\u4e00\u540d\u63a5\u5f85\u5458\uff0c\u6bcf\u5929\u8981\u4e0e\u8bb8\u591a\u8bbf\u5ba2\u548c\u987e\u5ba2\u6253\u4ea4\u9053\u3002", new OccupationTag[0]),
    NPC_SHOP_ASSISTANT(Perk.JOB_MISC, "\u5546\u5e97\u5e97\u5458", "-", new OccupationTag[0]),
    NPC_ARTIST(Perk.JOB_MISC, "\u827a\u672f\u5bb6", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_NURSE(Perk.JOB_MISC, "\u62a4\u58eb", "-", new OccupationTag[0]){

        @Override
        public boolean isAvailable(GameCharacter character) {
            return character.isFeminine();
        }

        @Override
        public DayOfWeek getStartDay() {
            return DayOfWeek.MONDAY;
        }

        @Override
        public DayOfWeek getEndDay() {
            return DayOfWeek.SATURDAY;
        }
    }
    ,
    NPC_CHEF(Perk.JOB_MISC, "\u53a8\u5e08", "-", new OccupationTag[0]),
    NPC_ATHLETE(Perk.JOB_MISC, "\u8fd0\u52a8\u5458", "-", OccupationTag.HAS_PREREQUISITES),
    NPC_MODEL(Perk.JOB_MISC, "\u6a21\u7279", "-", new OccupationTag[0]),
    NPC_TRADER(Perk.JOB_NPC_SHOP_MANAGER, "\u5546\u4eba", "[npc.Name]\u662f\u4e00\u540d\u5546\u4eba\uff0c\u4ee5\u4e70\u5356\u5404\u79cd\u8d27\u7269\u4e3a\u751f\u3002", OccupationTag.HAS_PREREQUISITES),
    UNEMPLOYED(Perk.JOB_UNEMPLOYED, "\u65e0\u4e1a\u6e38\u6c11", "\u4f60\u5df2\u7ecf\u5931\u4e1a\u6709\u6bb5\u65f6\u95f4\u4e86\u3002", OccupationTag.PLAYER_ONLY),
    OFFICE_WORKER(Perk.JOB_OFFICE_WORKER, "\u529e\u516c\u5ba4\u804c\u5458", "\u4f60\u5728\u5f53\u5730\u7684\u4e00\u680b\u529e\u516c\u697c\u4e0a\u73ed\uff0c\u5904\u7406\u6587\u4e66\u5de5\u4f5c\u3001\u5e94\u7b54\u7535\u8bdd\u4e0e\u90ae\u4ef6\uff0c\u4ec0\u4e48\u4e8b\u90fd\u8981\u5e72\u4e00\u70b9\u3002", OccupationTag.PLAYER_ONLY),
    STUDENT(Perk.JOB_STUDENT, "\u5b66\u751f", "\u4f60\u662f\u5e02\u5185\u7684\u4e00\u6240\u5927\u5b66\u7684\u5b66\u751f\uff0c\u4f46\u662f\u4f60\u8fd8\u6ca1\u51b3\u5b9a\u597d\u4e13\u4e1a\u65b9\u5411\u3002", OccupationTag.PLAYER_ONLY),
    MUSICIAN(Perk.JOB_MUSICIAN, "\u97f3\u4e50\u5bb6", "\u4f60\u662f\u4e00\u540d\u97f3\u4e50\u5bb6\uff0c\u4e5f\u80fd\u5f39\u594f\u8bb8\u591a\u79cd\u7c7b\u7684\u4e50\u5668\uff0c\u4f60\u4e5f\u662f\u4e00\u540d\u597d\u6b4c\u624b\u3002", OccupationTag.PLAYER_ONLY),
    TEACHER(Perk.JOB_TEACHER, "\u6559\u5e08", "\u4f60\u662f\u4e00\u540d\u6559\u5e08\uff0c\u5728\u5f53\u5730\u7684\u5b66\u6821\u6559\u4e86\u51e0\u5e74\u4e66\u3002", OccupationTag.PLAYER_ONLY),
    WRITER(Perk.JOB_WRITER, "\u4f5c\u5bb6", "\u4f60\u662f\u4e00\u540d\u4f5c\u5bb6\uff0c\u8fd1\u51e0\u4e2a\u6708\u4e00\u76f4\u5728\u5199\u4f60\u7684\u65b0\u5c0f\u8bf4\u3002", OccupationTag.PLAYER_ONLY),
    CHEF(Perk.JOB_CHEF, "\u53a8\u5e08\u957f", "\u4f60\u662f\u5f53\u5730\u4e00\u5bb6\u996d\u5e97\u7684\u53a8\u5e08\u957f\u3002", OccupationTag.PLAYER_ONLY),
    CONSTRUCTION_WORKER(Perk.JOB_PLAYER_CONSTRUCTION_WORKER, "\u5efa\u7b51\u5de5\u4eba", "\u4f60\u662f\u7ecf\u9a8c\u6df1\u539a\u4e14\u6280\u672f\u719f\u7ec3\u7684\u5efa\u7b51\u5de5\u4eba\u3002", OccupationTag.PLAYER_ONLY),
    SOLDIER(Perk.JOB_SOLDIER, "\u58eb\u5175", "\u4f60\u662f\u4e00\u540d\u58eb\u5175\uff0c\u76ee\u524d\u6b63\u5145\u5206\u4eab\u53d7\u4f60\u7684\u5047\u671f\u3002", OccupationTag.PLAYER_ONLY),
    ATHLETE(Perk.JOB_ATHLETE, "\u8fd0\u52a8\u5458", "\u4f60\u662f\u4e00\u540d\u8fd0\u52a8\u5458\uff0c\u6b63\u4e3a\u4e0b\u6b21\u8d5b\u4e8b\u800c\u8bad\u7ec3\u3002", OccupationTag.PLAYER_ONLY),
    ARISTOCRAT(Perk.JOB_ARISTOCRAT, "\u8d35\u65cf", "\u4f60\u51fa\u8eab\u4e8e\u949f\u9e23\u9f0e\u98df\u7684\u4e16\u5bb6\u5927\u65cf\uff0c\u4ece\u51fa\u751f\u5230\u73b0\u5728\u4e5f\u6ca1\u5de5\u4f5c\u8fc7\u4e00\u5929\u3002", OccupationTag.PLAYER_ONLY),
    MAID(Perk.JOB_MAID, "\u5973\u4ec6", "\u4f60\u662f\u4e00\u540d\u5973\u4ec6\uff0c\u88ab\u5bcc\u6709\u7684\u5bb6\u5ead\u96c7\u4f63\u6765\u4fdd\u6301\u4ed6\u4eec\u8c6a\u5b85\u7684\u6574\u6d01\u3002", new OccupationTag[]{OccupationTag.PLAYER_ONLY}){

        @Override
        public boolean isAvailable(GameCharacter character) {
            return character.isFeminine();
        }
    }
    ,
    BUTLER(Perk.JOB_BUTLER, "\u7ba1\u5bb6", "\u4f60\u662f\u4e00\u540d\u7ba1\u5bb6\uff0c\u88ab\u5bcc\u6709\u7684\u5bb6\u5ead\u96c7\u4f63\u6765\u76d1\u7763\u5973\u4ec6\u548c\u5e94\u5bf9\u8bbf\u5ba2\u3002", new OccupationTag[]{OccupationTag.PLAYER_ONLY}){

        @Override
        public boolean isAvailable(GameCharacter character) {
            return !character.isFeminine();
        }
    }
    ,
    TOURIST(Perk.JOB_TOURIST, "\u7f8e\u56fd\u6e38\u5ba2", "\u4eca\u5e74\u7684\u5047\u671f\u91cc\u4f60\u51c6\u5907\u53bb\u82f1\u56fd\u73a9\u73a9\u3002", new OccupationTag[]{OccupationTag.PLAYER_ONLY}){

        @Override
        public boolean isAvailable(GameCharacter character) {
            return Main.game.isSillyModeEnabled();
        }
    };

    private static List<Occupation> historiesList;
    protected static boolean[] noWorkHours;
    protected static boolean[] daylightWorkHours;
    protected static boolean[] eveningWorkHours;
    protected static boolean[] nightWorkHours;
    private String name;
    private String description;
    private AbstractPerk associatedPerk;
    private List<OccupationTag> occupationTags;

    public static List<Occupation> getAvailableHistories(GameCharacter character) {
        historiesList = new ArrayList<Occupation>();
        for (Occupation history : Occupation.values()) {
            if (!history.isAvailable(character) || !(character.isPlayer() ? history.isAvailableToPlayer() : !history.isAvailableToPlayer())) continue;
            historiesList.add(history);
        }
        return historiesList;
    }

    private Occupation(AbstractPerk associatedPerk, String name, String description, OccupationTag ... occupationTags) {
        this.associatedPerk = associatedPerk;
        this.name = name;
        this.description = description;
        this.occupationTags = new ArrayList<OccupationTag>();
        for (OccupationTag tag : occupationTags) {
            this.occupationTags.add(tag);
        }
    }

    public boolean isAvailable(GameCharacter character) {
        return !this.occupationTags.contains((Object)OccupationTag.HAS_PREREQUISITES);
    }

    public void applyExtraEffects(GameCharacter character) {
    }

    public void revertExtraEffects(GameCharacter character) {
    }

    public boolean isAvailableToPlayer() {
        return this.occupationTags.contains((Object)OccupationTag.PLAYER_ONLY);
    }

    public AbstractPerk getAssociatedPerk() {
        return this.associatedPerk;
    }

    public String getName(GameCharacter character) {
        return this.name;
    }

    public String getDescription(GameCharacter character) {
        return UtilText.parse(character, this.description, new ParserTag[0]);
    }

    public boolean isLowlife() {
        return this.occupationTags.contains((Object)OccupationTag.LOWLIFE);
    }

    public List<OccupationTag> getOccupationTags() {
        return this.occupationTags;
    }

    public boolean isAtWork(int hour) {
        return Main.game.getDateNow().getDayOfWeek().getValue() >= this.getStartDay().getValue() && Main.game.getDateNow().getDayOfWeek().getValue() <= this.getEndDay().getValue() && this.getWorkHours()[hour];
    }

    public boolean[] getWorkHours() {
        if (this.getOccupationTags().contains((Object)OccupationTag.LOWLIFE) || this == NPC_UNEMPLOYED || this == UNEMPLOYED) {
            return noWorkHours;
        }
        if (this.getOccupationTags().contains((Object)OccupationTag.EVENING_SHIFT)) {
            return eveningWorkHours;
        }
        if (this.getOccupationTags().contains((Object)OccupationTag.NIGHT_SHIFT)) {
            return nightWorkHours;
        }
        return daylightWorkHours;
    }

    public int getWorkHourStart() {
        for (int i = 0; i < 24; ++i) {
            int hour = (6 + i) % 24;
            if (!this.getWorkHours()[hour]) continue;
            return 6 + i;
        }
        return 0;
    }

    public int getWorkHourEnd() {
        return (this.getWorkHourStart() + 8) % 24;
    }

    public DayOfWeek getStartDay() {
        return DayOfWeek.MONDAY;
    }

    public DayOfWeek getEndDay() {
        return DayOfWeek.FRIDAY;
    }

    static {
        noWorkHours = new boolean[24];
        daylightWorkHours = new boolean[24];
        eveningWorkHours = new boolean[24];
        nightWorkHours = new boolean[24];
        for (int i = 0; i < 8; ++i) {
            Occupation.daylightWorkHours[9 + i] = true;
            int hour = (18 + i) % 24;
            Occupation.eveningWorkHours[hour] = true;
            hour = (21 + i) % 24;
            Occupation.nightWorkHours[hour] = true;
        }
    }
}

