/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.pregnancy;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.misc.GenericFemaleNPC;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PregnancyPossibility
implements XMLSaving {
    private String motherId;
    private String fatherId;
    private float probability;

    public PregnancyPossibility(String motherId, String fatherId, float probability) {
        this.motherId = motherId;
        this.fatherId = fatherId;
        this.probability = probability;
    }

    public boolean equals(Object o) {
        return o instanceof PregnancyPossibility && ((PregnancyPossibility)o).getMotherId().equals(this.motherId) && ((PregnancyPossibility)o).getFatherId().equals(this.fatherId) && ((PregnancyPossibility)o).getProbability() == this.probability;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.motherId.hashCode();
        result = 31 * result + this.fatherId.hashCode();
        result = 31 * result + (int)this.probability;
        return result;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("pregnancyPossibility");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "motherId", this.getMotherId());
        XMLUtil.addAttribute(doc, element, "fatherId", this.getFatherId());
        XMLUtil.addAttribute(doc, element, "probability", String.valueOf(this.getProbability()));
        return element;
    }

    public static PregnancyPossibility loadFromXML(Element parentElement, Document doc) {
        return new PregnancyPossibility(parentElement.getAttribute("motherId"), parentElement.getAttribute("fatherId"), Float.valueOf(parentElement.getAttribute("probability")).floatValue());
    }

    public String getMotherId() {
        return this.motherId;
    }

    public String getFatherId() {
        return this.fatherId;
    }

    public GameCharacter getMother() {
        try {
            return Main.game.getNPCById(this.motherId);
        }
        catch (Exception e) {
            if (!this.motherId.equals("NOT_SET")) {
                Util.logGetNpcByIdError("PregnancyPossibility.getMother()", this.motherId);
            }
            return Main.game.getNpc(GenericFemaleNPC.class);
        }
    }

    public GameCharacter getFather() {
        try {
            return Main.game.getNPCById(this.fatherId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public float getProbability() {
        return this.probability;
    }

    public void setProbability(float probability) {
        this.probability = probability;
    }
}

