/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.race;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.valueEnums.Affinity;
import com.lilithsthrone.game.character.body.valueEnums.CoveringPattern;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.effects.PerkCategory;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.misc.Elemental;
import com.lilithsthrone.game.character.npc.misc.GenericAndrogynousNPC;
import com.lilithsthrone.game.character.persona.PersonalityTrait;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.FeralAttributes;
import com.lilithsthrone.game.character.race.FurryPreference;
import com.lilithsthrone.game.character.race.Nocturnality;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.character.race.SubspeciesFlag;
import com.lilithsthrone.game.character.race.SubspeciesPreference;
import com.lilithsthrone.game.character.race.SubspeciesSpawnRarity;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.Season;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.rmi.AccessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public abstract class AbstractSubspecies {
    private boolean mod;
    private boolean fromExternalFile;
    private boolean mainSubspecies;
    private int baseSlaveValue;
    private int subspeciesOverridePriority;
    private boolean shortStature;
    private boolean bipedalSubspecies;
    private boolean winged;
    private boolean doesNotAge;
    private Map<PersonalityTrait, Float> personalityChanceOverrides;
    private String applySubspeciesChanges;
    private String subspeciesWeighting;
    private String attributeItemId;
    private String transformativeItemId;
    private Map<LegConfiguration, String[]> anthroNames;
    private Map<LegConfiguration, String[]> anthroNamesSillyMode;
    private Map<LegConfiguration, String[]> halfDemonNames;
    private FeralAttributes feralAttributes;
    private Nocturnality nocturnality;
    private String statusEffectDescription;
    private Map<PerkCategory, Integer> perkWeightingFeminine;
    private Map<PerkCategory, Integer> perkWeightingMasculine;
    private Map<AbstractAttribute, Float> statusEffectAttributeModifiers;
    private List<String> extraEffects;
    private String bookName;
    private String bookNamePlural;
    private String bookIdFolderPath;
    private String basicDescriptionId;
    private String advancedDescriptionId;
    private AbstractRace race;
    private Affinity affinity;
    private SubspeciesPreference subspeciesPreferenceDefault;
    private String description;
    private Colour colour;
    private Colour secondaryColour;
    private Colour tertiaryColour;
    protected int iconSize;
    protected String pathName;
    protected String backgroundPathName;
    protected boolean externalFileBackground;
    protected String SVGString;
    protected String SVGStringUncoloured;
    protected String SVGStringUncolouredNoBackground;
    protected String SVGStringNoBackground;
    protected String SVGStringDesaturated;
    protected String slimeSVGString;
    protected String dollSVGString;
    protected String dollSVGStringDesaturated;
    protected String halfDemonSVGString;
    protected String demonSVGString;
    protected String bookPathName;
    protected String bookSVGString;
    private Map<WorldRegion, SubspeciesSpawnRarity> regionLocations;
    private Map<AbstractWorldType, SubspeciesSpawnRarity> worldLocations;
    private Map<AbstractPlaceType, SubspeciesSpawnRarity> placeLocations;
    private List<SubspeciesFlag> flags;
    protected static Map<Integer, String> youkoIconMap;
    protected static Map<Integer, String> youkoDesaturatedIconMap;
    protected static Map<Integer, String> youkoHalfDemonIconMap;
    public static Map<LegConfiguration, String[]> demonLegConfigurationNames;

    public AbstractSubspecies(boolean mainSubspecies, int baseSlaveValue, String attributeItemId, String transformativeItemId, String pathName, String backgroundPathName, String name, String namePlural, String singularMaleName, String singularFemaleName, String pluralMaleName, String pluralFemaleName, FeralAttributes feralAttributes, Nocturnality nocturnality, String statusEffectDescription, Map<AbstractAttribute, Float> statusEffectAttributeModifiers, List<String> extraEffects, String bookName, String bookNamePlural, String basicDescription, String advancedDescription, AbstractRace race, Map<PerkCategory, Integer> perkWeightingFeminine, Map<PerkCategory, Integer> perkWeightingMasculine, Colour colour, SubspeciesPreference subspeciesPreferenceDefault, String description, Map<WorldRegion, SubspeciesSpawnRarity> regionLocations, Map<AbstractWorldType, SubspeciesSpawnRarity> worldLocations, Map<AbstractPlaceType, SubspeciesSpawnRarity> placeLocations, List<SubspeciesFlag> flags) {
        this.mainSubspecies = mainSubspecies;
        this.baseSlaveValue = baseSlaveValue;
        this.subspeciesOverridePriority = 0;
        this.winged = false;
        this.shortStature = false;
        this.bipedalSubspecies = true;
        this.doesNotAge = false;
        this.attributeItemId = attributeItemId;
        this.transformativeItemId = transformativeItemId;
        this.personalityChanceOverrides = new HashMap<PersonalityTrait, Float>();
        this.anthroNames = new HashMap<LegConfiguration, String[]>();
        this.anthroNames.put(null, new String[]{name, namePlural, singularMaleName, singularFemaleName, pluralMaleName, pluralFemaleName});
        this.anthroNamesSillyMode = new HashMap<LegConfiguration, String[]>();
        this.halfDemonNames = new HashMap<LegConfiguration, String[]>();
        this.feralAttributes = feralAttributes;
        this.nocturnality = nocturnality;
        this.statusEffectDescription = statusEffectDescription;
        this.statusEffectAttributeModifiers = statusEffectAttributeModifiers;
        if (this.statusEffectAttributeModifiers != null) {
            this.statusEffectAttributeModifiers.entrySet().removeIf(entry -> ((Float)entry.getValue()).floatValue() == 0.0f);
        }
        this.perkWeightingFeminine = perkWeightingFeminine != null ? perkWeightingFeminine : new HashMap<PerkCategory, Integer>();
        this.perkWeightingMasculine = perkWeightingMasculine != null ? perkWeightingMasculine : new HashMap<PerkCategory, Integer>();
        this.extraEffects = extraEffects == null ? new ArrayList<String>() : extraEffects;
        this.bookName = bookName;
        this.bookNamePlural = bookNamePlural;
        this.bookIdFolderPath = "";
        this.basicDescriptionId = basicDescription;
        this.advancedDescriptionId = advancedDescription;
        this.colour = colour;
        this.secondaryColour = colour;
        this.tertiaryColour = colour;
        this.race = race;
        this.affinity = Affinity.AMPHIBIOUS;
        this.subspeciesPreferenceDefault = subspeciesPreferenceDefault;
        this.description = description;
        this.regionLocations = regionLocations == null ? new HashMap<WorldRegion, SubspeciesSpawnRarity>() : regionLocations;
        this.worldLocations = worldLocations == null ? new HashMap<AbstractWorldType, SubspeciesSpawnRarity>() : worldLocations;
        this.placeLocations = placeLocations == null ? new HashMap<AbstractPlaceType, SubspeciesSpawnRarity>() : placeLocations;
        this.flags = flags == null ? new ArrayList<SubspeciesFlag>() : flags;
        this.externalFileBackground = false;
        this.pathName = "/com/lilithsthrone/res/" + pathName;
        this.bookPathName = "/com/lilithsthrone/res/" + pathName;
        this.backgroundPathName = "/com/lilithsthrone/res/" + backgroundPathName;
        this.SVGString = null;
        this.iconSize = 80;
    }

    public AbstractSubspecies(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                LegConfiguration legConfiguration;
                String pluralFemaleName;
                String pluralMaleName;
                String singularFemaleName;
                String singularMaleName;
                String namePlural;
                String name;
                Element defaultNamesElement;
                String pluralFemaleName2;
                String pluralMaleName2;
                String singularFemaleName2;
                String singularMaleName2;
                String namePlural2;
                String name2;
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.race = Race.getRaceFromId(coreElement.getMandatoryFirstOf("race").getTextContent());
                this.affinity = coreElement.getOptionalFirstOf("affinity").isPresent() ? Affinity.getAffinityFromId(coreElement.getMandatoryFirstOf("affinity").getTextContent()) : Affinity.AMPHIBIOUS;
                String secondaryColourText = coreElement.getMandatoryFirstOf("secondaryColour").getTextContent();
                String tertiaryColourText = coreElement.getMandatoryFirstOf("tertiaryColour").getTextContent();
                this.colour = PresetColour.getColourFromId(coreElement.getMandatoryFirstOf("colour").getTextContent());
                this.secondaryColour = secondaryColourText.isEmpty() ? this.colour : PresetColour.getColourFromId(secondaryColourText);
                this.tertiaryColour = tertiaryColourText.isEmpty() ? this.colour : PresetColour.getColourFromId(tertiaryColourText);
                this.mainSubspecies = Boolean.valueOf(coreElement.getMandatoryFirstOf("mainSubspecies").getTextContent());
                this.baseSlaveValue = Integer.valueOf(coreElement.getMandatoryFirstOf("baseSlaveValue").getTextContent());
                this.attributeItemId = coreElement.getMandatoryFirstOf("attributeItemId").getTextContent();
                if (this.attributeItemId.isEmpty()) {
                    this.attributeItemId = "innoxia_race_human_vanilla_water";
                }
                this.transformativeItemId = coreElement.getMandatoryFirstOf("transformativeItemId").getTextContent();
                if (this.transformativeItemId.isEmpty()) {
                    this.transformativeItemId = "innoxia_race_human_bread_roll";
                }
                this.subspeciesOverridePriority = Integer.valueOf(coreElement.getMandatoryFirstOf("subspeciesOverridePriority").getTextContent());
                this.nocturnality = Nocturnality.DIURNAL;
                if (coreElement.getOptionalFirstOf("nocturnality").isPresent()) {
                    this.nocturnality = Nocturnality.valueOf(coreElement.getMandatoryFirstOf("nocturnality").getTextContent());
                }
                this.shortStature = Boolean.valueOf(coreElement.getMandatoryFirstOf("shortStature").getTextContent());
                this.bipedalSubspecies = Boolean.valueOf(coreElement.getMandatoryFirstOf("bipedalSubspecies").getTextContent());
                this.winged = coreElement.getOptionalFirstOf("winged").isPresent() ? Boolean.valueOf(coreElement.getMandatoryFirstOf("winged").getTextContent()) : false;
                this.doesNotAge = coreElement.getOptionalFirstOf("doesNotAge").isPresent() ? Boolean.valueOf(coreElement.getMandatoryFirstOf("doesNotAge").getTextContent()) : false;
                this.personalityChanceOverrides = new HashMap<PersonalityTrait, Float>();
                if (coreElement.getOptionalFirstOf("personalityChances").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("personalityChances").getAllOf("entry")) {
                        try {
                            this.personalityChanceOverrides.put(PersonalityTrait.valueOf(e.getTextContent()), Float.valueOf(e.getAttribute("chance")));
                        }
                        catch (Exception ex) {
                            System.err.println("AbstractSubspecies error: PersonalityTrait '" + e.getTextContent() + "' failed to load!");
                        }
                    }
                }
                this.applySubspeciesChanges = coreElement.getMandatoryFirstOf("applySubspeciesChanges").getTextContent();
                this.subspeciesWeighting = coreElement.getMandatoryFirstOf("subspeciesWeighting").getTextContent();
                this.pathName = XMLFile.getParentFile().getAbsolutePath() + "/" + coreElement.getMandatoryFirstOf("iconName").getTextContent();
                this.iconSize = !coreElement.getMandatoryFirstOf("iconName").getAttribute("displaySize").isEmpty() ? Integer.valueOf(coreElement.getMandatoryFirstOf("iconName").getAttribute("displaySize")) : 100;
                if (coreElement.getOptionalFirstOf("backgroundName").isPresent() && !coreElement.getMandatoryFirstOf("backgroundName").getTextContent().isEmpty()) {
                    this.backgroundPathName = XMLFile.getParentFile().getAbsolutePath() + "/" + coreElement.getMandatoryFirstOf("backgroundName").getTextContent();
                    this.externalFileBackground = true;
                } else {
                    this.backgroundPathName = "/com/lilithsthrone/res/statusEffects/race/raceBackground";
                    this.externalFileBackground = false;
                }
                this.SVGString = null;
                this.bookPathName = XMLFile.getParentFile().getAbsolutePath() + "/" + coreElement.getMandatoryFirstOf("bookIconName").getTextContent();
                this.bookNamePlural = this.bookName = coreElement.getMandatoryFirstOf("bookName").getTextContent();
                this.bookIdFolderPath = XMLFile.getParentFile().getAbsolutePath();
                this.bookIdFolderPath = "res" + this.bookIdFolderPath.split("\\bres\\b")[1];
                this.basicDescriptionId = coreElement.getMandatoryFirstOf("basicDescriptionId").getTextContent();
                this.advancedDescriptionId = coreElement.getMandatoryFirstOf("advancedDescriptionId").getTextContent();
                this.subspeciesPreferenceDefault = SubspeciesPreference.valueOf(coreElement.getMandatoryFirstOf("defaultPreference").getTextContent());
                this.anthroNames = new HashMap<LegConfiguration, String[]>();
                if (!coreElement.getOptionalFirstOf("nameAnthro").isPresent()) {
                    name2 = coreElement.getMandatoryFirstOf("name").getTextContent();
                    namePlural2 = coreElement.getMandatoryFirstOf("namePlural").getTextContent();
                    singularMaleName2 = coreElement.getMandatoryFirstOf("singularMaleName").getTextContent();
                    singularFemaleName2 = coreElement.getMandatoryFirstOf("singularFemaleName").getTextContent();
                    pluralMaleName2 = coreElement.getMandatoryFirstOf("pluralMaleName").getTextContent();
                    pluralFemaleName2 = coreElement.getMandatoryFirstOf("pluralFemaleName").getTextContent();
                    this.anthroNames.put(null, new String[]{name2, namePlural2, singularMaleName2, singularFemaleName2, pluralMaleName2, pluralFemaleName2});
                } else {
                    defaultNamesElement = coreElement.getMandatoryFirstOf("nameAnthro").getMandatoryFirstOf("namesDefault");
                    name = defaultNamesElement.getMandatoryFirstOf("name").getTextContent();
                    namePlural = defaultNamesElement.getMandatoryFirstOf("namePlural").getTextContent();
                    singularMaleName = defaultNamesElement.getMandatoryFirstOf("singularMaleName").getTextContent();
                    singularFemaleName = defaultNamesElement.getMandatoryFirstOf("singularFemaleName").getTextContent();
                    pluralMaleName = defaultNamesElement.getMandatoryFirstOf("pluralMaleName").getTextContent();
                    pluralFemaleName = defaultNamesElement.getMandatoryFirstOf("pluralFemaleName").getTextContent();
                    this.anthroNames.put(null, new String[]{name, namePlural, singularMaleName, singularFemaleName, pluralMaleName, pluralFemaleName});
                    for (Element namesElement : coreElement.getMandatoryFirstOf("nameAnthro").getAllOf("names")) {
                        legConfiguration = LegConfiguration.valueOf(namesElement.getAttribute("legConfiguration"));
                        name = namesElement.getMandatoryFirstOf("name").getTextContent();
                        namePlural = namesElement.getMandatoryFirstOf("namePlural").getTextContent();
                        singularMaleName = namesElement.getMandatoryFirstOf("singularMaleName").getTextContent();
                        singularFemaleName = namesElement.getMandatoryFirstOf("singularFemaleName").getTextContent();
                        pluralMaleName = namesElement.getMandatoryFirstOf("pluralMaleName").getTextContent();
                        pluralFemaleName = namesElement.getMandatoryFirstOf("pluralFemaleName").getTextContent();
                        this.anthroNames.put(legConfiguration, new String[]{name, namePlural, singularMaleName, singularFemaleName, pluralMaleName, pluralFemaleName});
                    }
                }
                this.anthroNamesSillyMode = new HashMap<LegConfiguration, String[]>();
                if (coreElement.getOptionalFirstOf("nameAnthroSillyMode").isPresent()) {
                    defaultNamesElement = coreElement.getMandatoryFirstOf("nameAnthroSillyMode").getMandatoryFirstOf("namesDefault");
                    name = defaultNamesElement.getMandatoryFirstOf("name").getTextContent();
                    namePlural = defaultNamesElement.getMandatoryFirstOf("namePlural").getTextContent();
                    singularMaleName = defaultNamesElement.getMandatoryFirstOf("singularMaleName").getTextContent();
                    singularFemaleName = defaultNamesElement.getMandatoryFirstOf("singularFemaleName").getTextContent();
                    pluralMaleName = defaultNamesElement.getMandatoryFirstOf("pluralMaleName").getTextContent();
                    pluralFemaleName = defaultNamesElement.getMandatoryFirstOf("pluralFemaleName").getTextContent();
                    this.anthroNamesSillyMode.put(null, new String[]{name, namePlural, singularMaleName, singularFemaleName, pluralMaleName, pluralFemaleName});
                    for (Element namesElement : coreElement.getMandatoryFirstOf("nameAnthroSillyMode").getAllOf("names")) {
                        legConfiguration = LegConfiguration.valueOf(namesElement.getAttribute("legConfiguration"));
                        name = namesElement.getMandatoryFirstOf("name").getTextContent();
                        namePlural = namesElement.getMandatoryFirstOf("namePlural").getTextContent();
                        singularMaleName = namesElement.getMandatoryFirstOf("singularMaleName").getTextContent();
                        singularFemaleName = namesElement.getMandatoryFirstOf("singularFemaleName").getTextContent();
                        pluralMaleName = namesElement.getMandatoryFirstOf("pluralMaleName").getTextContent();
                        pluralFemaleName = namesElement.getMandatoryFirstOf("pluralFemaleName").getTextContent();
                        this.anthroNamesSillyMode.put(legConfiguration, new String[]{name, namePlural, singularMaleName, singularFemaleName, pluralMaleName, pluralFemaleName});
                    }
                }
                this.description = coreElement.getMandatoryFirstOf("description").getTextContent();
                this.halfDemonNames = new HashMap<LegConfiguration, String[]>();
                if (coreElement.getOptionalFirstOf("nameHalfDemon").isPresent()) {
                    if (!coreElement.getMandatoryFirstOf("nameHalfDemon").getOptionalFirstOf("namesDefault").isPresent()) {
                        name2 = coreElement.getMandatoryFirstOf("nameHalfDemon").getTextContent();
                        namePlural2 = coreElement.getMandatoryFirstOf("namePluralHalfDemon").getTextContent();
                        singularMaleName2 = coreElement.getMandatoryFirstOf("singularMaleNameHalfDemon").getTextContent();
                        singularFemaleName2 = coreElement.getMandatoryFirstOf("singularFemaleNameHalfDemon").getTextContent();
                        pluralMaleName2 = coreElement.getMandatoryFirstOf("pluralMaleNameHalfDemon").getTextContent();
                        pluralFemaleName2 = coreElement.getMandatoryFirstOf("pluralFemaleNameHalfDemon").getTextContent();
                        this.halfDemonNames.put(null, new String[]{name2, namePlural2, singularMaleName2, singularFemaleName2, pluralMaleName2, pluralFemaleName2});
                    } else {
                        defaultNamesElement = coreElement.getMandatoryFirstOf("nameHalfDemon").getMandatoryFirstOf("namesDefault");
                        name = defaultNamesElement.getMandatoryFirstOf("name").getTextContent();
                        namePlural = defaultNamesElement.getMandatoryFirstOf("namePlural").getTextContent();
                        singularMaleName = defaultNamesElement.getMandatoryFirstOf("singularMaleName").getTextContent();
                        singularFemaleName = defaultNamesElement.getMandatoryFirstOf("singularFemaleName").getTextContent();
                        pluralMaleName = defaultNamesElement.getMandatoryFirstOf("pluralMaleName").getTextContent();
                        pluralFemaleName = defaultNamesElement.getMandatoryFirstOf("pluralFemaleName").getTextContent();
                        this.halfDemonNames.put(null, new String[]{name, namePlural, singularMaleName, singularFemaleName, pluralMaleName, pluralFemaleName});
                        for (Element namesElement : coreElement.getMandatoryFirstOf("nameHalfDemon").getAllOf("names")) {
                            legConfiguration = LegConfiguration.valueOf(namesElement.getAttribute("legConfiguration"));
                            name = namesElement.getMandatoryFirstOf("name").getTextContent();
                            namePlural = namesElement.getMandatoryFirstOf("namePlural").getTextContent();
                            singularMaleName = namesElement.getMandatoryFirstOf("singularMaleName").getTextContent();
                            singularFemaleName = namesElement.getMandatoryFirstOf("singularFemaleName").getTextContent();
                            pluralMaleName = namesElement.getMandatoryFirstOf("pluralMaleName").getTextContent();
                            pluralFemaleName = namesElement.getMandatoryFirstOf("pluralFemaleName").getTextContent();
                            this.halfDemonNames.put(legConfiguration, new String[]{name, namePlural, singularMaleName, singularFemaleName, pluralMaleName, pluralFemaleName});
                        }
                    }
                }
                this.feralAttributes = null;
                if (coreElement.getOptionalFirstOf("feralAttributes").isPresent() && (coreElement.getMandatoryFirstOf("feralAttributes").getOptionalFirstOf("feralName").isPresent() || coreElement.getMandatoryFirstOf("feralAttributes").getOptionalFirstOf("name").isPresent())) {
                    try {
                        Element feralElement = coreElement.getMandatoryFirstOf("feralAttributes");
                        float serpentTailLength = 0.2f;
                        if (feralElement.getOptionalFirstOf("serpentTailLength").isPresent()) {
                            serpentTailLength = Float.valueOf(feralElement.getMandatoryFirstOf("serpentTailLength").getTextContent()).floatValue();
                        }
                        String name3 = "";
                        String namePlural3 = "";
                        String singularMaleName3 = "";
                        String singularFemaleName3 = "";
                        String pluralMaleName3 = "";
                        String pluralFemaleName3 = "";
                        if (feralElement.getOptionalFirstOf("feralName").isPresent()) {
                            name3 = feralElement.getMandatoryFirstOf("feralName").getTextContent();
                            namePlural3 = feralElement.getMandatoryFirstOf("feralNamePlural").getTextContent();
                            singularMaleName3 = feralElement.getMandatoryFirstOf("feralSingularMaleName").getTextContent();
                            singularFemaleName3 = feralElement.getMandatoryFirstOf("feralSingularFemaleName").getTextContent();
                            pluralMaleName3 = feralElement.getMandatoryFirstOf("feralPluralMaleName").getTextContent();
                            pluralFemaleName3 = feralElement.getMandatoryFirstOf("feralPluralFemaleName").getTextContent();
                        } else {
                            name3 = feralElement.getMandatoryFirstOf("name").getTextContent();
                            namePlural3 = feralElement.getMandatoryFirstOf("namePlural").getTextContent();
                            singularMaleName3 = feralElement.getMandatoryFirstOf("singularMaleName").getTextContent();
                            singularFemaleName3 = feralElement.getMandatoryFirstOf("singularFemaleName").getTextContent();
                            pluralMaleName3 = feralElement.getMandatoryFirstOf("pluralMaleName").getTextContent();
                            pluralFemaleName3 = feralElement.getMandatoryFirstOf("pluralFemaleName").getTextContent();
                        }
                        this.feralAttributes = new FeralAttributes(name3, namePlural3, singularMaleName3, singularFemaleName3, pluralMaleName3, pluralFemaleName3, LegConfiguration.valueOf(feralElement.getMandatoryFirstOf("legConfiguration").getTextContent()), Boolean.valueOf(feralElement.getMandatoryFirstOf("sizeHeight").getTextContent()), Integer.valueOf(feralElement.getMandatoryFirstOf("size").getTextContent()), serpentTailLength, Integer.valueOf(feralElement.getMandatoryFirstOf("breastRowCount").getTextContent()), Integer.valueOf(feralElement.getMandatoryFirstOf("nipplesPerBreastCount").getTextContent()), Integer.valueOf(feralElement.getMandatoryFirstOf("crotchBreastRowCount").getTextContent()), Integer.valueOf(feralElement.getMandatoryFirstOf("nipplesPerCrotchBreastCount").getTextContent()), Boolean.valueOf(feralElement.getMandatoryFirstOf("armsOrWingsPresent").getTextContent()), Boolean.valueOf(feralElement.getMandatoryFirstOf("fingerActionsAvailable").getTextContent()), Boolean.valueOf(feralElement.getMandatoryFirstOf("hairPresent").getTextContent()));
                    }
                    catch (Exception ex) {
                        System.err.println("Error in AbstractSubspecies loading: feralAttributes failed to initialise!<br/>" + ex.getMessage());
                    }
                }
                this.statusEffectDescription = coreElement.getMandatoryFirstOf("statusEffectDescription").getTextContent();
                this.statusEffectAttributeModifiers = new LinkedHashMap<AbstractAttribute, Float>();
                for (Element e : coreElement.getMandatoryFirstOf("statusEffectAttributeModifiers").getAllOf("attribute")) {
                    AbstractAttribute attribute = Attribute.getAttributeFromId(e.getTextContent());
                    if (attribute == null) continue;
                    this.statusEffectAttributeModifiers.put(attribute, Float.valueOf(e.getAttribute("value")));
                }
                this.statusEffectAttributeModifiers.entrySet().removeIf(entry -> ((Float)entry.getValue()).floatValue() == 0.0f);
                this.perkWeightingFeminine = new HashMap<PerkCategory, Integer>();
                this.perkWeightingMasculine = new HashMap<PerkCategory, Integer>();
                for (Element e : coreElement.getMandatoryFirstOf("perkWeightings").getAllOf("category")) {
                    PerkCategory cat = PerkCategory.valueOf(e.getTextContent());
                    this.perkWeightingFeminine.put(cat, Integer.valueOf(e.getAttribute("feminineWeighting")));
                    this.perkWeightingMasculine.put(cat, Integer.valueOf(e.getAttribute("masculineWeighting")));
                }
                this.extraEffects = new ArrayList<String>();
                for (Element e : coreElement.getMandatoryFirstOf("extraEffects").getAllOf("effect")) {
                    this.extraEffects.add(e.getTextContent());
                }
                this.regionLocations = new HashMap<WorldRegion, SubspeciesSpawnRarity>();
                if (coreElement.getOptionalFirstOf("regionLocations").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("regionLocations").getAllOf("region")) {
                        this.regionLocations.put(WorldRegion.valueOf(e.getTextContent()), SubspeciesSpawnRarity.getSubspeciesSpawnRarityFromString(e.getAttribute("rarity")));
                    }
                }
                this.worldLocations = new HashMap<AbstractWorldType, SubspeciesSpawnRarity>();
                if (coreElement.getOptionalFirstOf("worldLocations").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("worldLocations").getAllOf("world")) {
                        this.worldLocations.put(WorldType.getWorldTypeFromId(e.getTextContent()), SubspeciesSpawnRarity.getSubspeciesSpawnRarityFromString(e.getAttribute("rarity")));
                    }
                }
                this.placeLocations = new HashMap<AbstractPlaceType, SubspeciesSpawnRarity>();
                if (coreElement.getOptionalFirstOf("placeLocations").isPresent()) {
                    for (Element e : coreElement.getMandatoryFirstOf("placeLocations").getAllOf("place")) {
                        this.placeLocations.put(PlaceType.getPlaceTypeFromId(e.getTextContent()), SubspeciesSpawnRarity.getSubspeciesSpawnRarityFromString(e.getAttribute("rarity")));
                    }
                }
                this.flags = new ArrayList<SubspeciesFlag>();
                for (Element e : coreElement.getMandatoryFirstOf("flags").getAllOf("flag")) {
                    this.flags.add(SubspeciesFlag.getSubspeciesFlagFromString(e.getTextContent()));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("AbstractSubspecies was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public String toString() {
        new AccessException("WARNING: AbstractSubspecies is calling toString()!").printStackTrace(System.err);
        return Subspecies.getIdFromSubspecies(this);
    }

    public Map<PersonalityTrait, Float> getPersonalityTraitChances() {
        HashMap<PersonalityTrait, Float> map = new HashMap<PersonalityTrait, Float>();
        if (this.fromExternalFile && this.personalityChanceOverrides != null) {
            for (Map.Entry<PersonalityTrait, Float> entry : this.personalityChanceOverrides.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public void applySpeciesChanges(Body body) {
        if (this.isFromExternalFile()) {
            try {
                UtilText.setBodyForParsing("targetedBody", body);
                UtilText.parse(this.applySubspeciesChanges, new ParserTag[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void applyOffspringSpeciesChanges(Body body) {
        this.applySpeciesChanges(body);
    }

    public static AbstractSubspecies getMainSubspeciesOfRace(AbstractRace race) {
        AbstractSubspecies backup = Subspecies.HUMAN;
        for (AbstractSubspecies sub : Subspecies.getAllSubspecies()) {
            if (sub.getRace() != race) continue;
            if (sub.isMainSubspecies()) {
                return sub;
            }
            backup = sub;
        }
        System.err.println("Warning: getMainSubspeciesOfRace(" + Race.getIdFromRace(race) + ") did not find a main subspecies!");
        return backup;
    }

    public int getSubspeciesWeighting(Body body, AbstractRace race) {
        if (this.isFromExternalFile() && Main.game.isStarted()) {
            UtilText.setBodyForParsing("targetedBody", body);
            UtilText.setRaceForParsing("targetedRace", race);
            return Integer.valueOf(UtilText.parse(this.subspeciesWeighting, new ParserTag[0]).trim());
        }
        return 0;
    }

    public static AbstractSubspecies getSubspeciesFromBody(Body body, AbstractRace race) {
        int newWeighting;
        AbstractSubspecies subspecies = null;
        int highestWeighting = 0;
        for (AbstractSubspecies sub : Subspecies.getSubspeciesOfRace(race)) {
            newWeighting = sub.getSubspeciesWeighting(body, race);
            if (newWeighting <= highestWeighting || body.isFeral() && !sub.isFeralConfigurationAvailable(body)) continue;
            subspecies = sub;
            highestWeighting = newWeighting;
        }
        if (subspecies == null && Main.game.isStarted()) {
            highestWeighting = 0;
            for (AbstractSubspecies sub : Subspecies.getAllSubspecies()) {
                newWeighting = sub.getSubspeciesWeighting(body, race);
                if (newWeighting <= highestWeighting || body.isFeral() && !sub.isFeralConfigurationAvailable(body)) continue;
                subspecies = sub;
                highestWeighting = newWeighting;
            }
        }
        if (subspecies == null) {
            if (Main.game.isStarted()) {
                System.err.println("Error: getSubspeciesFromBody() did not find a suitable Subspecies! (Race: " + (race == null ? "null" : race.getName(false)) + ")");
                new Exception().printStackTrace();
            }
            return Subspecies.HUMAN;
        }
        return subspecies;
    }

    protected static void applyFoxColoring(Body body) {
        Colour c1 = body.getCoverings().get(BodyCoveringType.FOX_FUR).getPrimaryColour();
        Colour c2 = PresetColour.COVERING_WHITE;
        CoveringPattern pat = CoveringPattern.MARKED;
        if (c1 == PresetColour.COVERING_BLACK) {
            c2 = c1;
            pat = CoveringPattern.NONE;
        }
        body.getCoverings().put(BodyCoveringType.FOX_FUR, new Covering(BodyCoveringType.FOX_FUR, pat, c1, false, c2, false));
    }

    public static Body getPreGeneratedBody(GameCharacter linkedCharacter, Gender startingGender, GameCharacter mother, Body motherBody, Body fatherBody) {
        AbstractSubspecies motherSubspecies = motherBody.getTrueSubspecies();
        AbstractSubspecies motherHalfDemonSubspecies = motherBody.getHalfDemonSubspecies();
        AbstractSubspecies fatherSubspecies = fatherBody.getTrueSubspecies();
        AbstractSubspecies fatherHalfDemonSubspecies = fatherBody.getHalfDemonSubspecies();
        if (startingGender == null) {
            startingGender = Main.getProperties().isOffspringGenderUsingPreferences(mother) ? Gender.getGenderFromUserPreferences(false, false) : Gender.getBasicGender(Math.random() < (double)motherSubspecies.getRace().getChanceForMaleOffspring() ? Femininity.MASCULINE : Femininity.FEMININE);
        }
        Body preGeneratedBody = null;
        if (motherSubspecies == Subspecies.ELDER_LILIN || motherSubspecies == Subspecies.LILIN || motherSubspecies == Subspecies.DEMON) {
            preGeneratedBody = fatherSubspecies == Subspecies.ELDER_LILIN || fatherSubspecies == Subspecies.LILIN ? (motherSubspecies == Subspecies.ELDER_LILIN || motherSubspecies == Subspecies.LILIN ? Main.game.getCharacterUtils().generateBody(linkedCharacter, startingGender, RacialBody.DEMON, Subspecies.LILIN, RaceStage.GREATER) : Main.game.getCharacterUtils().generateBody(linkedCharacter, startingGender, RacialBody.DEMON, RaceStage.GREATER)) : (fatherSubspecies == Subspecies.DEMON ? Main.game.getCharacterUtils().generateBody(linkedCharacter, startingGender, RacialBody.DEMON, RaceStage.GREATER) : (fatherSubspecies == Subspecies.HALF_DEMON ? Main.game.getCharacterUtils().generateHalfDemonBody(linkedCharacter, startingGender, fatherHalfDemonSubspecies, true) : (fatherSubspecies == Subspecies.IMP || fatherSubspecies == Subspecies.IMP_ALPHA ? Main.game.getCharacterUtils().generateBody(linkedCharacter, startingGender, RacialBody.DEMON, Subspecies.IMP_ALPHA, RaceStage.GREATER) : Main.game.getCharacterUtils().generateHalfDemonBody(linkedCharacter, startingGender, fatherSubspecies, true))));
        } else if (motherSubspecies == Subspecies.HALF_DEMON) {
            preGeneratedBody = motherHalfDemonSubspecies == Subspecies.HUMAN ? (fatherSubspecies == Subspecies.ELDER_LILIN || fatherSubspecies == Subspecies.LILIN || fatherSubspecies == Subspecies.DEMON || fatherSubspecies == Subspecies.HALF_DEMON ? (fatherSubspecies == Subspecies.HALF_DEMON && fatherHalfDemonSubspecies == Subspecies.HUMAN ? Main.game.getCharacterUtils().generateBody(linkedCharacter, startingGender, RacialBody.DEMON, Subspecies.IMP, RaceStage.GREATER) : Main.game.getCharacterUtils().generateHalfDemonBody(linkedCharacter, startingGender, motherHalfDemonSubspecies, true)) : Main.game.getCharacterUtils().generateBody(linkedCharacter, startingGender, RacialBody.DEMON, Subspecies.IMP, RaceStage.GREATER)) : (fatherSubspecies == Subspecies.ELDER_LILIN || fatherSubspecies == Subspecies.LILIN || fatherSubspecies == Subspecies.DEMON ? Main.game.getCharacterUtils().generateHalfDemonBody(linkedCharacter, startingGender, motherHalfDemonSubspecies, true) : (fatherSubspecies == Subspecies.HALF_DEMON ? (Math.random() < 0.5 || fatherHalfDemonSubspecies == Subspecies.HUMAN ? Main.game.getCharacterUtils().generateHalfDemonBody(linkedCharacter, startingGender, motherHalfDemonSubspecies, true) : Main.game.getCharacterUtils().generateHalfDemonBody(linkedCharacter, startingGender, fatherHalfDemonSubspecies, true)) : (fatherSubspecies == Subspecies.IMP || fatherSubspecies == Subspecies.IMP_ALPHA ? Main.game.getCharacterUtils().generateBody(linkedCharacter, startingGender, RacialBody.DEMON, Subspecies.IMP_ALPHA, RaceStage.GREATER) : Main.game.getCharacterUtils().generateHalfDemonBody(linkedCharacter, startingGender, motherHalfDemonSubspecies, true))));
        } else if (motherSubspecies == Subspecies.IMP_ALPHA || motherSubspecies == Subspecies.IMP) {
            preGeneratedBody = fatherSubspecies == Subspecies.IMP ? Main.game.getCharacterUtils().generateBody(linkedCharacter, startingGender, RacialBody.DEMON, Subspecies.IMP, RaceStage.GREATER) : Main.game.getCharacterUtils().generateBody(linkedCharacter, startingGender, RacialBody.DEMON, Subspecies.IMP_ALPHA, RaceStage.GREATER);
        } else if (fatherSubspecies == Subspecies.ELDER_LILIN || fatherSubspecies == Subspecies.LILIN || fatherSubspecies == Subspecies.DEMON || fatherSubspecies == Subspecies.HALF_DEMON || fatherSubspecies == Subspecies.IMP || fatherSubspecies == Subspecies.IMP_ALPHA) {
            preGeneratedBody = AbstractSubspecies.getPreGeneratedBody(linkedCharacter, startingGender, null, fatherBody, motherBody);
        }
        if (preGeneratedBody != null) {
            Main.game.getCharacterUtils().applyGenetics(linkedCharacter, preGeneratedBody, motherBody, fatherBody, preGeneratedBody.getRace() == motherBody.getRace());
        }
        return preGeneratedBody;
    }

    public boolean isShortStature() {
        return this.shortStature;
    }

    public boolean isNonBiped() {
        return !this.bipedalSubspecies;
    }

    public boolean isAbleToSelfTransform() {
        return this.getRace().isAbleToSelfTransform();
    }

    public String getAttributeItemId() {
        return this.attributeItemId;
    }

    public AbstractItemType getAttributeItem(GameCharacter owner) {
        if (this.getAttributeItemId() == null || this.getAttributeItemId().isEmpty()) {
            return null;
        }
        return ItemType.getItemTypeFromId(this.getAttributeItemId());
    }

    public String getTransformativeItemId() {
        return this.transformativeItemId;
    }

    public AbstractItemType getTransformativeItem(GameCharacter owner) {
        if (this.getTransformativeItemId() == null || this.getTransformativeItemId().isEmpty()) {
            return null;
        }
        return ItemType.getItemTypeFromId(this.getTransformativeItemId());
    }

    public AbstractItemType getBook() {
        return ItemType.getLoreBook(this);
    }

    public boolean isMainSubspecies() {
        return this.mainSubspecies;
    }

    public int getSubspeciesOverridePriority() {
        return this.subspeciesOverridePriority;
    }

    private String getTaurEnding() {
        return this.getFeralName(null).charAt(this.getFeralName(null).length() - 1) == 't' ? "-taur" : "taur";
    }

    protected String applyNonBipedNameChange(Body body, String baseName, boolean applyFeminineForm, boolean plural) {
        switch (body.getLegConfiguration()) {
            case ARACHNID: {
                return "\u86db\u5f62" + baseName + (plural ? "" : "");
            }
            case AVIAN: {
                return "\u9e1f\u5f62" + baseName + (plural ? "" : "");
            }
            case WINGED_BIPED: {
                return "\u534a\u9e1f" + baseName + (plural ? "" : "");
            }
            case BIPEDAL: {
                break;
            }
            case CEPHALOPOD: {
                return "\u6d77\u602a" + baseName + (plural ? "" : "");
            }
            case TAIL: {
                return "\u4eba\u9c7c" + baseName + (plural ? "" : "");
            }
            case TAIL_LONG: {
                return "\u86c7\u5c3e" + baseName + (plural ? "" : "");
            }
            case QUADRUPEDAL: {
                return "\u56db\u8db3" + baseName + (plural ? "" : "");
            }
        }
        return baseName;
    }

    private Map<LegConfiguration, String[]> getAnthroNamesMap() {
        if (Main.game != null && Main.game.isSillyMode() && this.anthroNamesSillyMode != null && !this.anthroNamesSillyMode.isEmpty()) {
            return this.anthroNamesSillyMode;
        }
        return this.anthroNames;
    }

    public String getName(Body body) {
        if (body != null) {
            if (this.isFeralConfigurationAvailable(body) && body.isFeral()) {
                return this.getFeralAttributes(body).getFeralName();
            }
            LegConfiguration conf = body.getLegConfiguration();
            if (this.getAnthroNamesMap().containsKey((Object)conf)) {
                return this.getAnthroNamesMap().get((Object)conf)[0];
            }
            if (body.getLegConfiguration() != LegConfiguration.BIPEDAL && !this.isNonBiped()) {
                return this.applyNonBipedNameChange(body, this.getNonBipedRaceName(body), body.isFeminine(), false);
            }
        }
        return this.getAnthroNamesMap().get(null)[0];
    }

    public String getNamePlural(Body body) {
        if (body != null) {
            if (this.isFeralConfigurationAvailable(body) && body.isFeral()) {
                return this.getFeralAttributes(body).getFeralNamePlural();
            }
            LegConfiguration conf = body.getLegConfiguration();
            if (this.getAnthroNamesMap().containsKey((Object)conf)) {
                return this.getAnthroNamesMap().get((Object)conf)[1];
            }
            if (body.getLegConfiguration() != LegConfiguration.BIPEDAL && !this.isNonBiped()) {
                return this.applyNonBipedNameChange(body, this.getNonBipedRaceName(body), body.isFeminine(), true);
            }
        }
        return this.getAnthroNamesMap().get(null)[1];
    }

    public String getSingularMaleName(Body body) {
        if (body != null) {
            if (this.isFeralConfigurationAvailable(body) && body.isFeral()) {
                return this.getFeralAttributes(body).getFeralSingularMaleName();
            }
            LegConfiguration conf = body.getLegConfiguration();
            if (this.getAnthroNamesMap().containsKey((Object)conf)) {
                return this.getAnthroNamesMap().get((Object)conf)[2];
            }
            if (body.getLegConfiguration() != LegConfiguration.BIPEDAL && !this.isNonBiped()) {
                return this.applyNonBipedNameChange(body, this.getNonBipedRaceName(body), false, false);
            }
        }
        return this.getAnthroNamesMap().get(null)[2];
    }

    public String getSingularFemaleName(Body body) {
        if (body != null) {
            if (this.isFeralConfigurationAvailable(body) && body.isFeral()) {
                return this.getFeralAttributes(body).getFeralSingularFemaleName();
            }
            LegConfiguration conf = body.getLegConfiguration();
            if (this.getAnthroNamesMap().containsKey((Object)conf)) {
                return this.getAnthroNamesMap().get((Object)conf)[3];
            }
            if (body.getLegConfiguration() != LegConfiguration.BIPEDAL && !this.isNonBiped()) {
                return this.applyNonBipedNameChange(body, this.getNonBipedRaceName(body), true, false);
            }
        }
        return this.getAnthroNamesMap().get(null)[3];
    }

    public String getPluralMaleName(Body body) {
        if (body != null) {
            if (this.isFeralConfigurationAvailable(body) && body.isFeral()) {
                return this.getFeralAttributes(body).getFeralPluralMaleName();
            }
            LegConfiguration conf = body.getLegConfiguration();
            if (this.getAnthroNamesMap().containsKey((Object)conf)) {
                return this.getAnthroNamesMap().get((Object)conf)[4];
            }
            if (body.getLegConfiguration() != LegConfiguration.BIPEDAL && !this.isNonBiped()) {
                return this.applyNonBipedNameChange(body, this.getNonBipedRaceName(body), false, true);
            }
        }
        return this.getAnthroNamesMap().get(null)[4];
    }

    public String getPluralFemaleName(Body body) {
        if (body != null) {
            if (this.isFeralConfigurationAvailable(body) && body.isFeral()) {
                return this.getFeralAttributes(body).getFeralPluralFemaleName();
            }
            LegConfiguration conf = body.getLegConfiguration();
            if (this.getAnthroNamesMap().containsKey((Object)conf)) {
                return this.getAnthroNamesMap().get((Object)conf)[5];
            }
            if (body.getLegConfiguration() != LegConfiguration.BIPEDAL && !this.isNonBiped()) {
                return this.applyNonBipedNameChange(body, this.getNonBipedRaceName(body), true, true);
            }
        }
        return this.getAnthroNamesMap().get(null)[5];
    }

    public String getNonBipedRaceName(Body body) {
        return this.getFeralName(body);
    }

    public String getFeralName(Body body) {
        if (this.isFeralConfigurationAvailable(body)) {
            return this.getFeralAttributes(body).getFeralName();
        }
        return this.getAnthroNamesMap().get(null)[0];
    }

    public String getFeralNamePlural(Body body) {
        if (this.isFeralConfigurationAvailable(body)) {
            return this.getFeralAttributes(body).getFeralNamePlural();
        }
        return this.getAnthroNamesMap().get(null)[1];
    }

    public FeralAttributes getFeralAttributes(Body body) {
        return this.feralAttributes;
    }

    public Nocturnality getNocturnality() {
        return this.nocturnality;
    }

    public boolean isFeralConfigurationAvailable(Body body) {
        return this.getFeralAttributes(body) != null;
    }

    public String getStatusEffectDescription(GameCharacter character) {
        return UtilText.parse(character, this.statusEffectDescription, new ParserTag[0]);
    }

    public Map<AbstractAttribute, Float> getStatusEffectAttributeModifiers(GameCharacter character) {
        return this.statusEffectAttributeModifiers;
    }

    public Map<PerkCategory, Integer> getPerkWeighting(GameCharacter character) {
        if (character == null || !character.isFeminine()) {
            return this.perkWeightingMasculine;
        }
        return this.perkWeightingFeminine;
    }

    public List<String> getExtraEffects(GameCharacter character) {
        if (character != null) {
            ArrayList<String> effectsModified = new ArrayList<String>(this.extraEffects);
            int landSpeed = character.getLandSpeedModifier();
            int waterSpeed = character.getWaterSpeedModifier();
            if (landSpeed != 0) {
                effectsModified.add((landSpeed < 0 ? "[style.boldExcellent(" + landSpeed + "%)]" : "[style.boldTerrible(+" + landSpeed + "%)]") + "\u9646\u8def\u884c\u8fdb\u8017\u65f6");
            }
            if (waterSpeed != 0) {
                effectsModified.add((waterSpeed < 0 ? "[style.boldExcellent(" + waterSpeed + "%)]" : "[style.boldTerrible(+" + waterSpeed + "%)]") + "\u6c34\u4e2d\u884c\u8fdb\u8017\u65f6");
            }
            if (character.getLegConfiguration() == LegConfiguration.TAIL) {
                effectsModified.add("[style.boldTan(\u5728\u9646\u5730\u4e0a\u957f\u51fa\u4e0b\u80a2)]");
                effectsModified.add("[style.boldBlueLight(\u5728\u6c34\u4e2d\u5931\u53bb\u4e0b\u80a2)]");
            }
            if (character.isFeral()) {
                for (String s : this.getFeralEffects()) {
                    effectsModified.add(s);
                }
            }
            return effectsModified;
        }
        return this.extraEffects;
    }

    public List<String> getFeralEffects() {
        ArrayList<String> feralEffects = new ArrayList<String>();
        feralEffects.add("[style.colourUnarmed(\u57fa\u7840\u5f92\u624b\u4f24\u5bb3)][style.colourExcellent(\u4e09\u500d)]");
        feralEffects.add("[style.colourExcellent(\u514d\u75ab)][style.colourGenericTf(\u79cd\u65cf\u8f6c\u5316)]");
        return feralEffects;
    }

    public String getBookName() {
        return this.bookName;
    }

    public String getBookNamePlural() {
        return this.bookNamePlural;
    }

    private File getXMLBookFile() {
        return new File(this.bookIdFolderPath + System.getProperty("file.separator") + "bookEntries.xml");
    }

    public String getBookAuthor() {
        File bookFile = new File("res/txt/characters/raceInfo.xml");
        if (this.isFromExternalFile()) {
            bookFile = this.getXMLBookFile();
        }
        if (bookFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(bookFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(bookFile);
                for (Element element : coreElement.getAllOf("htmlContent")) {
                    if (!element.getAttribute("tag").equals(this.basicDescriptionId) || element.getAttribute("author").isEmpty()) continue;
                    return element.getAttribute("author");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    public String getBasicDescription(GameCharacter character) {
        if (this.isFromExternalFile() && this.getXMLBookFile().exists()) {
            return UtilText.parseFromXMLFile(new ArrayList<ParserTag>(), this.bookIdFolderPath, "bookEntries", this.getBasicDescriptionId(), new ArrayList<GameCharacter>());
        }
        return UtilText.parseFromXMLFile("characters/raceInfo", this.getBasicDescriptionId());
    }

    public String getAdvancedDescription(GameCharacter character) {
        if (this.isFromExternalFile() && this.getXMLBookFile().exists()) {
            return UtilText.parseFromXMLFile(new ArrayList<ParserTag>(), this.bookIdFolderPath, "bookEntries", this.getAdvancedDescriptionId(), new ArrayList<GameCharacter>());
        }
        return UtilText.parseFromXMLFile("characters/raceInfo", this.getAdvancedDescriptionId());
    }

    public String getBasicDescriptionId() {
        return this.basicDescriptionId;
    }

    public String getAdvancedDescriptionId() {
        return this.advancedDescriptionId;
    }

    public AbstractRace getRace() {
        return this.race;
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public Affinity getAffinity(Body body) {
        switch (body.getLegConfiguration()) {
            case CEPHALOPOD: 
            case TAIL: {
                return Affinity.AQUATIC;
            }
        }
        return body.getHalfDemonSubspecies() != null ? body.getHalfDemonSubspecies().getAffinity() : this.affinity;
    }

    public Affinity getAffinity(GameCharacter character) {
        switch (character.getLegConfiguration()) {
            case CEPHALOPOD: 
            case TAIL: {
                return Affinity.AQUATIC;
            }
        }
        return character.getHalfDemonSubspecies() != null ? character.getHalfDemonSubspecies().getAffinity() : this.affinity;
    }

    public AbstractAttribute getDamageMultiplier() {
        return this.getRace().getDefaultDamageMultiplier();
    }

    public Colour getColour(GameCharacter character) {
        return this.colour;
    }

    public Colour getSecondaryColour() {
        return this.secondaryColour;
    }

    public Colour getTertiaryColour() {
        return this.tertiaryColour;
    }

    public SubspeciesPreference getSubspeciesPreferenceDefault() {
        return this.subspeciesPreferenceDefault;
    }

    public String getDescription(GameCharacter character) {
        return this.description;
    }

    public boolean isWinged() {
        return this.winged;
    }

    public boolean isDoesNotAge() {
        return this.doesNotAge;
    }

    public boolean isAquatic() {
        return this.getAffinity() == Affinity.AQUATIC;
    }

    public boolean isAquatic(Body body) {
        return this.getAffinity(body) == Affinity.AQUATIC;
    }

    public boolean isAquatic(GameCharacter character) {
        return this.getAffinity(character) == Affinity.AQUATIC;
    }

    public String getPathName() {
        return this.pathName;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public String getBackgroundPathName() {
        return this.backgroundPathName;
    }

    protected String getBipedBackground(String svg, GameCharacter character, Colour colour) {
        return this.getBipedBackground(svg, character, colour, colour, colour);
    }

    protected String getBipedBackground(String svg, GameCharacter character, Colour colour, Colour secondaryColour, Colour tertiaryColour) {
        Object returnString = svg;
        if (character != null) {
            if (character.isFeral() || character.isElemental() && ((Elemental)character).getSummoner() != null && !((Elemental)character).getSummoner().isElementalActive()) {
                try {
                    Object feralBackground = "";
                    InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/statusEffects/race/raceBackgroundFeral.svg");
                    feralBackground = "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + Util.inputStreamToString(is) + "</div>";
                    is.close();
                    feralBackground = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this) + "FERAL", colour, secondaryColour, tertiaryColour, (String)feralBackground);
                    returnString = (String)returnString + "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + (String)feralBackground + "</div>";
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String backgroundPath = character.getLegConfiguration().getSubspeciesStatusEffectBackgroundPath();
                if (!backgroundPath.isEmpty()) {
                    try {
                        Object SVGStringLegConfigurationBackground = "";
                        InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/" + backgroundPath + ".svg");
                        SVGStringLegConfigurationBackground = "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + Util.inputStreamToString(is) + "</div>";
                        is.close();
                        SVGStringLegConfigurationBackground = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this) + "NBPID", colour, secondaryColour, tertiaryColour, (String)SVGStringLegConfigurationBackground);
                        returnString = (String)SVGStringLegConfigurationBackground + "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + svg + "</div>";
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return returnString;
    }

    protected void initBookSVGString() {
        try {
            if (this.isFromExternalFile()) {
                List<String> lines = Files.readAllLines(Paths.get(this.bookPathName + ".svg", new String[0]));
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append(line);
                }
                this.bookSVGString = sb.toString();
            } else {
                InputStream is = this.getClass().getResourceAsStream(this.bookPathName + ".svg");
                if (is == null) {
                    System.err.println("Error! Subspecies book icon file does not exist (Trying to read from '" + this.bookPathName + "')! (Code 1)");
                }
                this.bookSVGString = Util.inputStreamToString(is);
                is.close();
            }
            this.bookSVGString = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this), this.colour, this.getSecondaryColour(), this.getTertiaryColour(), "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + this.bookSVGString + "</div>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void initSVGStrings() {
        if (this.getPathName() != null) {
            String fullDivStyle = "width:100%;height:100%;margin:0;padding:0;position:absolute;left:0;bottom:0;";
            try {
                if (this.isFromExternalFile() || this.getPathName().startsWith("res")) {
                    List<String> lines = Files.readAllLines(Paths.get(this.getPathName() + ".svg", new String[0]));
                    StringBuilder sb = new StringBuilder();
                    for (String line : lines) {
                        sb.append(line);
                    }
                    this.SVGStringUncoloured = sb.toString();
                    float iconResizeBorder = (float)(100 - this.getIconSize()) / 2.0f;
                    this.SVGStringUncoloured = "<div style='width:" + this.getIconSize() + "%;height:" + this.getIconSize() + "%;position:absolute;left:" + iconResizeBorder + "%;bottom:" + iconResizeBorder + "%;'>" + this.SVGStringUncoloured + "</div>";
                } else {
                    InputStream is = this.getClass().getResourceAsStream(this.getPathName() + ".svg");
                    if (is == null) {
                        System.err.println("Error! Subspecies icon file does not exist (Trying to read from '" + this.getPathName() + "')! (Code 1)");
                    }
                    this.SVGStringUncoloured = Util.inputStreamToString(is);
                    is.close();
                }
                Object SVGStringBackground = "";
                if (this.externalFileBackground) {
                    List<String> lines = Files.readAllLines(Paths.get(this.getBackgroundPathName() + ".svg", new String[0]));
                    StringBuilder sb = new StringBuilder();
                    for (String line : lines) {
                        sb.append(line);
                    }
                    SVGStringBackground = "<div style='" + fullDivStyle + "'>" + sb.toString() + "</div>";
                } else if (!this.getBackgroundPathName().isEmpty()) {
                    InputStream is = this.getClass().getResourceAsStream(this.getBackgroundPathName() + ".svg");
                    if (is == null) {
                        System.err.println("Error! Subspecies background icon file does not exist (Trying to read from '" + this.getBackgroundPathName() + "')! (Code 1)");
                    }
                    SVGStringBackground = "<div style='" + fullDivStyle + "'>" + Util.inputStreamToString(is) + "</div>";
                    is.close();
                }
                this.initBookSVGString();
                this.SVGStringNoBackground = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this), this.colour, this.getSecondaryColour(), this.getTertiaryColour(), "<div style='" + fullDivStyle + "'>" + this.SVGStringUncoloured + "</div>");
                this.SVGStringUncolouredNoBackground = "<div style='" + fullDivStyle + "'>" + this.SVGStringUncoloured + "</div>";
                this.SVGStringUncoloured = (String)SVGStringBackground + "<div style='" + fullDivStyle + "'>" + this.SVGStringUncoloured + "</div>";
                this.slimeSVGString = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this), PresetColour.RACE_SLIME, PresetColour.RACE_SLIME, PresetColour.RACE_SLIME, "<div style='" + fullDivStyle + "'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceBackgroundSlime() + "</div><div style='" + fullDivStyle + "'>" + this.SVGStringUncolouredNoBackground + "</div>");
                this.dollSVGString = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this), PresetColour.RACE_DOLL, PresetColour.RACE_DOLL, PresetColour.RACE_DOLL, "<div style='" + fullDivStyle + "'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceBackgroundDoll() + "</div>" + (String)(this == Subspecies.HUMAN ? "" : "<div style='" + fullDivStyle + "'>" + this.SVGStringUncolouredNoBackground + "</div>"));
                this.dollSVGStringDesaturated = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this), PresetColour.BASE_GREY, PresetColour.BASE_GREY, PresetColour.BASE_GREY, "<div style='" + fullDivStyle + "'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceBackgroundDoll() + "</div>");
                this.halfDemonSVGString = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this), PresetColour.RACE_HALF_DEMON, PresetColour.RACE_HALF_DEMON, PresetColour.RACE_HALF_DEMON, "<div style='" + fullDivStyle + "'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceBackgroundDemon() + "</div><div style='" + fullDivStyle + "'>" + this.SVGStringUncolouredNoBackground + "</div>");
                this.demonSVGString = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this), PresetColour.RACE_DEMON, PresetColour.RACE_DEMON, PresetColour.RACE_DEMON, "<div style='" + fullDivStyle + "'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceBackgroundDemon() + "</div><div style='" + fullDivStyle + "'>" + this.SVGStringUncolouredNoBackground + "</div>");
                this.SVGStringDesaturated = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this), PresetColour.BASE_GREY, PresetColour.BASE_GREY, PresetColour.BASE_GREY, this.SVGStringUncoloured);
                this.SVGString = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(this), this.colour, this.getSecondaryColour(), this.getTertiaryColour(), this.SVGStringUncoloured);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.SVGString = "";
        }
    }

    public String getBookSVGString() {
        if (this.bookSVGString == null) {
            this.initBookSVGString();
        }
        return this.bookSVGString;
    }

    public String getSVGStringFromBody(Body body) {
        if (this.SVGString == null) {
            this.initSVGStrings();
        }
        if (body.getLoadedSubspecies().getRace() == Race.ELEMENTAL) {
            Elemental character = new Elemental(false);
            character.setBody(body, true);
            return this.getSVGString(character);
        }
        GenericAndrogynousNPC character = new GenericAndrogynousNPC();
        character.setBody(body, true);
        return this.getSVGString(character);
    }

    public String getSVGString(GameCharacter character) {
        if (this.SVGString == null) {
            this.initSVGStrings();
        }
        return this.getBipedBackground(this.SVGString, character, this.getColour(character), this.getSecondaryColour(), this.getTertiaryColour());
    }

    public String getSVGStringNoBackground() {
        if (this.SVGString == null) {
            this.initSVGStrings();
        }
        return this.SVGStringNoBackground;
    }

    public String getSVGStringDesaturatedFromBody(Body body) {
        if (this.SVGString == null) {
            this.initSVGStrings();
        }
        if (body.getLoadedSubspecies().getRace() == Race.ELEMENTAL) {
            Elemental character = new Elemental(false);
            character.setBody(body, true);
            return this.getSVGStringDesaturated(character);
        }
        GenericAndrogynousNPC character = new GenericAndrogynousNPC();
        character.setBody(body, true);
        return this.getSVGStringDesaturated(character);
    }

    public String getSVGStringDesaturated(GameCharacter character) {
        return this.getSVGStringDesaturated(character, PresetColour.BASE_GREY);
    }

    public String getSVGStringDesaturated(GameCharacter character, Colour colour) {
        if (this.SVGString == null) {
            this.initSVGStrings();
        }
        return this.getBipedBackground(this.SVGStringDesaturated, character, colour);
    }

    public String getSlimeSVGString(GameCharacter character) {
        if (this.SVGString == null) {
            this.initSVGStrings();
        }
        return this.getBipedBackground(this.slimeSVGString, character, PresetColour.RACE_SLIME);
    }

    public String getDollSVGString(GameCharacter character) {
        if (this.SVGString == null) {
            this.initSVGStrings();
        }
        return this.getBipedBackground(this.dollSVGString, character, PresetColour.RACE_DOLL);
    }

    public String getDollSVGStringDesaturated(GameCharacter character) {
        if (this.SVGString == null) {
            this.initSVGStrings();
        }
        return this.getBipedBackground(this.dollSVGStringDesaturated, character, PresetColour.RACE_DOLL);
    }

    public String getHalfDemonSVGString(GameCharacter character) {
        if (this.SVGString == null) {
            this.initSVGStrings();
        }
        if (character != null && character.getSubspeciesOverride() != null && character.getSubspeciesOverride().equals(Subspecies.DEMON)) {
            return this.getBipedBackground(this.demonSVGString, character, PresetColour.RACE_DEMON);
        }
        return this.getBipedBackground(this.halfDemonSVGString, character, PresetColour.RACE_HALF_DEMON);
    }

    public Map<WorldRegion, SubspeciesSpawnRarity> getRegionLocations() {
        return this.regionLocations;
    }

    public Map<AbstractWorldType, SubspeciesSpawnRarity> getWorldLocations() {
        return this.worldLocations;
    }

    public Map<AbstractPlaceType, SubspeciesSpawnRarity> getPlaceLocations() {
        return this.placeLocations;
    }

    public boolean isAbleToNaturallySpawnInLocation(AbstractWorldType worldType, AbstractPlaceType placeType) {
        return this.getRegionLocations().containsKey((Object)worldType.getWorldRegion()) || this.getWorldLocations().containsKey(worldType) || placeType != null && this.getPlaceLocations().containsKey(placeType);
    }

    public List<WorldRegion> getMostCommonWorldRegions() {
        ArrayList<WorldRegion> mostCommonRegion = Util.newArrayListOfValues(new WorldRegion[0]);
        SubspeciesSpawnRarity highestRarity = SubspeciesSpawnRarity.ONE;
        for (Map.Entry<WorldRegion, SubspeciesSpawnRarity> entry : this.getRegionLocations().entrySet()) {
            if (!(entry.getValue().getChanceMultiplier() >= highestRarity.getChanceMultiplier())) continue;
            if (entry.getValue().getChanceMultiplier() > highestRarity.getChanceMultiplier()) {
                mostCommonRegion.clear();
            }
            mostCommonRegion.add(entry.getKey());
            highestRarity = entry.getValue();
        }
        return mostCommonRegion;
    }

    public List<SubspeciesFlag> getFlags() {
        return this.flags;
    }

    public boolean hasFlag(SubspeciesFlag flag) {
        return this.getFlags().contains((Object)flag);
    }

    public String[] getHalfDemonName(Body body) {
        String[] names = null;
        if (this.getRace() == Race.DEMON || this.getRace() == Race.ELEMENTAL || this.getRace() == Race.HUMAN) {
            String[] demonNames = demonLegConfigurationNames.get((Object)(body == null ? LegConfiguration.BIPEDAL : body.getLegConfiguration()));
            names = new String[]{"\u534a" + demonNames[0], "\u534a" + demonNames[1], "\u534a" + demonNames[2], "\u534a" + demonNames[3], "\u534a" + demonNames[4], "\u534a" + demonNames[5]};
        }
        if (names == null) {
            if (body != null && this.halfDemonNames.containsKey((Object)body.getLegConfiguration())) {
                return this.halfDemonNames.get((Object)body.getLegConfiguration());
            }
            if (!this.halfDemonNames.isEmpty()) {
                return this.halfDemonNames.get(null);
            }
            names = body == null ? new String[]{"\u6076\u9b54" + this.getAnthroNamesMap().get(null)[0], "\u6076\u9b54" + this.getAnthroNamesMap().get(null)[1], "\u6076\u9b54" + this.getAnthroNamesMap().get(null)[2], "\u6076\u9b54" + this.getAnthroNamesMap().get(null)[3], "\u6076\u9b54" + this.getAnthroNamesMap().get(null)[4], "\u6076\u9b54" + this.getAnthroNamesMap().get(null)[5]} : new String[]{"\u6076\u9b54" + this.getName(body), "\u6076\u9b54" + this.getNamePlural(body), "\u6076\u9b54" + this.getSingularMaleName(body), "\u6076\u9b54" + this.getSingularFemaleName(body), "\u6076\u9b54" + this.getPluralMaleName(body), "\u6076\u9b54" + this.getPluralFemaleName(body)};
        }
        return names;
    }

    public FurryPreference getDefaultFemininePreference() {
        if (this.isNonBiped()) {
            return FurryPreference.MINIMUM;
        }
        return this.getRace().getDefaultFemininePreference();
    }

    public FurryPreference getDefaultMasculinePreference() {
        if (this.isNonBiped()) {
            return FurryPreference.MINIMUM;
        }
        return this.getRace().getDefaultMasculinePreference();
    }

    public boolean isDisplayedInFurryPreferences() {
        return !this.hasFlag(SubspeciesFlag.HIDDEN_FROM_PREFERENCES);
    }

    public boolean isFurryPreferencesEnabled() {
        return this.race.isAffectedByFurryPreference() && !this.hasFlag(SubspeciesFlag.DISABLE_FURRY_PREFERENCE);
    }

    public boolean isSpawnPreferencesEnabled() {
        return !this.hasFlag(SubspeciesFlag.DISABLE_SPAWN_PREFERENCE);
    }

    public int getBaseSlaveValue(GameCharacter character) {
        return this.baseSlaveValue;
    }

    public static Map<AbstractSubspecies, Integer> getGenericSexPartnerSubspeciesMap(Gender gender, AbstractSubspecies ... subspeciesToExclude) {
        HashMap<AbstractSubspecies, Integer> availableRaces = new HashMap<AbstractSubspecies, Integer>();
        ArrayList<AbstractSubspecies> subspecies = new ArrayList<AbstractSubspecies>(Subspecies.getAllSubspecies());
        subspecies.removeAll(Arrays.asList(subspeciesToExclude));
        for (AbstractSubspecies s : subspecies) {
            if (s == Subspecies.REINDEER_MORPH && Main.game.getSeason() == Season.WINTER && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.hasSnowedThisWinter)) {
                AbstractSubspecies.addToSubspeciesMap(10, gender, s, availableRaces);
                continue;
            }
            if (s.getRace() == Race.DEMON || s.getRace() == Race.ANGEL || s.getRace() == Race.ELEMENTAL || s == Subspecies.FOX_ASCENDANT || s == Subspecies.FOX_ASCENDANT_FENNEC || s == Subspecies.FOX_ASCENDANT_ARCTIC || s == Subspecies.SLIME) continue;
            if (AbstractSubspecies.getMainSubspeciesOfRace(s.getRace()) == s) {
                AbstractSubspecies.addToSubspeciesMap(10, gender, s, availableRaces);
                continue;
            }
            AbstractSubspecies.addToSubspeciesMap(3, gender, s, availableRaces);
        }
        return availableRaces;
    }

    public static AbstractSubspecies getRandomSubspeciesFromWeightedMap(Map<AbstractSubspecies, Integer> availableRaces) {
        return AbstractSubspecies.getRandomSubspeciesFromWeightedMap(availableRaces, Subspecies.HUMAN);
    }

    public static AbstractSubspecies getRandomSubspeciesFromWeightedMap(Map<AbstractSubspecies, Integer> availableRaces, AbstractSubspecies fallback) {
        AbstractSubspecies species = Util.getRandomObjectFromWeightedMap(availableRaces);
        return species != null ? species : fallback;
    }

    public static void addToSubspeciesMap(int weight, Gender gender, AbstractSubspecies subspecies, Map<AbstractSubspecies, Integer> map) {
        AbstractSubspecies.addToSubspeciesMap(weight, gender, subspecies, map, null);
    }

    public static void addToSubspeciesMap(int weight, Gender gender, AbstractSubspecies subspecies, Map<AbstractSubspecies, Integer> map, SubspeciesPreference userPreferenceOverride) {
        if (gender.isFeminine()) {
            if (Main.getProperties().getSubspeciesFeminineFurryPreferencesMap().get(subspecies) != FurryPreference.HUMAN && Main.getProperties().getSubspeciesFemininePreferencesMap().get(subspecies).getValue() > 0 || userPreferenceOverride != null) {
                map.put(subspecies, weight * (userPreferenceOverride != null ? userPreferenceOverride : Main.getProperties().getSubspeciesFemininePreferencesMap().get(subspecies)).getValue());
            }
        } else if (Main.getProperties().getSubspeciesMasculineFurryPreferencesMap().get(subspecies) != FurryPreference.HUMAN && Main.getProperties().getSubspeciesMasculinePreferencesMap().get(subspecies).getValue() > 0 || userPreferenceOverride != null) {
            map.put(subspecies, weight * (userPreferenceOverride != null ? userPreferenceOverride : Main.getProperties().getSubspeciesMasculinePreferencesMap().get(subspecies)).getValue());
        }
    }

    static {
        Object baseSVGString;
        InputStream is;
        Object SVGStringBackground;
        int i;
        demonLegConfigurationNames = Util.newHashMapOfValues(new Util.Value<LegConfiguration, String[]>(LegConfiguration.ARACHNID, new String[]{"\u86db\u5f62\u6076\u9b54", "\u86db\u5f62\u6076\u9b54", "incunid", "\u86db\u5f62\u9b45\u9b54", "\u86db\u5f62\u6deb\u68a6\u9b54", "\u86db\u5f62\u9b45\u9b54"}), new Util.Value<LegConfiguration, String[]>(LegConfiguration.BIPEDAL, new String[]{"\u6076\u9b54", "\u6076\u9b54", "\u6deb\u68a6\u9b54", "\u9b45\u9b54", "\u6deb\u68a6\u9b54", "\u9b45\u9b54"}), new Util.Value<LegConfiguration, String[]>(LegConfiguration.CEPHALOPOD, new String[]{"\u6d77\u602a\u6076\u9b54", "\u6d77\u602a\u6076\u9b54", "\u6d77\u602a\u6deb\u68a6\u9b54", "\u6d77\u602a\u9b45\u9b54", "\u6d77\u602a\u6deb\u68a6\u9b54", "\u6d77\u602a\u9b45\u9b54"}), new Util.Value<LegConfiguration, String[]>(LegConfiguration.QUADRUPEDAL, new String[]{"\u56db\u8db3\u6076\u9b54", "\u56db\u8db3\u6076\u9b54", "\u56db\u8db3\u6deb\u68a6\u9b54", "\u56db\u8db3\u9b45\u9b54", "\u56db\u8db3\u6deb\u68a6\u9b54", "\u56db\u8db3\u9b45\u9b54"}), new Util.Value<LegConfiguration, String[]>(LegConfiguration.TAIL, new String[]{"\u4eba\u9c7c\u6076\u9b54", "\u4eba\u9c7c\u6076\u9b54", "\u4eba\u9c7c\u6deb\u68a6\u9b54", "\u4eba\u9c7c\u9b45\u9b54", "\u4eba\u9c7c\u6deb\u68a6\u9b54", "\u4eba\u9c7c\u9b45\u9b54"}), new Util.Value<LegConfiguration, String[]>(LegConfiguration.TAIL_LONG, new String[]{"\u86c7\u5c3e\u6076\u9b54", "\u86c7\u5c3e\u6076\u9b54", "\u86c7\u5c3e\u6deb\u68a6\u9b54", "\u86c7\u5c3e\u9b45\u9b54", "\u86c7\u5c3e\u6deb\u68a6\u9b54", "\u86c7\u5c3e\u9b45\u9b54"}), new Util.Value<LegConfiguration, String[]>(LegConfiguration.AVIAN, new String[]{"\u9e1f\u5f62\u6076\u9b54", "\u9e1f\u5f62\u6076\u9b54", "\u9e1f\u5f62\u6deb\u68a6\u9b54", "\u9e1f\u5f62\u9b45\u9b54", "\u9e1f\u5f62\u6deb\u68a6\u9b54", "\u9e1f\u5f62\u9b45\u9b54"}));
        youkoIconMap = new HashMap<Integer, String>();
        youkoHalfDemonIconMap = new HashMap<Integer, String>();
        for (i = 1; i <= 9; ++i) {
            try {
                SVGStringBackground = "";
                is = Subspecies.class.getClassLoader().getResourceAsStream("com/lilithsthrone/res/statusEffects/race/raceBackground.svg");
                if (is == null) {
                    System.err.println("Error! Subspecies background icon file does not exist (Trying to read from 'statusEffects/race/raceBackground')! (Code 1f)");
                }
                SVGStringBackground = "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + Util.inputStreamToString(is) + "</div>";
                is.close();
                baseSVGString = (String)SVGStringBackground + "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getFoxTail(i) + "</div>";
                youkoIconMap.put(i, (String)baseSVGString);
                baseSVGString = SvgUtil.colourReplacement("youkohalfDemon" + i, PresetColour.RACE_HALF_DEMON, PresetColour.RACE_HALF_DEMON, PresetColour.RACE_HALF_DEMON, "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceBackgroundDemon() + "</div><div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getFoxTailDemon(i) + "</div>");
                youkoHalfDemonIconMap.put(i, (String)baseSVGString);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        youkoDesaturatedIconMap = new HashMap<Integer, String>();
        for (i = 1; i <= 9; ++i) {
            try {
                SVGStringBackground = "";
                is = Subspecies.class.getClassLoader().getResourceAsStream("com/lilithsthrone/res/statusEffects/race/raceBackground.svg");
                if (is == null) {
                    System.err.println("Error! Subspecies background icon file does not exist (Trying to read from 'statusEffects/race/raceBackground')! (Code 2f)");
                }
                SVGStringBackground = "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + Util.inputStreamToString(is) + "</div>";
                is.close();
                baseSVGString = (String)SVGStringBackground + "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getFoxTailDesaturated(i) + "</div>";
                baseSVGString = SvgUtil.colourReplacement("youkoGradient" + i, PresetColour.BASE_GREY, PresetColour.BASE_GREY, PresetColour.BASE_GREY, (String)baseSVGString);
                youkoDesaturatedIconMap.put(i, (String)baseSVGString);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

