/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.race;

import com.lilithsthrone.utils.time.DayPeriod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum Nocturnality {
    DIURNAL("\u767d\u5929\u6d3b\u52a8", "\u767d\u5929\u6d3b\u52a8\uff0c\u591c\u665a\u4f11\u606f\u3002", true, false),
    NOCTURNAL("\u591c\u665a\u6d3b\u52a8", "\u591c\u665a\u6d3b\u52a8\uff0c\u767d\u5929\u4f11\u606f\u3002", false, true),
    CREPUSCULAR("\u9ec4\u660f\u6d3b\u52a8", "\u5728\u65e9\u6668\u548c\u508d\u665a\u7684\u9ec4\u660f\u65f6\u6bb5\u6d3b\u52a8\u3002", true, true),
    MATUTINAL("\u65e9\u6668\u6d3b\u52a8", "\u5728\u9ece\u660e\u65f6\u6bb5\u6d3b\u52a8\u3002", true, true),
    VESPERTINE("\u665a\u95f4\u6d3b\u52a8", "\u5728\u665a\u95f4\u9ec4\u660f\u65f6\u6bb5\u6d3b\u52a8\u3002", true, true),
    CATHEMERAL("\u65e0\u89c4\u5f8b", "\u5728\u767d\u5929\u548c\u591c\u665a\u4e0d\u89c4\u5f8b\u5730\u6d3b\u52a8\u3002", true, true);

    private String name;
    private String description;
    private boolean activeAtDay;
    private boolean activeAtNight;

    private Nocturnality(String name, String description, boolean activeAtDay, boolean activeAtNight) {
        this.name = name;
        this.description = description;
        this.activeAtDay = activeAtDay;
        this.activeAtNight = activeAtNight;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isActiveAtDay() {
        return this.activeAtDay;
    }

    public boolean isActiveAtNight() {
        return this.activeAtNight;
    }

    public List<DayPeriod> getSleepPeriods() {
        ArrayList<DayPeriod> sleepyTimes = new ArrayList<DayPeriod>();
        if (this.isActiveAtDay() && this.isActiveAtNight()) {
            Collections.addAll(sleepyTimes, DayPeriod.values());
        } else if (!this.isActiveAtDay()) {
            sleepyTimes.add(DayPeriod.DAY);
            sleepyTimes.add(DayPeriod.CIVIL_TWILIGHT);
        } else if (!this.isActiveAtNight()) {
            sleepyTimes.add(DayPeriod.NIGHT);
            sleepyTimes.add(DayPeriod.ASTRONOMICAL_TWILIGHT);
            sleepyTimes.add(DayPeriod.NAUTICAL_TWILIGHT);
        }
        return sleepyTimes;
    }
}

