/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.race;

import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.FurryPreference;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RaceStage {
    HUMAN("", PresetColour.TRANSFORMATION_HUMAN){

        @Override
        public boolean isAntennaFurry() {
            return false;
        }

        @Override
        public boolean isArmFurry() {
            return false;
        }

        @Override
        public boolean isAssFurry() {
            return false;
        }

        @Override
        public boolean isBreastFurry() {
            return false;
        }

        @Override
        public boolean isEarFurry() {
            return false;
        }

        @Override
        public boolean isEyeFurry() {
            return false;
        }

        @Override
        public boolean isFaceFurry() {
            return false;
        }

        @Override
        public boolean isHairFurry() {
            return false;
        }

        @Override
        public boolean isHornFurry() {
            return false;
        }

        @Override
        public boolean isLegFurry() {
            return false;
        }

        @Override
        public boolean isPenisFurry() {
            return false;
        }

        @Override
        public boolean isSkinFurry() {
            return false;
        }

        @Override
        public boolean isTailFurry() {
            return false;
        }

        @Override
        public boolean isVaginaFurry() {
            return false;
        }

        @Override
        public boolean isWingFurry() {
            return false;
        }

        @Override
        public boolean isTentacleFurry() {
            return false;
        }
    }
    ,
    PARTIAL("\u4f3c", PresetColour.TRANSFORMATION_PARTIAL){

        @Override
        public boolean isAntennaFurry() {
            return true;
        }

        @Override
        public boolean isArmFurry() {
            return false;
        }

        @Override
        public boolean isAssFurry() {
            return false;
        }

        @Override
        public boolean isBreastFurry() {
            return false;
        }

        @Override
        public boolean isEarFurry() {
            return true;
        }

        @Override
        public boolean isEyeFurry() {
            return true;
        }

        @Override
        public boolean isFaceFurry() {
            return false;
        }

        @Override
        public boolean isHairFurry() {
            return true;
        }

        @Override
        public boolean isHornFurry() {
            return true;
        }

        @Override
        public boolean isLegFurry() {
            return false;
        }

        @Override
        public boolean isPenisFurry() {
            return false;
        }

        @Override
        public boolean isSkinFurry() {
            return false;
        }

        @Override
        public boolean isTailFurry() {
            return true;
        }

        @Override
        public boolean isVaginaFurry() {
            return false;
        }

        @Override
        public boolean isWingFurry() {
            return true;
        }

        @Override
        public boolean isTentacleFurry() {
            return false;
        }
    }
    ,
    PARTIAL_FULL("\u6cdb", PresetColour.TRANSFORMATION_PARTIAL_FULL){

        @Override
        public boolean isAntennaFurry() {
            return true;
        }

        @Override
        public boolean isArmFurry() {
            return false;
        }

        @Override
        public boolean isAssFurry() {
            return true;
        }

        @Override
        public boolean isBreastFurry() {
            return true;
        }

        @Override
        public boolean isEarFurry() {
            return true;
        }

        @Override
        public boolean isEyeFurry() {
            return true;
        }

        @Override
        public boolean isFaceFurry() {
            return false;
        }

        @Override
        public boolean isHairFurry() {
            return true;
        }

        @Override
        public boolean isHornFurry() {
            return true;
        }

        @Override
        public boolean isLegFurry() {
            return false;
        }

        @Override
        public boolean isPenisFurry() {
            return true;
        }

        @Override
        public boolean isSkinFurry() {
            return false;
        }

        @Override
        public boolean isTailFurry() {
            return true;
        }

        @Override
        public boolean isVaginaFurry() {
            return true;
        }

        @Override
        public boolean isWingFurry() {
            return true;
        }

        @Override
        public boolean isTentacleFurry() {
            return false;
        }
    }
    ,
    LESSER("\u4e9a", PresetColour.TRANSFORMATION_LESSER){

        @Override
        public boolean isAntennaFurry() {
            return true;
        }

        @Override
        public boolean isArmFurry() {
            return true;
        }

        @Override
        public boolean isAssFurry() {
            return true;
        }

        @Override
        public boolean isBreastFurry() {
            return true;
        }

        @Override
        public boolean isEarFurry() {
            return true;
        }

        @Override
        public boolean isEyeFurry() {
            return true;
        }

        @Override
        public boolean isFaceFurry() {
            return false;
        }

        @Override
        public boolean isHairFurry() {
            return true;
        }

        @Override
        public boolean isHornFurry() {
            return true;
        }

        @Override
        public boolean isLegFurry() {
            return true;
        }

        @Override
        public boolean isPenisFurry() {
            return true;
        }

        @Override
        public boolean isSkinFurry() {
            return false;
        }

        @Override
        public boolean isTailFurry() {
            return true;
        }

        @Override
        public boolean isVaginaFurry() {
            return true;
        }

        @Override
        public boolean isWingFurry() {
            return true;
        }

        @Override
        public boolean isTentacleFurry() {
            return false;
        }
    }
    ,
    GREATER("\u7eaf", PresetColour.TRANSFORMATION_GREATER){

        @Override
        public boolean isAntennaFurry() {
            return true;
        }

        @Override
        public boolean isArmFurry() {
            return true;
        }

        @Override
        public boolean isAssFurry() {
            return true;
        }

        @Override
        public boolean isBreastFurry() {
            return true;
        }

        @Override
        public boolean isEarFurry() {
            return true;
        }

        @Override
        public boolean isEyeFurry() {
            return true;
        }

        @Override
        public boolean isFaceFurry() {
            return true;
        }

        @Override
        public boolean isHairFurry() {
            return true;
        }

        @Override
        public boolean isHornFurry() {
            return true;
        }

        @Override
        public boolean isLegFurry() {
            return true;
        }

        @Override
        public boolean isPenisFurry() {
            return true;
        }

        @Override
        public boolean isSkinFurry() {
            return true;
        }

        @Override
        public boolean isTailFurry() {
            return true;
        }

        @Override
        public boolean isVaginaFurry() {
            return true;
        }

        @Override
        public boolean isWingFurry() {
            return true;
        }

        @Override
        public boolean isTentacleFurry() {
            return true;
        }
    }
    ,
    FERAL("\u517d\u6001", PresetColour.RACE_BESTIAL){

        @Override
        public boolean isAntennaFurry() {
            return true;
        }

        @Override
        public boolean isArmFurry() {
            return true;
        }

        @Override
        public boolean isAssFurry() {
            return true;
        }

        @Override
        public boolean isBreastFurry() {
            return true;
        }

        @Override
        public boolean isEarFurry() {
            return true;
        }

        @Override
        public boolean isEyeFurry() {
            return true;
        }

        @Override
        public boolean isFaceFurry() {
            return true;
        }

        @Override
        public boolean isHairFurry() {
            return true;
        }

        @Override
        public boolean isHornFurry() {
            return true;
        }

        @Override
        public boolean isLegFurry() {
            return true;
        }

        @Override
        public boolean isPenisFurry() {
            return true;
        }

        @Override
        public boolean isSkinFurry() {
            return true;
        }

        @Override
        public boolean isTailFurry() {
            return true;
        }

        @Override
        public boolean isVaginaFurry() {
            return true;
        }

        @Override
        public boolean isWingFurry() {
            return true;
        }

        @Override
        public boolean isTentacleFurry() {
            return true;
        }
    };

    private String name;
    private Colour colour;

    private RaceStage(String name, Colour colour) {
        this.name = name;
        this.colour = colour;
    }

    public String getName() {
        return this.name;
    }

    public Colour getColour() {
        return this.colour;
    }

    public static RaceStage getRaceStageFromUserPreferences(Gender gender, AbstractSubspecies subspecies) {
        FurryPreference preference = gender.isFeminine() ? Main.getProperties().getSubspeciesFeminineFurryPreferencesMap().get(subspecies) : Main.getProperties().getSubspeciesMasculineFurryPreferencesMap().get(subspecies);
        if (preference == null) {
            preference = FurryPreference.HUMAN;
        }
        RaceStage raceStage = PARTIAL;
        switch (preference) {
            case HUMAN: {
                return HUMAN;
            }
            case MINIMUM: {
                return PARTIAL;
            }
            case REDUCED: {
                return Util.randomItemFrom(Util.newArrayListOfValues(PARTIAL, LESSER));
            }
            case NORMAL: {
                return Util.randomItemFrom(Util.newArrayListOfValues(PARTIAL, LESSER, GREATER));
            }
            case MAXIMUM: {
                return GREATER;
            }
        }
        return raceStage;
    }

    public abstract boolean isAntennaFurry();

    public abstract boolean isArmFurry();

    public abstract boolean isAssFurry();

    public abstract boolean isBreastFurry();

    public abstract boolean isEarFurry();

    public abstract boolean isEyeFurry();

    public abstract boolean isFaceFurry();

    public abstract boolean isHairFurry();

    public abstract boolean isHornFurry();

    public abstract boolean isLegFurry();

    public abstract boolean isPenisFurry();

    public abstract boolean isSkinFurry();

    public abstract boolean isTailFurry();

    public abstract boolean isTentacleFurry();

    public abstract boolean isVaginaFurry();

    public abstract boolean isWingFurry();
}

