/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.character.race;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.attributes.IntelligenceLevel;
import com.lilithsthrone.game.character.body.Body;
import com.lilithsthrone.game.character.body.FluidCum;
import com.lilithsthrone.game.character.body.FluidGirlCum;
import com.lilithsthrone.game.character.body.FluidMilk;
import com.lilithsthrone.game.character.body.LegConfigurationAffinity;
import com.lilithsthrone.game.character.body.Wing;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractFaceType;
import com.lilithsthrone.game.character.body.coverings.AbstractBodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringCategory;
import com.lilithsthrone.game.character.body.coverings.BodyCoveringType;
import com.lilithsthrone.game.character.body.coverings.Covering;
import com.lilithsthrone.game.character.body.types.EarType;
import com.lilithsthrone.game.character.body.types.FaceType;
import com.lilithsthrone.game.character.body.types.FluidType;
import com.lilithsthrone.game.character.body.types.HairType;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.types.LegType;
import com.lilithsthrone.game.character.body.types.PenisType;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.body.valueEnums.BodySize;
import com.lilithsthrone.game.character.body.valueEnums.CoveringModifier;
import com.lilithsthrone.game.character.body.valueEnums.CoveringPattern;
import com.lilithsthrone.game.character.body.valueEnums.CupSize;
import com.lilithsthrone.game.character.body.valueEnums.FluidModifier;
import com.lilithsthrone.game.character.body.valueEnums.HairStyle;
import com.lilithsthrone.game.character.body.valueEnums.Height;
import com.lilithsthrone.game.character.body.valueEnums.HornLength;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.body.valueEnums.Muscle;
import com.lilithsthrone.game.character.body.valueEnums.WingSize;
import com.lilithsthrone.game.character.effects.PerkCategory;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.npc.misc.Elemental;
import com.lilithsthrone.game.character.persona.PersonalityTrait;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.FeralAttributes;
import com.lilithsthrone.game.character.race.Nocturnality;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.SubspeciesFlag;
import com.lilithsthrone.game.character.race.SubspeciesPreference;
import com.lilithsthrone.game.character.race.SubspeciesSpawnRarity;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Subspecies {
    public static AbstractSubspecies HUMAN;
    public static AbstractSubspecies ANGEL;
    public static AbstractSubspecies ELDER_LILIN;
    public static AbstractSubspecies LILIN;
    public static AbstractSubspecies DEMON;
    public static AbstractSubspecies HALF_DEMON;
    public static AbstractSubspecies IMP;
    public static AbstractSubspecies IMP_ALPHA;
    public static AbstractSubspecies COW_MORPH;
    public static AbstractSubspecies DOG_MORPH;
    public static AbstractSubspecies DOG_MORPH_BORDER_COLLIE;
    public static AbstractSubspecies DOG_MORPH_DOBERMANN;
    public static AbstractSubspecies DOG_MORPH_GERMAN_SHEPHERD;
    public static AbstractSubspecies WOLF_MORPH;
    public static AbstractSubspecies FOX_MORPH;
    public static AbstractSubspecies FOX_MORPH_ARCTIC;
    public static AbstractSubspecies FOX_MORPH_FENNEC;
    public static AbstractSubspecies FOX_ASCENDANT;
    public static AbstractSubspecies FOX_ASCENDANT_ARCTIC;
    public static AbstractSubspecies FOX_ASCENDANT_FENNEC;
    public static AbstractSubspecies CAT_MORPH;
    public static AbstractSubspecies CAT_MORPH_LYNX;
    public static AbstractSubspecies CAT_MORPH_CHEETAH;
    public static AbstractSubspecies CAT_MORPH_CARACAL;
    public static AbstractSubspecies HORSE_MORPH;
    public static AbstractSubspecies HORSE_MORPH_UNICORN;
    public static AbstractSubspecies HORSE_MORPH_PEGASUS;
    public static AbstractSubspecies HORSE_MORPH_ALICORN;
    public static AbstractSubspecies CENTAUR;
    public static AbstractSubspecies PEGATAUR;
    public static AbstractSubspecies UNITAUR;
    public static AbstractSubspecies ALITAUR;
    public static AbstractSubspecies HORSE_MORPH_ZEBRA;
    public static AbstractSubspecies HORSE_MORPH_DONKEY;
    public static AbstractSubspecies REINDEER_MORPH;
    public static AbstractSubspecies ALLIGATOR_MORPH;
    public static AbstractSubspecies SQUIRREL_MORPH;
    public static AbstractSubspecies RAT_MORPH;
    public static AbstractSubspecies RABBIT_MORPH;
    public static AbstractSubspecies RABBIT_MORPH_LOP;
    public static AbstractSubspecies BAT_MORPH;
    public static AbstractSubspecies HARPY;
    public static AbstractSubspecies HARPY_RAVEN;
    public static AbstractSubspecies HARPY_SWAN;
    public static AbstractSubspecies HARPY_PHOENIX;
    public static AbstractSubspecies SLIME;
    public static AbstractSubspecies DOLL;
    public static AbstractSubspecies ELEMENTAL_FIRE;
    public static AbstractSubspecies ELEMENTAL_EARTH;
    public static AbstractSubspecies ELEMENTAL_WATER;
    public static AbstractSubspecies ELEMENTAL_AIR;
    public static AbstractSubspecies ELEMENTAL_ARCANE;
    public static List<AbstractSubspecies> allSubspecies;
    public static Map<AbstractSubspecies, String> subspeciesToIdMap;
    public static Map<String, AbstractSubspecies> idToSubspeciesMap;
    private static Map<WorldRegion, Map<AbstractSubspecies, SubspeciesSpawnRarity>> regionSpecies;
    private static Map<AbstractWorldType, Map<AbstractSubspecies, SubspeciesSpawnRarity>> worldSpecies;
    private static Map<AbstractPlaceType, Map<AbstractSubspecies, SubspeciesSpawnRarity>> placeSpecies;
    protected static Map<AbstractSubspecies, SubspeciesSpawnRarity> dominionStormImmuneSpecies;
    protected static Map<AbstractRace, List<AbstractSubspecies>> subspeciesFromRace;

    public static AbstractSubspecies getSubspeciesFromId(String id) {
        if (id.equalsIgnoreCase("CAT_MORPH_LEOPARD_SNOW")) {
            id = "innoxia_panther_subspecies_snow_leopard";
        } else if (id.equalsIgnoreCase("CAT_MORPH_LEOPARD")) {
            id = "innoxia_panther_subspecies_leopard";
        } else if (id.equalsIgnoreCase("CAT_MORPH_LION")) {
            id = "innoxia_panther_subspecies_lion";
        } else if (id.equalsIgnoreCase("CAT_MORPH_TIGER")) {
            id = "innoxia_panther_subspecies_tiger";
        } else if (id.equalsIgnoreCase("HARPY_BALD_EAGLE")) {
            id = "innoxia_raptor_subspecies_bald_eagle";
        }
        id = Util.getClosestStringMatch(id, idToSubspeciesMap.keySet());
        return idToSubspeciesMap.get(id);
    }

    public static String getIdFromSubspecies(AbstractSubspecies subspecies) {
        return subspeciesToIdMap.get(subspecies);
    }

    public static List<AbstractSubspecies> getAllSubspecies() {
        return allSubspecies;
    }

    public static Map<AbstractSubspecies, SubspeciesSpawnRarity> getWorldSpecies(AbstractWorldType worldType, AbstractPlaceType placeType, boolean onlyCoreRaceSpecies, AbstractSubspecies ... subspeciesToExclude) {
        return Subspecies.getWorldSpecies(worldType, placeType, onlyCoreRaceSpecies, true, subspeciesToExclude);
    }

    public static Map<AbstractSubspecies, SubspeciesSpawnRarity> getWorldSpecies(AbstractWorldType worldType, AbstractPlaceType placeType, boolean onlyCoreRaceSpecies, boolean includeRegionSpecies, AbstractSubspecies ... subspeciesToExclude) {
        return Subspecies.getWorldSpecies(worldType, placeType, onlyCoreRaceSpecies, includeRegionSpecies, Arrays.asList(subspeciesToExclude));
    }

    public static Map<AbstractSubspecies, SubspeciesSpawnRarity> getWorldSpecies(AbstractWorldType worldType, AbstractPlaceType placeType, boolean onlyCoreRaceSpecies, boolean includeRegionSpecies, List<AbstractSubspecies> subspeciesToExclude) {
        worldSpecies.putIfAbsent(worldType, new HashMap());
        regionSpecies.putIfAbsent(worldType.getWorldRegion(), new HashMap());
        HashMap<AbstractSubspecies, SubspeciesSpawnRarity> map = new HashMap<AbstractSubspecies, SubspeciesSpawnRarity>(worldSpecies.get(worldType));
        if (includeRegionSpecies) {
            for (Map.Entry<AbstractSubspecies, SubspeciesSpawnRarity> regionEntry : regionSpecies.get((Object)worldType.getWorldRegion()).entrySet()) {
                if (map.containsKey(regionEntry.getKey())) continue;
                map.put(regionEntry.getKey(), regionEntry.getValue());
            }
        }
        if (placeType != null) {
            placeSpecies.putIfAbsent(placeType, new HashMap());
            regionSpecies.putIfAbsent(placeType.getWorldRegion(), new HashMap());
            for (Map.Entry<AbstractSubspecies, SubspeciesSpawnRarity> placeEntry : placeSpecies.get(placeType).entrySet()) {
                if (map.containsKey(placeEntry.getKey())) continue;
                map.put(placeEntry.getKey(), placeEntry.getValue());
            }
            if (includeRegionSpecies && regionSpecies.get((Object)placeType.getWorldRegion()) != null) {
                for (Map.Entry<AbstractSubspecies, SubspeciesSpawnRarity> regionEntry : regionSpecies.get((Object)placeType.getWorldRegion()).entrySet()) {
                    if (map.containsKey(regionEntry.getKey())) continue;
                    map.put(regionEntry.getKey(), regionEntry.getValue());
                }
            }
        }
        HashMap<AbstractSubspecies, SubspeciesSpawnRarity> filteredMap = new HashMap<AbstractSubspecies, SubspeciesSpawnRarity>(map);
        if (onlyCoreRaceSpecies) {
            for (AbstractSubspecies sub : map.keySet()) {
                if (AbstractSubspecies.getMainSubspeciesOfRace(sub.getRace()) == sub) continue;
                filteredMap.remove(sub);
            }
        }
        for (AbstractSubspecies sub : subspeciesToExclude) {
            filteredMap.remove(sub);
        }
        return filteredMap;
    }

    public static Map<AbstractSubspecies, SubspeciesSpawnRarity> getDominionStormImmuneSpecies(boolean onlyCoreRaceSpecies, AbstractSubspecies ... subspeciesToExclude) {
        HashMap<AbstractSubspecies, SubspeciesSpawnRarity> map = new HashMap<AbstractSubspecies, SubspeciesSpawnRarity>(dominionStormImmuneSpecies);
        if (onlyCoreRaceSpecies) {
            for (AbstractSubspecies sub : dominionStormImmuneSpecies.keySet()) {
                if (AbstractSubspecies.getMainSubspeciesOfRace(sub.getRace()) == sub) continue;
                map.remove(sub);
            }
        }
        for (AbstractSubspecies sub : subspeciesToExclude) {
            map.remove(sub);
        }
        return map;
    }

    public static List<AbstractSubspecies> getSubspeciesOfRace(AbstractRace race) {
        return subspeciesFromRace.get(race);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var5_23;
        Field[] fieldArray;
        HUMAN = new AbstractSubspecies(true, 4000, "innoxia_race_human_vanilla_water", "innoxia_race_human_bread_roll", "statusEffects/race/raceHuman", "statusEffects/race/raceBackground", "\u4eba\u7c7b", "\u4eba\u7c7b", "\u7537\u4eba", "\u5973\u4eba", "\u7537\u4eba", "\u5973\u4eba", null, Nocturnality.DIURNAL, "\u4eba\u7c7b\u5bf9\u4e8e\u5feb\u611f\u548c\u5965\u672f\u7684\u62b5\u6297\u80fd\u529b\u8fdc\u9ad8\u4e8e\u5176\u4ed6\u79cd\u65cf\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_LUST, Float.valueOf(5.0f))), null, "\u5fc3\u7cfb\u4eba\u7c7b", "\u5fc3\u7cfb\u4eba\u7c7b", "HUMAN_BASIC", "HUMAN_ADVANCED", Race.HUMAN, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_HUMAN, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u4e2a\u666e\u901a\u7684\u4eba\u7c7b\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HUMAN) {
                    return 100;
                }
                return 0;
            }
        };
        ANGEL = new AbstractSubspecies(true, 80000, "innoxia_race_angel_angels_tears", null, "statusEffects/race/raceAngel", "statusEffects/race/raceBackground", "\u5929\u4f7f", "\u5929\u4f7f", "\u5929\u4f7f", "\u5929\u4f7f", "\u5929\u4f7f", "\u5929\u4f7f", null, Nocturnality.DIURNAL, "\u4f5c\u4e3a\u4e00\u540d\u5929\u4f7f\uff0c[npc.nameIsFull]\u5bf9\u5965\u672f\u9020\u6210\u7684\u6b32\u671b\u6548\u5e94\u5177\u6709\u9ad8\u62b5\u6297\u529b\uff0c\u4e14\u5584\u4e8e\u4e0e\u6076\u9b54\u4f5c\u6218\u3002[npc.her]\u62e5\u6709\u4fdd\u62a4\u4eba\u7c7b\u7684\u672c\u80fd\uff0c\u7136\u800c\uff0c\u8fd9\u4f7f[npc.her]\u96be\u4ee5\u62b5\u5fa1\u6765\u81ea\u4eba\u7c7b\u7684\u4f24\u5bb3\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(-100.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_LUST, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.DEMON), Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.HUMAN), Float.valueOf(-50.0f))), null, "\u5b88\u62a4\u8005", "\u5b88\u62a4\u8005", "ANGEL_BASIC", "ANGEL_ADVANCED", Race.ANGEL, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 0), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 0), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 2)), PresetColour.RACE_ANGEL, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u4e2a\u666e\u901a\u7684\u5929\u4f7f\u3002", null, (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 10;
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u5815\u5929\u4f7f", "\u5815\u5929\u4f7f", "\u5815\u5929\u4f7f", "\u5815\u5929\u4f7f", "\u5815\u5929\u4f7f", "\u5815\u5929\u4f7f"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u5815\u5929\u4f7f", false, false), this.applyNonBipedNameChange(body, "\u5815\u5929\u4f7f", false, true), this.applyNonBipedNameChange(body, "\u5815\u5929\u4f7f", false, false), this.applyNonBipedNameChange(body, "\u5815\u5929\u4f7f", true, false), this.applyNonBipedNameChange(body, "\u5815\u5929\u4f7f", false, true), this.applyNonBipedNameChange(body, "\u5815\u5929\u4f7f", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.ANGEL) {
                    return 100;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        ELDER_LILIN = new AbstractSubspecies(false, 1000000000, "innoxia_race_demon_liliths_gift", null, "statusEffects/race/raceElderLilin", "statusEffects/race/raceBackground", "\u8389\u7433\u957f\u8001", "\u8389\u7433\u957f\u8001", "\u8389\u7433\u957f\u8001", "\u8389\u7433\u957f\u8001", "\u8389\u7433\u957f\u8001", "\u8389\u7433\u957f\u8001", null, Nocturnality.CATHEMERAL, "[npc.NameIsFull]\u662f\u4e03\u4f4d\u8389\u7433\u957f\u8001\u4e4b\u4e00\uff0c\u4e5f\u662f\u73b0\u5b58\u8005\u4e2d\u6700\u6709\u529b\u91cf\u7684\u4e00\u4f4d\uff0c[npc.She]\u53ef\u4ee5\u628a[npc.her]\u7684\u8eab\u4f53\u8f6c\u5316\u6210[npc.she]\u60f3\u8981\u7684\u4efb\u4f55\u5f62\u5f0f\uff0c\u8fd8\u80fd\u5b8c\u5168\u638c\u63a7\u5965\u672f\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(1000.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(1000.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(1000.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.HEALTH_MAXIMUM, Float.valueOf(1000.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MANA_MAXIMUM, Float.valueOf(1000.0f))), Util.newArrayListOfValues("[style.boldExcellent(\u65e0\u9650\u5236)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u6211\u8f6c\u5316</b>", "<b style='color: " + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u514d\u75ab\u79cd\u65cf\u8f6c\u5316</b>"), "\u8389\u8389\u4e1d\u7684\u5b50\u55e3", "\u8389\u8389\u4e1d\u7684\u5b50\u55e3", "ELDER_LILIN_BASIC", "ELDER_LILIN_ADVANCED", Race.DEMON, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_LILIN, SubspeciesPreference.ONE_LOW, "\u4e03\u4f4d\u8389\u7433\u957f\u8001\u4e4b\u4e00\u3002", null, (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 10000;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setSubspeciesOverride(ELDER_LILIN);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                return 0;
            }

            @Override
            public AbstractAttribute getDamageMultiplier() {
                return Attribute.DAMAGE_ELDER_LILIN;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        LILIN = new AbstractSubspecies(false, 500000000, "innoxia_race_demon_liliths_gift", null, "statusEffects/race/raceLilin", "statusEffects/race/raceBackground", "\u8389\u7433", "\u8389\u7433", "\u8389\u7433", "\u8389\u7433", "\u8389\u7433", "\u8389\u7433", null, Nocturnality.CATHEMERAL, "[npc.Name]\u662f\u4f4d\u8389\u7433\uff0c\u8fdc\u6bd4\u5bfb\u5e38\u6076\u9b54\u66f4\u4e3a\u5f3a\u5927\u3002[npc.She]\u53ef\u4ee5\u5c06\u8eaf\u4f53\u968f\u5fc3\u6240\u6b32\u5730\u8f6c\u5316\u6210[npc.she]\u671f\u671b\u7684\u59ff\u6001\uff0c\u4e14\u62e5\u6709\u7740\u5e9e\u5927\u7684\u5965\u672f\u4e4b\u529b\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(500.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(500.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(500.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.HEALTH_MAXIMUM, Float.valueOf(500.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MANA_MAXIMUM, Float.valueOf(500.0f))), Util.newArrayListOfValues("[style.boldExcellent(\u65e0\u9650\u5236)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u6211\u8f6c\u5316</b>", "<b style='color: " + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u514d\u75ab\u79cd\u65cf\u8f6c\u5316</b>"), "\u8389\u8389\u4e1d\u7684\u8840\u8109", "\u8389\u8389\u4e1d\u7684\u8840\u8109", "LILIN_BASIC", "LILIN_ADVANCED", Race.DEMON, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_LILIN, SubspeciesPreference.ONE_LOW, "\u4e00\u4f4d\u8389\u7433\u3002", null, null, null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 5000;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setSubspeciesOverride(LILIN);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                return 0;
            }

            @Override
            public AbstractAttribute getDamageMultiplier() {
                return Attribute.DAMAGE_LILIN;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        DEMON = new AbstractSubspecies(true, 120000, "innoxia_race_demon_liliths_gift", null, "statusEffects/race/raceDemon", "statusEffects/race/raceBackground", "\u6076\u9b54", "\u6076\u9b54", "\u6deb\u68a6\u9b54", "\u9b45\u9b54", "\u6deb\u68a6\u9b54", "\u9b45\u9b54", null, Nocturnality.CATHEMERAL, "\u7531\u4e8e\u6076\u9b54\u80fd\u8f7b\u677e\u5730\u9a7e\u9a6d\u5965\u672f\u4e4b\u529b\uff0c[npc.namePos]\u7684\u65bd\u6cd5\u80fd\u529b\u53ef\u6015\u5230\u65e0\u4eba\u80fd\u654c\uff01", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(30.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(100.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_SPELLS, Float.valueOf(75.0f))), Util.newArrayListOfValues("[style.boldDemon(\u6076\u9b54)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u4f53\u8f6c\u53d8</b>", "<b style='color: " + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u514d\u75ab\u79cd\u65cf\u8f6c\u5316</b>"), "\u6076\u9b54\u65cf\u7684\u8d77\u6e90", "\u6076\u9b54\u65cf\u7684\u8d77\u6e90", "DEMON_BASIC", "DEMON_ADVANCED", Race.DEMON, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.RACE_DEMON, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u4e2a\u666e\u901a\u7684\u6076\u9b54\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.THREE)), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 20;
            }

            @Override
            public String getFeralName(Body body) {
                if (body != null) {
                    AbstractRace r = body.getLegType().getRace();
                    LegConfiguration legConfiguration = body.getLegConfiguration();
                    switch (legConfiguration) {
                        case BIPEDAL: {
                            return "\u6076\u9b54";
                        }
                        case ARACHNID: 
                        case CEPHALOPOD: 
                        case QUADRUPEDAL: 
                        case TAIL: 
                        case TAIL_LONG: 
                        case AVIAN: 
                        case WINGED_BIPED: {
                            return r == Race.HUMAN || r == Race.DEMON ? Race.DEMON.getFeralName(new LegConfigurationAffinity(legConfiguration, this.getAffinity()), false) : "\u6076\u9b54" + r.getName(body, true);
                        }
                    }
                }
                return "\u6076\u9b54";
            }

            @Override
            public void applySpeciesChanges(Body body) {
                if (Math.random() < 0.25 && body.getLeg().getType().equals(LegType.DEMON_COMMON)) {
                    body.getLeg().setType(null, LegType.DEMON_HOOFED);
                }
                if (Math.random() < (double)0.2f && body.getPenis().getType() != PenisType.NONE) {
                    body.getPenis().getTesticle().setTesticleCount(null, 4);
                }
                if (body.getLegConfiguration() == LegConfiguration.BIPEDAL && body.getTailType() == TailType.DEMON_HORSE) {
                    body.setTailType(TailType.DEMON_COMMON);
                }
            }

            @Override
            public String getName(Body body) {
                if (body == null || body.getRaceStage() == RaceStage.GREATER) {
                    if (body != null) {
                        return ((String[])demonLegConfigurationNames.get((Object)body.getLegConfiguration()))[0];
                    }
                    return super.getName(body);
                }
                return HALF_DEMON.getName(body);
            }

            @Override
            public String getNamePlural(Body body) {
                if (body == null || body.getRaceStage() == RaceStage.GREATER) {
                    if (body != null) {
                        return ((String[])demonLegConfigurationNames.get((Object)body.getLegConfiguration()))[1];
                    }
                    return super.getNamePlural(body);
                }
                return HALF_DEMON.getNamePlural(body);
            }

            @Override
            public String getSingularMaleName(Body body) {
                if (body == null || body.getRaceStage() == RaceStage.GREATER) {
                    if (body != null) {
                        return ((String[])demonLegConfigurationNames.get((Object)body.getLegConfiguration()))[2];
                    }
                    return super.getSingularMaleName(body);
                }
                return HALF_DEMON.getSingularMaleName(body);
            }

            @Override
            public String getSingularFemaleName(Body body) {
                if (body == null || body.getRaceStage() == RaceStage.GREATER) {
                    if (body != null) {
                        return ((String[])demonLegConfigurationNames.get((Object)body.getLegConfiguration()))[3];
                    }
                    return super.getSingularFemaleName(body);
                }
                return HALF_DEMON.getSingularFemaleName(body);
            }

            @Override
            public String getPluralMaleName(Body body) {
                if (body == null || body.getRaceStage() == RaceStage.GREATER) {
                    if (body != null) {
                        return ((String[])demonLegConfigurationNames.get((Object)body.getLegConfiguration()))[4];
                    }
                    return super.getPluralMaleName(body);
                }
                return HALF_DEMON.getPluralMaleName(body);
            }

            @Override
            public String getPluralFemaleName(Body body) {
                if (body == null || body.getRaceStage() == RaceStage.GREATER) {
                    if (body != null) {
                        return ((String[])demonLegConfigurationNames.get((Object)body.getLegConfiguration()))[5];
                    }
                    return super.getPluralFemaleName(body);
                }
                return HALF_DEMON.getPluralFemaleName(body);
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character == null || character.getRaceStage() == RaceStage.GREATER) {
                    return super.getSVGString(character);
                }
                return HALF_DEMON.getSVGString(character);
            }

            @Override
            public String getSVGStringDesaturated(GameCharacter character) {
                if (character == null || character.getRaceStage() == RaceStage.GREATER) {
                    return super.getSVGStringDesaturated(character);
                }
                return HALF_DEMON.getSVGStringDesaturated(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.DEMON) {
                    return 100;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        HALF_DEMON = new AbstractSubspecies(false, 50000, "innoxia_race_demon_liliths_gift", null, "statusEffects/race/raceDemon", "statusEffects/race/raceBackground", "\u534a\u6076\u9b54", "\u534a\u6076\u9b54", "\u534a\u6deb\u68a6\u9b54", "\u534a\u9b45\u9b54", "\u534a\u6deb\u68a6\u9b54", "\u534a\u9b45\u9b54", null, Nocturnality.CATHEMERAL, "\u534a\u6076\u9b54\u5728\u9a7e\u9a6d\u5965\u672f\u4e4b\u529b\u65b9\u9762\u4e0e\u666e\u901a\u6076\u9b54\u65e0\u5f02\uff0c\u56e0\u800c[npc.namePos]\u91ca\u653e\u9b54\u6cd5\u7684\u80fd\u529b\u540c\u6837\u5f02\u4e4e\u5bfb\u5e38\uff01", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(20.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(20.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(20.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_SPELLS, Float.valueOf(60.0f))), Util.newArrayListOfValues("<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u6211\u8f6c\u5316\u53d7\u9650</b>", "<b style='color: " + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u514d\u75ab\u79cd\u65cf\u8f6c\u5316</b>"), "\u6076\u9b54\u6df7\u8840", "\u6076\u9b54\u6df7\u8840", "HALF_DEMON_BASIC", "HALF_DEMON_ADVANCED", Race.DEMON, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 2)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 2)), PresetColour.RACE_HALF_DEMON, SubspeciesPreference.FOUR_ABUNDANT, "\u662f\u6076\u9b54\u4e0e\u975e\u6076\u9b54\u914d\u5076\u4ea4\u914d\u7684\u7ed3\u679c", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.TWO)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.HARPY_NEST, SubspeciesSpawnRarity.TWO), new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TWO)), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 5;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                if (body.getLegConfiguration() == LegConfiguration.BIPEDAL && body.getTailType() == TailType.DEMON_HORSE) {
                    body.setTailType(TailType.DEMON_COMMON);
                }
            }

            @Override
            public String getFeralName(Body body) {
                if (body != null && body.getHalfDemonSubspecies() != null) {
                    return body.getHalfDemonSubspecies().getFeralName(body);
                }
                return DEMON.getFeralName(body);
            }

            @Override
            public String getName(Body body) {
                if (body == null || body.getHalfDemonSubspecies() == null) {
                    return super.getName(body);
                }
                return body.getHalfDemonSubspecies().getHalfDemonName(body)[0];
            }

            @Override
            public String getNamePlural(Body body) {
                if (body == null || body.getHalfDemonSubspecies() == null) {
                    return super.getNamePlural(body);
                }
                return body.getHalfDemonSubspecies().getHalfDemonName(body)[1];
            }

            @Override
            public String getSingularMaleName(Body body) {
                if (body == null || body.getHalfDemonSubspecies() == null) {
                    return super.getSingularMaleName(body);
                }
                return body.getHalfDemonSubspecies().getHalfDemonName(body)[2];
            }

            @Override
            public String getSingularFemaleName(Body body) {
                if (body == null || body.getHalfDemonSubspecies() == null) {
                    return super.getSingularFemaleName(body);
                }
                return body.getHalfDemonSubspecies().getHalfDemonName(body)[3];
            }

            @Override
            public String getPluralMaleName(Body body) {
                if (body == null || body.getHalfDemonSubspecies() == null) {
                    return super.getPluralMaleName(body);
                }
                return body.getHalfDemonSubspecies().getHalfDemonName(body)[4];
            }

            @Override
            public String getPluralFemaleName(Body body) {
                if (body == null || body.getHalfDemonSubspecies() == null) {
                    return super.getPluralFemaleName(body);
                }
                return body.getHalfDemonSubspecies().getHalfDemonName(body)[5];
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character == null || character.getHalfDemonSubspecies() == null) {
                    return HUMAN.getHalfDemonSVGString(character);
                }
                AbstractSubspecies coreSubspecies = character.getHalfDemonSubspecies();
                if (coreSubspecies == HALF_DEMON) {
                    coreSubspecies = HUMAN;
                }
                return coreSubspecies.getHalfDemonSVGString(character);
            }

            @Override
            public String getSVGStringDesaturated(GameCharacter character) {
                if (character == null || character.getHalfDemonSubspecies() == null) {
                    return HUMAN.getSVGStringDesaturated(character);
                }
                AbstractSubspecies coreSubspecies = character.getHalfDemonSubspecies();
                if (coreSubspecies == HALF_DEMON) {
                    coreSubspecies = HUMAN;
                }
                return coreSubspecies.getSVGStringDesaturated(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.DEMON && body.getRaceWeightMap().size() > 1) {
                    return 200;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        IMP = new AbstractSubspecies(false, 1000, "innoxia_race_imp_impish_brew", null, "statusEffects/race/raceImp", "statusEffects/race/raceBackground", "\u5c0f\u6076\u9b54", "\u5c0f\u6076\u9b54", "\u5c0f\u6076\u9b54", "\u5c0f\u6076\u9b54", "\u5c0f\u6076\u9b54", "\u5c0f\u6076\u9b54", null, Nocturnality.CATHEMERAL, "[npc.NamePos]\u7684\u5c0f\u6076\u9b54\u8eaf\u4f53\u5bf9\u6027\u6709\u7740\u6df1\u6c89\u4e14\u6c38\u4e0d\u6ee1\u8db3\u7684\u6e34\u671b\u3002\u7531\u4e8e\u5c0f\u6076\u9b54\u4e3e\u6b62\u7c97\u9c81\uff0c\u53c8\u5728\u793e\u4f1a\u7684\u6700\u5e95\u5c42\uff0c[npc.she]\u96be\u4ee5\u8bf1\u60d1\u4ed6\u4eba\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(-5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(200.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_LUST, Float.valueOf(-25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(-75.0f))), Util.newArrayListOfValues("[style.boldDemon(\u6076\u9b54)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u4f53\u8f6c\u53d8</b>", "<b style='color: " + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u514d\u75ab\u79cd\u65cf\u8f6c\u5316</b>"), "\u65e0\u6cd5\u65e0\u5929\u7684\u5c0f\u6076\u9b54", "\u65e0\u6cd5\u65e0\u5929\u7684\u5c0f\u6076\u9b54'", "IMP_BASIC", "IMP_ADVANCED", Race.DEMON, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 4), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 8), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 4), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_IMP, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u4e2a\u666e\u901a\u7684\u5c0f\u6076\u9b54\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 1;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setHeight(Height.NEGATIVE_TWO_MINIMUM.getRandomValue());
                body.getPenis().setPenisLength(null, 8 + Util.random.nextInt(8));
                body.getWing().setSize(null, WingSize.THREE_LARGE.getValue());
                if (body.getLegConfiguration() == LegConfiguration.BIPEDAL && body.getTailType() == TailType.DEMON_HORSE) {
                    body.setTailType(TailType.DEMON_COMMON);
                }
            }

            @Override
            public boolean isShortStature() {
                return true;
            }

            @Override
            public AbstractAttribute getDamageMultiplier() {
                return Attribute.DAMAGE_IMP;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.DEMON && body.getHeight() == Height.NEGATIVE_TWO_MINIMUM) {
                    return 150;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        IMP_ALPHA = new AbstractSubspecies(false, 1000, "innoxia_race_imp_impish_brew", null, "statusEffects/race/raceImpAlpha", "statusEffects/race/raceBackground", "\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54", "\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54", "\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54", "\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54", "\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54", "\u963f\u5c14\u6cd5\u5c0f\u6076\u9b54", null, Nocturnality.CATHEMERAL, "[npc.NamePos]\u7684\u5c0f\u6076\u9b54\u8eaf\u4f53\u5bf9\u6027\u6709\u7740\u6df1\u6c89\u4e14\u6c38\u4e0d\u6ee1\u8db3\u7684\u6e34\u671b\u3002\u7531\u4e8e\u5c0f\u6076\u9b54\u4e3e\u6b62\u7c97\u9c81\uff0c\u53c8\u5728\u793e\u4f1a\u7684\u6700\u5e95\u5c42\uff0c[npc.she]\u96be\u4ee5\u8bf1\u60d1\u4ed6\u4eba\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(200.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_LUST, Float.valueOf(-50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(-50.0f))), Util.newArrayListOfValues("[style.boldDemon(\u6076\u9b54)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u4f53\u8f6c\u53d8</b>", "<b style='color: " + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u514d\u75ab\u79cd\u65cf\u8f6c\u5316</b>"), "\u65e0\u6cd5\u65e0\u5929\u7684\u5c0f\u6076\u9b54", "\u65e0\u6cd5\u65e0\u5929\u7684\u5c0f\u6076\u9b54'", "IMP_BASIC", "IMP_ADVANCED", Race.DEMON, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 4), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 8), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 4), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_IMP, SubspeciesPreference.ONE_LOW, "\u5c0f\u6076\u9b54\u4e00\u79cd\u66f4\u52a0\u5f3a\u529b\u7684\u5f62\u6001\uff0c\u7ad9\u7acb\u7ea6\u6709[style.sizes(107)]\u9ad8\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 2;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setHeight(Height.NEGATIVE_ONE_TINY.getRandomValue());
                body.getPenis().setPenisLength(null, 8 + Util.random.nextInt(12));
                body.getWing().setSize(null, WingSize.THREE_LARGE.getValue());
                if (body.getLegConfiguration() == LegConfiguration.BIPEDAL && body.getTailType() == TailType.DEMON_HORSE) {
                    body.setTailType(TailType.DEMON_COMMON);
                }
            }

            @Override
            public boolean isShortStature() {
                return true;
            }

            @Override
            public AbstractAttribute getDamageMultiplier() {
                return Attribute.DAMAGE_IMP;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.DEMON && body.getHeight() == Height.NEGATIVE_ONE_TINY) {
                    return 150;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        COW_MORPH = new AbstractSubspecies(true, 15000, "innoxia_race_cow_bubble_milk", "innoxia_race_cow_bubble_cream", "statusEffects/race/raceCowMorph", "statusEffects/race/raceBackground", "\u725b\u5316\u5f62", "\u725b\u5316\u5f62", "\u725b\u7537", "\u725b\u5973", "\u725b\u7537", "\u725b\u5973", new FeralAttributes("\u725b", "\u725b", "\u516c\u725b", "\u6bcd\u725b", "\u516c\u725b", "\u6bcd\u725b", LegConfiguration.QUADRUPEDAL, 160, 0, 1, 1, 4, false), Nocturnality.DIURNAL, "\u5c3d\u7ba1[npc.namePos]\u7684\u8eab\u8eaf\u529b\u5927\u65e0\u7a77\uff0c\u575a\u97e7\u65e0\u6bd4\uff0c\u4f46\u5934\u8111\u5374\u5e76\u4e0d\u662f\u90a3\u4e48\u7075\u654f\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(30.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(-5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_PHYSICAL, Float.valueOf(2.0f))), null, "\u6324\u725b\u5976", "\u6324\u725b\u5976'", "COW_MORPH_BASIC", "COW_MORPH_ADVANCED", Race.COW_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_COW_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u725b\uff0c\u5f53\u4e0b\u80a2\u4e3a\u53cc\u8db3\u65f6\u79f0\u4e3a\u201c\u725b\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u725b\u517d\u6001\u65f6\u79f0\u4e3a\u201c\u534a\u516c\u725b\u4eba\u201d\u6216\u201c\u534a\u6bcd\u725b\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.TWO)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.THREE)), null, null){

            @Override
            public String[] getHalfDemonName(Body body) {
                return new String[]{"\u7c73\u8bfa\u9676\u6d1b\u65af", "\u7c73\u8bfa\u9676\u6d1b\u65af", "\u7c73\u8bfa\u9676\u6d1b\u65af", "\u7c73\u8bfa\u9676\u6d1b\u65af", "\u7c73\u8bfa\u9676\u6d1b\u65af", "\u7c73\u8bfa\u9676\u6d1b\u65af"};
            }

            @Override
            protected String applyNonBipedNameChange(Body body, String baseName, boolean applyFeminineForm, boolean plural) {
                if (body.getLegConfiguration() == LegConfiguration.QUADRUPEDAL) {
                    return applyFeminineForm ? "\u534a\u6bcd\u725b\u4eba" + (plural ? "" : "") : "\u534a\u516c\u725b\u4eba" + (plural ? "" : "");
                }
                return super.applyNonBipedNameChange(body, baseName, applyFeminineForm, plural);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.COW_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        DOG_MORPH = new AbstractSubspecies(true, 12000, "innoxia_race_dog_canine_crush", "innoxia_race_dog_canine_crunch", "statusEffects/race/raceDogMorph", "statusEffects/race/raceBackground", "\u72ac\u5316\u5f62", "\u72ac\u5316\u5f62", "\u72ac\u7537", "\u72ac\u5973", "\u72ac\u7537", "\u72ac\u5973", new FeralAttributes("\u72ac", "\u72ac", "\u72ac", "\u5a4a\u5b50", "\u72ac", "\u5a4a\u5b50", LegConfiguration.QUADRUPEDAL, 70, 0, 1, 5, 1, false), Nocturnality.DIURNAL, "[npc.Name]\u603b\u662f\u80fd\u91cf\u6ee1\u6ee1\uff0c\u4e14\u6781\u6613\u56e0\u65b0\u9c9c\u4e8b\u7269\u800c\u5174\u594b\u8d77\u6765\u3002[npc.she]\u8fd8\u6709\u7740\u4e00\u79cd\u6765\u6e90\u4e8e\u672c\u80fd\u7684\u6b32\u671b\uff0c\u60f3\u5bf9\u65e0\u8f9c\u7684\u732b\u5316\u5f62\u5c55\u793a\u5176\u652f\u914d\u5730\u4f4d\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.HEALTH_MAXIMUM, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.CAT_MORPH), Float.valueOf(5.0f))), null, "\u72ac\u7c7b\u6587\u5316", "\u72ac\u7c7b\u6587\u5316", "DOG_MORPH_BASIC", "DOG_MORPH_ADVANCED", Race.DOG_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_DOG_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u72d7\uff0c\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u72ac\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u72ac\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u72ac\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SAVANNAH, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, true), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", true, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, true), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.DOG_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        DOG_MORPH_BORDER_COLLIE = new AbstractSubspecies(false, 24000, "innoxia_race_dog_canine_crush", "innoxia_race_dog_canine_crunch", "statusEffects/race/raceDogMorph", "statusEffects/race/raceBackground", "\u8fb9\u7267\u5316\u5f62", "\u8fb9\u7267\u5316\u5f62", "\u8fb9\u7267\u7537", "\u8fb9\u7267\u5973", "\u8fb9\u7267\u7537", "\u8fb9\u7267\u5973", new FeralAttributes("\u8fb9\u7267", "\u8fb9\u7267", "\u8fb9\u7267\u72ac", "\u8fb9\u7267\u5a4a\u5b50", "\u8fb9\u7267\u72ac", "\u8fb9\u7267\u5a4a\u5b50", LegConfiguration.QUADRUPEDAL, 65, 0, 1, 5, 1, false), Nocturnality.DIURNAL, "[npc.NameIsFull]\u76f8\u6bd4\u4e00\u822c\u7684\u72ac\u5316\u5f62\u66f4\u52a0\u806a\u660e\uff0c\u5e76\u4e14\u603b\u6709\u4e00\u79cd\u5f3a\u70c8\u51b2\u52a8\uff0c\u60f3\u5c06\u5468\u56f4\u4eba\u805a\u96c6\u5728\u4e00\u8d77\u3002[npc.She]\u8fd8\u6709\u7740\u4e00\u79cd\u6765\u6e90\u4e8e\u672c\u80fd\u7684\u6b32\u671b\uff0c\u60f3\u5bf9\u65e0\u8f9c\u7684\u7ef5\u7f8a\u5316\u5f62\u5c55\u793a\u5176\u652f\u914d\u5730\u4f4d\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.HEALTH_MAXIMUM, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.getRaceFromId("innoxia_sheep")), Float.valueOf(25.0f))), null, "\u72ac\u7c7b\u6587\u5316", "\u72ac\u7c7b\u6587\u5316", "DOG_MORPH_BASIC", "DOG_MORPH_ADVANCED", Race.DOG_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 6), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 6), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_DOG_MORPH, SubspeciesPreference.TWO_AVERAGE, "\u4e00\u79cd\u683c\u5916\u806a\u660e\u4e5f\u6d3b\u529b\u56db\u5c04\u7684\u72ac\u5316\u5f62\uff0c\u5448\u73b0\u51fa\u4eba\u5f62\u8fb9\u5883\u7267\u7f8a\u72ac\u7684\u5916\u8c8c\u3002\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u8fb9\u7267\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u8fb9\u7267\u7684\u6837\u5b50\u65f6\u5219\u79f0\u4e3a\u201c\u534a\u8fb9\u7267\u4eba\u201d\u3002\u82e5\u8981\u88ab\u5224\u5b9a\u4e3a\u8fb9\u7267\u5316\u5f62\uff0c\u89d2\u8272\u5fc5\u987b\u662f\u72ac\u5316\u5f62\uff0c\u4e14\u62e5\u6709\u4e0a\u7ad6\u8033\u6216\u6298\u8033\uff0c\u5e76\u4e14\u62e5\u6709\u677e\u8f6f\u7684\u9ed1\u8272\u76ae\u6bdb\uff0c\u5e26\u6709\u767d\u8272\u82b1\u7eb9\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getCoverings().put(BodyCoveringType.CANINE_FUR, new Covering(BodyCoveringType.CANINE_FUR, CoveringPattern.MARKED, CoveringModifier.FLUFFY, PresetColour.COVERING_BLACK, false, PresetColour.COVERING_WHITE, false));
                if (body.getEar().getType() == EarType.DOG_MORPH) {
                    if (Math.random() < 0.5) {
                        body.getEar().setType(null, EarType.DOG_MORPH_POINTED);
                    } else {
                        body.getEar().setType(null, EarType.DOG_MORPH_FOLDED);
                    }
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, true), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", true, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, true), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.DOG_MORPH) {
                    AbstractBodyCoveringType canineFur;
                    AbstractBodyCoveringType abstractBodyCoveringType = canineFur = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FUR) : BodyCoveringType.CANINE_FUR;
                    if (body.getCoverings().get(canineFur).getPrimaryColour() == PresetColour.COVERING_BLACK && body.getCoverings().get(canineFur).getSecondaryColour() == PresetColour.COVERING_WHITE && body.getCoverings().get(canineFur).getPattern() == CoveringPattern.MARKED && body.getCoverings().get(canineFur).getModifier() == CoveringModifier.FLUFFY && (body.getEar().getType() == EarType.DOG_MORPH_FOLDED || body.getEar().getType() == EarType.DOG_MORPH_POINTED)) {
                        return 150;
                    }
                }
                return 0;
            }

            @Override
            public String getPathName() {
                return "res/race/neverLucky/dog/border_collie";
            }
        };
        DOG_MORPH_DOBERMANN = new AbstractSubspecies(false, 18000, "innoxia_race_dog_canine_crush", "innoxia_race_dog_canine_crunch", "statusEffects/race/raceDogMorphDobermann", "statusEffects/race/raceBackground", "\u675c\u5bbe\u5316\u5f62", "\u675c\u5bbe\u5316\u5f62", "\u675c\u5bbe\u7537", "\u675c\u5bbe\u5973", "\u675c\u5bbe\u7537", "\u675c\u5bbe\u5973", new FeralAttributes("\u675c\u5bbe\u5316\u5f62", "\u675c\u5bbe\u5316\u5f62", "\u675c\u5bbe\u72ac", "\u675c\u5bbe\u5a4a\u5b50", "\u675c\u5bbe\u72ac", "\u675c\u5bbe\u5a4a\u5b50", LegConfiguration.QUADRUPEDAL, 70, 0, 1, 5, 1, false), Nocturnality.DIURNAL, "[npc.NameIsFull]\u65f6\u523b\u51c6\u5907\u7740\u4fdd\u536b[npc.she]\u7684\u6bcf\u4e00\u4f4d\u670b\u53cb\uff0c\u501f\u52a9\u7740[npc.her]\u5f3a\u5065\u7684\u4f53\u9b44\uff0c\u901a\u5e38\u90fd\u80fd\u591f\u5982\u613f\u3002[npc.she]\u8fd8\u6709\u7740\u4e00\u79cd\u6765\u6e90\u4e8e\u672c\u80fd\u7684\u6b32\u671b\uff0c\u60f3\u5bf9\u65e0\u8f9c\u7684\u732b\u5316\u5f62\u5c55\u793a\u5176\u652f\u914d\u5730\u4f4d\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.CAT_MORPH), Float.valueOf(5.0f))), null, "\u72ac\u7c7b\u6587\u5316", "\u72ac\u7c7b\u6587\u5316", "DOG_MORPH_BASIC", "DOG_MORPH_ADVANCED", Race.DOG_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 6), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_DOG_MORPH, SubspeciesPreference.TWO_AVERAGE, "\u4e00\u79cd\u72ac\u5316\u5f62\uff0c\u5448\u73b0\u51fa\u4eba\u5f62\u675c\u5bbe\u72ac\u7684\u5916\u8c8c\u3002\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u675c\u5bbe\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u675c\u5bbe\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u675c\u5bbe\u4eba\u201d\u3002\u82e5\u8981\u88ab\u5224\u5b9a\u4e3a\u675c\u5bbe\u5316\u5f62\uff0c\u89d2\u8272\u5fc5\u987b\u662f\u72ac\u5316\u5f62\uff0c\u4e14\u62e5\u6709\u9ed1\u8272\u7684\u77ed\u76ae\u6bdb\uff0c\u5e26\u68d5\u8272\u3001\u6df1\u68d5\u8272\u3001\u68d5\u8910\u8272\u7684\u82b1\u7eb9\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                Colour secondaryColour = PresetColour.COVERING_BROWN;
                double rand = Math.random();
                if (rand < (double)0.3f) {
                    secondaryColour = PresetColour.COVERING_TAN;
                } else if (rand < (double)0.6f) {
                    secondaryColour = PresetColour.COVERING_BROWN_DARK;
                }
                body.getCoverings().put(BodyCoveringType.CANINE_FUR, new Covering(BodyCoveringType.CANINE_FUR, CoveringPattern.MARKED, CoveringModifier.SHORT, PresetColour.COVERING_BLACK, false, secondaryColour, false));
                body.getCoverings().put(BodyCoveringType.HAIR_CANINE_FUR, new Covering(BodyCoveringType.HAIR_CANINE_FUR, CoveringPattern.NONE, PresetColour.COVERING_BLACK, false, secondaryColour, false));
                body.getCoverings().put(BodyCoveringType.HUMAN, new Covering(BodyCoveringType.HUMAN, CoveringPattern.NONE, PresetColour.SKIN_EBONY, false, PresetColour.SKIN_EBONY, false));
                body.updateCoverings(true, true, true, true);
                if (body.getPenis().getType() == PenisType.DOG_MORPH) {
                    body.getCoverings().put(BodyCoveringType.PENIS, new Covering(BodyCoveringType.PENIS, PresetColour.SKIN_RED));
                }
                if (body.getEar().getType() == EarType.DOG_MORPH) {
                    body.getEar().setType(null, EarType.DOG_MORPH_POINTED);
                }
                if (body.getTail().getType() == TailType.DOG_MORPH) {
                    body.getTail().setType(null, TailType.DOG_MORPH_STUBBY);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, true), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", true, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, true), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.DOG_MORPH) {
                    AbstractBodyCoveringType canineFur;
                    AbstractBodyCoveringType abstractBodyCoveringType = canineFur = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FUR) : BodyCoveringType.CANINE_FUR;
                    if (!(body.getCoverings().get(canineFur).getPrimaryColour() != PresetColour.COVERING_BLACK && body.getCoverings().get(canineFur).getPrimaryColour() != PresetColour.COVERING_JET_BLACK || body.getCoverings().get(canineFur).getSecondaryColour() != PresetColour.COVERING_BROWN && body.getCoverings().get(canineFur).getSecondaryColour() != PresetColour.COVERING_BROWN_DARK && body.getCoverings().get(canineFur).getSecondaryColour() != PresetColour.COVERING_TAN || body.getCoverings().get(canineFur).getPattern() != CoveringPattern.MARKED || body.getCoverings().get(canineFur).getModifier() != CoveringModifier.SHORT)) {
                        return 150;
                    }
                }
                return 0;
            }
        };
        DOG_MORPH_GERMAN_SHEPHERD = new AbstractSubspecies(false, 18000, "innoxia_race_dog_canine_crush", "innoxia_race_dog_canine_crunch", "statusEffects/race/raceDogMorph", "statusEffects/race/raceBackground", "\u5fb7\u7267\u5316\u5f62", "\u5fb7\u7267\u5316\u5f62", "\u5fb7\u7267\u7537", "\u5fb7\u7267\u5973", "\u5fb7\u7267\u7537", "\u5fb7\u7267\u5973", new FeralAttributes("\u5fb7\u7267", "\u5fb7\u7267", "\u5fb7\u7267\u72ac", "\u5fb7\u7267\u5a4a\u5b50", "\u5fb7\u7267\u72ac", "\u5fb7\u7267\u5a4a\u5b50", LegConfiguration.QUADRUPEDAL, 70, 0, 1, 5, 1, false), Nocturnality.DIURNAL, "[npc.NameHasFull]\u62e5\u6709\u76f8\u5bf9\u539f\u59cb\u7684\u72fc\u4e00\u822c\u7684\u5916\u8c8c\uff0c\u76f8\u6bd4\u4e8e\u5176\u4ed6\u5927\u591a\u6570\u72ac\u5316\u5f62\u90fd\u66f4\u6709\u529b\u91cf\uff0c\u66f4\u52a0\u806a\u6167\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.HEALTH_MAXIMUM, Float.valueOf(5.0f))), null, "\u72ac\u7c7b\u6587\u5316", "\u72ac\u7c7b\u6587\u5316", "DOG_MORPH_BASIC", "DOG_MORPH_ADVANCED", Race.DOG_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 6), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 6), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_DOG_MORPH, SubspeciesPreference.TWO_AVERAGE, "\u4e00\u79cd\u5f3a\u58ee\u3001\u806a\u6167\u4e14\u5fe0\u8bda\u7684\u72ac\u5316\u5f62\u4e9a\u79cd\uff0c\u5448\u73b0\u51fa\u4eba\u5f62\u5fb7\u7267\u72ac\u7684\u5916\u8c8c\u3002\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u5fb7\u7267\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u5fb7\u7267\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u5fb7\u7267\u4eba\u201d\u3002\u8981\u88ab\u5224\u5b9a\u4e3a\u5fb7\u7267\u5316\u5f62\uff0c\u89d2\u8272\u5fc5\u987b\u662f\u72ac\u5316\u5f62\uff0c\u4e14\u62e5\u6709\u4e0a\u7ad6\u7684\u8033\u6735\uff0c\u4ee5\u53ca\u68d5\u8910\u8272\u82b1\u7eb9\u7684\u9ed1\u8272\u76ae\u6bdb\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.FIVE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.DOMINION, SubspeciesSpawnRarity.TEN), new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getCoverings().put(BodyCoveringType.CANINE_FUR, new Covering(BodyCoveringType.CANINE_FUR, CoveringPattern.MARKED, CoveringModifier.FLUFFY, PresetColour.COVERING_BLACK, false, PresetColour.COVERING_TAN, false));
                body.getCoverings().put(BodyCoveringType.HAIR_CANINE_FUR, new Covering(BodyCoveringType.HAIR_CANINE_FUR, CoveringPattern.NONE, PresetColour.COVERING_BLACK, false, PresetColour.COVERING_TAN, false));
                if (body.getEar().getType() == EarType.DOG_MORPH) {
                    body.getEar().setType(null, EarType.DOG_MORPH_POINTED);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac", "\u5730\u72f1\u730e\u72ac"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, true), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", true, false), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", false, true), this.applyNonBipedNameChange(body, "\u5730\u72f1\u730e\u72ac", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.DOG_MORPH) {
                    AbstractBodyCoveringType canineFur;
                    AbstractBodyCoveringType abstractBodyCoveringType = canineFur = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FUR) : BodyCoveringType.CANINE_FUR;
                    if (body.getCoverings().get(canineFur).getPrimaryColour() == PresetColour.COVERING_BLACK && body.getCoverings().get(canineFur).getSecondaryColour() == PresetColour.COVERING_TAN && body.getCoverings().get(canineFur).getPattern() == CoveringPattern.MARKED && body.getCoverings().get(canineFur).getModifier() == CoveringModifier.FLUFFY && body.getEar().getType() == EarType.DOG_MORPH_POINTED) {
                        return 150;
                    }
                }
                return 0;
            }
        };
        WOLF_MORPH = new AbstractSubspecies(true, 10000, "innoxia_race_wolf_wolf_whiskey", "innoxia_race_wolf_meat_and_marrow", "statusEffects/race/raceWolfMorph", "statusEffects/race/raceBackground", "\u72fc\u5316\u5f62", "\u72fc\u5316\u5f62", "\u72fc\u7537", "\u72fc\u5973", "\u72fc\u7537", "\u72fc\u5973", new FeralAttributes("\u72fc", "\u72fc", "\u72fc", "\u72fc", "\u72fc", "\u72fc", LegConfiguration.QUADRUPEDAL, 80, 0, 1, 4, 1, false), Nocturnality.NOCTURNAL, "[npc.NamePos]\u72fc\u4e00\u822c\u7684\u8eab\u8eaf\u683c\u5916\u6709\u529b\uff0c\u7ecf\u5e38\u62e5\u6709\u4e00\u79cd\u5f3a\u70c8\u7684\u51b2\u52a8\uff0c\u60f3\u8981\u652f\u914d\u89c1\u5230\u7684\u4efb\u4f55\u4eba\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(20.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_UNARMED, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.getRaceFromId("innoxia_sheep")), Float.valueOf(25.0f))), null, "\u6f5c\u884c\u4e4b\u72fc", "\u6f5c\u884c\u4e4b\u72fc", "WOLF_MORPH_BASIC", "WOLF_MORPH_ADVANCED", Race.WOLF_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_WOLF_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u72fc\uff0c\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u6210\u4e3a\u201c\u72fc\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u72fc\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u72fc\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.FIVE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public String getName(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && (body == null || !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL)) {
                    return "\u55f7\u545c\u5316\u5f62";
                }
                return super.getName(body);
            }

            @Override
            public String getNamePlural(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && (body == null || !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL)) {
                    return "\u55f7\u545c\u5316\u5f62";
                }
                return super.getNamePlural(body);
            }

            @Override
            public String getSingularMaleName(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && body != null && !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL) {
                    return "\u55f7\u545c\u5c0f\u5b50";
                }
                return super.getSingularMaleName(body);
            }

            @Override
            public String getSingularFemaleName(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && body != null && !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL) {
                    return "\u55f7\u545c\u5973";
                }
                return super.getSingularFemaleName(body);
            }

            @Override
            public void applySpeciesChanges(Body body) {
                ArrayList<Colour> naturalWolfFurColours = Util.newArrayListOfValues(PresetColour.COVERING_GREY, PresetColour.COVERING_BLACK, PresetColour.COVERING_JET_BLACK);
                Colour c = Util.randomItemFrom(naturalWolfFurColours);
                body.getCoverings().put(BodyCoveringType.LYCAN_FUR, new Covering(BodyCoveringType.LYCAN_FUR, c));
                body.getCoverings().put(BodyCoveringType.HAIR_LYCAN_FUR, new Covering(BodyCoveringType.HAIR_LYCAN_FUR, c));
                body.getCoverings().put(BodyCoveringType.BODY_HAIR_LYCAN_FUR, new Covering(BodyCoveringType.BODY_HAIR_LYCAN_FUR, c));
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u5ea7\u72fc", "\u5ea7\u72fc", "\u5ea7\u72fc", "\u5ea7\u72fc", "\u5ea7\u72fc", "\u5ea7\u72fc"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u5ea7\u72fc", false, false), this.applyNonBipedNameChange(body, "\u5ea7\u72fc", false, true), this.applyNonBipedNameChange(body, "\u5ea7\u72fc", false, false), this.applyNonBipedNameChange(body, "\u5ea7\u72fc", true, false), this.applyNonBipedNameChange(body, "\u5ea7\u72fc", false, true), this.applyNonBipedNameChange(body, "\u5ea7\u72fc", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.WOLF_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        FOX_MORPH = new AbstractSubspecies(true, 16000, "innoxia_race_fox_vulpines_vineyard", "innoxia_race_fox_chicken_pot_pie", "statusEffects/race/raceFoxMorph", "statusEffects/race/raceBackground", "\u72d0\u5316\u5f62", "\u72d0\u5316\u5f62", "\u72d0\u7537", "\u72d0\u5973", "\u72d0\u7537", "\u72d0\u5973", new FeralAttributes("\u72d0\u72f8", "\u72d0\u72f8", "\u72d0\u72f8", "\u96cc\u72d0", "\u72d0\u72f8", "\u96cc\u72d0", LegConfiguration.QUADRUPEDAL, 45, 0, 1, 4, 1, false), Nocturnality.CREPUSCULAR, "[npc.NameIsFull]\u654f\u6377\u53c8\u72e1\u733e\uff0c[npc.sheIs]\u80fd\u591f\u5229\u7528\u654f\u9510\u7684\u611f\u5b98\u68c0\u6d4b\u5230\u4efb\u4f55\u80fd\u591f\u653b\u51fb\u7684\u673a\u4f1a\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.ENERGY_SHIELDING, Float.valueOf(1.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f))), null, "\u9690\u533f\u4e4b\u72d0", "\u9690\u533f\u4e4b\u72d0", "FOX_MORPH_BASIC", "FOX_MORPH_ADVANCED", Race.FOX_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 6), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 6), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_FOX_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u72d0\u72f8\uff0c\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u72d0\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u72d0\u72f8\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u72d0\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                AbstractSubspecies.applyFoxColoring(body);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.FOX_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        FOX_MORPH_ARCTIC = new AbstractSubspecies(false, 20000, "innoxia_race_fox_vulpines_vineyard", "innoxia_race_fox_chicken_pot_pie", "statusEffects/race/raceFoxMorph", "statusEffects/race/raceBackground", "\u5317\u6781\u72d0\u5316\u5f62", "\u5317\u6781\u72d0\u5316\u5f62", "\u5317\u6781\u72d0\u7537", "\u5317\u6781\u72d0\u5973", "\u5317\u6781\u72d0\u7537", "\u5317\u6781\u72d0\u5973", new FeralAttributes("\u5317\u6781\u72d0", "\u5317\u6781\u72d0", "\u96c4\u5317\u6781\u72d0", "\u96cc\u5317\u6781\u72d0", "\u96c4\u5317\u6781\u72d0", "\u96cc\u5317\u6781\u72d0", LegConfiguration.QUADRUPEDAL, 30, 0, 1, 4, 1, false), Nocturnality.NOCTURNAL, "[npc.NameIsFull]\u654f\u6377\u53c8\u72e1\u733e\uff0c[npc.sheIs]\u80fd\u591f\u5229\u7528\u654f\u9510\u7684\u611f\u5b98\u68c0\u6d4b\u5230\u4efb\u4f55\u80fd\u591f\u653b\u51fb\u7684\u673a\u4f1a\u3002\u7531\u4e8e[npc.sheIsFull]\u9002\u5e94\u4e86\u5317\u6781\u7684\u73af\u5883\uff0c\u6240\u4ee5\u80fd\u591f\u5f88\u597d\u5730\u62b5\u6297\u88ad\u6765\u7684\u5bd2\u51b7\u4f24\u5bb3\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.ENERGY_SHIELDING, Float.valueOf(1.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_ICE, Float.valueOf(5.0f))), null, "\u9690\u533f\u4e4b\u72d0", "\u9690\u533f\u4e4b\u72d0", "FOX_MORPH_BASIC", "FOX_MORPH_ADVANCED", Race.FOX_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_FOX_MORPH_ARCTIC, SubspeciesPreference.ONE_LOW, "\u4e00\u79cd\u4eba\u5f62\u7684\u72d0\u72f8\uff0c\u5e26\u6709\u767d\u8272\u76ae\u6bdb\uff0c\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u5317\u6781\u72d0\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u72d0\u72f8\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u5317\u6781\u72d0\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SNOW, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.THREE)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getCoverings().put(BodyCoveringType.HUMAN, new Covering(BodyCoveringType.HUMAN, CoveringPattern.NONE, PresetColour.SKIN_PALE, false, PresetColour.SKIN_PALE, true));
                body.getCoverings().put(BodyCoveringType.FOX_FUR, new Covering(BodyCoveringType.FOX_FUR, CoveringPattern.NONE, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false));
                body.getCoverings().put(BodyCoveringType.HAIR_FOX_FUR, new Covering(BodyCoveringType.HAIR_FOX_FUR, CoveringPattern.NONE, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false));
                body.getCoverings().put(BodyCoveringType.BODY_HAIR_FOX_FUR, new Covering(BodyCoveringType.BODY_HAIR_FOX_FUR, CoveringPattern.NONE, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false));
                body.updateCoverings(false, false, true, true);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.FOX_MORPH) {
                    AbstractBodyCoveringType foxFur = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FUR) : BodyCoveringType.FOX_FUR;
                    Covering fox_fur = body.getCoverings().get(foxFur);
                    if (fox_fur.getPrimaryColour() == PresetColour.COVERING_WHITE && body.getEar().getType() != EarType.FOX_MORPH_BIG && body.getTail().getType() != TailType.FOX_MORPH_MAGIC) {
                        return 150;
                    }
                }
                return 0;
            }
        };
        FOX_MORPH_FENNEC = new AbstractSubspecies(false, 16000, "innoxia_race_fox_vulpines_vineyard", "innoxia_race_fox_chicken_pot_pie", "statusEffects/race/raceFoxMorph", "statusEffects/race/raceBackground", "\u8033\u5ed3\u72d0\u5316\u5f62", "\u8033\u5ed3\u72d0\u5316\u5f62", "\u8033\u5ed3\u72d0\u7537", "\u8033\u5ed3\u72d0\u5973", "\u8033\u5ed3\u72d0\u7537", "\u8033\u5ed3\u72d0\u5973", new FeralAttributes("\u8033\u5ed3\u72d0", "\u8033\u5ed3\u72d0", "\u8033\u5ed3\u72d0", "\u8033\u5ed3\u96cc\u72d0", "\u8033\u5ed3\u72d0", "\u8033\u5ed3\u96cc\u72d0", LegConfiguration.QUADRUPEDAL, 20, 0, 1, 4, 1, false), Nocturnality.CREPUSCULAR, "[npc.NameIsFull]\u654f\u6377\u53c8\u72e1\u733e\uff0c[npc.sheIs]\u80fd\u591f\u5229\u7528\u654f\u9510\u7684\u611f\u5b98\u68c0\u6d4b\u5230\u4efb\u4f55\u80fd\u591f\u653b\u51fb\u7684\u673a\u4f1a\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.ENERGY_SHIELDING, Float.valueOf(1.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f))), null, "\u9690\u533f\u4e4b\u72d0", "\u9690\u533f\u4e4b\u72d0", "FOX_MORPH_BASIC", "FOX_MORPH_ADVANCED", Race.FOX_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_FOX_MORPH_FENNEC, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u72d0\u72f8\uff0c\u8033\u6735\u683c\u5916\u5927\uff0c\u5e26\u6709\u68d5\u8910\u8272\u3001\u7070\u91d1\u8272\u6216\u4eae\u91d1\u8272\u7684\u76ae\u6bdb\u3002\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u8033\u5ed3\u72d0\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u8033\u5ed3\u72d0\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u8033\u5ed3\u72d0\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.FIVE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                Colour fennecColour = Util.randomItemFrom(Util.newArrayListOfValues(PresetColour.COVERING_DIRTY_BLONDE, PresetColour.COVERING_BLEACH_BLONDE, PresetColour.COVERING_TAN));
                body.getCoverings().put(BodyCoveringType.FOX_FUR, new Covering(BodyCoveringType.FOX_FUR, CoveringPattern.NONE, fennecColour, false, fennecColour, false));
                body.getCoverings().put(BodyCoveringType.HAIR_FOX_FUR, new Covering(BodyCoveringType.FOX_FUR, CoveringPattern.NONE, fennecColour, false, fennecColour, false));
                body.getCoverings().put(BodyCoveringType.HUMAN, new Covering(BodyCoveringType.HUMAN, CoveringPattern.NONE, PresetColour.SKIN_OLIVE, false, PresetColour.SKIN_OLIVE, false));
                body.updateCoverings(true, true, true, true);
                if (body.getPenis().getType() == PenisType.FOX_MORPH) {
                    body.getCoverings().put(BodyCoveringType.PENIS, new Covering(BodyCoveringType.PENIS, PresetColour.SKIN_RED));
                }
                if (body.getEar().getType() == EarType.FOX_MORPH) {
                    body.getEar().setType(null, EarType.FOX_MORPH_BIG);
                }
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.FOX_MORPH && body.getEar().getType() == EarType.FOX_MORPH_BIG && body.getTail().getType() != TailType.FOX_MORPH_MAGIC) {
                    return 150;
                }
                return 0;
            }

            @Override
            public String getPathName() {
                return "res/race/neverLucky/fox/fennec";
            }

            @Override
            public int getIconSize() {
                return 70;
            }
        };
        FOX_ASCENDANT = new AbstractSubspecies(false, 15000, "innoxia_race_fox_vulpines_vineyard", "innoxia_race_fox_chicken_pot_pie", "statusEffects/race/raceFoxMorph", "statusEffects/race/raceBackground", "\u5996\u72d0", "\u5996\u72d0", "\u5996\u72d0\u7537", "\u5996\u72d0\u5973", "\u5996\u72d0\u7537", "\u5996\u72d0\u5973", new FeralAttributes("\u5996\u72d0\u72d0\u72f8", "\u5996\u72d0\u72d0\u72f8", "\u96c4\u5996\u72d0", "\u96cc\u5996\u72d0", "\u96c4\u5996\u72d0", "\u96cc\u5996\u72d0", LegConfiguration.QUADRUPEDAL, 50, 0, 1, 4, 1, false), Nocturnality.CATHEMERAL, "", null, null, "\u4e5d\u5c3e\u72d0", "\u72d0\u4e4b\u4e5d\u5c3e", "FOX_MORPH_BASIC", "FOX_MORPH_ADVANCED", Race.FOX_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 10)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.RACE_FOX_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u53ea\u72d0\u5316\u5f62\uff0c\u88ab\u4e00\u4f4d\u8389\u7433\u8d50\u4e88\u4e86\u529b\u91cf\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.YOUKO_FOREST, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.DISABLE_SPAWN_PREFERENCE)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 40;
            }

            @Override
            public int getBaseSlaveValue(GameCharacter character) {
                if (character == null) {
                    return 15000;
                }
                return 15000 * character.getMaxTailCount();
            }

            @Override
            public boolean isAbleToSelfTransform() {
                return true;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                AbstractSubspecies.applyFoxColoring(body);
                if (body.getTail().getType() == TailType.FOX_MORPH) {
                    body.getTail().setType(null, TailType.FOX_MORPH_MAGIC);
                }
            }

            @Override
            public String getStatusEffectDescription(GameCharacter character) {
                if (character.getMaxTailCount() < 9) {
                    return UtilText.parse(character, "[npc.NameIsFull]\u662f\u4e00\u53ea\u72d0\u5316\u5f62\uff0c\u901a\u8fc7\u4e3a\u67d0\u4f4d\u8389\u7433\u6548\u529b\u4ece\u800c\u5f97\u5230\u4e86[npc.tailMaxCount]\u6839\u5965\u672f\u4e4b\u5c3e\u3002", new ParserTag[0]);
                }
                return UtilText.parse(character, "[npc.NameIsFull]\u662f\u4e00\u53ea\u72d0\u5316\u5f62\uff0c\u5176\u6570\u6761\u5965\u672f\u4e4b\u5c3e\u9884\u793a\u7740[npc.her]\u5df2\u7ecf\u5411\u67d0\u4f4d\u8389\u7433\u732e\u51fa\u4e86\u65e0\u4f11\u65e0\u6b62\u7684\u5fe0\u8bda\u3002", new ParserTag[0]);
            }

            @Override
            public Map<AbstractAttribute, Float> getStatusEffectAttributeModifiers(GameCharacter character) {
                if (character != null && character.getMaxTailCount() < 9) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(10 * character.getMaxTailCount())), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(10 + 5 * character.getMaxTailCount())), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(20 + 5 * character.getMaxTailCount())));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(100.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(60.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(100.0f)));
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character == null) {
                    return (String)youkoIconMap.get(9);
                }
                return this.getBipedBackground((String)youkoIconMap.get(character.getMaxTailCount()), character, this.getColour(character));
            }

            @Override
            public String getSVGStringDesaturated(GameCharacter character) {
                if (character == null) {
                    return (String)youkoDesaturatedIconMap.get(9);
                }
                return this.getBipedBackground((String)youkoDesaturatedIconMap.get(character.getMaxTailCount()), character, PresetColour.BASE_GREY);
            }

            @Override
            public String getHalfDemonSVGString(GameCharacter character) {
                if (character != null && character.getSubspeciesOverride() != null && character.getSubspeciesOverride().equals(DEMON)) {
                    return super.getHalfDemonSVGString(character);
                }
                return this.getBipedBackground((String)youkoHalfDemonIconMap.get(character.getMaxTailCount()), character, PresetColour.RACE_HALF_DEMON);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.FOX_MORPH && body.getTail().getType() == TailType.FOX_MORPH_MAGIC) {
                    body.setSubspeciesOverride(FOX_ASCENDANT);
                    return 200;
                }
                return 0;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        FOX_ASCENDANT_ARCTIC = new AbstractSubspecies(false, 15000, "innoxia_race_fox_vulpines_vineyard", "innoxia_race_fox_chicken_pot_pie", "statusEffects/race/raceFoxMorph", "statusEffects/race/raceBackground", "\u5317\u6781\u5996\u72d0", "\u5317\u6781\u5996\u72d0", "\u5317\u6781\u5996\u72d0\u7537", "\u5317\u6781\u5996\u72d0\u5973", "\u5317\u6781\u5996\u72d0\u7537", "\u5317\u6781\u5996\u72d0\u5973", new FeralAttributes("\u5317\u6781\u5996\u72d0\u72d0\u72f8", "\u5317\u6781\u5996\u72d0\u72d0\u72f8", "\u5317\u6781\u5996\u72d0\u96c4\u72d0", "\u5317\u6781\u5996\u72d0\u96cc\u72d0", "\u5317\u6781\u5996\u72d0\u96c4\u72d0", "\u5317\u6781\u5996\u72d0\u96cc\u72d0", LegConfiguration.QUADRUPEDAL, 40, 0, 1, 4, 1, false), Nocturnality.CATHEMERAL, "", null, null, "\u72d0\u4e4b\u4e5d\u5c3e", "\u72d0\u4e4b\u4e5d\u5c3e", "FOX_MORPH_BASIC", "FOX_MORPH_ADVANCED", Race.FOX_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 10)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.RACE_FOX_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u53ea\u5317\u6781\u72d0\u5316\u5f62\uff0c\u88ab\u4e00\u4f4d\u8389\u7433\u8d50\u4e88\u4e86\u529b\u91cf\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.YOUKO_FOREST, SubspeciesSpawnRarity.TWO)), (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.DISABLE_SPAWN_PREFERENCE)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 40;
            }

            @Override
            public int getBaseSlaveValue(GameCharacter character) {
                if (character == null) {
                    return 15000;
                }
                return 15000 * character.getMaxTailCount();
            }

            @Override
            public boolean isAbleToSelfTransform() {
                return true;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.getCoverings().put(BodyCoveringType.HUMAN, new Covering(BodyCoveringType.HUMAN, CoveringPattern.NONE, PresetColour.SKIN_PALE, false, PresetColour.SKIN_PALE, true));
                body.getCoverings().put(BodyCoveringType.FOX_FUR, new Covering(BodyCoveringType.FOX_FUR, CoveringPattern.NONE, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false));
                body.getCoverings().put(BodyCoveringType.HAIR_FOX_FUR, new Covering(BodyCoveringType.HAIR_FOX_FUR, CoveringPattern.NONE, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false));
                body.getCoverings().put(BodyCoveringType.BODY_HAIR_FOX_FUR, new Covering(BodyCoveringType.BODY_HAIR_FOX_FUR, CoveringPattern.NONE, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false));
                if (body.getTail().getType() == TailType.FOX_MORPH) {
                    body.getTail().setType(null, TailType.FOX_MORPH_MAGIC);
                }
                body.updateCoverings(false, false, true, true);
            }

            @Override
            public String getStatusEffectDescription(GameCharacter character) {
                if (character.getMaxTailCount() < 9) {
                    return UtilText.parse(character, "[npc.NameIsFull]\u662f\u4e00\u53ea\u5317\u6781\u72d0\u5316\u5f62\uff0c\u901a\u8fc7\u4e3a\u67d0\u4f4d\u8389\u7433\u6548\u529b\u4ece\u800c\u5f97\u5230\u4e86[npc.tailMaxCount]\u6839\u5965\u672f\u4e4b\u5c3e\u3002", new ParserTag[0]);
                }
                return UtilText.parse(character, "[npc.NameIsFull]\u662f\u4e00\u53ea\u5317\u6781\u72d0\u5316\u5f62\uff0c\u5176\u6570\u6761\u5965\u672f\u4e4b\u5c3e\u9884\u793a\u7740[npc.her]\u5df2\u7ecf\u5411\u67d0\u4f4d\u8389\u7433\u732e\u51fa\u4e86\u65e0\u4f11\u65e0\u6b62\u7684\u5fe0\u8bda\u3002", new ParserTag[0]);
            }

            @Override
            public Map<AbstractAttribute, Float> getStatusEffectAttributeModifiers(GameCharacter character) {
                if (character != null && character.getMaxTailCount() < 9) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(10 * character.getMaxTailCount())), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(10 + 5 * character.getMaxTailCount())), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(20 + 5 * character.getMaxTailCount())));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(100.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(60.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(100.0f)));
            }

            @Override
            public String getSVGString(GameCharacter character) {
                return FOX_ASCENDANT.getSVGString(character);
            }

            @Override
            public String getSVGStringDesaturated(GameCharacter character) {
                return FOX_ASCENDANT.getSVGStringDesaturated(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.FOX_MORPH) {
                    AbstractBodyCoveringType foxFur = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FUR) : BodyCoveringType.FOX_FUR;
                    Covering fox_fur = body.getCoverings().get(foxFur);
                    if (fox_fur.getPrimaryColour() == PresetColour.COVERING_WHITE && body.getEar().getType() != EarType.FOX_MORPH_BIG && body.getTail().getType() == TailType.FOX_MORPH_MAGIC) {
                        body.setSubspeciesOverride(FOX_ASCENDANT_ARCTIC);
                        return 250;
                    }
                }
                return 0;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        FOX_ASCENDANT_FENNEC = new AbstractSubspecies(false, 15000, "innoxia_race_fox_vulpines_vineyard", "innoxia_race_fox_chicken_pot_pie", "statusEffects/race/raceFoxMorph", "statusEffects/race/raceBackground", "\u8033\u5ed3\u5996\u72d0", "\u8033\u5ed3\u5996\u72d0", "\u8033\u5ed3\u5996\u72d0\u7537", "\u8033\u5ed3\u5996\u72d0\u5973", "\u8033\u5ed3\u5996\u72d0\u7537", "\u8033\u5ed3\u5996\u72d0\u5973", new FeralAttributes("\u8033\u5ed3\u5996\u72d0\u72d0\u72f8", "\u8033\u5ed3\u5996\u72d0\u72d0\u72f8", "\u8033\u5ed3\u5996\u72d0\u96c4\u72d0", "\u8033\u5ed3\u5996\u72d0\u96cc\u72d0", "\u8033\u5ed3\u5996\u72d0\u96c4\u72d0", "\u8033\u5ed3\u5996\u72d0\u96cc\u72d0", LegConfiguration.QUADRUPEDAL, 30, 0, 1, 4, 1, false), Nocturnality.CATHEMERAL, "", null, null, "\u72d0\u4e4b\u4e5d\u5c3e", "\u72d0\u4e4b\u4e5d\u5c3e", "FOX_MORPH_BASIC", "FOX_MORPH_ADVANCED", Race.FOX_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 10)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.RACE_FOX_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u53ea\u8033\u5ed3\u72d0\u5316\u5f62\uff0c\u88ab\u4e00\u4f4d\u8389\u7433\u8d50\u4e88\u4e86\u529b\u91cf\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.YOUKO_FOREST, SubspeciesSpawnRarity.ONE)), (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.DISABLE_SPAWN_PREFERENCE)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 40;
            }

            @Override
            public int getBaseSlaveValue(GameCharacter character) {
                if (character == null) {
                    return 15000;
                }
                return 15000 * character.getMaxTailCount();
            }

            @Override
            public boolean isAbleToSelfTransform() {
                return true;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                Colour fennecColour = PresetColour.COVERING_BLEACH_BLONDE;
                double rand = Math.random();
                if (rand < 0.5) {
                    fennecColour = PresetColour.COVERING_DIRTY_BLONDE;
                }
                body.getCoverings().put(BodyCoveringType.FOX_FUR, new Covering(BodyCoveringType.FOX_FUR, CoveringPattern.NONE, fennecColour, false, fennecColour, false));
                body.getCoverings().put(BodyCoveringType.HAIR_FOX_FUR, new Covering(BodyCoveringType.FOX_FUR, CoveringPattern.NONE, fennecColour, false, fennecColour, false));
                body.getCoverings().put(BodyCoveringType.HUMAN, new Covering(BodyCoveringType.HUMAN, CoveringPattern.NONE, PresetColour.SKIN_OLIVE, false, PresetColour.SKIN_OLIVE, false));
                body.updateCoverings(true, true, true, true);
                if (body.getPenis().getType() == PenisType.FOX_MORPH) {
                    body.getCoverings().put(BodyCoveringType.PENIS, new Covering(BodyCoveringType.PENIS, PresetColour.SKIN_RED));
                }
                if (body.getEar().getType() == EarType.FOX_MORPH) {
                    body.getEar().setType(null, EarType.FOX_MORPH_BIG);
                }
                if (body.getTail().getType() == TailType.FOX_MORPH) {
                    body.getTail().setType(null, TailType.FOX_MORPH_MAGIC);
                }
            }

            @Override
            public String getStatusEffectDescription(GameCharacter character) {
                if (character.getMaxTailCount() < 9) {
                    return UtilText.parse(character, "[npc.NameIsFull]\u662f\u4e00\u53ea\u8033\u5ed3\u72d0\u5316\u5f62\uff0c\u901a\u8fc7\u4e3a\u67d0\u4f4d\u8389\u7433\u6548\u529b\u4ece\u800c\u5f97\u5230\u4e86[npc.tailMaxCount]\u6839\u5965\u672f\u4e4b\u5c3e\u3002", new ParserTag[0]);
                }
                return UtilText.parse(character, "[npc.NameIsFull]\u662f\u4e00\u53ea\u8033\u5ed3\u72d0\u5316\u5f62\uff0c\u5176\u6570\u6761\u5965\u672f\u4e4b\u5c3e\u9884\u793a\u7740[npc.her]\u5df2\u7ecf\u5411\u67d0\u4f4d\u8389\u7433\u732e\u51fa\u4e86\u65e0\u4f11\u65e0\u6b62\u7684\u5fe0\u8bda\u3002", new ParserTag[0]);
            }

            @Override
            public Map<AbstractAttribute, Float> getStatusEffectAttributeModifiers(GameCharacter character) {
                if (character != null && character.getMaxTailCount() < 9) {
                    return Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(10 * character.getMaxTailCount())), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(10 + 5 * character.getMaxTailCount())), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(20 + 5 * character.getMaxTailCount())));
                }
                return Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(100.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(60.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(100.0f)));
            }

            @Override
            public String getSVGString(GameCharacter character) {
                return FOX_ASCENDANT.getSVGString(character);
            }

            @Override
            public String getSVGStringDesaturated(GameCharacter character) {
                return FOX_ASCENDANT.getSVGStringDesaturated(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.FOX_MORPH && body.getEar().getType() == EarType.FOX_MORPH_BIG && body.getTail().getType() == TailType.FOX_MORPH_MAGIC) {
                    body.setSubspeciesOverride(FOX_ASCENDANT_FENNEC);
                    return 250;
                }
                return 0;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        CAT_MORPH = new AbstractSubspecies(true, 12000, "innoxia_race_cat_felines_fancy", "innoxia_race_cat_kittys_reward", "statusEffects/race/raceCatMorph", "statusEffects/race/raceBackground", "\u732b\u5316\u5f62", "\u732b\u5316\u5f62", "\u732b\u7537", "\u732b\u5973", "\u732b\u7537", "\u732b\u5973", new FeralAttributes("\u732b", "\u732b", "\u516c\u732b", "\u6bcd\u732b", "\u516c\u732b", "\u6bcd\u732b", LegConfiguration.QUADRUPEDAL, 25, 0, 1, 4, 1, false), Nocturnality.CREPUSCULAR, "[npc.NamePos]\u7684\u8eab\u4f53\u5c24\u5176\u654f\u6377\uff0c\u53cd\u5e94\u5982\u95ea\u7535\u822c\u8fc5\u901f\u3002[npc.She]\u8fd8\u6709\u7740\u4e00\u79cd\u6765\u6e90\u4e8e\u672c\u80fd\u7684\u6b32\u671b\uff0c\u60f3\u5bf9\u65e0\u8f9c\u7684\u54c8\u6bd4\u548c\u556e\u9f7f\u7c7b\u5316\u5f62\u5c55\u793a\u5176\u652f\u914d\u5730\u4f4d\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.HARPY), Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.RAT_MORPH), Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.SQUIRREL_MORPH), Float.valueOf(5.0f))), null, "\u597d\u5947\u5c0f\u732b\u54aa", "\u597d\u5947\u5c0f\u732b\u54aa", "CAT_MORPH_BASIC", "CAT_MORPH_ADVANCED", Race.CAT_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_CAT_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u732b\uff0c\u5f53\u4e0b\u80a2\u62df\u4eba\u65f6\u88ab\u79f0\u4e3a\u201c\u732b\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u7ecf\u5178\u7684\u5927\u578b\u517d\u6001\u732b\u7684\u6837\u5b50\u65f6\u5219\u79f0\u4e3a\u201c\u534a\u732b\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SAVANNAH, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public String getName(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && (body == null || !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL)) {
                    return "\u55b5\u5316\u5f62";
                }
                return super.getName(body);
            }

            @Override
            public String getNamePlural(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && (body == null || !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL)) {
                    return "\u55b5\u5316\u5f62";
                }
                return super.getNamePlural(body);
            }

            @Override
            public String getSingularMaleName(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && body != null && !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL) {
                    return "\u55b5\u55b5\u5c0f\u5b50";
                }
                return super.getSingularMaleName(body);
            }

            @Override
            public String getSingularFemaleName(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && body != null && !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL) {
                    return "\u55b5\u55b5\u5973";
                }
                return super.getSingularFemaleName(body);
            }

            @Override
            public void applySpeciesChanges(Body body) {
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.CAT_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        CAT_MORPH_LYNX = new AbstractSubspecies(false, 12000, "innoxia_race_cat_felines_fancy", "innoxia_race_cat_kittys_reward", "statusEffects/race/raceCatMorph", "statusEffects/race/raceBackground", "\u731e\u7301\u5316\u5f62", "\u731e\u7301\u5316\u5f62", "\u731e\u7301\u7537", "\u731e\u7301\u5973", "\u731e\u7301\u7537", "\u731e\u7301\u5973", new FeralAttributes("\u731e\u7301", "\u731e\u7301", LegConfiguration.QUADRUPEDAL, 60, 0, 1, 4, 1, false), Nocturnality.CREPUSCULAR, "[npc.NamePos]\u7684\u8eab\u4f53\u5c24\u5176\u654f\u6377\uff0c\u53cd\u5e94\u5982\u95ea\u7535\u822c\u8fc5\u901f\u3002[npc.She]\u8fd8\u6709\u7740\u4e00\u79cd\u6765\u6e90\u4e8e\u672c\u80fd\u7684\u6b32\u671b\uff0c\u60f3\u5bf9\u65e0\u8f9c\u7684\u54c8\u6bd4\u548c\u556e\u9f7f\u7c7b\u5316\u5f62\u5c55\u793a\u5176\u652f\u914d\u5730\u4f4d\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.HARPY), Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.RAT_MORPH), Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.SQUIRREL_MORPH), Float.valueOf(5.0f))), null, "\u597d\u5947\u5c0f\u732b\u54aa", "\u597d\u5947\u5c0f\u732b\u54aa", "CAT_MORPH_BASIC", "CAT_MORPH_ADVANCED", Race.CAT_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_CAT_MORPH_LYNX, SubspeciesPreference.TWO_AVERAGE, "\u4e00\u79cd\u4eba\u5f62\u7684\u731e\u7301\uff0c\u5f53\u4e0b\u80a2\u4e3a\u53cc\u8db3\u65f6\u79f0\u4e3a\u201c\u731e\u7301\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u731e\u7301\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u731e\u7301\u4eba\u201d\u82e5\u8981\u88ab\u5224\u5b9a\u4e3a\u731e\u7301\u5316\u5f62\uff0c\u89d2\u8272\u5fc5\u987b\u662f\u732b\u5316\u5f62\uff0c\u5e76\u4e14\u62e5\u6709\u677e\u8f6f\u7684\u76ae\u6bdb\uff0c\u8f83\u77ed\u7684\u5c3e\u5df4\u548c\u8138\u988a\u7ed2\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                Colour primaryColor = PresetColour.COVERING_BROWN;
                double rand = Math.random();
                if (rand < (double)0.3f) {
                    primaryColor = PresetColour.COVERING_TAN;
                } else if (rand < (double)0.6f) {
                    primaryColor = PresetColour.COVERING_BROWN_DARK;
                }
                body.getCoverings().put(BodyCoveringType.FELINE_FUR, new Covering(BodyCoveringType.FELINE_FUR, CoveringPattern.SPOTTED, CoveringModifier.FLUFFY, primaryColor, false, PresetColour.COVERING_BLACK, false));
                body.getCoverings().put(BodyCoveringType.HAIR_FELINE_FUR, new Covering(BodyCoveringType.FELINE_FUR, CoveringPattern.NONE, primaryColor, false, PresetColour.COVERING_BLACK, false));
                body.updateCoverings(true, true, true, true);
                if (body.getEar().getType().getRace() == Race.CAT_MORPH) {
                    body.getEar().setType(null, EarType.CAT_MORPH_TUFTED);
                }
                if (body.getTail().getType().getRace() == Race.CAT_MORPH) {
                    body.getTail().setType(null, TailType.CAT_MORPH_SHORT);
                }
                if (body.getHair().getType().getRace() == Race.CAT_MORPH) {
                    body.getHair().setType(null, HairType.CAT_MORPH_SIDEFLUFF);
                }
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.CAT_MORPH) {
                    AbstractBodyCoveringType felineFur;
                    AbstractFaceType faceType = body.getFace().getType();
                    AbstractBodyCoveringType abstractBodyCoveringType = felineFur = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FUR) : BodyCoveringType.FELINE_FUR;
                    if ((faceType == FaceType.CAT_MORPH || faceType == FaceType.HUMAN) && body.getHair().getType() == HairType.CAT_MORPH_SIDEFLUFF && body.getEar().getType() == EarType.CAT_MORPH_TUFTED && body.getCoverings().get(felineFur).getModifier() == CoveringModifier.FLUFFY && body.getTail().getType() == TailType.CAT_MORPH_SHORT) {
                        return 150;
                    }
                }
                return 0;
            }
        };
        CAT_MORPH_CHEETAH = new AbstractSubspecies(false, 16000, "innoxia_race_cat_felines_fancy", "innoxia_race_cat_kittys_reward", "statusEffects/race/raceCatMorph", "statusEffects/race/raceBackgroundCheetah", "\u730e\u8c79\u5316\u5f62", "\u730e\u8c79\u5316\u5f62", "\u730e\u8c79\u7537", "\u730e\u8c79\u5973", "\u730e\u8c79\u7537", "\u730e\u8c79\u5973", new FeralAttributes("\u730e\u8c79", "\u730e\u8c79", "\u730e\u8c79", "\u730e\u8c79", "\u730e\u8c79", "\u730e\u8c79", LegConfiguration.QUADRUPEDAL, 80, 0, 1, 4, 1, false), Nocturnality.CREPUSCULAR, "[npc.NameIsFull]\u6781\u5176\u8fc5\u6377\uff0c\u53ea\u9700\u77ed\u77ed\u6570\u79d2\u4fbf\u80fd\u591f\u52a0\u901f\u5230\u5176\u4ed6\u79cd\u65cf\u65e0\u6cd5\u4f01\u53ca\u7684\u901f\u5ea6\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(25.0f))), Util.newArrayListOfValues("\u4ece\u975e\u730e\u8c79\u5316\u5f62\u5904\u9003\u8d70\u7684\u6982\u7387\u4e3a[style.boldExcellent(100%)]"), "\u597d\u5947\u5c0f\u732b\u54aa", "\u597d\u5947\u5c0f\u732b\u54aa", "CAT_MORPH_BASIC", "CAT_MORPH_ADVANCED", Race.CAT_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_CAT_MORPH_CHEETAH, SubspeciesPreference.TWO_AVERAGE, "\u4e00\u79cd\u4eba\u5f62\u7684\u730e\u8c79\uff0c\u5f53\u4e0b\u80a2\u4e3a\u53cc\u8db3\u65f6\u79f0\u4e3a\u201c\u730e\u8c79\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u96ea\u8c82\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u730e\u8c79\u4eba\u201d\u82e5\u8981\u88ab\u5224\u5b9a\u4e3a\u730e\u8c79\u5316\u5f62\uff0c\u89d2\u8272\u5fc5\u987b\u662f\u732b\u5316\u5f62\uff0c\u5e76\u4e14\u62e5\u6709\u8f83\u77ed\u7684\u6591\u70b9\u76ae\u6bdb\uff0c\u5e76\u4e14\u4e0d\u80fd\u88ab\u8ba4\u5b9a\u4e3a\u5176\u4ed6\u732b\u7c7b\u5316\u5f62\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SAVANNAH, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                Colour primaryColor = PresetColour.COVERING_ORANGE;
                double rand = Math.random();
                if (rand < (double)0.35f) {
                    primaryColor = PresetColour.COVERING_TAN;
                }
                Colour secondaryColor = PresetColour.COVERING_BLACK;
                body.getCoverings().put(BodyCoveringType.FELINE_FUR, new Covering(BodyCoveringType.FELINE_FUR, CoveringPattern.SPOTTED, CoveringModifier.SHORT, primaryColor, false, secondaryColor, false));
                body.getCoverings().put(BodyCoveringType.HAIR_FELINE_FUR, new Covering(BodyCoveringType.FELINE_FUR, CoveringPattern.NONE, primaryColor, false, secondaryColor, false));
                body.updateCoverings(true, true, true, true);
                if (body.getTail().getType().getRace() == Race.CAT_MORPH) {
                    body.getTail().setType(null, TailType.CAT_MORPH);
                }
                if (body.getBreast().getRawSizeValue() > CupSize.B.getMeasurement()) {
                    rand = Math.random();
                    if (rand < (double)0.35f) {
                        body.getBreast().setSize(null, CupSize.B.getMeasurement());
                    } else if (rand < (double)0.7f) {
                        body.getBreast().setSize(null, CupSize.A.getMeasurement());
                    } else {
                        body.getBreast().setSize(null, CupSize.AA.getMeasurement());
                    }
                }
                body.setBodySize(BodySize.ZERO_SKINNY.getMedianValue());
                body.setMuscle(Muscle.FOUR_RIPPED.getMedianValue());
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.CAT_MORPH) {
                    AbstractBodyCoveringType felineFur;
                    AbstractFaceType faceType = body.getFace().getType();
                    AbstractBodyCoveringType abstractBodyCoveringType = felineFur = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FUR) : BodyCoveringType.FELINE_FUR;
                    if ((faceType == FaceType.CAT_MORPH || faceType == FaceType.HUMAN) && body.getCoverings().get(felineFur).getPattern() == CoveringPattern.SPOTTED && body.getCoverings().get(felineFur).getModifier() == CoveringModifier.SHORT && body.getTail().getType() == TailType.CAT_MORPH) {
                        return 150;
                    }
                }
                return 0;
            }
        };
        CAT_MORPH_CARACAL = new AbstractSubspecies(false, 12000, "innoxia_race_cat_felines_fancy", "innoxia_race_cat_kittys_reward", "statusEffects/race/raceCatMorph", "statusEffects/race/raceBackground", "\u72de\u732b\u5316\u5f62", "\u72de\u732b\u5316\u5f62", "\u72de\u732b\u7537", "\u72de\u732b\u5973", "\u72de\u732b\u7537", "\u72de\u732b\u5973", new FeralAttributes("\u72de\u732b", "\u72de\u732b", "\u72de\u732b", "\u72de\u732b", "\u72de\u732b", "\u72de\u732b", LegConfiguration.QUADRUPEDAL, 50, 0, 1, 4, 1, false), Nocturnality.NOCTURNAL, "[npc.NamePos]\u7684\u8eab\u4f53\u5c24\u5176\u654f\u6377\uff0c\u53cd\u5e94\u5982\u95ea\u7535\u822c\u8fc5\u901f\u3002[npc.She]\u8fd8\u6709\u7740\u4e00\u79cd\u6765\u6e90\u4e8e\u672c\u80fd\u7684\u6b32\u671b\uff0c\u60f3\u5bf9\u65e0\u8f9c\u7684\u54c8\u6bd4\u548c\u556e\u9f7f\u7c7b\u5316\u5f62\u5c55\u793a\u5176\u652f\u914d\u5730\u4f4d\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.HARPY), Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.RAT_MORPH), Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.SQUIRREL_MORPH), Float.valueOf(5.0f))), null, "\u597d\u5947\u5c0f\u732b\u54aa", "\u597d\u5947\u5c0f\u732b\u54aa", "CAT_MORPH_BASIC", "CAT_MORPH_ADVANCED", Race.CAT_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_CAT_MORPH_CARACAL, SubspeciesPreference.TWO_AVERAGE, "\u4e00\u79cd\u4eba\u5f62\u7684\u72de\u732b\uff0c\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u6210\u4e3a\u201c\u72de\u732b\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u72de\u732b\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u72de\u732b\u4eba\u201d\u3002\u8981\u88ab\u5224\u5b9a\u4e3a\u72de\u732b\u5316\u5f62\uff0c\u89d2\u8272\u5fc5\u987b\u662f\u732b\u5316\u5f62\uff0c\u4e14\u8033\u6735\u4e0a\u6709\u7c07\u751f\u7ed2\u6bdb\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SAVANNAH, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                if (body.getEar().getType().getRace() == Race.CAT_MORPH) {
                    body.getEar().setType(null, EarType.CAT_MORPH_TUFTED);
                }
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.CAT_MORPH && body.getEar().getType() == EarType.CAT_MORPH_TUFTED) {
                    return 140;
                }
                return 0;
            }
        };
        HORSE_MORPH = new AbstractSubspecies(true, 18000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorph", "statusEffects/race/raceBackground", "\u9a6c\u5316\u5f62", "\u9a6c\u5316\u5f62", "\u9a6c\u7537", "\u9a6c\u5973", "\u9a6c\u7537", "\u9a6c\u5973", new FeralAttributes("\u9a6c", "\u9a6c", "\u516c\u9a6c", "\u6bcd\u9a6c", "\u516c\u9a6c", "\u6bcd\u9a6c", LegConfiguration.QUADRUPEDAL, 175, 0, 1, 1, 1, true), Nocturnality.DIURNAL, "\u5c3d\u7ba1[npc.namePos]\u7684\u8eab\u4f53\u529b\u5927\u65e0\u6bd4\uff0c\u901f\u5ea6\u6781\u5feb\uff0c\u4f46[npc.sheIs]\u5374\u5e76\u4e0d\u662f\u4e16\u4e0a\u6700\u806a\u660e\u7684\u79cd\u65cf\uff0c\u5e76\u4e14\u5728\u9a7e\u9a6d\u5965\u672f\u65f6\u4e5f\u901a\u5e38\u5341\u5206\u8270\u96be\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(-5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(-10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(25.0f))), null, "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "HORSE_MORPH_BASIC", "HORSE_MORPH_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_HORSE_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u53cc\u8db3\u9a6c\u7c7b\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.NONE);
                body.getWing().setType(null, WingType.NONE);
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u68a6\u9b47", "\u68a6\u9b47", "\u68a6\u9b47", "\u68a6\u9b47", "\u68a6\u9b47", "\u68a6\u9b47"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u68a6\u9b47", true, false), this.applyNonBipedNameChange(body, "\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u68a6\u9b47", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        HORSE_MORPH_UNICORN = new AbstractSubspecies(false, 30000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorph", "statusEffects/race/raceBackground", "\u72ec\u89d2\u517d\u5316\u5f62", "\u72ec\u89d2\u517d\u5316\u5f62", "\u72ec\u89d2\u517d\u7537", "\u72ec\u89d2\u517d\u5973", "\u72ec\u89d2\u517d\u7537", "\u72ec\u89d2\u517d\u5973", new FeralAttributes("\u72ec\u89d2\u517d", "\u72ec\u89d2\u517d", "\u96c4\u72ec\u89d2\u517d", "\u96cc\u72ec\u89d2\u517d", "\u96c4\u72ec\u89d2\u517d", "\u96cc\u72ec\u89d2\u517d", LegConfiguration.QUADRUPEDAL, 175, 0, 1, 1, 1, true), Nocturnality.DIURNAL, "\u867d\u7136\u4f53\u8d28\u7565\u5dee\u4e8e\u5e38\u89c4\u7684\u9a6c\u5316\u5f62\uff0c\u4f46[npc.nameHasFull]\u62e5\u6709\u7279\u6b8a\u7684\u5965\u672f\u7ebd\u5e26\uff0c\u80fd\u591f\u5728[npc.her]\u7075\u6c14\u8870\u7aed\u524d\u65bd\u653e\u8bb8\u591a\u6cd5\u672f\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(20.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f))), null, "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "HORSE_MORPH_BASIC", "HORSE_MORPH_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 3)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 4), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 3)), PresetColour.RACE_UNICORN, SubspeciesPreference.ONE_LOW, "\u4e00\u79cd\u4eba\u5f62\u7684\u53cc\u8db3\u9a6c\u7c7b\uff0c\u524d\u989d\u4e0a\u957f\u6709\u4e00\u6839\u5145\u6ee1\u9b54\u6cd5\u7684\u72ec\u89d2\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TWO)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.HORSE_STRAIGHT);
                body.getHorn().setHornRows(null, 1);
                body.getHorn().setHornsPerRow(null, 1);
                body.getHorn().setHornLength(null, HornLength.TWO_LONG.getMedianValue());
                body.getWing().setType(null, WingType.NONE);
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u72ec\u89d2\u517d\u68a6\u9b47", "\u72ec\u89d2\u517d\u68a6\u9b47", "\u72ec\u89d2\u517d\u68a6\u9b47", "\u72ec\u89d2\u517d\u68a6\u9b47", "\u72ec\u89d2\u517d\u68a6\u9b47", "\u72ec\u89d2\u517d\u68a6\u9b47"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u72ec\u89d2\u517d\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u72ec\u89d2\u517d\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u72ec\u89d2\u517d\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u72ec\u89d2\u517d\u68a6\u9b47", true, false), this.applyNonBipedNameChange(body, "\u72ec\u89d2\u517d\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u72ec\u89d2\u517d\u68a6\u9b47", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH && !body.getHorn().getType().equals(HornType.NONE) && body.getHorn().getHornRows() == 1 && body.getHorn().getHornsPerRow() == 1) {
                    return 150;
                }
                return 0;
            }
        };
        HORSE_MORPH_PEGASUS = new AbstractSubspecies(false, 24000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorph", "statusEffects/race/raceBackground", "\u5929\u9a6c\u5316\u5f62", "\u5929\u9a6c\u5316\u5f62", "\u5929\u9a6c\u7537", "\u5929\u9a6c\u5973", "\u5929\u9a6c\u7537", "\u5929\u9a6c\u5973", new FeralAttributes("\u5929\u9a6c", "\u5929\u9a6c", "\u516c\u5929\u9a6c", "\u6bcd\u5929\u9a6c", "\u516c\u5929\u9a6c", "\u6bcd\u5929\u9a6c", LegConfiguration.QUADRUPEDAL, 175, 0, 1, 1, 1, true), Nocturnality.DIURNAL, "\u867d\u7136\u4f53\u8d28\u7565\u5dee\u4e8e\u5e38\u89c4\u7684\u9a6c\u5316\u5f62\uff0c\u4f46[npc.nameHasFull]\u884c\u52a8\u66f4\u52a0\u654f\u6377\uff0c\u603b\u80fd\u591f\u51fb\u654c\u4e8e\u5f31\u70b9\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(30.0f))), null, "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "HORSE_MORPH_BASIC", "HORSE_MORPH_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_PEGASUS, SubspeciesPreference.ONE_LOW, "\u4e00\u79cd\u4eba\u5f62\u7684\u53cc\u8db3\u9a6c\u7c7b\uff0c\u80cc\u4e0a\u957f\u6709\u4e00\u53cc\u7fbd\u6bdb\u8986\u76d6\u7684\u7fc5\u8180\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TWO)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.NONE);
                body.setWing(new Wing(WingType.FEATHERED, WingSize.THREE_LARGE.getValue()));
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u5929\u9a6c\u68a6\u9b47", "\u5929\u9a6c\u68a6\u9b47", "\u5929\u9a6c\u68a6\u9b47", "\u5929\u9a6c\u68a6\u9b47", "\u5929\u9a6c\u68a6\u9b47", "\u5929\u9a6c\u68a6\u9b47"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u5929\u9a6c\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u5929\u9a6c\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u5929\u9a6c\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u5929\u9a6c\u68a6\u9b47", true, false), this.applyNonBipedNameChange(body, "\u5929\u9a6c\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u5929\u9a6c\u68a6\u9b47", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH && body.getWing().getType() == WingType.FEATHERED) {
                    return 150;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }
        };
        HORSE_MORPH_ALICORN = new AbstractSubspecies(false, 60000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorph", "statusEffects/race/raceBackground", "\u5929\u89d2\u517d\u5316\u5f62", "\u5929\u89d2\u517d\u5316\u5f62", "\u5929\u89d2\u517d\u7537", "\u5929\u89d2\u517d\u5973", "\u5929\u89d2\u517d\u7537", "\u5929\u89d2\u517d\u5973", new FeralAttributes("\u5929\u89d2\u517d", "\u5929\u89d2\u517d", "\u516c\u5929\u89d2\u517d", "\u6bcd\u5929\u89d2\u517d", "\u516c\u5929\u89d2\u517d", "\u6bcd\u5929\u89d2\u517d", LegConfiguration.QUADRUPEDAL, 175, 0, 1, 1, 1, true), Nocturnality.DIURNAL, "[npc.nameIsFull]\u62e5\u6709\u7fbd\u7ffc\u548c\u72ec\u89d2\uff0c\u88ab\u5f52\u7c7b\u4e3a\u5f3a\u5927\u7684\u5929\u89d2\u517d\uff0c\u65bd\u6cd5\u51e0\u4e4e\u4e0d\u8d39\u5439\u7070\u4e4b\u529b\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(75.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(50.0f))), null, "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "HORSE_MORPH_BASIC", "HORSE_MORPH_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 3)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 3)), PresetColour.RACE_ALICORN, SubspeciesPreference.ONE_LOW, "\u4e00\u79cd\u4eba\u5f62\u7684\u53cc\u8db3\u9a6c\u7c7b\uff0c\u80cc\u4e0a\u957f\u6709\u4e00\u53cc\u7fbd\u6bdb\u8986\u76d6\u7684\u7fc5\u8180\uff0c\u800c\u524d\u989d\u4e0a\u957f\u6709\u4e00\u6839\u5145\u6ee1\u9b54\u6cd5\u7684\u72ec\u89d2\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.ONE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.ONE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.ONE)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.HORSE_STRAIGHT);
                body.getHorn().setHornRows(null, 1);
                body.getHorn().setHornsPerRow(null, 1);
                body.getHorn().setHornLength(null, HornLength.TWO_LONG.getMedianValue());
                body.setWing(new Wing(WingType.FEATHERED, WingSize.THREE_LARGE.getValue()));
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u5929\u89d2\u517d\u68a6\u9b47", "\u5929\u89d2\u517d\u68a6\u9b47", "\u5929\u89d2\u517d\u68a6\u9b47", "\u5929\u89d2\u517d\u68a6\u9b47", "\u5929\u89d2\u517d\u68a6\u9b47", "\u5929\u89d2\u517d\u68a6\u9b47"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u5929\u89d2\u517d\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u5929\u89d2\u517d\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u5929\u89d2\u517d\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u5929\u89d2\u517d\u68a6\u9b47", true, false), this.applyNonBipedNameChange(body, "\u5929\u89d2\u517d\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u5929\u89d2\u517d\u68a6\u9b47", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH && body.getWing().getType() == WingType.FEATHERED && !body.getHorn().getType().equals(HornType.NONE) && body.getHorn().getHornRows() == 1 && body.getHorn().getHornsPerRow() == 1) {
                    return 200;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }
        };
        CENTAUR = new AbstractSubspecies(false, 25000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorph", "statusEffects/race/raceBackground", "\u534a\u4eba\u9a6c", "\u534a\u4eba\u9a6c", "\u534a\u4eba\u9a6c", "\u534a\u4eba\u9a6c", "\u534a\u4eba\u9a6c", "\u534a\u4eba\u9a6c", null, Nocturnality.DIURNAL, "\u5f97\u76ca\u4e8e\u62e5\u6709\u9a6c\u7684\u4e0b\u534a\u8eab\uff0c[npc.nameIsFull]\u80fd\u4ee5\u6781\u5feb\u7684\u901f\u5ea6\u5954\u8dd1\uff0c\u8fd8\u80fd\u501f\u6b64\u9020\u6210\u5de8\u5927\u7684\u7269\u7406\u4f24\u5bb3\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(35.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(-5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(-10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(50.0f))), null, "\u4e0d\u6b62\u534a\u4eba\u9a6c", "\u4e0d\u6b62\u534a\u4eba\u9a6c", "CENTAUR_BASIC", "CENTAUR_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_CENTAUR, SubspeciesPreference.FOUR_ABUNDANT, "\u4efb\u4f55\u62e5\u6709\u517d\u6001\u56db\u8db3\u4e0b\u80a2\u7684\u9a6c\u7c7b\u90fd\u4f1a\u88ab\u5206\u7c7b\u4e3a\u534a\u4eba\u9a6c\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TWO)), null, null){

            @Override
            public boolean isNonBiped() {
                return true;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.NONE);
                body.getWing().setType(null, WingType.NONE);
                body.getLeg().setType(null, LegType.HORSE_MORPH);
                LegType.HORSE_MORPH.applyLegConfigurationTransformation(body, LegConfiguration.QUADRUPEDAL, true);
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
                body.getPenis().getTesticle().getCum().addFluidModifier(null, FluidModifier.MUSKY);
                body.getVagina().getGirlcum().addFluidModifier(null, FluidModifier.MUSKY);
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                return new String[]{"\u6076\u9b54\u534a\u4eba\u9a6c", "\u6076\u9b54\u534a\u4eba\u9a6c", "\u6076\u9b54\u534a\u4eba\u9a6c", "\u6076\u9b54\u534a\u4eba\u9a6c", "\u6076\u9b54\u534a\u4eba\u9a6c", "\u6076\u9b54\u534a\u4eba\u9a6c"};
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH && body.getLeg().getLegConfiguration() == LegConfiguration.QUADRUPEDAL) {
                    return 1000;
                }
                return 0;
            }
        };
        PEGATAUR = new AbstractSubspecies(false, 35000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorph", "statusEffects/race/raceBackground", "\u534a\u5929\u9a6c\u4eba", "\u534a\u5929\u9a6c\u4eba", "\u534a\u5929\u9a6c\u4eba", "\u534a\u5929\u9a6c\u4eba", "\u534a\u5929\u9a6c\u4eba", "\u534a\u5929\u9a6c\u4eba", null, Nocturnality.DIURNAL, "\u867d\u7136\u4f53\u8d28\u7565\u5dee\u4e8e\u5e38\u89c4\u7684\u534a\u4eba\u9a6c\uff0c\u4f46[npc.nameHasFull]\u884c\u52a8\u66f4\u52a0\u654f\u6377\uff0c\u603b\u80fd\u591f\u51fb\u654c\u4e8e\u5f31\u70b9\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(30.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f))), null, "\u4e0d\u6b62\u534a\u4eba\u9a6c", "\u4e0d\u6b62\u534a\u4eba\u9a6c", "CENTAUR_BASIC", "CENTAUR_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_PEGATAUR, SubspeciesPreference.ONE_LOW, "\u4efb\u4f55\u62e5\u6709\u9a6c\u578b\u517d\u6001\u7684\u56db\u8db3\u4e0b\u534a\u8eab\uff0c\u4e14\u5e26\u6709\u7fbd\u7ffc\u548c\u72ec\u89d2\u7684\u4eba\uff0c\u90fd\u88ab\u5f52\u7c7b\u4e3a\u534a\u5929\u9a6c\u4eba\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.ONE)), null, null){

            @Override
            public boolean isNonBiped() {
                return true;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.NONE);
                body.getLeg().setType(null, LegType.HORSE_MORPH);
                LegType.HORSE_MORPH.applyLegConfigurationTransformation(body, LegConfiguration.QUADRUPEDAL, true);
                body.setWing(new Wing(WingType.FEATHERED, WingSize.FOUR_HUGE.getValue()));
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
                body.getPenis().getTesticle().getCum().addFluidModifier(null, FluidModifier.MUSKY);
                body.getVagina().getGirlcum().addFluidModifier(null, FluidModifier.MUSKY);
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                return new String[]{"\u6076\u9b54\u534a\u5929\u9a6c\u4eba", "\u6076\u9b54\u534a\u5929\u9a6c\u4eba", "\u6076\u9b54\u534a\u5929\u9a6c\u4eba", "\u6076\u9b54\u534a\u5929\u9a6c\u4eba", "\u6076\u9b54\u534a\u5929\u9a6c\u4eba", "\u6076\u9b54\u534a\u5929\u9a6c\u4eba"};
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH && body.getLeg().getLegConfiguration() == LegConfiguration.QUADRUPEDAL && body.getWing().getType() == WingType.FEATHERED) {
                    return 1150;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }
        };
        UNITAUR = new AbstractSubspecies(false, 50000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorph", "statusEffects/race/raceBackground", "\u534a\u72ec\u89d2\u517d\u4eba", "\u534a\u72ec\u89d2\u517d\u4eba", "\u534a\u72ec\u89d2\u517d\u4eba", "\u534a\u72ec\u89d2\u517d\u4eba", "\u534a\u72ec\u89d2\u517d\u4eba", "\u534a\u72ec\u89d2\u517d\u4eba", null, Nocturnality.DIURNAL, "\u867d\u7136\u4f53\u8d28\u7565\u5dee\u4e8e\u5e38\u89c4\u7684\u534a\u4eba\u9a6c\uff0c\u4f46[npc.nameHasFull]\u62e5\u6709\u7279\u6b8a\u7684\u5965\u672f\u7ebd\u5e26\uff0c\u80fd\u591f\u5728[npc.her]\u7075\u6c14\u8870\u7aed\u524d\u65bd\u653e\u8bb8\u591a\u6cd5\u672f\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f))), null, "\u4e0d\u6b62\u534a\u4eba\u9a6c", "\u4e0d\u6b62\u534a\u4eba\u9a6c", "CENTAUR_BASIC", "CENTAUR_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_UNICORN, SubspeciesPreference.ONE_LOW, "\u4efb\u4f55\u62e5\u6709\u517d\u6001\u56db\u8db3\u4e0b\u80a2\u548c\u72ec\u89d2\u7684\u9a6c\u7c7b\uff0c\u90fd\u88ab\u5f52\u7c7b\u4e3a\u534a\u72ec\u89d2\u517d\u4eba\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.ONE)), null, null){

            @Override
            public boolean isNonBiped() {
                return true;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.HORSE_STRAIGHT);
                body.getHorn().setHornRows(null, 1);
                body.getHorn().setHornsPerRow(null, 1);
                body.getHorn().setHornLength(null, HornLength.TWO_LONG.getMedianValue());
                body.getLeg().setType(null, LegType.HORSE_MORPH);
                LegType.HORSE_MORPH.applyLegConfigurationTransformation(body, LegConfiguration.QUADRUPEDAL, true);
                body.getWing().setType(null, WingType.NONE);
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
                body.getPenis().getTesticle().getCum().addFluidModifier(null, FluidModifier.MUSKY);
                body.getVagina().getGirlcum().addFluidModifier(null, FluidModifier.MUSKY);
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                return new String[]{"\u6076\u9b54\u534a\u72ec\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u72ec\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u72ec\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u72ec\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u72ec\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u72ec\u89d2\u517d\u4eba"};
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH && body.getLeg().getLegConfiguration() == LegConfiguration.QUADRUPEDAL && !body.getHorn().getType().equals(HornType.NONE) && body.getHorn().getHornRows() == 1 && body.getHorn().getHornsPerRow() == 1) {
                    return 1150;
                }
                return 0;
            }
        };
        ALITAUR = new AbstractSubspecies(false, 100000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorph", "statusEffects/race/raceBackground", "\u534a\u5929\u89d2\u517d\u4eba", "\u534a\u5929\u89d2\u517d\u4eba", "\u534a\u5929\u89d2\u517d\u4eba", "\u534a\u5929\u89d2\u517d\u4eba", "\u534a\u5929\u89d2\u517d\u4eba", "\u534a\u5929\u89d2\u517d\u4eba", null, Nocturnality.DIURNAL, "[npc.nameIsFull]\u62e5\u6709\u7fbd\u7ffc\u548c\u72ec\u89d2\uff0c\u88ab\u5f52\u7c7b\u4e3a\u5f3a\u5927\u7684\u5929\u89d2\u517d\uff0c\u65bd\u6cd5\u51e0\u4e4e\u4e0d\u8d39\u5439\u7070\u4e4b\u529b\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(75.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(50.0f))), null, "\u4e0d\u6b62\u534a\u4eba\u9a6c", "\u4e0d\u6b62\u534a\u4eba\u9a6c", "CENTAUR_BASIC", "CENTAUR_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 2)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 2)), PresetColour.RACE_ALICORN, SubspeciesPreference.ONE_LOW, "\u4efb\u4f55\u62e5\u6709\u517d\u6001\u56db\u8db3\u4e0b\u80a2\uff0c\u4e14\u62e5\u6709\u7fc5\u8180\u548c\u72ec\u89d2\u7684\u9a6c\u7c7b\uff0c\u90fd\u88ab\u5f52\u7c7b\u4e3a\u534a\u5929\u89d2\u517d\u4eba\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.ONE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.ONE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.ONE)), null, null){

            @Override
            public boolean isNonBiped() {
                return true;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.HORSE_STRAIGHT);
                body.getHorn().setHornRows(null, 1);
                body.getHorn().setHornsPerRow(null, 1);
                body.getHorn().setHornLength(null, HornLength.TWO_LONG.getMedianValue());
                body.getLeg().setType(null, LegType.HORSE_MORPH);
                LegType.HORSE_MORPH.applyLegConfigurationTransformation(body, LegConfiguration.QUADRUPEDAL, true);
                body.setWing(new Wing(WingType.FEATHERED, WingSize.FOUR_HUGE.getValue()));
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
                body.getPenis().getTesticle().getCum().addFluidModifier(null, FluidModifier.MUSKY);
                body.getVagina().getGirlcum().addFluidModifier(null, FluidModifier.MUSKY);
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                return new String[]{"\u6076\u9b54\u534a\u5929\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u5929\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u5929\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u5929\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u5929\u89d2\u517d\u4eba", "\u6076\u9b54\u534a\u5929\u89d2\u517d\u4eba"};
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH && body.getLeg().getLegConfiguration() == LegConfiguration.QUADRUPEDAL && body.getWing().getType() == WingType.FEATHERED && !body.getHorn().getType().equals(HornType.NONE) && body.getHorn().getHornRows() == 1 && body.getHorn().getHornsPerRow() == 1) {
                    return 1200;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }
        };
        HORSE_MORPH_ZEBRA = new AbstractSubspecies(false, 18000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorphZebra", "statusEffects/race/raceBackgroundZebra", "\u6591\u9a6c\u5316\u5f62", "\u6591\u9a6c\u5316\u5f62", "\u6591\u9a6c\u7537", "\u6591\u9a6c\u5973", "\u6591\u9a6c\u7537", "\u6591\u9a6c\u5973", new FeralAttributes("\u6591\u9a6c", "\u6591\u9a6c", "\u516c\u6591\u9a6c", "\u6bcd\u6591\u9a6c", "\u516c\u6591\u9a6c", "\u6bcd\u6591\u9a6c", LegConfiguration.QUADRUPEDAL, 130, 0, 1, 1, 1, true), Nocturnality.DIURNAL, "\u5c3d\u7ba1[npc.namePos]\u7684\u8eab\u4f53\u529b\u5927\u65e0\u6bd4\uff0c\u901f\u5ea6\u6781\u5feb\uff0c\u4f46[npc.sheIs]\u5374\u5e76\u4e0d\u662f\u4e16\u4e0a\u6700\u806a\u660e\u7684\u79cd\u65cf\uff0c\u5e76\u4e14\u5728\u9a7e\u9a6d\u5965\u672f\u65f6\u4e5f\u901a\u5e38\u5341\u5206\u8270\u96be\u3002[npc.She]\u5bf9\u4e8e\u5929\u7136\u706b\u7130\u548c\u5965\u672f\u706b\u7130\u90fd\u6709\u6781\u9ad8\u7684\u6297\u6027\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(-5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(-10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(20.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_FIRE, Float.valueOf(5.0f))), null, "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "HORSE_MORPH_BASIC", "HORSE_MORPH_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.BASE_BLACK, SubspeciesPreference.ONE_LOW, "\u4e00\u79cd\u4eba\u5f62\u7684\u9a6c\uff0c\u957f\u7740\u9ed1\u767d\u8272\u6761\u7eb9\u7684\u76ae\u6bdb\uff0c\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u6591\u9a6c\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u6591\u9a6c\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u6591\u9a6c\u4eba\u201d\u3002\u82e5\u8981\u88ab\u5224\u5b9a\u4e3a\u6591\u9a6c\u5316\u5f62\uff0c\u89d2\u8272\u5fc5\u987b\u662f\u9a6c\u5316\u5f62\uff0c\u5e76\u4e14\u62e5\u6709\u9ed1\u767d\u6761\u7eb9\u7684\u76ae\u6bdb\uff0c\u4ee5\u53ca\u6591\u9a6c\u5316\u5f62\u7684\u5c3e\u5df4\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SAVANNAH, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.FIVE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.NONE);
                body.getWing().setType(null, WingType.NONE);
                body.getCoverings().put(BodyCoveringType.HORSE_HAIR, new Covering(BodyCoveringType.HORSE_HAIR, CoveringPattern.STRIPED, CoveringModifier.SHORT, PresetColour.COVERING_BLACK, false, PresetColour.COVERING_WHITE, false));
                body.getCoverings().put(BodyCoveringType.HAIR_HORSE_HAIR, new Covering(BodyCoveringType.HAIR_HORSE_HAIR, CoveringPattern.NONE, PresetColour.COVERING_BLACK, false, PresetColour.COVERING_WHITE, false));
                body.getCoverings().put(BodyCoveringType.HUMAN, new Covering(BodyCoveringType.HUMAN, CoveringPattern.NONE, PresetColour.SKIN_EBONY, false, PresetColour.SKIN_EBONY, false));
                body.updateCoverings(true, true, true, true);
                if (body.getTail().getType() == TailType.HORSE_MORPH) {
                    body.getTail().setType(null, TailType.HORSE_MORPH_ZEBRA);
                }
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u6591\u9a6c\u68a6\u9b47", "\u6591\u9a6c\u68a6\u9b47", "\u6591\u9a6c\u68a6\u9b47", "\u6591\u9a6c\u68a6\u9b47", "\u6591\u9a6c\u68a6\u9b47", "\u6591\u9a6c\u68a6\u9b47"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u6591\u9a6c\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u6591\u9a6c\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u6591\u9a6c\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u6591\u9a6c\u68a6\u9b47", true, false), this.applyNonBipedNameChange(body, "\u6591\u9a6c\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u6591\u9a6c\u68a6\u9b47", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH) {
                    AbstractBodyCoveringType horseHair = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_HAIR) : BodyCoveringType.HORSE_HAIR;
                    Colour zebraPrimary = body.getCoverings().get(horseHair).getPrimaryColour();
                    Colour zebraSecondary = body.getCoverings().get(horseHair).getSecondaryColour();
                    if (((zebraPrimary == PresetColour.COVERING_BLACK || zebraPrimary == PresetColour.COVERING_JET_BLACK) && zebraSecondary == PresetColour.COVERING_WHITE || zebraPrimary == PresetColour.COVERING_WHITE && (zebraSecondary == PresetColour.COVERING_BLACK || zebraSecondary == PresetColour.COVERING_JET_BLACK)) && body.getTail().getType() == TailType.HORSE_MORPH_ZEBRA) {
                        return 1500;
                    }
                }
                return 0;
            }
        };
        HORSE_MORPH_DONKEY = new AbstractSubspecies(false, 12000, "innoxia_race_horse_equine_cider", "innoxia_race_horse_sugar_carrot_cube", "statusEffects/race/raceHorseMorph", "statusEffects/race/raceBackground", "\u9a74\u5316\u5f62", "\u9a74\u5316\u5f62", "\u9a74\u7537", "\u9a74\u5973", "\u9a74\u7537", "\u9a74\u5973", new FeralAttributes("\u9a74", "\u9a74", "\u516c\u9a74", "\u6bcd\u9a74", "\u516c\u9a74", "\u6bcd\u9a74", LegConfiguration.QUADRUPEDAL, 120, 0, 1, 1, 1, true), Nocturnality.DIURNAL, "\u5c3d\u7ba1[npc.namePos]\u7684\u8eab\u4f53\u529b\u5927\u65e0\u6bd4\uff0c\u8010\u529b\u6781\u4f73\uff0c\u4f46[npc.sheIs]\u5728\u9a7e\u9a6d\u5965\u672f\u65f6\u901a\u5e38\u5341\u5206\u8270\u96be\u3002[npc.She]\u8fd8\u62e5\u6709\u5929\u751f\u7684\u77e5\u8bc6\uff0c\u80fd\u591f\u6709\u529b\u5730\u5bf9\u6297\u72ac\u7c7b\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(-5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.SPELL_COST_MODIFIER, Float.valueOf(-10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(20.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_PHYSICAL, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.DOG_MORPH), Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.WOLF_MORPH), Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.getRacialDamageAttribute(Race.FOX_MORPH), Float.valueOf(25.0f))), null, "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "\u9a6c\u7c7b\u767e\u79d1\u5168\u4e66", "HORSE_MORPH_BASIC", "HORSE_MORPH_ADVANCED", Race.HORSE_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 15), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.CLOTHING_DESATURATED_BROWN, SubspeciesPreference.ONE_LOW, "\u4e00\u79cd\u4eba\u5f62\u7684\u9a74\uff0c\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u9a74\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u9a74\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u9a74\u4eba\u201d\u3002\u82e5\u8981\u88ab\u5224\u5b9a\u4e3a\u9a74\u5316\u5f62\uff0c\u89d2\u8272\u5fc5\u987b\u662f\u9a6c\u5316\u5f62\uff0c\u5e76\u4e14\u62e5\u6709\u8f83\u9ad8\u7684\u4e0a\u7ad6\u8033\u6735\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.THREE)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getHorn().setType(null, HornType.NONE);
                body.getWing().setType(null, WingType.NONE);
                if (Math.random() < 0.75) {
                    body.getCoverings().put(BodyCoveringType.HORSE_HAIR, new Covering(BodyCoveringType.HORSE_HAIR, CoveringPattern.MARKED, CoveringModifier.SHORT, PresetColour.COVERING_BROWN_DARK, false, PresetColour.COVERING_WHITE, false));
                    body.getCoverings().put(BodyCoveringType.HAIR_HORSE_HAIR, new Covering(BodyCoveringType.HAIR_HORSE_HAIR, CoveringPattern.NONE, PresetColour.COVERING_BROWN_DARK, false, PresetColour.COVERING_WHITE, false));
                    body.getCoverings().put(BodyCoveringType.HUMAN, new Covering(BodyCoveringType.HUMAN, CoveringPattern.NONE, PresetColour.SKIN_DARK, false, PresetColour.SKIN_DARK, false));
                }
                body.updateCoverings(true, true, true, true);
                if (body.getEar().getType() == EarType.HORSE_MORPH) {
                    body.getEar().setType(null, EarType.HORSE_MORPH_UPRIGHT);
                }
                if (body.getFace().getType() == FaceType.HORSE_MORPH && (!body.isFeminine() || Math.random() < 0.5)) {
                    body.getHair().setStyle(null, HairStyle.NONE);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u9a74\u68a6\u9b47", "\u9a74\u68a6\u9b47", "\u9a74\u68a6\u9b47", "\u9a74\u68a6\u9b47", "\u9a74\u68a6\u9b47", "\u9a74\u68a6\u9b47"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u9a74\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u9a74\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u9a74\u68a6\u9b47", false, false), this.applyNonBipedNameChange(body, "\u9a74\u68a6\u9b47", true, false), this.applyNonBipedNameChange(body, "\u9a74\u68a6\u9b47", false, true), this.applyNonBipedNameChange(body, "\u9a74\u68a6\u9b47", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HORSE_MORPH && body.getEar().getType() == EarType.HORSE_MORPH_UPRIGHT) {
                    return 1400;
                }
                return 0;
            }

            @Override
            public Map<PersonalityTrait, Float> getPersonalityTraitChances() {
                Map<PersonalityTrait, Float> map = super.getPersonalityTraitChances();
                map.put(PersonalityTrait.BRAVE, Float.valueOf(0.5f));
                return map;
            }
        };
        REINDEER_MORPH = new AbstractSubspecies(true, 18000, "innoxia_race_reindeer_rudolphs_egg_nog", "innoxia_race_reindeer_sugar_cookie", "statusEffects/race/raceReindeerMorph", "statusEffects/race/raceBackground", "\u9a6f\u9e7f\u5316\u5f62", "\u9a6f\u9e7f\u5316\u5f62", "\u9a6f\u9e7f\u7537", "\u9a6f\u9e7f\u5973", "\u9a6f\u9e7f\u7537", "\u9a6f\u9e7f\u5973", new FeralAttributes("\u9a6f\u9e7f", "\u9a6f\u9e7f", "\u516c\u9a6f\u9e7f", "\u6bcd\u9a6f\u9e7f", "\u516c\u9a6f\u9e7f", "\u6bcd\u9a6f\u9e7f", LegConfiguration.QUADRUPEDAL, 130, 0, 1, 1, 4, false), Nocturnality.DIURNAL, "[npc.NamePos]\u7684\u8eab\u4f53\u975e\u5e38\u9002\u5408\u5730\u72f1\u81ea\u7136\u548c\u5965\u672f\u5bd2\u51b7\uff0c\u5e76\u4e14\u5341\u5206\u575a\u97e7\u5f3a\u58ee\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_PHYSICAL, Float.valueOf(2.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_ICE, Float.valueOf(5.0f))), null, "\u9a6f\u9e7f\u7684\u8fc1\u5f99", "\u9a6f\u9e7f\u7684\u8fc1\u5f99", "REINDEER_MORPH_BASIC", "REINDEER_MORPH_ADVANCED", Race.REINDEER_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_REINDEER_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u9a6f\u9e7f\uff0c\u5f53\u4e0b\u80a2\u4e3a\u53cc\u8db3\u65f6\u79f0\u4e3a\u201c\u9a6f\u9e7f\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u517d\u6001\u9a6f\u9e7f\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u9a6f\u9e7f\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.ONE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SNOW, SubspeciesSpawnRarity.FIVE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.THREE)), null, null){

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.REINDEER_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        ALLIGATOR_MORPH = new AbstractSubspecies(true, 10000, "innoxia_race_alligator_swamp_water", "innoxia_race_alligator_gators_gumbo", "statusEffects/race/raceGatorMorph", "statusEffects/race/raceBackground", "\u9cc4\u5316\u5f62", "\u9cc4\u5316\u5f62", "\u9cc4\u7537", "\u9cc4\u5973", "\u9cc4\u7537", "\u9cc4\u5973", new FeralAttributes("\u9cc4\u9c7c", "\u9cc4\u9c7c", LegConfiguration.QUADRUPEDAL, false, 180, 0, 1, 0, 1, false), Nocturnality.NOCTURNAL, "[npc.NamePos]\u7684\u8eab\u4f53\u6781\u5176\u575a\u97e7\uff0c\u4e14\u53cd\u5e94\u8fc5\u901f\uff0c\u5176\u529b\u91cf\u4e5f\u8db3\u4ee5\u5728\u591a\u6570\u60c5\u51b5\u4e0b\u53d1\u52a8\u7a81\u7136\u88ad\u51fb\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(30.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(25.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_PHYSICAL, Float.valueOf(5.0f))), null, "\u548c\u9cc4\u9c7c\u640f\u6597", "\u548c\u9cc4\u9c7c\u640f\u6597", "ALLIGATOR_MORPH_BASIC", "ALLIGATOR_MORPH_ADVANCED", Race.ALLIGATOR_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 10), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_ALLIGATOR_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u9cc4\u9c7c\uff0c\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u6210\u4e3a\u201c\u9cc4\u9c7c\u5316\u5f62\u201d\uff0c\u800c\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u9cc4\u9c7c\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u9cc4\u9c7c\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.RIVER, SubspeciesSpawnRarity.TWO)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TWO)), null, null){

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.ALLIGATOR_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        SQUIRREL_MORPH = new AbstractSubspecies(true, 6000, "innoxia_race_squirrel_squirrel_java", "innoxia_race_squirrel_round_nuts", "statusEffects/race/raceSquirrelMorph", "statusEffects/race/raceBackground", "\u677e\u9f20\u5316\u5f62", "\u677e\u9f20\u5316\u5f62", "\u677e\u9f20\u7537", "\u677e\u9f20\u5973", "\u677e\u9f20\u7537", "\u677e\u9f20\u5973", new FeralAttributes("\u677e\u9f20", "\u677e\u9f20", LegConfiguration.QUADRUPEDAL, 15, 0, 1, 4, 1, false), Nocturnality.DIURNAL, "[npc.NameIsFull]\u5341\u5206\u673a\u654f\u7075\u5de7\uff0c\u5176\u5f3a\u58ee\u7684[npc.legs]\u80fd\u591f\u8df3\u51fa\u5f88\u957f\u4e00\u6bb5\u8ddd\u79bb\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(10.0f))), null, "\u8ffd\u9010\u677e\u9f20", "\u8ffd\u9010\u677e\u9f20", "SQUIRREL_MORPH_BASIC", "SQUIRREL_MORPH_ADVANCED", Race.SQUIRREL_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_SQUIRREL_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u677e\u9f20\uff0c\u5f53\u4e0b\u80a2\u4f3c\u4eba\u65f6\u79f0\u4e3a\u201c\u677e\u9f20\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u677e\u9f20\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u677e\u9f20\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.SQUIRREL_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        RAT_MORPH = new AbstractSubspecies(true, 6000, "innoxia_race_rat_black_rats_rum", "innoxia_race_rat_brown_rats_burger", "statusEffects/race/raceRatMorph", "statusEffects/race/raceBackground", "\u9f20\u5316\u5f62", "\u9f20\u5316\u5f62", "\u9f20\u7537", "\u9f20\u5973", "\u9f20\u7537", "\u9f20\u5973", new FeralAttributes("\u8001\u9f20", "\u8001\u9f20", LegConfiguration.QUADRUPEDAL, 15, 0, 1, 6, 1, false), Nocturnality.CREPUSCULAR, "[npc.NamePos]\u7684\u8eab\u4f53\u80fd\u591f\u9002\u5e94\u6781\u7aef\u7684\u6076\u52a3\u73af\u5883\uff0c\u5e76\u4e14\u5bf9\u4e8e\u5965\u672f\u6bd2\u7d20\u6297\u6027\u6781\u4f73\uff0c\u4eb2\u548c\u529b\u4e5f\u5f88\u5f3a\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_POISON, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_POISON, Float.valueOf(5.0f))), null, "\u7eb7\u4e71\u4e4b\u6e90", "\u7eb7\u4e71\u4e4b\u6e90", "RAT_MORPH_BASIC", "RAT_MORPH_ADVANCED", Race.RAT_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_RAT_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u8001\u9f20\uff0c\u5f53\u4e0b\u80a2\u62df\u4eba\u65f6\u88ab\u79f0\u4e3a\u201c\u9f20\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u8001\u9f20\u7684\u6837\u5b50\u65f6\u5219\u79f0\u4e3a\u201c\u534a\u9f20\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.FIVE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TWO)), null, null){

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.RAT_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        RABBIT_MORPH = new AbstractSubspecies(true, 12000, "innoxia_race_rabbit_bunny_juice", "innoxia_race_rabbit_bunny_carrot_cake", "statusEffects/race/raceRabbitMorph", "statusEffects/race/raceBackground", "\u5154\u5316\u5f62", "\u5154\u5316\u5f62", "\u5154\u7537", "\u5154\u5973", "\u5154\u7537", "\u5154\u5973", new FeralAttributes("\u5154\u5b50", "\u5154\u5b50", LegConfiguration.QUADRUPEDAL, 20, 0, 1, 5, 1, false), Nocturnality.CREPUSCULAR, "[npc.NameIsFull]\u5341\u5206\u673a\u654f\u7075\u5de7\uff0c\u77ed\u65f6\u95f4\u5185\u80fd\u591f\u7206\u53d1\u51fa\u6781\u5feb\u7684\u901f\u5ea6\u3002[npc.Her]\u7684\u8eab\u4f53\u4f1a\u5c3d\u53ef\u80fd\u591a\u5730\u751f\u80b2\u540e\u4ee3\uff0c\u65e0\u8bba[npc.she]\u662f\u5426\u613f\u610f\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.FERTILITY, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.VIRILITY, Float.valueOf(50.0f))), null, "\u5154\u5b50\u4ea7\u4ed4", "\u5154\u5b50\u4ea7\u4ed4", "RABBIT_MORPH_BASIC", "RABBIT_MORPH_ADVANCED", Race.RABBIT_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_RABBIT_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u5154\u5b50\uff0c\u5f53\u4e0b\u80a2\u62df\u4eba\u65f6\u88ab\u79f0\u4e3a\u201c\u5154\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u5154\u5b50\u7684\u6837\u5b50\u65f6\u5219\u79f0\u4e3a\u201c\u534a\u5154\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.FIVE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                if (body.isFeminine() && body.getRaceStage() == RaceStage.GREATER) {
                    body.getHair().setNeckFluff(null, Math.random() < (double)0.1f);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", false, false), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", false, true), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", false, false), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", true, false), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", false, true), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.RABBIT_MORPH) {
                    return 100;
                }
                return 0;
            }
        };
        RABBIT_MORPH_LOP = new AbstractSubspecies(false, 12000, "innoxia_race_rabbit_bunny_juice", "innoxia_race_rabbit_bunny_carrot_cake", "statusEffects/race/raceRabbitLopMorph", "statusEffects/race/raceBackground", "\u5782\u8033\u5154\u5316\u5f62", "\u5782\u8033\u5154\u5316\u5f62", "\u5782\u8033\u5154\u7537", "\u5782\u8033\u5154\u5973", "\u5782\u8033\u5154\u7537", "\u5782\u8033\u5154\u5973", new FeralAttributes("\u5782\u8033\u5154", "\u5782\u8033\u5154", LegConfiguration.QUADRUPEDAL, 20, 0, 1, 5, 1, false), Nocturnality.CREPUSCULAR, "[npc.NameIsFull]\u5341\u5206\u673a\u654f\u7075\u5de7\uff0c\u77ed\u65f6\u95f4\u5185\u80fd\u591f\u7206\u53d1\u51fa\u6781\u5feb\u7684\u901f\u5ea6\u3002[npc.Her]\u7684\u8eab\u4f53\u4f1a\u5c3d\u53ef\u80fd\u591a\u5730\u751f\u80b2\u540e\u4ee3\uff0c\u65e0\u8bba[npc.she]\u662f\u5426\u613f\u610f\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.CRITICAL_DAMAGE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.FERTILITY, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.VIRILITY, Float.valueOf(50.0f))), null, "\u5154\u5b50\u4ea7\u4ed4", "\u5154\u5b50\u4ea7\u4ed4", "RABBIT_MORPH_BASIC", "RABBIT_MORPH_ADVANCED", Race.RABBIT_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_RABBIT_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u53ea\u7684\u4eba\u5f62\u5154\uff0c\u62e5\u6709\u4e0b\u5782\u7684\u8033\u6735\u800c\u4e0d\u662f\u5e38\u89c1\u7684\u7ad6\u7acb\u8033\u6735\u3002\u5f53\u4e0b\u80a2\u62df\u4eba\u65f6\u79f0\u4e3a\u201c\u5782\u8033\u5154\u5316\u5f62\u201d\uff0c\u800c\u5f53\u4e0b\u80a2\u5448\u73b0\u51fa\u5927\u578b\u517d\u6001\u5782\u8033\u5154\u7684\u6837\u5b50\u65f6\u79f0\u4e3a\u201c\u534a\u5782\u8033\u5154\u4eba\u201d\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DOMINION, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.TEN), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.FIVE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, null){

            @Override
            public void applySpeciesChanges(Body body) {
                if (body.getEar().getType() == EarType.RABBIT_MORPH) {
                    body.getEar().setType(null, EarType.RABBIT_MORPH_FLOPPY);
                }
                if (body.isFeminine() && body.getRaceStage() == RaceStage.GREATER) {
                    body.getHair().setNeckFluff(null, Math.random() < (double)0.1f);
                }
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e", "\u52a0\u5361\u6d1b\u666e"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", false, false), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", false, true), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", false, false), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", true, false), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", false, true), this.applyNonBipedNameChange(body, "\u52a0\u5361\u6d1b\u666e", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.RABBIT_MORPH && body.getEar().getType() == EarType.RABBIT_MORPH_FLOPPY) {
                    return 150;
                }
                return 0;
            }
        };
        BAT_MORPH = new AbstractSubspecies(true, 10000, "innoxia_race_bat_fruit_bats_juice_box", "innoxia_race_bat_fruit_bats_salad", "statusEffects/race/raceBatMorph", "statusEffects/race/raceBackground", "\u8759\u8760\u5316\u5f62", "\u8759\u8760\u5316\u5f62", "\u8759\u8760\u7537", "\u8759\u8760\u5973", "\u8759\u8760\u7537", "\u8759\u8760\u5973", new FeralAttributes("\u8759\u8760", "\u8759\u8760", LegConfiguration.WINGED_BIPED, 30, 0, 1, 1, 1, false){

            @Override
            public boolean isArmsOrWingsPresent() {
                return true;
            }
        }, Nocturnality.NOCTURNAL, "\u7531\u4e8e\u72ec\u7279\u7684\u56de\u58f0\u5b9a\u4f4d\u80fd\u529b\uff0c\u6240\u6709\u7684\u8759\u8760\u5316\u5f62\u90fd\u6709\u5c3d\u53ef\u80fd\u591a\u8bf4\u8bdd\u7684\u5929\u6027\u3002\u6b63\u56e0\u5982\u6b64\uff0c[npc.Name]\u4f1a\u5728\u8111\u6d77\u4e2d\u4e0d\u65ad\u9884\u6f14\u5bf9\u8bdd\uff0c\u5728\u4e0e\u4eba\u89c1\u9762\u524d\uff0c\u5c31\u80fd\u60f3\u51fa\u65b0\u5947\u7684\u65b9\u5f0f\u5438\u5f15\u5bf9\u65b9\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(15.0f))), null, "\u98de\u72d0", "\u98de\u72d0'", "BAT_MORPH_BASIC", "BAT_MORPH_ADVANCED", Race.BAT_MORPH, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_BAT_MORPH, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u53cc\u8db3\u8759\u8760\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TWO), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.SUBMISSION, SubspeciesSpawnRarity.TWO), new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.BAT_CAVERNS, SubspeciesSpawnRarity.TEN), new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.ONE)), null, null){

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.BAT_MORPH) {
                    return 100;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }
        };
        HARPY = new AbstractSubspecies(true, 12000, "innoxia_race_harpy_harpy_perfume", "innoxia_race_harpy_bubblegum_lollipop", "statusEffects/race/raceHarpy", "statusEffects/race/raceBackground", "\u54c8\u6bd4", "\u54c8\u6bd4", "\u54c8\u6bd4", "\u54c8\u6bd4", "\u54c8\u6bd4", "\u54c8\u6bd4", new FeralAttributes("\u5929\u5802\u9e1f", "\u5929\u5802\u9e1f", LegConfiguration.AVIAN, 30, 0, 1, 0, 1, true){

            @Override
            public boolean isArmsOrWingsPresent() {
                return true;
            }
        }, Nocturnality.DIURNAL, "[npc.NameIsFull]\u75f4\u8ff7\u4e8e\u81ea\u5df1\u7684\u5916\u8868\uff0c\u4e3a\u4e86\u5c3d\u53ef\u80fd\u5730\u770b\u8d77\u6765\u6709\u5438\u5f15\u529b\uff0c[npc.she]\u8ba4\u4e3a\u82b1\u8d39\u4e00\u534a\u9192\u7740\u7684\u65f6\u95f4\u6765\u6253\u626e\u81ea\u5df1\u4e5f\u662f\u5f88\u6b63\u5e38\u7684\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(15.0f))), null, "\u54c8\u6bd4\u5168\u77e5\u9053", "\u54c8\u6bd4\u5168\u77e5\u9053", "HARPY_BASIC", "HARPY_ADVANCED", Race.HARPY, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_HARPY, SubspeciesPreference.FOUR_ABUNDANT, "\u4e00\u79cd\u4eba\u5f62\u7684\u53cc\u8db3\u9e1f\u7c7b\u3002\u4e00\u822c\u53ea\u6709\u624b\u81c2\u3001\u817f\u90e8\u3001\u773c\u775b\u3001\u8033\u6735\u548c\u6bdb\u53d1\u4e3a\u975e\u4eba\u7c7b\u6837\u8c8c\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SAVANNAH, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.DESERT_CITY, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE, SubspeciesSpawnRarity.THREE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.JUNGLE_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.HARPY_NEST, SubspeciesSpawnRarity.TEN), new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, Util.newArrayListOfValues(SubspeciesFlag.DISABLE_SPAWN_PREFERENCE, SubspeciesFlag.DISABLE_FURRY_PREFERENCE)){

            @Override
            public String getName(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && (body == null || !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL)) {
                    return "\u557e";
                }
                return super.getName(body);
            }

            @Override
            public String getNamePlural(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && (body == null || !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL)) {
                    return "\u557e";
                }
                return super.getNamePlural(body);
            }

            @Override
            public String getSingularMaleName(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && body != null && !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL) {
                    return "\u557e";
                }
                return super.getSingularMaleName(body);
            }

            @Override
            public String getSingularFemaleName(Body body) {
                if (Main.game != null && Main.game.isSillyModeEnabled() && body != null && !body.isFeral() && body.getLegConfiguration() == LegConfiguration.BIPEDAL) {
                    return "\u557e";
                }
                return super.getSingularFemaleName(body);
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u6012\u517d", "\u6012\u517d", "\u6012\u517d", "\u6012\u517d", "\u6012\u517d", "\u6012\u517d"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u6012\u517d", false, false), this.applyNonBipedNameChange(body, "\u6012\u517d", false, true), this.applyNonBipedNameChange(body, "\u6012\u517d", false, false), this.applyNonBipedNameChange(body, "\u6012\u517d", true, false), this.applyNonBipedNameChange(body, "\u6012\u517d", false, true), this.applyNonBipedNameChange(body, "\u6012\u517d", true, true)};
                }
                return names;
            }

            @Override
            public String getNonBipedRaceName(Body body) {
                return "\u54c8\u6bd4";
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HARPY) {
                    return 100;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }
        };
        HARPY_RAVEN = new AbstractSubspecies(false, 14000, "innoxia_race_harpy_harpy_perfume", "innoxia_race_harpy_bubblegum_lollipop", "statusEffects/race/raceHarpy", "statusEffects/race/raceBackground", "\u6e21\u9e26\u54c8\u6bd4", "\u6e21\u9e26\u54c8\u6bd4", "\u6e21\u9e26\u54c8\u6bd4", "\u6e21\u9e26\u54c8\u6bd4", "\u6e21\u9e26\u54c8\u6bd4", "\u6e21\u9e26\u54c8\u6bd4", new FeralAttributes("\u6e21\u9e26", "\u6e21\u9e26", LegConfiguration.AVIAN, 60, 0, 1, 0, 1, false){

            @Override
            public boolean isArmsOrWingsPresent() {
                return true;
            }
        }, Nocturnality.DIURNAL, "[npc.NameIsFull]\u75f4\u8ff7\u4e8e\u81ea\u5df1\u7684\u5916\u8868\uff0c\u4e3a\u4e86\u5c3d\u53ef\u80fd\u5730\u770b\u8d77\u6765\u6709\u5438\u5f15\u529b\uff0c[npc.she]\u8ba4\u4e3a\u82b1\u8d39\u4e00\u534a\u9192\u7740\u7684\u65f6\u95f4\u6765\u6253\u626e\u81ea\u5df1\u4e5f\u662f\u5f88\u6b63\u5e38\u7684\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(15.0f))), null, "\u54c8\u6bd4\u5168\u77e5\u9053", "\u54c8\u6bd4\u5168\u77e5\u9053", "HARPY_BASIC", "HARPY_ADVANCED", Race.HARPY, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.BASE_BLACK, SubspeciesPreference.ONE_LOW, "\u4e00\u79cd\u4eba\u5f62\u7684\u53cc\u8db3\u6e21\u9e26\uff0c\u7fbd\u6bdb\u4e3a\u6f06\u9ed1\u8272\u3002\u4e00\u822c\u53ea\u6709\u624b\u81c2\u3001\u817f\u90e8\u3001\u773c\u775b\u3001\u8033\u6735\u548c\u6bdb\u53d1\u4e3a\u975e\u4eba\u7c7b\u6837\u8c8c\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.WOODLAND, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.HARPY_NEST, SubspeciesSpawnRarity.THREE), new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, Util.newArrayListOfValues(SubspeciesFlag.DISABLE_FURRY_PREFERENCE)){

            @Override
            public void applySpeciesChanges(Body body) {
                Colour ravenColour = PresetColour.COVERING_BLACK;
                if (Math.random() < 0.5) {
                    ravenColour = PresetColour.COVERING_JET_BLACK;
                }
                body.getCoverings().put(BodyCoveringType.FEATHERS, new Covering(BodyCoveringType.FEATHERS, CoveringPattern.NONE, ravenColour, false, ravenColour, false));
                body.getCoverings().put(BodyCoveringType.BODY_HAIR_HARPY, new Covering(BodyCoveringType.BODY_HAIR_HARPY, CoveringPattern.NONE, ravenColour, false, ravenColour, false));
                body.getCoverings().put(BodyCoveringType.HAIR_HARPY, new Covering(BodyCoveringType.HAIR_HARPY, CoveringPattern.NONE, ravenColour, false, ravenColour, false));
                body.getCoverings().put(BodyCoveringType.HARPY_SKIN, new Covering(BodyCoveringType.HARPY_SKIN, CoveringPattern.NONE, PresetColour.SKIN_EBONY, false, PresetColour.SKIN_EBONY, false));
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u6012\u517d", "\u6012\u517d", "\u6012\u517d", "\u6012\u517d", "\u6012\u517d", "\u6012\u517d"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u6012\u517d", false, false), this.applyNonBipedNameChange(body, "\u6012\u517d", false, true), this.applyNonBipedNameChange(body, "\u6012\u517d", false, false), this.applyNonBipedNameChange(body, "\u6012\u517d", true, false), this.applyNonBipedNameChange(body, "\u6012\u517d", false, true), this.applyNonBipedNameChange(body, "\u6012\u517d", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HARPY) {
                    AbstractBodyCoveringType feathers;
                    AbstractBodyCoveringType abstractBodyCoveringType = feathers = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FEATHER) : BodyCoveringType.FEATHERS;
                    if (body.getCoverings().get(feathers).getPrimaryColour() == PresetColour.COVERING_BLACK || body.getCoverings().get(feathers).getPrimaryColour() == PresetColour.COVERING_JET_BLACK) {
                        return 150;
                    }
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }
        };
        HARPY_SWAN = new AbstractSubspecies(false, 22000, "innoxia_race_harpy_harpy_perfume", "innoxia_race_harpy_bubblegum_lollipop", "statusEffects/race/raceHarpy", "statusEffects/race/raceBackground", "\u5929\u9e45\u54c8\u6bd4", "\u5929\u9e45\u54c8\u6bd4", "\u5929\u9e45\u54c8\u6bd4", "\u5929\u9e45\u54c8\u6bd4", "\u5929\u9e45\u54c8\u6bd4", "\u5929\u9e45\u54c8\u6bd4", new FeralAttributes("\u5929\u9e45", "\u5929\u9e45", LegConfiguration.AVIAN, 100, 0, 1, 0, 1, false){

            @Override
            public boolean isArmsOrWingsPresent() {
                return true;
            }
        }, Nocturnality.DIURNAL, "[npc.NameIsFull]\u75f4\u8ff7\u4e8e\u81ea\u5df1\u7684\u5916\u8868\uff0c\u4e3a\u4e86\u5c3d\u53ef\u80fd\u5730\u770b\u8d77\u6765\u6709\u5438\u5f15\u529b\uff0c[npc.she]\u8ba4\u4e3a\u82b1\u8d39\u4e00\u534a\u9192\u7740\u7684\u65f6\u95f4\u6765\u6253\u626e\u81ea\u5df1\u4e5f\u662f\u5f88\u6b63\u5e38\u7684\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(15.0f))), null, "\u54c8\u6bd4\u5168\u77e5\u9053", "\u54c8\u6bd4\u5168\u77e5\u9053", "HARPY_BASIC", "HARPY_ADVANCED", Race.HARPY, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.BASE_WHITE, SubspeciesPreference.ONE_LOW, "\u4e00\u79cd\u4eba\u5f62\u7684\u53cc\u8db3\u5929\u9e45\uff0c\u62e5\u6709\u767d\u8272\u7684\u7fbd\u6bdb\uff0c\u4ee5\u53ca\u9ed1\u6a80\u8272\u6216\u7070\u8272\u7684\u817f\u90e8\u76ae\u80a4\u3002\u4e00\u822c\u53ea\u6709\u624b\u81c2\u3001\u817f\u90e8\u3001\u773c\u775b\u3001\u8033\u6735\u548c\u6bdb\u53d1\u4e3a\u975e\u4eba\u7c7b\u6837\u8c8c\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELDS, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.RIVER, SubspeciesSpawnRarity.FIVE), new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.FIELD_CITY, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.HARPY_NEST, SubspeciesSpawnRarity.THREE), new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.NIGHTLIFE_CLUB, SubspeciesSpawnRarity.TEN)), null, Util.newArrayListOfValues(SubspeciesFlag.DISABLE_FURRY_PREFERENCE)){

            @Override
            public void applySpeciesChanges(Body body) {
                body.getCoverings().put(BodyCoveringType.FEATHERS, new Covering(BodyCoveringType.FEATHERS, CoveringPattern.NONE, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false));
                body.getCoverings().put(BodyCoveringType.HAIR_HARPY, new Covering(BodyCoveringType.HAIR_HARPY, CoveringPattern.NONE, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false));
                body.getCoverings().put(BodyCoveringType.BODY_HAIR_HARPY, new Covering(BodyCoveringType.BODY_HAIR_HARPY, CoveringPattern.NONE, PresetColour.COVERING_WHITE, false, PresetColour.COVERING_WHITE, false));
                body.getCoverings().put(BodyCoveringType.HARPY_SKIN, new Covering(BodyCoveringType.HARPY_SKIN, CoveringPattern.NONE, PresetColour.SKIN_EBONY, false, PresetColour.SKIN_EBONY, false));
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u6012\u517d", "\u6012\u517d", "\u6012\u517d", "\u6012\u517d", "\u6012\u517d", "\u6012\u517d"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u6012\u517d", false, false), this.applyNonBipedNameChange(body, "\u6012\u517d", false, true), this.applyNonBipedNameChange(body, "\u6012\u517d", false, false), this.applyNonBipedNameChange(body, "\u6012\u517d", true, false), this.applyNonBipedNameChange(body, "\u6012\u517d", false, true), this.applyNonBipedNameChange(body, "\u6012\u517d", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HARPY) {
                    AbstractBodyCoveringType feathers = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FEATHER) : BodyCoveringType.FEATHERS;
                    AbstractBodyCoveringType legSkin = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_SKIN) : BodyCoveringType.HARPY_SKIN;
                    Colour legColour = body.getCoverings().get(legSkin).getPrimaryColour();
                    if (body.getCoverings().get(feathers).getPrimaryColour() == PresetColour.COVERING_WHITE && (legColour == PresetColour.SKIN_GREY || legColour == PresetColour.SKIN_EBONY)) {
                        return 150;
                    }
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }
        };
        HARPY_PHOENIX = new AbstractSubspecies(false, 50000, "innoxia_race_harpy_harpy_perfume", "innoxia_race_harpy_bubblegum_lollipop", "statusEffects/race/raceHarpy", "statusEffects/race/raceBackgroundPhoenix", "\u4e0d\u6b7b\u9e1f\u54c8\u6bd4", "\u4e0d\u6b7b\u9e1f\u54c8\u6bd4", "\u4e0d\u6b7b\u9e1f\u54c8\u6bd4", "\u4e0d\u6b7b\u9e1f\u54c8\u6bd4", "\u4e0d\u6b7b\u9e1f\u54c8\u6bd4", "\u4e0d\u6b7b\u9e1f\u54c8\u6bd4", new FeralAttributes("\u4e0d\u6b7b\u9e1f", "\u4e0d\u6b7b\u9e1f", LegConfiguration.AVIAN, 90, 0, 1, 0, 1, true){

            @Override
            public boolean isArmsOrWingsPresent() {
                return true;
            }
        }, Nocturnality.DIURNAL, "[npc.NameIsFull]\u4e0e\u5176\u4ed6\u54c8\u6bd4\u4e00\u6837\u75f4\u8ff7\u4e8e\u81ea\u5df1\u7684\u5916\u8868\uff0c[npc.herHim]\u8fd8\u62e5\u6709\u64cd\u63a7\u5965\u672f\u7684\u5929\u8d4b\uff0c\u53ef\u4ee5\u76f8\u5bf9\u8f7b\u677e\u5730\u5b66\u4e60\u548c\u65bd\u653e\u6cd5\u672f\u3002\u7279\u522b\u662f[npc.she]\u5bf9\u5965\u672f\u706b\u7130\u6709\u7740\u5f02\u5e38\u9ad8\u7684\u4eb2\u548c\u529b\u2026\u2026", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(10.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_FIRE, Float.valueOf(75.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_FIRE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(15.0f))), null, "\u54c8\u6bd4\u5168\u77e5\u9053", "\u54c8\u6bd4\u5168\u77e5\u9053", "HARPY_BASIC", "HARPY_ADVANCED", Race.HARPY, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.BASE_ORANGE, SubspeciesPreference.ONE_LOW, "\u4e00\u79cd\u5b58\u5728\u4e8e\u795e\u8bdd\u4e2d\u7684\u9e1f\u7c7b\uff0c\u4eba\u5f62\u53cc\u8db3\uff0c\u7fbd\u6bdb\u901a\u5e38\u4e3a\u6563\u53d1\u7740\u5149\u8292\u7684\u7ea2\u8272\u3001\u6a58\u8272\u6216\u9ec4\u8272\uff0c\u6216\u8005\u5c31\u76f4\u63a5\u7531\u5965\u672f\u706b\u7130\u6784\u6210\u3002\u8fd9\u4e2a\u79cd\u65cf\u5341\u5206\u7a00\u6709\uff0c\u4e00\u822c\u53ea\u6709\u624b\u81c2\u3001\u817f\u90e8\u3001\u773c\u775b\u3001\u8033\u6735\u548c\u6bdb\u53d1\u4e3a\u975e\u4eba\u7c7b\u6837\u8c8c\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.VOLCANO, SubspeciesSpawnRarity.THREE)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.HARPY_NEST, SubspeciesSpawnRarity.ONE)), null, Util.newArrayListOfValues(SubspeciesFlag.DISABLE_FURRY_PREFERENCE)){

            @Override
            public void applySpeciesChanges(Body body) {
                CoveringPattern pattern = CoveringPattern.OMBRE;
                if (Math.random() < 0.5) {
                    pattern = CoveringPattern.HIGHLIGHTS;
                }
                body.getCoverings().put(BodyCoveringType.FEATHERS, new Covering(BodyCoveringType.FEATHERS, pattern, PresetColour.COVERING_ORANGE, true, PresetColour.COVERING_YELLOW, true));
                body.getCoverings().put(BodyCoveringType.HAIR_HARPY, new Covering(BodyCoveringType.HAIR_HARPY, pattern, PresetColour.COVERING_RED, true, PresetColour.COVERING_ORANGE, true));
                body.getCoverings().put(BodyCoveringType.BODY_HAIR_HARPY, new Covering(BodyCoveringType.BODY_HAIR_HARPY, CoveringPattern.NONE, PresetColour.COVERING_RED, true, PresetColour.COVERING_RED, true));
                body.getCoverings().put(BodyCoveringType.HARPY_SKIN, new Covering(BodyCoveringType.HARPY_SKIN, CoveringPattern.NONE, PresetColour.SKIN_ORANGE, false, PresetColour.SKIN_ORANGE, false));
            }

            @Override
            public String[] getHalfDemonName(Body body) {
                String[] names = new String[]{"\u4e0d\u6b7b\u9e1f\u6012\u517d", "\u4e0d\u6b7b\u9e1f\u6012\u517d", "\u4e0d\u6b7b\u9e1f\u6012\u517d", "\u4e0d\u6b7b\u9e1f\u6012\u517d", "\u4e0d\u6b7b\u9e1f\u6012\u517d", "\u4e0d\u6b7b\u9e1f\u6012\u517d"};
                if (body != null && !body.getHalfDemonSubspecies().isNonBiped()) {
                    names = new String[]{this.applyNonBipedNameChange(body, "\u4e0d\u6b7b\u9e1f\u6012\u517d", false, false), this.applyNonBipedNameChange(body, "\u4e0d\u6b7b\u9e1f\u6012\u517d", false, true), this.applyNonBipedNameChange(body, "\u4e0d\u6b7b\u9e1f\u6012\u517d", false, false), this.applyNonBipedNameChange(body, "\u4e0d\u6b7b\u9e1f\u6012\u517d", true, false), this.applyNonBipedNameChange(body, "\u4e0d\u6b7b\u9e1f\u6012\u517d", false, true), this.applyNonBipedNameChange(body, "\u4e0d\u6b7b\u9e1f\u6012\u517d", true, true)};
                }
                return names;
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.HARPY) {
                    AbstractBodyCoveringType feathers;
                    AbstractBodyCoveringType abstractBodyCoveringType = feathers = body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE ? BodyCoveringType.getMaterialBodyCoveringType(body.getBodyMaterial(), BodyCoveringCategory.MAIN_FEATHER) : BodyCoveringType.FEATHERS;
                    if (body.getCoverings().get(feathers).isPrimaryGlowing() && (body.getCoverings().get(feathers).getPrimaryColour() == PresetColour.COVERING_RED || body.getCoverings().get(feathers).getPrimaryColour() == PresetColour.COVERING_ORANGE || body.getCoverings().get(feathers).getPrimaryColour() == PresetColour.COVERING_YELLOW) || body.getBodyMaterial() == BodyMaterial.FIRE) {
                        return 200;
                    }
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }
        };
        SLIME = new AbstractSubspecies(true, 10000, "innoxia_race_slime_slime_quencher", "innoxia_race_slime_biojuice_canister", "statusEffects/race/raceSlime", "statusEffects/race/raceBackgroundSlime", "\u53f2\u83b1\u59c6", "\u53f2\u83b1\u59c6", "\u53f2\u83b1\u59c6\u7537", "\u53f2\u83b1\u59c6\u5973", "\u53f2\u83b1\u59c6\u7537", "\u53f2\u83b1\u59c6\u5973", null, Nocturnality.DIURNAL, "[npc.nameIsFull]\u501f\u52a9\u5176\u67d4\u8f6f\u7c98\u6ed1\u7684\u8eab\u4f53\uff0c\u80fd\u591f\u5b8c\u5168\u514d\u75ab\u7269\u7406\u4f24\u5bb3\uff0c\u4f46\u4ece\u800c\u5728\u5f92\u624b\u65f6\u4e5f\u65e0\u6cd5\u9020\u6210\u592a\u591a\u4f24\u5bb3\u3002[npc.She]\u4e5f\u80fd\u968f\u610f\u53d8\u5316\u5f62\u4f53\uff0c\u968f\u5fc3\u6240\u6b32\u5730\u6210\u4e3a\u4efb\u4f55\u60f3\u6210\u4e3a\u7684\u5f62\u6001\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_ARCANE, Float.valueOf(0.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_CORRUPTION, Float.valueOf(25.0f))), Util.newArrayListOfValues(new String[0]), "\u53f2\u83b1\u59c6\u8da3\u95fb", "\u53f2\u83b1\u59c6\u8da3\u95fb", "SLIME_BASIC", "SLIME_ADVANCED", Race.SLIME, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 2), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 0)), PresetColour.RACE_SLIME, SubspeciesPreference.FOUR_ABUNDANT, "\u5b8c\u5168\u7531\u7c98\u6db2\u6784\u6210\u7684\u751f\u7269\uff0c\u539f\u672c\u5fc3\u810f\u7684\u4f4d\u7f6e\u60ac\u6d6e\u7740\u4e00\u9897\u56fa\u6001\u7684\u6838\u5fc3\u3002", (Map)Util.newHashMapOfValues(new Util.Value<WorldRegion, SubspeciesSpawnRarity>(WorldRegion.SUBMISSION, SubspeciesSpawnRarity.TEN)), (Map)Util.newHashMapOfValues(new Util.Value<AbstractWorldType, SubspeciesSpawnRarity>(WorldType.BAT_CAVERNS, SubspeciesSpawnRarity.TEN)), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public AbstractItemType getTransformativeItem(GameCharacter owner) {
                if (this.getTransformativeItemId() == null || this.getTransformativeItemId().isEmpty()) {
                    return null;
                }
                if (owner != null && !owner.hasFetish(Fetish.FETISH_TRANSFORMATION_GIVING)) {
                    return ItemType.getItemTypeFromId("innoxia_race_slime_slime_quencher");
                }
                return ItemType.getItemTypeFromId(this.getTransformativeItemId());
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setBodyMaterial(BodyMaterial.SLIME);
            }

            @Override
            public String getStatusEffectDescription(GameCharacter character) {
                if (character != null) {
                    AbstractSubspecies coreSubspecies = character.getBody().getFleshSubspecies();
                    if (character.getSubspeciesOverrideRace() == Race.DEMON) {
                        return UtilText.parse(character, "[npc.nameIsFull]\u501f\u52a9\u5176\u67d4\u8f6f\u7c98\u6ed1\u7684\u8eab\u4f53\uff0c\u80fd\u591f\u5b8c\u5168\u514d\u75ab\u7269\u7406\u4f24\u5bb3\uff0c\u4f46\u4ece\u800c\u5728\u5f92\u624b\u65f6\u4e5f\u65e0\u6cd5\u9020\u6210\u592a\u4e25\u91cd\u7684\u4f24\u5bb3\u3002[npc.Her]\u7684\u53f2\u83b1\u59c6\u6838\u5fc3\u5728\u5f3a\u5927\u7684\u529b\u91cf\u4e0b\u8109\u52a8\u7740\uff0c\u8fd9\u610f\u5473\u7740[npc.sheIs]\u662f\u4e00\u53ea\u771f\u6b63\u7684\u6076\u9b54\u53f2\u83b1\u59c6\u3002", new ParserTag[0]);
                    }
                    if (coreSubspecies == DEMON) {
                        return UtilText.parse(character, "[npc.nameIsFull]\u501f\u52a9\u5176\u67d4\u8f6f\u7c98\u6ed1\u7684\u8eab\u4f53\uff0c\u80fd\u591f\u5b8c\u5168\u514d\u75ab\u7269\u7406\u4f24\u5bb3\uff0c\u4f46\u4ece\u800c\u5728\u5f92\u624b\u65f6\u4e5f\u65e0\u6cd5\u9020\u6210\u592a\u4e25\u91cd\u7684\u4f24\u5bb3\u3002\u5c3d\u7ba1[npc.she]\u770b\u4e0a\u53bb\u50cf\u4e2a\u6076\u9b54\uff0c\u4f46\u53ea\u4e0d\u8fc7\u662f\u62df\u6001\u4e86\u5916\u5f62\u800c\u5df2\u2026\u2026", new ParserTag[0]);
                    }
                }
                return super.getStatusEffectDescription(character);
            }

            @Override
            public String getName(Body body) {
                if (body == null) {
                    return super.getName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getName(body);
                }
                if (coreSubspecies == DEMON && body.getSubspeciesOverride() == null) {
                    return coreSubspecies.getName(body) + "\u62df\u6001\u53f2\u83b1\u59c6";
                }
                return coreSubspecies.getName(body) + "\u53f2\u83b1\u59c6";
            }

            @Override
            public String getNamePlural(Body body) {
                if (body == null) {
                    return super.getNamePlural(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getNamePlural(body);
                }
                if (coreSubspecies == DEMON && body.getSubspeciesOverride() == null) {
                    return coreSubspecies.getName(body) + "\u62df\u6001\u53f2\u83b1\u59c6";
                }
                return coreSubspecies.getName(body) + "\u53f2\u83b1\u59c6";
            }

            @Override
            public String getSingularMaleName(Body body) {
                if (body == null) {
                    return super.getSingularMaleName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getSingularMaleName(body);
                }
                if (coreSubspecies == DEMON && body.getSubspeciesOverride() == null) {
                    return coreSubspecies.getSingularMaleName(body) + "\u62df\u6001\u53f2\u83b1\u59c6";
                }
                return coreSubspecies.getSingularMaleName(body) + "\u53f2\u83b1\u59c6";
            }

            @Override
            public String getSingularFemaleName(Body body) {
                if (body == null) {
                    return super.getSingularFemaleName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getSingularFemaleName(body);
                }
                if (coreSubspecies == DEMON && body.getSubspeciesOverride() == null) {
                    return coreSubspecies.getSingularFemaleName(body) + "\u62df\u6001\u53f2\u83b1\u59c6";
                }
                return coreSubspecies.getSingularFemaleName(body) + "\u53f2\u83b1\u59c6";
            }

            @Override
            public String getPluralMaleName(Body body) {
                if (body == null) {
                    return super.getPluralMaleName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getPluralMaleName(body);
                }
                if (coreSubspecies == DEMON && body.getSubspeciesOverride() == null) {
                    return coreSubspecies.getSingularMaleName(body) + "\u62df\u6001\u53f2\u83b1\u59c6";
                }
                return coreSubspecies.getSingularMaleName(body) + "\u53f2\u83b1\u59c6";
            }

            @Override
            public String getPluralFemaleName(Body body) {
                if (body == null) {
                    return super.getPluralFemaleName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getPluralFemaleName(body);
                }
                if (coreSubspecies == DEMON && body.getSubspeciesOverride() == null) {
                    return coreSubspecies.getSingularFemaleName(body) + "\u62df\u6001\u53f2\u83b1\u59c6";
                }
                return coreSubspecies.getSingularFemaleName(body) + "\u53f2\u83b1\u59c6";
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character == null) {
                    return HUMAN.getSlimeSVGString(null);
                }
                return character.getBody().getFleshSubspecies().getSlimeSVGString(character);
            }

            @Override
            public String getSVGStringDesaturated(GameCharacter character) {
                if (character == null) {
                    return HUMAN.getSVGStringDesaturated(null);
                }
                return character.getBody().getFleshSubspecies().getSVGStringDesaturated(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.SLIME) {
                    return 10000;
                }
                return 0;
            }

            @Override
            public FeralAttributes getFeralAttributes(Body body) {
                if (body == null) {
                    return super.getFeralAttributes(body);
                }
                return body.getFleshSubspecies().getFeralAttributes(body);
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        DOLL = new AbstractSubspecies(true, 10000, "innoxia_race_doll_silic_oil", null, "statusEffects/race/raceDoll", "statusEffects/race/raceBackgroundDoll", "\u73a9\u5076", "\u73a9\u5076", "\u73a9\u5076", "\u73a9\u5076", "\u73a9\u5076", "\u73a9\u5076", null, Nocturnality.CATHEMERAL, "[npc.NameIsFull]\u662f\u4e00\u4e2a\u5916\u5f62\u6781\u5176\u903c\u771f\u7684\u81ea\u52a8\u6027\u7231\u73a9\u5076\uff0c\u662f\u5728\u201c\u6d1b\u7ef4\u8036\u7eb3\u7684\u5962\u4f88\u54c1\u5e97\u201d\u4e2d\u7531\u6ce8\u5165\u5965\u672f\u7684\u7845\u80f6\u5236\u6210\u3002[npc.Her]\u4eba\u5de5\u9020\u5c31\u7684\u8eab\u4f53\u548c\u5965\u672f\u9a71\u52a8\u7684\u81ea\u52a8\u539f\u7406\u4f7f[npc.herHim]\u7279\u6027\u591a\u53d8\u3002", (Map)Util.newHashMapOfValues(new Util.Value[0]), Util.newArrayListOfValues("[style.boldExcellent(\u73a9\u5076\u72ec\u6709\u5929\u8d4b\u6811)]", "[style.boldGood(\u5929\u8d4b\u80fd\u591f\u5e26\u6765\u5927\u91cf\u6548\u679c)]"), "\u7ec8\u6781\u73a9\u5177", "\u7ec8\u6781\u73a9\u5177", "DOLL_BASIC", "DOLL_ADVANCED", Race.DOLL, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 1)), PresetColour.RACE_DOLL, SubspeciesPreference.ZERO_NONE, "\u4e00\u4e2a\u6829\u6829\u5982\u751f\u7684\u7845\u80f6\u73a9\u5076\uff0c\u5df2\u7ecf\u6ce8\u5165\u9644\u9b54\uff0c\u80fd\u591f\u79fb\u52a8\u3001\u8bf4\u8bdd\u3001\u9075\u4ece\u6307\u4ee4\u3002", null, (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public AbstractItemType getTransformativeItem(GameCharacter owner) {
                return null;
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setBodyMaterial(BodyMaterial.SILICONE);
                body.getBreast().setMilk(new FluidMilk(FluidType.MILK_DOLL, false));
                body.getBreastCrotch().setMilk(new FluidMilk(FluidType.MILK_DOLL, true));
                body.getPenis().getTesticle().setCum(new FluidCum(FluidType.CUM_DOLL));
                body.getVagina().setGirlcum(new FluidGirlCum(FluidType.GIRL_CUM_DOLL));
            }

            @Override
            public String getName(Body body) {
                if (body == null) {
                    return super.getName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getName(body);
                }
                return coreSubspecies.getName(body) + "\u73a9\u5076";
            }

            @Override
            public String getNamePlural(Body body) {
                if (body == null) {
                    return super.getNamePlural(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getNamePlural(body);
                }
                return coreSubspecies.getName(body) + "\u73a9\u5076";
            }

            @Override
            public String getSingularMaleName(Body body) {
                if (body == null) {
                    return super.getSingularMaleName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getSingularMaleName(body);
                }
                return coreSubspecies.getSingularMaleName(body) + "\u73a9\u5076";
            }

            @Override
            public String getSingularFemaleName(Body body) {
                if (body == null) {
                    return super.getSingularFemaleName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getSingularFemaleName(body);
                }
                return coreSubspecies.getSingularFemaleName(body) + "\u73a9\u5076";
            }

            @Override
            public String getPluralMaleName(Body body) {
                if (body == null) {
                    return super.getPluralMaleName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getPluralMaleName(body);
                }
                return coreSubspecies.getSingularMaleName(body) + "\u73a9\u5076";
            }

            @Override
            public String getPluralFemaleName(Body body) {
                if (body == null) {
                    return super.getPluralFemaleName(body);
                }
                AbstractSubspecies coreSubspecies = body.getFleshSubspecies();
                if (coreSubspecies == HUMAN) {
                    return super.getPluralFemaleName(body);
                }
                return coreSubspecies.getSingularFemaleName(body) + "\u73a9\u5076";
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character == null) {
                    return HUMAN.getDollSVGString(null);
                }
                return character.getBody().getFleshSubspecies().getDollSVGString(character);
            }

            @Override
            public String getSVGStringDesaturated(GameCharacter character) {
                if (character == null) {
                    return HUMAN.getDollSVGStringDesaturated(null);
                }
                return character.getBody().getFleshSubspecies().getDollSVGStringDesaturated(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.DOLL) {
                    return 20000;
                }
                return 0;
            }

            @Override
            public FeralAttributes getFeralAttributes(Body body) {
                if (body == null) {
                    return super.getFeralAttributes(body);
                }
                return body.getFleshSubspecies().getFeralAttributes(body);
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        ELEMENTAL_FIRE = new AbstractSubspecies(false, 100000, "innoxia_race_demon_liliths_gift", null, "statusEffects/race/raceElemental", "statusEffects/race/raceBackgroundFire", "\u706b\u5143\u7d20", "\u706b\u5143\u7d20", "\u706b\u5143\u7d20", "\u706b\u5143\u7d20", "\u706b\u5143\u7d20", "\u706b\u5143\u7d20", null, Nocturnality.DIURNAL, "[npc.NameIsFull]\u662f\u53ec\u5524\u800c\u6765\u7684\u5143\u7d20\u4f53\uff0c\u5f53\u524d\u7ed1\u5b9a\u4e8e\u70c8\u706b\u5b66\u6d3e\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_FIRE, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_FIRE, Float.valueOf(50.0f))), Util.newArrayListOfValues("[style.boldExcellent(\u65e0\u9650\u5236)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u6211\u8f6c\u5316</b>"), "\u706b\u5143\u7d20", "\u706b\u5143\u7d20", "ELEMENTAL_FIRE_BASIC", "ELEMENTAL_FIRE_ADVANCED", Race.ELEMENTAL, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.SPELL_SCHOOL_FIRE, SubspeciesPreference.FOUR_ABUNDANT, "\u7ed1\u5b9a\u4e8e\u70c8\u706b\u5b66\u6d3e\u7684\u5965\u672f\u5143\u7d20\u4f53\u3002", null, (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return 50000;
            }

            @Override
            public AbstractItemType getBook() {
                return ItemType.getLoreBook(this);
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setBodyMaterial(BodyMaterial.FIRE);
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character != null && character instanceof Elemental && ((Elemental)character).getSummoner() != null && !((Elemental)character).getSummoner().isElementalActive()) {
                    if (((Elemental)character).getPassiveForm() == null) {
                        String wispSVG = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_FIRE), this.getColour(character), this.getColour(character), this.getColour(character), "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceWisp() + "</div>");
                        return wispSVG;
                    }
                    AbstractSubspecies passiveForm = ((Elemental)character).getPassiveForm();
                    if (passiveForm.SVGString == null) {
                        passiveForm.initSVGStrings();
                    }
                    String raceSvg = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_FIRE), this.getColour(character), this.getColour(character), this.getColour(character), passiveForm.SVGStringUncoloured);
                    return this.getBipedBackground(raceSvg, character, this.getColour(character));
                }
                return super.getSVGString(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.ELEMENTAL && body.getBodyMaterial() == BodyMaterial.FIRE) {
                    return 100;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        ELEMENTAL_EARTH = new AbstractSubspecies(false, 100000, "innoxia_race_demon_liliths_gift", null, "statusEffects/race/raceElemental", "statusEffects/race/raceBackgroundEarth", "\u571f\u5143\u7d20", "\u571f\u5143\u7d20", "\u571f\u5143\u7d20", "\u571f\u5143\u7d20", "\u571f\u5143\u7d20", "\u571f\u5143\u7d20", null, Nocturnality.DIURNAL, "[npc.NameIsFull]\u662f\u53ec\u5524\u800c\u6765\u7684\u5143\u7d20\u4f53\uff0c\u5f53\u524d\u7ed1\u5b9a\u4e8e\u5927\u5730\u5b66\u6d3e\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_PHYSICAL, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_PHYSICAL, Float.valueOf(50.0f))), Util.newArrayListOfValues("[style.boldExcellent(\u65e0\u9650\u5236)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u6211\u8f6c\u5316</b>"), "\u571f\u5143\u7d20", "\u571f\u5143\u7d20", "ELEMENTAL_EARTH_BASIC", "ELEMENTAL_EARTH_ADVANCED", Race.ELEMENTAL, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 1), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.SPELL_SCHOOL_EARTH, SubspeciesPreference.FOUR_ABUNDANT, "\u7ed1\u5b9a\u4e8e\u5927\u5730\u5b66\u6d3e\u7684\u5965\u672f\u5143\u7d20\u4f53\u3002", null, (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return ELEMENTAL_FIRE.getSubspeciesOverridePriority();
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setBodyMaterial(BodyMaterial.STONE);
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character != null && character instanceof Elemental && ((Elemental)character).getSummoner() != null && !((Elemental)character).getSummoner().isElementalActive()) {
                    if (((Elemental)character).getPassiveForm() == null) {
                        String wispSVG = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_EARTH), this.getColour(character), this.getColour(character), this.getColour(character), "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceWisp() + "</div>");
                        return wispSVG;
                    }
                    AbstractSubspecies passiveForm = ((Elemental)character).getPassiveForm();
                    if (passiveForm.SVGString == null) {
                        passiveForm.initSVGStrings();
                    }
                    String raceSvg = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_EARTH), this.getColour(character), this.getColour(character), this.getColour(character), passiveForm.SVGStringUncoloured);
                    return this.getBipedBackground(raceSvg, character, this.getColour(character));
                }
                return super.getSVGString(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.ELEMENTAL && (body.getBodyMaterial() == BodyMaterial.STONE || body.getBodyMaterial() == BodyMaterial.RUBBER || body.getBodyMaterial() == BodyMaterial.FLESH || body.getBodyMaterial() == BodyMaterial.SLIME || body.getBodyMaterial() == BodyMaterial.SILICONE)) {
                    return 100;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        ELEMENTAL_WATER = new AbstractSubspecies(false, 100000, "innoxia_race_demon_liliths_gift", null, "statusEffects/race/raceElemental", "statusEffects/race/raceBackgroundWater", "\u6c34\u5143\u7d20", "\u6c34\u5143\u7d20", "\u6c34\u5143\u7d20", "\u6c34\u5143\u7d20", "\u6c34\u5143\u7d20", "\u6c34\u5143\u7d20", null, Nocturnality.DIURNAL, "[npc.NameIsFull]\u662f\u53ec\u5524\u800c\u6765\u7684\u5143\u7d20\u4f53\uff0c\u5f53\u524d\u7ed1\u5b9a\u4e8e\u6fc0\u6d41\u5b66\u6d3e\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_ICE, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_ICE, Float.valueOf(50.0f))), Util.newArrayListOfValues("[style.boldExcellent(\u65e0\u9650\u5236)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u6211\u8f6c\u5316</b>"), "\u6c34\u5143\u7d20", "\u6c34\u5143\u7d20", "ELEMENTAL_WATER_BASIC", "ELEMENTAL_WATER_ADVANCED", Race.ELEMENTAL, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 3), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.SPELL_SCHOOL_WATER, SubspeciesPreference.FOUR_ABUNDANT, "\u7ed1\u5b9a\u4e8e\u6fc0\u6d41\u5b66\u6d3e\u7684\u5965\u672f\u5143\u7d20\u4f53\u3002", null, (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return ELEMENTAL_FIRE.getSubspeciesOverridePriority();
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setBodyMaterial(BodyMaterial.WATER);
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character != null && character instanceof Elemental && ((Elemental)character).getSummoner() != null && !((Elemental)character).getSummoner().isElementalActive()) {
                    if (((Elemental)character).getPassiveForm() == null) {
                        String wispSVG = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_WATER), this.getColour(character), this.getColour(character), this.getColour(character), "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceWisp() + "</div>");
                        return wispSVG;
                    }
                    AbstractSubspecies passiveForm = ((Elemental)character).getPassiveForm();
                    if (passiveForm.SVGString == null) {
                        passiveForm.initSVGStrings();
                    }
                    String raceSvg = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_WATER), this.getColour(character), this.getColour(character), this.getColour(character), passiveForm.SVGStringUncoloured);
                    return this.getBipedBackground(raceSvg, character, this.getColour(character));
                }
                return super.getSVGString(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.ELEMENTAL && (body.getBodyMaterial() == BodyMaterial.WATER || body.getBodyMaterial() == BodyMaterial.ICE)) {
                    return 100;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        ELEMENTAL_AIR = new AbstractSubspecies(false, 100000, "innoxia_race_demon_liliths_gift", null, "statusEffects/race/raceElemental", "statusEffects/race/raceBackgroundAir", "\u98ce\u5143\u7d20", "\u98ce\u5143\u7d20", "\u98ce\u5143\u7d20", "\u98ce\u5143\u7d20", "\u98ce\u5143\u7d20", "\u98ce\u5143\u7d20", null, Nocturnality.DIURNAL, "[npc.NameIsFull]\u662f\u53ec\u5524\u800c\u6765\u7684\u5143\u7d20\u4f53\uff0c\u5f53\u524d\u7ed1\u5b9a\u4e8e\u5927\u6c14\u5b66\u6d3e\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(5.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_POISON, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_POISON, Float.valueOf(50.0f))), Util.newArrayListOfValues("[style.boldExcellent(\u65e0\u9650\u5236)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u6211\u8f6c\u5316</b>"), "\u98ce\u5143\u7d20", "\u98ce\u5143\u7d20", "ELEMENTAL_AIR_BASIC", "ELEMENTAL_AIR_ADVANCED", Race.ELEMENTAL, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.SPELL_SCHOOL_AIR, SubspeciesPreference.FOUR_ABUNDANT, "\u7ed1\u5b9a\u4e8e\u5927\u6c14\u5b66\u6d3e\u7684\u5965\u672f\u5143\u7d20\u4f53\u3002", null, (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return ELEMENTAL_FIRE.getSubspeciesOverridePriority();
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setBodyMaterial(BodyMaterial.AIR);
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character != null && character instanceof Elemental && ((Elemental)character).getSummoner() != null && !((Elemental)character).getSummoner().isElementalActive()) {
                    if (((Elemental)character).getPassiveForm() == null) {
                        String wispSVG = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_AIR), this.getColour(character), this.getColour(character), this.getColour(character), "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceWisp() + "</div>");
                        return wispSVG;
                    }
                    AbstractSubspecies passiveForm = ((Elemental)character).getPassiveForm();
                    if (passiveForm.SVGString == null) {
                        passiveForm.initSVGStrings();
                    }
                    String raceSvg = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_AIR), this.getColour(character), this.getColour(character), this.getColour(character), passiveForm.SVGStringUncoloured);
                    return this.getBipedBackground(raceSvg, character, this.getColour(character));
                }
                return super.getSVGString(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.ELEMENTAL && body.getBodyMaterial() == BodyMaterial.AIR) {
                    return 100;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        ELEMENTAL_ARCANE = new AbstractSubspecies(true, 100000, "innoxia_race_demon_liliths_gift", null, "statusEffects/race/raceElemental", "statusEffects/race/raceBackgroundArcane", "\u5965\u672f\u5143\u7d20", "\u5965\u672f\u5143\u7d20", "\u5965\u672f\u5143\u7d20", "\u5965\u672f\u5143\u7d20", "\u5965\u672f\u5143\u7d20", "\u5965\u672f\u5143\u7d20", null, Nocturnality.DIURNAL, "[npc.NameIsFull]\u662f\u53ec\u5524\u800c\u6765\u7684\u5143\u7d20\u4f53\uff0c\u5f53\u524d\u7ed1\u5b9a\u4e8e\u5965\u672f\u5b66\u6d3e\u3002", (Map)Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(15.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.DAMAGE_LUST, Float.valueOf(50.0f)), new Util.Value<AbstractAttribute, Float>(Attribute.RESISTANCE_LUST, Float.valueOf(50.0f))), Util.newArrayListOfValues("[style.boldExcellent(\u65e0\u9650\u5236)]<b style='color: " + PresetColour.TRANSFORMATION_GENERIC.toWebHexString() + ";'>\u81ea\u6211\u8f6c\u5316</b>"), "\u5965\u672f\u5143\u7d20", "\u5965\u672f\u5143\u7d20", "ELEMENTAL_ARCANE_BASIC", "ELEMENTAL_ARCANE_ADVANCED", Race.ELEMENTAL, (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), (Map)Util.newHashMapOfValues(new Util.Value<PerkCategory, Integer>(PerkCategory.PHYSICAL, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.LUST, 5), new Util.Value<PerkCategory, Integer>(PerkCategory.ARCANE, 5)), PresetColour.SPELL_SCHOOL_ARCANE, SubspeciesPreference.FOUR_ABUNDANT, "\u7ed1\u5b9a\u4e8e\u5965\u672f\u5b66\u6d3e\u7684\u5965\u672f\u5143\u7d20\u4f53\u3002", null, (Map)Util.newHashMapOfValues(new Util.Value[0]), null, Util.newArrayListOfValues(SubspeciesFlag.HIDDEN_FROM_PREFERENCES)){

            @Override
            public int getSubspeciesOverridePriority() {
                return ELEMENTAL_FIRE.getSubspeciesOverridePriority();
            }

            @Override
            public void applySpeciesChanges(Body body) {
                body.setBodyMaterial(BodyMaterial.ARCANE);
            }

            @Override
            public String getSVGString(GameCharacter character) {
                if (character != null && character instanceof Elemental && ((Elemental)character).getSummoner() != null && !((Elemental)character).getSummoner().isElementalActive()) {
                    if (((Elemental)character).getPassiveForm() == null) {
                        String wispSVG = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_ARCANE), this.getColour(character), this.getColour(character), this.getColour(character), "<div style='width:100%;height:100%;position:absolute;left:0;bottom:0;'>" + SVGImages.SVG_IMAGE_PROVIDER.getRaceWisp() + "</div>");
                        return wispSVG;
                    }
                    AbstractSubspecies passiveForm = ((Elemental)character).getPassiveForm();
                    if (passiveForm.SVGString == null) {
                        passiveForm.initSVGStrings();
                    }
                    String raceSvg = SvgUtil.colourReplacement(Subspecies.getIdFromSubspecies(ELEMENTAL_ARCANE), this.getColour(character), this.getColour(character), this.getColour(character), passiveForm.SVGStringUncoloured);
                    return this.getBipedBackground(raceSvg, character, this.getColour(character));
                }
                return super.getSVGString(character);
            }

            @Override
            public int getSubspeciesWeighting(Body body, AbstractRace race) {
                if (race == Race.ELEMENTAL && body.getBodyMaterial() == BodyMaterial.ARCANE) {
                    return 100;
                }
                return 0;
            }

            @Override
            public boolean isWinged() {
                return true;
            }

            @Override
            public boolean isDoesNotAge() {
                return true;
            }
        };
        subspeciesToIdMap = new HashMap<AbstractSubspecies, String>();
        idToSubspeciesMap = new HashMap<String, AbstractSubspecies>();
        allSubspecies = new ArrayList<AbstractSubspecies>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/race", "subspecies", null);
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> entry2 : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(entry2.getValue()).equals("subspecies")) continue;
                try {
                    AbstractSubspecies abstractSubspecies = new AbstractSubspecies(entry2.getValue(), entry.getKey(), true){};
                    String string = entry2.getKey().replaceAll("_race", "");
                    allSubspecies.add(abstractSubspecies);
                    subspeciesToIdMap.put(abstractSubspecies, string);
                    idToSubspeciesMap.put(string, abstractSubspecies);
                }
                catch (Exception exception) {
                    System.err.println("Loading modded subspecies failed at 'Subspecies'. File path: " + entry2.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    exception.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/race", "subspecies", null);
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> entry3 : entry.getValue().entrySet()) {
                if (!Util.getXmlRootElementName(entry3.getValue()).equals("subspecies")) continue;
                try {
                    AbstractSubspecies abstractSubspecies = new AbstractSubspecies(entry3.getValue(), entry.getKey(), false){};
                    String id = entry3.getKey().replaceAll("_race", "");
                    allSubspecies.add(abstractSubspecies);
                    subspeciesToIdMap.put(abstractSubspecies, id);
                    idToSubspeciesMap.put(id, abstractSubspecies);
                }
                catch (Exception exception) {
                    System.err.println("Loading subspecies failed at 'Subspecies'. File path: " + entry3.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    exception.printStackTrace(System.err);
                }
            }
        }
        Field[] fieldArray2 = fieldArray = Subspecies.class.getFields();
        int n = fieldArray2.length;
        boolean bl = false;
        while (var5_23 < n) {
            Field field = fieldArray2[var5_23];
            if (AbstractSubspecies.class.isAssignableFrom(field.getType())) {
                try {
                    AbstractSubspecies subspecies = (AbstractSubspecies)field.get(null);
                    subspeciesToIdMap.put(subspecies, field.getName());
                    idToSubspeciesMap.put(field.getName(), subspecies);
                    allSubspecies.add(subspecies);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            ++var5_23;
        }
        worldSpecies = new HashMap<AbstractWorldType, Map<AbstractSubspecies, SubspeciesSpawnRarity>>();
        regionSpecies = new HashMap<WorldRegion, Map<AbstractSubspecies, SubspeciesSpawnRarity>>();
        placeSpecies = new HashMap<AbstractPlaceType, Map<AbstractSubspecies, SubspeciesSpawnRarity>>();
        dominionStormImmuneSpecies = new HashMap<AbstractSubspecies, SubspeciesSpawnRarity>();
        subspeciesFromRace = new HashMap<AbstractRace, List<AbstractSubspecies>>();
        for (AbstractSubspecies abstractSubspecies : Subspecies.getAllSubspecies()) {
            subspeciesFromRace.putIfAbsent(abstractSubspecies.getRace(), new ArrayList());
            subspeciesFromRace.get(abstractSubspecies.getRace()).add(abstractSubspecies);
            for (Map.Entry<WorldRegion, SubspeciesSpawnRarity> entry : abstractSubspecies.getRegionLocations().entrySet()) {
                regionSpecies.putIfAbsent(entry.getKey(), new HashMap());
                regionSpecies.get((Object)entry.getKey()).put(abstractSubspecies, entry.getValue());
                try {
                    if (entry.getKey() != WorldRegion.DOMINION || abstractSubspecies.getRace() != Race.DEMON && !(abstractSubspecies.getStatusEffectAttributeModifiers(null).get(Attribute.MAJOR_ARCANE).floatValue() >= (float)IntelligenceLevel.TWO_SMART.getMinimumValue())) continue;
                    dominionStormImmuneSpecies.put(abstractSubspecies, entry.getValue());
                }
                catch (Exception exception) {}
            }
            for (Map.Entry<AbstractWorldType, SubspeciesSpawnRarity> entry : abstractSubspecies.getWorldLocations().entrySet()) {
                worldSpecies.putIfAbsent(entry.getKey(), new HashMap());
                worldSpecies.get(entry.getKey()).put(abstractSubspecies, entry.getValue());
                try {
                    if (entry.getKey() != WorldType.DOMINION || abstractSubspecies.getRace() != Race.DEMON && !(abstractSubspecies.getStatusEffectAttributeModifiers(null).get(Attribute.MAJOR_ARCANE).floatValue() >= (float)IntelligenceLevel.TWO_SMART.getMinimumValue())) continue;
                    dominionStormImmuneSpecies.put(abstractSubspecies, entry.getValue());
                }
                catch (Exception exception) {}
            }
            for (Map.Entry<AbstractPlaceType, SubspeciesSpawnRarity> entry : abstractSubspecies.getPlaceLocations().entrySet()) {
                placeSpecies.putIfAbsent(entry.getKey(), new HashMap());
                placeSpecies.get(entry.getKey()).put(abstractSubspecies, entry.getValue());
            }
        }
        for (List<AbstractSubspecies> list : subspeciesFromRace.values()) {
            list.sort((s1, s2) -> s1.getName(null).compareTo(s2.getName(null)));
        }
        allSubspecies.sort((s1, s2) -> s1.getRace().getName(false).compareTo(s2.getRace().getName(false)));
    }
}

