/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.DamageVariance;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import java.util.Map;

public class AoEData {
    private int chance;
    private String damageType;
    private String damage;
    private DamageVariance damageVariance;
    private Map<AbstractStatusEffect, Integer> aoeStatusEffects;
    private Map<AbstractStatusEffect, Integer> aoeStatusEffectsCritical;

    public AoEData(int chance, String damageType, String damage, DamageVariance damageVariance, Map<AbstractStatusEffect, Integer> aoeStatusEffects, Map<AbstractStatusEffect, Integer> aoeStatusEffectsCritical) {
        this.chance = chance;
        this.damageType = damageType;
        this.damage = damage;
        this.damageVariance = damageVariance;
        this.aoeStatusEffects = aoeStatusEffects;
        this.aoeStatusEffectsCritical = aoeStatusEffectsCritical;
    }

    public int getChance() {
        return this.chance;
    }

    public DamageVariance getDamageVariance() {
        return this.damageVariance;
    }

    public DamageType getDamageType(GameCharacter performer, GameCharacter target) {
        DamageType dt = DamageType.PHYSICAL;
        try {
            dt = DamageType.valueOf(UtilText.parse(performer, this.damageType, new ParserTag[0]).trim());
        }
        catch (Exception ex) {
            System.err.println("AoEData loading error: getDamageType() parsing not recognised! (Set to DamageType.PHYSICAL)");
        }
        if (dt == DamageType.UNARMED) {
            return DamageType.UNARMED.getParentDamageType(performer, target);
        }
        return dt;
    }

    public int getDamage(GameCharacter performer) {
        float dmg = 1.0f;
        try {
            String s = UtilText.parse(performer, this.damage, new ParserTag[0]).trim();
            dmg = Float.valueOf(s).floatValue();
        }
        catch (Exception ex) {
            System.err.println("AoEData loading error: getDamage() parsing not recognised! (Set to 1)");
        }
        return (int)dmg;
    }

    public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
        if (isCritical) {
            return this.aoeStatusEffectsCritical;
        }
        return this.aoeStatusEffects;
    }
}

