/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.npc.misc.Elemental;
import com.lilithsthrone.game.character.persona.SexualOrientation;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.DamageVariance;
import com.lilithsthrone.game.combat.moves.CombatMoveType;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.main.Main;

public enum Attack {
    NONE("\u65e0"),
    MAIN("\u4e3b\u624b"),
    OFFHAND("\u526f\u624b"),
    DUAL("\u53cc\u6301"),
    SEDUCTION("\u9b45\u60d1"),
    SPELL("\u6cd5\u672f"),
    SPECIAL_ATTACK("\u7279\u6b8a\u653b\u51fb"),
    USE_ITEM("\u4f7f\u7528\u7269\u54c1"),
    ESCAPE("\u9003\u8dd1"),
    WAIT("\u7b49\u5f85");

    private String name;

    private Attack(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static float getHitChance(GameCharacter attacker, GameCharacter defender) {
        float chanceToHit = 1.0f;
        return chanceToHit > 1.0f ? 1.0f : (chanceToHit < 0.0f ? 0.0f : chanceToHit);
    }

    public static boolean rollForHit(GameCharacter attacker, GameCharacter defender) {
        return Math.random() < (double)Attack.getHitChance(attacker, defender);
    }

    public static float getBaseWeaponDamage(GameCharacter attacker, AbstractWeapon weapon) {
        if (attacker == null) {
            return 0.0f;
        }
        if (weapon == null) {
            return attacker.getUnarmedDamage();
        }
        if (weapon.getWeaponType().isUsingUnarmedCalculation()) {
            return weapon.getWeaponType().getDamage() + attacker.getUnarmedDamage();
        }
        return weapon.getWeaponType().getDamage();
    }

    public static float getSeductionDamage(GameCharacter attacker) {
        if (attacker == null) {
            return 0.0f;
        }
        return 10.0f;
    }

    public static int calculateSeductionDamage(GameCharacter attacker, GameCharacter defender, int baseDamage, boolean critical) {
        float damage = Attack.getModifiedDamage(attacker, defender, SEDUCTION, null, DamageType.LUST, baseDamage);
        if (critical) {
            damage *= attacker.getAttributeValue(Attribute.CRITICAL_DAMAGE) / 100.0f;
        }
        damage = attacker.isPlayer() || attacker.getPartyLeader() != null && attacker.getPartyLeader().isPlayer() || attacker instanceof Elemental && ((Elemental)attacker).getSummoner() != null && ((Elemental)attacker).getSummoner().isPlayer() ? (damage *= Main.getProperties().difficultyLevel.getDamageModifierPlayer()) : (damage *= Main.getProperties().difficultyLevel.getDamageModifierNPC());
        return Math.round(damage);
    }

    public static int calculateDamage(GameCharacter attacker, GameCharacter defender, Attack attackType, AbstractWeapon weapon, int damage, boolean critical) {
        float finalDamage = Attack.getMinimumDamage(attacker, defender, attackType, weapon, damage);
        if (Attack.getMaximumDamage(attacker, defender, attackType, weapon, damage) - Attack.getMinimumDamage(attacker, defender, attackType, weapon, damage) > 0) {
            float difference = Attack.getMaximumDamage(attacker, defender, attackType, weapon, damage) - Attack.getMinimumDamage(attacker, defender, attackType, weapon, damage);
            finalDamage = (float)((double)finalDamage + Math.random() * (double)difference);
        }
        return Attack.applyFinalDamageModifiers(attacker, defender, finalDamage, critical);
    }

    public static int calculateDamage(GameCharacter attacker, GameCharacter defender, Attack attackType, AbstractWeapon weapon, boolean critical) {
        float damage = Attack.getMinimumDamage(attacker, defender, attackType, weapon);
        if (Attack.getMaximumDamage(attacker, defender, attackType, weapon) - Attack.getMinimumDamage(attacker, defender, attackType, weapon) > 0) {
            float difference = Attack.getMaximumDamage(attacker, defender, attackType, weapon) - Attack.getMinimumDamage(attacker, defender, attackType, weapon);
            damage = (float)((double)damage + Math.random() * (double)difference);
        }
        return Attack.applyFinalDamageModifiers(attacker, defender, damage, critical);
    }

    public static int applyFinalDamageModifiers(GameCharacter attacker, GameCharacter defender, float damage, boolean critical) {
        if (critical) {
            damage *= attacker.getAttributeValue(Attribute.CRITICAL_DAMAGE) / 100.0f;
        }
        damage = attacker.isPlayer() || attacker.getPartyLeader() != null && attacker.getPartyLeader().isPlayer() || attacker instanceof Elemental && ((Elemental)attacker).getSummoner() != null && ((Elemental)attacker).getSummoner().isPlayer() ? (damage *= Main.getProperties().difficultyLevel.getDamageModifierPlayer()) : (damage *= Main.getProperties().difficultyLevel.getDamageModifierNPC());
        if (attacker.hasStatusEffect(StatusEffect.COMBAT_JOB_SOLDIER) && Main.game.isInCombat() && Main.combat.getTurn() == 0) {
            return 2 * Math.round(damage);
        }
        return Math.round(damage);
    }

    public static int calculateSpellDamage(GameCharacter attacker, GameCharacter defender, DamageType damageType, float damage, DamageVariance damageVariance, boolean critical) {
        float minimumDamage = Attack.getMinimumSpellDamage(attacker, defender, damageType, damage, damageVariance);
        float maximumDamage = Attack.getMaximumSpellDamage(attacker, defender, damageType, damage, damageVariance);
        float difference = maximumDamage - minimumDamage;
        float finalDamage = minimumDamage;
        if (difference > 0.0f) {
            finalDamage = (float)((double)finalDamage + Math.random() * (double)difference);
        }
        if (critical) {
            finalDamage *= attacker.getAttributeValue(Attribute.CRITICAL_DAMAGE) / 100.0f;
        }
        finalDamage = attacker.isPlayer() || attacker.getPartyLeader() != null && attacker.getPartyLeader().isPlayer() || attacker instanceof Elemental && ((Elemental)attacker).getSummoner() != null && ((Elemental)attacker).getSummoner().isPlayer() ? (finalDamage *= Main.getProperties().difficultyLevel.getDamageModifierPlayer()) : (finalDamage *= Main.getProperties().difficultyLevel.getDamageModifierNPC());
        if (attacker.hasStatusEffect(StatusEffect.COMBAT_JOB_SOLDIER) && Main.game.isInCombat() && Main.combat.getTurn() == 0) {
            return 2 * Math.round(finalDamage);
        }
        return Math.round(finalDamage);
    }

    public static int calculateSpecialAttackDamage(GameCharacter attacker, GameCharacter defender, DamageType damageType, float damage, DamageVariance damageVariance, boolean critical) {
        return Attack.calculateSpecialAttackDamage(attacker, defender, CombatMoveType.ATTACK, damageType, damage, damageVariance, critical);
    }

    public static int calculateSpecialAttackDamage(GameCharacter attacker, GameCharacter defender, CombatMoveType combatMoveType, DamageType damageType, float damage, DamageVariance damageVariance, boolean critical) {
        float minimumDamage = Attack.getMinimumSpecialAttackDamage(attacker, defender, combatMoveType, damageType, damage, damageVariance);
        float maximumDamage = Attack.getMaximumSpecialAttackDamage(attacker, defender, combatMoveType, damageType, damage, damageVariance);
        float difference = maximumDamage - minimumDamage;
        float finalDamage = minimumDamage;
        if (difference > 0.0f) {
            finalDamage = (float)((double)finalDamage + Math.random() * (double)difference);
        }
        if (critical) {
            finalDamage *= attacker.getAttributeValue(Attribute.CRITICAL_DAMAGE) / 100.0f;
        }
        finalDamage = attacker.isPlayer() || attacker.getPartyLeader() != null && attacker.getPartyLeader().isPlayer() || attacker instanceof Elemental && ((Elemental)attacker).getSummoner() != null && ((Elemental)attacker).getSummoner().isPlayer() ? (finalDamage *= Main.getProperties().difficultyLevel.getDamageModifierPlayer()) : (finalDamage *= Main.getProperties().difficultyLevel.getDamageModifierNPC());
        if (attacker.hasStatusEffect(StatusEffect.COMBAT_JOB_SOLDIER) && Main.game.isInCombat() && Main.combat.getTurn() == 0) {
            return 2 * Math.round(finalDamage);
        }
        return Math.round(finalDamage);
    }

    public static int getMinimumDamage(GameCharacter attacker, GameCharacter defender, Attack attackType, AbstractWeapon weapon) {
        return Attack.getMinimumDamage(attacker, defender, attackType, weapon, Attack.getBaseWeaponDamage(attacker, weapon));
    }

    public static int getMinimumDamage(GameCharacter attacker, GameCharacter defender, Attack attackType, AbstractWeapon weapon, float baseDamage) {
        float damage = 0.0f;
        damage = attackType == MAIN || attackType == OFFHAND ? Attack.getModifiedDamage(attacker, defender, attackType, weapon, weapon == null ? DamageType.UNARMED.getParentDamageType(attacker, defender) : weapon.getDamageType(), baseDamage * (weapon == null ? 1.0f - DamageVariance.MEDIUM.getPercentage() : 1.0f - weapon.getWeaponType().getDamageVariance().getPercentage())) : Attack.getModifiedDamage(attacker, defender, attackType, weapon, DamageType.LUST, Attack.getSeductionDamage(attacker) * 0.9f);
        return Math.round(damage);
    }

    public static int getMaximumDamage(GameCharacter attacker, GameCharacter defender, Attack attackType, AbstractWeapon weapon) {
        return Attack.getMaximumDamage(attacker, defender, attackType, weapon, Attack.getBaseWeaponDamage(attacker, weapon));
    }

    public static int getMaximumDamage(GameCharacter attacker, GameCharacter defender, Attack attackType, AbstractWeapon weapon, float baseDamage) {
        float damage = 0.0f;
        damage = attackType == MAIN || attackType == OFFHAND ? Attack.getModifiedDamage(attacker, defender, attackType, weapon, weapon == null ? DamageType.UNARMED.getParentDamageType(attacker, defender) : weapon.getDamageType(), baseDamage * (weapon == null ? 1.0f + DamageVariance.MEDIUM.getPercentage() : 1.0f + weapon.getWeaponType().getDamageVariance().getPercentage())) : Attack.getModifiedDamage(attacker, defender, attackType, weapon, DamageType.LUST, Attack.getSeductionDamage(attacker) * 1.1f);
        return Math.round(damage);
    }

    public static float getMinimumSpellDamage(GameCharacter attacker, GameCharacter defender, DamageType damageType, float damage, DamageVariance damageVariance) {
        float minDamage = Attack.getModifiedDamage(attacker, defender, SPELL, null, damageType, damage * (1.0f - damageVariance.getPercentage()));
        minDamage = (float)Math.round(minDamage * 10.0f) / 10.0f;
        return minDamage;
    }

    public static float getMaximumSpellDamage(GameCharacter caster, GameCharacter target, DamageType damageType, float damage, DamageVariance damageVariance) {
        float maxDamage = Attack.getModifiedDamage(caster, target, SPELL, null, damageType, damage * (1.0f + damageVariance.getPercentage()));
        maxDamage = (float)Math.round(maxDamage * 10.0f) / 10.0f;
        return maxDamage;
    }

    public static float getMinimumSpecialAttackDamage(GameCharacter attacker, GameCharacter defender, CombatMoveType combatMoveType, DamageType damageType, float damage, DamageVariance damageVariance) {
        float minDamage = Attack.getModifiedDamage(attacker, defender, combatMoveType, SPECIAL_ATTACK, null, damageType, damage * (1.0f - damageVariance.getPercentage()));
        minDamage = (float)Math.round(minDamage * 10.0f) / 10.0f;
        return minDamage;
    }

    public static float getMaximumSpecialAttackDamage(GameCharacter attacker, GameCharacter defender, CombatMoveType combatMoveType, DamageType damageType, float damage, DamageVariance damageVariance) {
        float maxDamage = Attack.getModifiedDamage(attacker, defender, combatMoveType, SPECIAL_ATTACK, null, damageType, damage * (1.0f + damageVariance.getPercentage()));
        maxDamage = (float)Math.round(maxDamage * 10.0f) / 10.0f;
        return maxDamage;
    }

    public static float getModifiedDamage(GameCharacter attacker, GameCharacter defender, Attack attackType, AbstractWeapon weapon, DamageType damageType, float attackersDamage) {
        return Attack.getModifiedDamage(attacker, defender, CombatMoveType.ATTACK, attackType, weapon, damageType, attackersDamage);
    }

    public static float getModifiedDamage(GameCharacter attacker, GameCharacter defender, CombatMoveType combatMoveType, Attack attackType, AbstractWeapon weapon, DamageType damageType, float attackersDamage) {
        float damage = 0.0f;
        boolean damageDoubledFromElemental = false;
        if (defender != null && defender.isImmuneToDamageType(damageType)) {
            return 0.0f;
        }
        if (attacker != null && attacker.isElemental()) {
            switch (attacker.getBodyMaterial()) {
                case AIR: {
                    damageDoubledFromElemental = ((Elemental)attacker).hasStatusEffect(StatusEffect.ELEMENTAL_AIR_SERVANT_OF_AIR_ELEMENTAL_BUFF);
                    break;
                }
                case ARCANE: {
                    damageDoubledFromElemental = ((Elemental)attacker).hasStatusEffect(StatusEffect.ELEMENTAL_ARCANE_SERVANT_OF_ARCANE_ELEMENTAL_BUFF);
                    break;
                }
                case FIRE: {
                    damageDoubledFromElemental = ((Elemental)attacker).hasStatusEffect(StatusEffect.ELEMENTAL_FIRE_SERVANT_OF_FIRE_ELEMENTAL_BUFF);
                    break;
                }
                case FLESH: 
                case SLIME: 
                case SILICONE: {
                    break;
                }
                case RUBBER: 
                case STONE: {
                    damageDoubledFromElemental = ((Elemental)attacker).hasStatusEffect(StatusEffect.ELEMENTAL_EARTH_SERVANT_OF_EARTH_ELEMENTAL_BUFF);
                    break;
                }
                case ICE: 
                case WATER: {
                    damageDoubledFromElemental = ((Elemental)attacker).hasStatusEffect(StatusEffect.ELEMENTAL_WATER_SERVANT_OF_WATER_ELEMENTAL_BUFF);
                }
            }
        }
        if (attackType == MAIN || attackType == OFFHAND || attackType == SPECIAL_ATTACK) {
            damage = damageDoubledFromElemental ? (damage += attackersDamage * 2.0f) : (damage += attackersDamage);
            if (weapon != null && weapon.getWeaponType().getItemTags().contains((Object)ItemTag.WEAPON_FIREARM) && attacker.hasPerkAnywhereInTree(Perk.SPECIAL_ENFORCER_FIREARMS_TRAINING)) {
                damage *= 2.0f;
            }
            if (attacker != null) {
                damage += attackersDamage * (attacker.getAttributeValue(damageType.getMultiplierAttribute()) / 100.0f);
                switch (combatMoveType) {
                    case SPELL: 
                    case POWER: {
                        damage += attackersDamage * (attacker.getAttributeValue(Attribute.DAMAGE_SPELLS) / 100.0f);
                        break;
                    }
                    default: {
                        if (weapon == null || weapon.getWeaponType().isUsingUnarmedCalculation()) break;
                        if (weapon.getWeaponType().isMelee()) {
                            damage += attackersDamage * (attacker.getAttributeValue(Attribute.DAMAGE_MELEE_WEAPON) / 100.0f);
                            break;
                        }
                        damage += attackersDamage * (attacker.getAttributeValue(Attribute.DAMAGE_RANGED_WEAPON) / 100.0f);
                    }
                }
                if (damage < 1.0f) {
                    damage = 1.0f;
                }
            }
        } else if (attackType == SPELL) {
            damage = damageDoubledFromElemental ? (damage += attackersDamage * 2.0f) : (damage += attackersDamage);
            if (attacker != null) {
                damage += attackersDamage * (attacker.getAttributeValue(Attribute.DAMAGE_SPELLS) / 100.0f);
                damage += attackersDamage * (attacker.getAttributeValue(damageType.getMultiplierAttribute()) / 100.0f);
            }
        } else {
            if (attacker != null) {
                damage += attackersDamage * (1.0f + attacker.getAttributeValue(Attribute.DAMAGE_LUST) / 100.0f);
                if (defender != null && (attacker.hasTrait(Perk.FEMALE_ATTRACTION, true) && defender.isFeminine() || attacker.hasTrait(Perk.MALE_ATTRACTION, true) && !defender.isFeminine())) {
                    damage += attackersDamage * 0.1f;
                }
                if (damage < 1.0f) {
                    damage = 1.0f;
                }
            } else {
                damage = attackersDamage;
            }
            if (defender != null && !defender.hasStatusEffect(StatusEffect.DESPERATE_FOR_SEX)) {
                if (attacker != null) {
                    if (defender.getSexualOrientation() == SexualOrientation.ANDROPHILIC && attacker.isFeminine() || attacker.getSexualOrientation() == SexualOrientation.ANDROPHILIC && defender.isFeminine()) {
                        damage *= 0.5f;
                    }
                    if (defender.getSexualOrientation() == SexualOrientation.GYNEPHILIC && !attacker.isFeminine() || attacker.getSexualOrientation() == SexualOrientation.GYNEPHILIC && !defender.isFeminine()) {
                        damage *= 0.5f;
                    }
                }
                if (damage < 1.0f) {
                    damage = 1.0f;
                }
            }
        }
        if (attacker != null && defender != null) {
            damage += attackersDamage * (attacker.getAttributeValue(defender.getSubspecies().getDamageMultiplier()) / 100.0f);
        }
        return damage;
    }
}

