/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.combat.spells.SpellSchool;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DamageType {
    HEALTH("\u751f\u547d", PresetColour.ATTRIBUTE_HEALTH, "\u593a\u547d", Attribute.ENERGY_SHIELDING, Attribute.HEALTH_MAXIMUM, SpellSchool.EARTH, null),
    PHYSICAL("\u7269\u7406", PresetColour.DAMAGE_TYPE_PHYSICAL, "\u5f3a\u51fb", Attribute.RESISTANCE_PHYSICAL, Attribute.DAMAGE_PHYSICAL, SpellSchool.EARTH, HEALTH),
    ICE("\u51b0\u7cfb", PresetColour.DAMAGE_TYPE_COLD, "\u51b0\u971c", Attribute.RESISTANCE_ICE, Attribute.DAMAGE_ICE, SpellSchool.WATER, HEALTH),
    FIRE("\u706b\u7cfb", PresetColour.DAMAGE_TYPE_FIRE, "\u707c\u70ed", Attribute.RESISTANCE_FIRE, Attribute.DAMAGE_FIRE, SpellSchool.FIRE, HEALTH),
    POISON("\u6bd2\u7d20", PresetColour.DAMAGE_TYPE_POISON, "\u5267\u6bd2", Attribute.RESISTANCE_POISON, Attribute.DAMAGE_POISON, SpellSchool.AIR, HEALTH),
    UNARMED("\u5f92\u624b", PresetColour.DAMAGE_TYPE_PHYSICAL, "\u5f92\u624b", Attribute.RESISTANCE_PHYSICAL, Attribute.DAMAGE_PHYSICAL, SpellSchool.EARTH, HEALTH){

        @Override
        public Util.Value<String, Integer> damageTarget(GameCharacter source, GameCharacter target, int damageAmount) {
            return this.getParentDamageType(source, target).damageTarget(source, target, damageAmount);
        }

        @Override
        public DamageType getParentDamageType(GameCharacter source, GameCharacter target) {
            if (source.hasStatusEffect(StatusEffect.CLOAK_OF_FLAMES_1) || source.hasStatusEffect(StatusEffect.CLOAK_OF_FLAMES_2) || source.hasStatusEffect(StatusEffect.CLOAK_OF_FLAMES_3)) {
                return FIRE;
            }
            return source.getBodyMaterial().getUnarmedDamageType();
        }
    }
    ,
    LUST("\u6027\u6b32", PresetColour.DAMAGE_TYPE_LUST, "\u5feb\u611f", Attribute.RESISTANCE_LUST, Attribute.DAMAGE_LUST, SpellSchool.ARCANE, null){

        @Override
        public Util.Value<String, Integer> damageTarget(GameCharacter source, GameCharacter target, int damageAmount) {
            if ((damageAmount = this.shieldCheck(source, target, damageAmount)) > 0) {
                if (target.hasStatusEffect(StatusEffect.DESPERATE_FOR_SEX)) {
                    target.incrementMana(-damageAmount);
                    return HEALTH.damageTarget(source, target, damageAmount * 2);
                }
                target.setLust(target.getLust() + (float)damageAmount);
            }
            return new Util.Value<String, Integer>("", damageAmount);
        }
    }
    ,
    MISC("\u4e00\u822c", PresetColour.DAMAGE_TYPE_PHYSICAL, "\u6807\u51c6", Attribute.RESISTANCE_PHYSICAL, Attribute.DAMAGE_PHYSICAL, SpellSchool.ARCANE, HEALTH);

    private String name;
    private Colour colour;
    private String weaponDescriptor;
    private AbstractAttribute resistAttribute;
    private AbstractAttribute multiplierAttribute;
    private SpellSchool spellSchool;
    private DamageType parentDamageType;

    private DamageType(String name, Colour colour, String weaponDescriptor, AbstractAttribute resistAttribute, AbstractAttribute multiplierAttribute, SpellSchool spellSchool, DamageType parentDamageType) {
        this.name = name;
        this.colour = colour;
        this.weaponDescriptor = weaponDescriptor;
        this.resistAttribute = resistAttribute;
        this.multiplierAttribute = multiplierAttribute;
        this.spellSchool = spellSchool;
        this.parentDamageType = parentDamageType;
    }

    public String getName() {
        return this.name;
    }

    public String getNameColoured() {
        return this.getNameColoured("span");
    }

    public String getNameColoured(String tag) {
        return "<" + tag + " style='color:" + this.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + this.getName() + "</" + tag + ">";
    }

    public Colour getColour() {
        return this.colour;
    }

    public String getWeaponDescriptor() {
        return this.weaponDescriptor;
    }

    public AbstractAttribute getResistAttribute() {
        return this.resistAttribute;
    }

    public AbstractAttribute getMultiplierAttribute() {
        return this.multiplierAttribute;
    }

    public SpellSchool getSpellSchool() {
        return this.spellSchool;
    }

    public Util.Value<String, Integer> damageTarget(GameCharacter source, GameCharacter target, int damageAmount) {
        damageAmount = this.shieldCheck(source, target, damageAmount);
        String description = "";
        description = target.incrementHealth(source, -damageAmount);
        if (target.hasFetish(Fetish.FETISH_MASOCHIST)) {
            damageAmount = (int)((float)damageAmount * 0.75f);
        }
        return new Util.Value<String, Integer>(description, damageAmount);
    }

    public int shieldCheckNoDamage(GameCharacter source, GameCharacter target, int damageAmount) {
        if (this.getParentDamageType(source, target) != null) {
            damageAmount = this.getParentDamageType(source, target).shieldCheckNoDamage(source, target, damageAmount);
        }
        if (target.getShields(this) > 0) {
            AbstractAttribute resist = this.getResistAttribute();
            damageAmount = target.getAttributeValue(resist) >= (float)resist.getUpperLimit() && resist.isInfiniteAtUpperLimit() ? 0 : (damageAmount -= target.getShields(this));
            if (damageAmount < 0) {
                damageAmount = 0;
            }
        }
        return damageAmount;
    }

    public int shieldCheck(GameCharacter source, GameCharacter target, int damageAmount) {
        if (damageAmount > 0) {
            if (this.getParentDamageType(source, target) != null) {
                damageAmount = this.getParentDamageType(source, target).shieldCheck(source, target, damageAmount);
            }
            if (target.getShields(this) > 0) {
                AbstractAttribute resist = this.getResistAttribute();
                if (target.getAttributeValue(resist) >= (float)resist.getUpperLimit() && resist.isInfiniteAtUpperLimit()) {
                    damageAmount = 0;
                } else {
                    int oldShields = target.getShields(this);
                    target.setShields(this, target.getShields(this) - damageAmount);
                    damageAmount -= oldShields;
                }
                if (damageAmount < 0) {
                    damageAmount = 0;
                }
            }
        }
        return damageAmount;
    }

    public DamageType getParentDamageType(GameCharacter source, GameCharacter target) {
        return this.parentDamageType;
    }
}

