/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat.moves;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.attributes.CorruptionLevel;
import com.lilithsthrone.game.character.attributes.LustLevel;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.combat.AoEData;
import com.lilithsthrone.game.combat.Attack;
import com.lilithsthrone.game.combat.CombatBehaviour;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.DamageVariance;
import com.lilithsthrone.game.combat.moves.CombatMove;
import com.lilithsthrone.game.combat.moves.CombatMoveCategory;
import com.lilithsthrone.game.combat.moves.CombatMoveType;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Document;

public abstract class AbstractCombatMove {
    private boolean mod;
    private boolean fromExternalFile;
    private CombatMoveCategory category;
    private CombatMoveType type;
    private String name;
    private String description;
    private String damageTypeString = "";
    private String baseDamageString = "";
    private String cooldownString = "";
    private String APCostString = "";
    private String blockDamageTypeString = "";
    private String blockString = "";
    private String availabilityCondition = "";
    private String availabilityDescription = "";
    private String criticalCondition = "";
    private String criticalDescription = "";
    private String movePredictionDescriptionWithTarget = "";
    private String movePredictionDescriptionNoTarget = "";
    private String performingText = "";
    private String performingCritDescText = "";
    private String performingCritText = "";
    private String weightingText = "";
    private DamageType damageType;
    private int baseDamage;
    private DamageVariance damageVariance;
    protected List<AoEData> aoeDamage;
    private int cooldown;
    private int APcost;
    private int equipWeighting;
    private boolean canTargetEnemies;
    private boolean canTargetAllies;
    private boolean canTargetSelf;
    private String SVGString;
    private Map<AbstractStatusEffect, Integer> statusEffects;
    private Map<AbstractStatusEffect, Integer> statusEffectsCritical;
    private Spell associatedSpell;

    public AbstractCombatMove(CombatMoveCategory category, String name, int cooldown, int APcost, CombatMoveType type, DamageType damageType, String pathName, boolean canTargetAllies, boolean canTargetEnemies, boolean canTargetSelf, Map<AbstractStatusEffect, Integer> statusEffects) {
        this(category, name, cooldown, APcost, 1, type, damageType, DamageVariance.NONE, pathName, null, canTargetAllies, canTargetEnemies, canTargetSelf, statusEffects, statusEffects);
    }

    public AbstractCombatMove(CombatMoveCategory category, String name, int cooldown, int APcost, CombatMoveType type, DamageType damageType, DamageVariance damageVariance, String pathName, boolean canTargetAllies, boolean canTargetEnemies, boolean canTargetSelf, Map<AbstractStatusEffect, Integer> statusEffects) {
        this(category, name, cooldown, APcost, 1, type, damageType, damageVariance, pathName, null, canTargetAllies, canTargetEnemies, canTargetSelf, statusEffects, statusEffects);
    }

    public AbstractCombatMove(CombatMoveCategory category, String name, int cooldown, int APcost, CombatMoveType type, DamageType damageType, String pathName, List<Colour> iconColours, boolean canTargetAllies, boolean canTargetEnemies, boolean canTargetSelf, Map<AbstractStatusEffect, Integer> statusEffects) {
        this(category, name, cooldown, APcost, 1, type, damageType, DamageVariance.NONE, pathName, iconColours, canTargetAllies, canTargetEnemies, canTargetSelf, statusEffects, statusEffects);
    }

    public AbstractCombatMove(CombatMoveCategory category, String name, int cooldown, int APcost, int equipWeighting, CombatMoveType type, DamageType damageType, DamageVariance damageVariance, String pathName, List<Colour> iconColours, boolean canTargetAllies, boolean canTargetEnemies, boolean canTargetSelf, Map<AbstractStatusEffect, Integer> statusEffects, Map<AbstractStatusEffect, Integer> statusEffectsCritical) {
        this.fromExternalFile = false;
        this.mod = false;
        this.category = category;
        this.name = name;
        this.description = "\u8be5\u52a8\u4f5c\u4ec0\u4e48\u4e5f\u4e0d\u4f1a\u505a\u3002";
        this.performingText = "\u6267\u884c\u4e86\u8be5\u52a8\u4f5c\u3002";
        this.cooldown = cooldown;
        this.APcost = APcost;
        this.equipWeighting = equipWeighting;
        this.type = type;
        this.baseDamage = 0;
        this.damageType = damageType;
        this.damageVariance = damageVariance;
        this.aoeDamage = new ArrayList<AoEData>();
        this.canTargetEnemies = canTargetEnemies;
        this.canTargetAllies = canTargetAllies;
        this.canTargetSelf = canTargetSelf;
        this.statusEffects = statusEffects;
        this.statusEffectsCritical = statusEffectsCritical;
        this.associatedSpell = null;
        try {
            InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/" + pathName + ".svg");
            if (is == null) {
                System.err.println("Error! CombatMove icon file does not exist (Trying to read from '" + pathName + "')!");
            }
            this.SVGString = Util.inputStreamToString(is);
            this.SVGString = iconColours != null ? SvgUtil.colourReplacement("CM", iconColours.get(0), iconColours.size() > 1 ? iconColours.get(1) : null, iconColours.size() > 2 ? iconColours.get(2) : null, this.SVGString) : SvgUtil.colourReplacement("CM", type.getColour(), this.SVGString);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public AbstractCombatMove(File XMLFile, String author, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.category = CombatMoveCategory.SPECIAL;
                if (coreElement.getOptionalFirstOf("category").isPresent()) {
                    try {
                        this.category = CombatMoveCategory.valueOf(coreElement.getMandatoryFirstOf("category").getTextContent());
                    }
                    catch (Exception ex) {
                        System.err.println("CombatMove loading error in '" + XMLFile.getName() + "': category not recognised! (Set to SPECIAL)");
                    }
                }
                this.type = CombatMoveType.ATTACK;
                if (coreElement.getOptionalFirstOf("type").isPresent()) {
                    try {
                        this.type = CombatMoveType.valueOf(coreElement.getMandatoryFirstOf("type").getTextContent());
                    }
                    catch (Exception ex) {
                        System.err.println("CombatMove loading error in '" + XMLFile.getName() + "': type not recognised! (Set to ATTACK)");
                    }
                }
                this.equipWeighting = Integer.valueOf(coreElement.getMandatoryFirstOf("equipWeighting").getTextContent().trim());
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                this.description = coreElement.getMandatoryFirstOf("description").getTextContent();
                if (coreElement.getOptionalFirstOf("primaryDamage").isPresent()) {
                    Element primaryDamageElement = coreElement.getMandatoryFirstOf("primaryDamage");
                    this.damageTypeString = primaryDamageElement.getMandatoryFirstOf("damageType").getTextContent();
                    this.baseDamageString = primaryDamageElement.getMandatoryFirstOf("damage").getTextContent();
                    this.damageVariance = DamageVariance.NONE;
                    if (primaryDamageElement.getOptionalFirstOf("damageVariance").isPresent()) {
                        try {
                            String variance = coreElement.getMandatoryFirstOf("damageVariance").getTextContent();
                            if (!variance.isEmpty()) {
                                this.damageVariance = DamageVariance.valueOf(variance);
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("CombatMove loading error in '" + XMLFile.getName() + "': variance not recognised! (Set to NONE)");
                        }
                    }
                    this.statusEffects = new HashMap<AbstractStatusEffect, Integer>();
                    this.statusEffectsCritical = new HashMap<AbstractStatusEffect, Integer>();
                    for (Element e : primaryDamageElement.getAllOf("effect")) {
                        try {
                            int length = Integer.valueOf(e.getAttribute("turnLength"));
                            AbstractStatusEffect se = StatusEffect.getStatusEffectFromId(e.getTextContent());
                            if (Boolean.valueOf(e.getAttribute("onCrit")).booleanValue()) {
                                this.statusEffectsCritical.put(se, length);
                                continue;
                            }
                            this.statusEffects.put(se, length);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                } else {
                    this.damageTypeString = coreElement.getMandatoryFirstOf("damageType").getTextContent();
                    this.baseDamageString = coreElement.getMandatoryFirstOf("baseDamage").getTextContent();
                    this.damageVariance = DamageVariance.NONE;
                    if (coreElement.getOptionalFirstOf("damageVariance").isPresent()) {
                        try {
                            String variance = coreElement.getMandatoryFirstOf("damageVariance").getTextContent();
                            if (!variance.isEmpty()) {
                                this.damageVariance = DamageVariance.valueOf(variance);
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("CombatMove loading error in '" + XMLFile.getName() + "': variance not recognised! (Set to NONE)");
                        }
                    }
                    this.statusEffects = new HashMap<AbstractStatusEffect, Integer>();
                    this.statusEffectsCritical = new HashMap<AbstractStatusEffect, Integer>();
                    if (coreElement.getOptionalFirstOf("statusEffects").isPresent()) {
                        for (Element e : coreElement.getMandatoryFirstOf("statusEffects").getAllOf("effect")) {
                            try {
                                int length = Integer.valueOf(e.getAttribute("turnLength"));
                                AbstractStatusEffect se = StatusEffect.getStatusEffectFromId(e.getTextContent());
                                if (Boolean.valueOf(e.getAttribute("onCrit")).booleanValue()) {
                                    this.statusEffectsCritical.put(se, length);
                                    continue;
                                }
                                this.statusEffects.put(se, length);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
                this.aoeDamage = new ArrayList<AoEData>();
                if (coreElement.getOptionalFirstOf("aoe").isPresent()) {
                    for (Element aoeElement : coreElement.getAllOf("aoe")) {
                        int chance = Integer.valueOf(aoeElement.getAttribute("chance"));
                        String damageTypeString = aoeElement.getMandatoryFirstOf("damageType").getTextContent();
                        String baseDamageString = aoeElement.getMandatoryFirstOf("damage").getTextContent();
                        DamageVariance aoeDamageVariance = DamageVariance.NONE;
                        if (aoeElement.getOptionalFirstOf("damageVariance").isPresent()) {
                            try {
                                String variance = coreElement.getMandatoryFirstOf("damageVariance").getTextContent();
                                if (!variance.isEmpty()) {
                                    aoeDamageVariance = DamageVariance.valueOf(variance);
                                }
                            }
                            catch (Exception ex) {
                                System.err.println("CombatMove loading error in '" + XMLFile.getName() + "': variance not recognised! (Set to NONE)");
                            }
                        }
                        HashMap<AbstractStatusEffect, Integer> aoeStatusEffects = new HashMap<AbstractStatusEffect, Integer>();
                        HashMap<AbstractStatusEffect, Integer> aoeStatusEffectsCritical = new HashMap<AbstractStatusEffect, Integer>();
                        for (Element effectElement : aoeElement.getAllOf("effect")) {
                            try {
                                int length = Integer.valueOf(effectElement.getAttribute("turnLength"));
                                AbstractStatusEffect se = StatusEffect.getStatusEffectFromId(effectElement.getTextContent());
                                if (Boolean.valueOf(effectElement.getAttribute("onCrit")).booleanValue()) {
                                    aoeStatusEffectsCritical.put(se, length);
                                    continue;
                                }
                                aoeStatusEffects.put(se, length);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        this.aoeDamage.add(new AoEData(chance, damageTypeString, baseDamageString, aoeDamageVariance, aoeStatusEffects, aoeStatusEffectsCritical));
                    }
                }
                if (coreElement.getOptionalFirstOf("shielding").isPresent()) {
                    this.blockDamageTypeString = coreElement.getMandatoryFirstOf("shielding").getMandatoryFirstOf("damageType").getTextContent();
                    this.blockString = coreElement.getMandatoryFirstOf("shielding").getMandatoryFirstOf("blockAmount").getTextContent();
                } else if (coreElement.getOptionalFirstOf("blockAmount").isPresent()) {
                    this.blockString = coreElement.getMandatoryFirstOf("blockAmount").getTextContent();
                }
                this.cooldown = 1;
                this.cooldownString = coreElement.getMandatoryFirstOf("cooldown").getTextContent();
                this.APcost = 1;
                this.APCostString = coreElement.getMandatoryFirstOf("APcost").getTextContent();
                this.canTargetAllies = Boolean.valueOf(coreElement.getMandatoryFirstOf("canTargetAllies").getTextContent().trim());
                this.canTargetEnemies = Boolean.valueOf(coreElement.getMandatoryFirstOf("canTargetEnemies").getTextContent().trim());
                this.canTargetSelf = Boolean.valueOf(coreElement.getMandatoryFirstOf("canTargetSelf").getTextContent().trim());
                String pathName = XMLFile.getParentFile().getAbsolutePath() + "/" + coreElement.getMandatoryFirstOf("imageName").getTextContent();
                this.SVGString = null;
                Colour colourShade = PresetColour.getColourFromId(coreElement.getMandatoryFirstOf("colourPrimary").getTextContent());
                Colour colourShadeSecondary = null;
                if (coreElement.getOptionalFirstOf("colourSecondary").isPresent() && !coreElement.getMandatoryFirstOf("colourSecondary").getTextContent().isEmpty()) {
                    colourShadeSecondary = PresetColour.getColourFromId(coreElement.getMandatoryFirstOf("colourSecondary").getTextContent());
                }
                Colour colourShadeTertiary = null;
                if (coreElement.getOptionalFirstOf("colourTertiary").isPresent() && !coreElement.getMandatoryFirstOf("colourTertiary").getTextContent().isEmpty()) {
                    colourShadeTertiary = PresetColour.getColourFromId(coreElement.getMandatoryFirstOf("colourTertiary").getTextContent());
                }
                ArrayList<Colour> colourShades = Util.newArrayListOfValues(colourShade, colourShadeSecondary, colourShadeTertiary);
                try {
                    List<String> lines = Files.readAllLines(Paths.get(pathName, new String[0]));
                    StringBuilder sb = new StringBuilder();
                    for (String line : lines) {
                        sb.append(line);
                    }
                    this.SVGString = sb.toString();
                    this.SVGString = SvgUtil.colourReplacement(this.getIdentifier(), colourShades, null, this.SVGString);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.availabilityCondition = coreElement.getMandatoryFirstOf("availabilityCondition").getTextContent();
                this.availabilityDescription = coreElement.getMandatoryFirstOf("availabilityDescription").getTextContent();
                this.weightingText = coreElement.getOptionalFirstOf("weighting").isPresent() ? coreElement.getMandatoryFirstOf("weighting").getTextContent() : "";
                this.criticalCondition = coreElement.getMandatoryFirstOf("criticalCondition").getTextContent();
                this.criticalDescription = coreElement.getMandatoryFirstOf("criticalDescription").getTextContent();
                this.movePredictionDescriptionWithTarget = coreElement.getMandatoryFirstOf("movePredictionDescriptionWithTarget").getTextContent();
                this.movePredictionDescriptionNoTarget = coreElement.getMandatoryFirstOf("movePredictionDescriptionNoTarget").getTextContent();
                this.performingText = coreElement.getMandatoryFirstOf("performMove").getMandatoryFirstOf("execute").getTextContent();
                this.performingCritDescText = coreElement.getMandatoryFirstOf("performMove").getMandatoryFirstOf("critDescription").getTextContent();
                this.performingCritText = coreElement.getMandatoryFirstOf("performMove").getMandatoryFirstOf("critEffectDescription").getTextContent();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("SetBonus was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    protected boolean isTargetAtMaximumLust(GameCharacter target) {
        return target != null && target.hasStatusEffect(StatusEffect.DESPERATE_FOR_SEX);
    }

    public static String getFormattedDamage(DamageType damageType, int damage, GameCharacter target, boolean damageHasBeenApplied, boolean targetWasAtMaximumLust) {
        if (target != null && damageType == DamageType.LUST && targetWasAtMaximumLust) {
            damageType = DamageType.HEALTH;
            if (damageHasBeenApplied) {
                damage /= 2;
            }
            return "<span style='color:" + damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + String.valueOf(damage * 2) + damageType.getName() + "</span>\u53ca<span style='color:" + PresetColour.DAMAGE_TYPE_MANA.toWebHexString() + ";'>" + String.valueOf(damage) + Attribute.MANA_MAXIMUM.getName() + "</span>";
        }
        return "<span style='color:" + damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + String.valueOf(damage) + damageType.getName() + "</span>";
    }

    protected static String getFormattedDamageRange(GameCharacter attacker, GameCharacter defender, DamageType damageType, Attack attackType, AbstractWeapon weapon, boolean isCritical) {
        return AbstractCombatMove.getFormattedDamageRange(attacker, defender, damageType, attackType, weapon, isCritical, 1.0f);
    }

    protected static String getFormattedDamageRange(GameCharacter attacker, GameCharacter defender, DamageType damageType, Attack attackType, AbstractWeapon weapon, boolean isCritical, float multiplier) {
        return "<span style='color:" + damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + String.valueOf(Attack.applyFinalDamageModifiers(attacker, defender, (float)Attack.getMinimumDamage(attacker, defender, attackType, weapon) * multiplier, isCritical)) + "-" + String.valueOf(Attack.applyFinalDamageModifiers(attacker, defender, (float)Attack.getMaximumDamage(attacker, defender, attackType, weapon) * multiplier, isCritical)) + damageType.getName() + "</span>";
    }

    protected static String formatAttackOutcome(GameCharacter source, GameCharacter target, String attackText, String attackEffectText, String criticalText, String criticalEffectText) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p><i>" + attackText + "</i></p>");
        sb.append(attackEffectText);
        if (criticalText != null) {
            sb.append("<p><span style='color:" + PresetColour.CRIT.toWebHexString() + ";'>\u66b4\u51fb</span>\uff1a<i>" + criticalEffectText + "</i></p>");
        }
        return UtilText.parse(source, target, sb.toString(), new ParserTag[0]);
    }

    public float getWeight(GameCharacter source, List<GameCharacter> enemies, List<GameCharacter> allies) {
        if (this.isCanTargetAllies() && !this.isCanTargetSelf() && !this.isCanTargetEnemies() && allies.isEmpty()) {
            return 0.0f;
        }
        if (AbstractCombatMove.shouldBlunder()) {
            return (float)Math.random() - 0.2f * (float)source.getSelectedMovesByType(this.type);
        }
        if (this.weightingText != null && !this.weightingText.isEmpty()) {
            float maxWeight = 0.0f;
            for (GameCharacter character : Main.combat.getAllCombatants(true)) {
                float weight;
                if (!(this.isCanTargetSelf() && character.equals(source) || this.isCanTargetAllies() && character.isCombatAlly(source)) && (!this.isCanTargetEnemies() || !character.isCombatEnemy(source)) || !((weight = Float.valueOf(UtilText.parse(source, character, this.weightingText, new ParserTag[0]).trim()).floatValue()) > maxWeight)) continue;
                maxWeight = weight;
            }
            return maxWeight;
        }
        int behaviourMultiplier = 1;
        switch (this.type) {
            case ATTACK: {
                if (source.getCombatBehaviour() == CombatBehaviour.ATTACK) {
                    behaviourMultiplier = 10;
                }
                for (GameCharacter character : enemies) {
                    if (!((double)character.getHealthPercentage() < 0.2)) continue;
                    return 1.1f * (float)behaviourMultiplier + 0.2f * (float)Math.random() - 0.2f * (float)source.getSelectedMovesByType(this.type);
                }
                return 0.8f * (float)behaviourMultiplier + 0.2f * (float)Math.random() - 0.2f * (float)source.getSelectedMovesByType(this.type);
            }
            case DEFEND: {
                if (source.getCombatBehaviour() == CombatBehaviour.DEFEND) {
                    behaviourMultiplier = 10;
                }
                if ((double)source.getHealthPercentage() < 0.2) {
                    return 1.0f * (float)behaviourMultiplier + 0.5f * (float)Math.random() - 0.2f * (float)source.getSelectedMovesByType(this.type);
                }
                return 0.25f * (float)behaviourMultiplier + 0.75f * (float)Math.random() - 0.2f * (float)source.getSelectedMovesByType(this.type);
            }
            case TEASE: {
                if (source.getCombatBehaviour() == CombatBehaviour.SEDUCE) {
                    behaviourMultiplier = 10;
                }
                float weight = 0.8f * (float)behaviourMultiplier + 0.2f * (float)Math.random() - 0.2f * (float)source.getSelectedMovesByType(this.type);
                for (GameCharacter character : enemies) {
                    if (character.getLustLevel() != LustLevel.FOUR_IMPASSIONED && character.getLustLevel() != LustLevel.FIVE_BURNING) continue;
                    weight += 0.2f;
                    break;
                }
                if (source.getCorruptionLevel() == CorruptionLevel.FOUR_LUSTFUL || source.getCorruptionLevel() == CorruptionLevel.FIVE_CORRUPT) {
                    weight += 0.4f;
                }
                if (!source.isAttractedTo(this.getPreferredTarget(source, enemies, allies)) && source.getCombatBehaviour() != CombatBehaviour.SEDUCE) {
                    weight *= 0.5f;
                }
                return weight;
            }
            case SPELL: {
                if (source.getCombatBehaviour() == CombatBehaviour.SPELLS) {
                    behaviourMultiplier = 100000;
                }
                return behaviourMultiplier;
            }
        }
        return (float)Math.random() - 0.2f * (float)source.getSelectedMovesByType(this.type);
    }

    public GameCharacter getPreferredTarget(GameCharacter source, List<GameCharacter> enemies, List<GameCharacter> allies) {
        GameCharacter potentialCharacter;
        GameCharacter preferredTarget;
        if (Main.game.isInCombat() && (preferredTarget = Main.combat.getPreferredTarget(source)) != null && !Main.combat.isCombatantDefeated(preferredTarget)) {
            return preferredTarget;
        }
        if (this.weightingText != null && !this.weightingText.isEmpty()) {
            float maxWeight = 0.0f;
            GameCharacter target = null;
            for (GameCharacter character : Main.combat.getAllCombatants(true)) {
                if (!(this.isCanTargetSelf() && character.equals(source) || this.isCanTargetAllies() && character.isCombatAlly(source)) && (!this.isCanTargetEnemies() || !character.isCombatEnemy(source))) continue;
                float f = Float.valueOf(UtilText.parse(source, character, this.weightingText, new ParserTag[0]).trim()).floatValue();
                boolean bl = !Main.combat.isCombatantDefeated(character);
                float weight = f * (float)bl;
                if (!(weight > maxWeight)) continue;
                target = character;
                maxWeight = weight;
            }
            if (target != null) {
                return target;
            }
        }
        if (this.isCanTargetEnemies()) {
            if (AbstractCombatMove.shouldBlunder() && enemies.stream().anyMatch(enemy -> !Main.combat.isCombatantDefeated((GameCharacter)enemy))) {
                ArrayList<GameCharacter> nonDefeatedEnemies = new ArrayList<GameCharacter>(enemies);
                nonDefeatedEnemies.removeIf(enemy -> Main.combat.isCombatantDefeated((GameCharacter)enemy));
                return (GameCharacter)nonDefeatedEnemies.get(Util.random.nextInt(nonDefeatedEnemies.size()));
            }
            float lowestHP = -1.0f;
            potentialCharacter = null;
            for (GameCharacter character : enemies) {
                if (lowestHP != -1.0f && !(character.getHealth() < lowestHP)) continue;
                potentialCharacter = character;
                lowestHP = character.getHealth();
            }
            return potentialCharacter;
        }
        if (this.isCanTargetAllies() && !allies.isEmpty()) {
            if (AbstractCombatMove.shouldBlunder() && allies.stream().anyMatch(ally -> !Main.combat.isCombatantDefeated((GameCharacter)ally))) {
                ArrayList<GameCharacter> nonDefeatedAllies = new ArrayList<GameCharacter>(allies);
                nonDefeatedAllies.removeIf(ally -> Main.combat.isCombatantDefeated((GameCharacter)ally));
                return (GameCharacter)nonDefeatedAllies.get(Util.random.nextInt(nonDefeatedAllies.size()));
            }
            float lowestHP = -1.0f;
            potentialCharacter = null;
            for (GameCharacter character : allies) {
                if (lowestHP != -1.0f && !(character.getHealth() < lowestHP)) continue;
                potentialCharacter = character;
                lowestHP = character.getHealth();
            }
            return potentialCharacter;
        }
        return source;
    }

    public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        String parseText = target == null ? this.movePredictionDescriptionNoTarget : this.movePredictionDescriptionWithTarget;
        if (this.fromExternalFile) {
            boolean crit = this.canCrit(turnIndex, source, target, enemies, allies);
            parseText = parseText.replaceAll("isCritical", String.valueOf(crit));
            parseText = parseText.replaceAll("damageInflicted", String.valueOf(this.getDamage(turnIndex, source, target, crit)));
            parseText = parseText.replaceAll("formattedDamageInflicted", AbstractCombatMove.getFormattedDamage(this.getDamageType(turnIndex, source), this.getDamage(turnIndex, source, target, crit), target, false, this.isTargetAtMaximumLust(target)));
        }
        return UtilText.parse(source, target, parseText, new ParserTag[0]);
    }

    public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        String parseText = this.performingText;
        if (this.fromExternalFile) {
            boolean crit = this.canCrit(turnIndex, source, target, enemies, allies);
            parseText = parseText.replaceAll("isCritical", String.valueOf(crit));
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, crit));
            parseText = parseText.replaceAll("damageInflicted", String.valueOf(damageValue.getValue()));
            parseText = parseText.replaceAll("formattedDamageInflicted", AbstractCombatMove.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust));
            parseText = parseText.replaceAll("formattedHealthDamage", damageValue.getKey());
            StringBuilder sb = new StringBuilder();
            sb.append(AbstractCombatMove.formatAttackOutcome(source, target, parseText, (String)(damageValue.getValue() > 0 ? "[npc2.Name]\u6536\u5230\u4e86" + AbstractCombatMove.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01" : ""), crit ? this.performingCritDescText : null, this.performingCritText));
            if (!this.getAoeDamage().isEmpty()) {
                ArrayList<GameCharacter> aoeAvailableTargets = new ArrayList<GameCharacter>(enemies);
                aoeAvailableTargets.remove(target);
                for (AoEData aoe : this.getAoeDamage()) {
                    if (aoeAvailableTargets.isEmpty()) break;
                    GameCharacter aoeTarget = Util.randomItemFrom(aoeAvailableTargets);
                    if (!(Math.random() * 100.0 <= (double)aoe.getChance())) continue;
                    DamageType aoeDamageType = aoe.getDamageType(source, target);
                    DamageVariance damageVariance = aoe.getDamageVariance();
                    maxLust = this.isTargetAtMaximumLust(aoeTarget);
                    damageValue = aoeDamageType.damageTarget(source, aoeTarget, Attack.calculateSpecialAttackDamage(source, aoeTarget, this.getType(), aoeDamageType, aoe.getDamage(source), damageVariance, crit));
                    sb.append(AbstractCombatMove.formatAttackOutcome(source, aoeTarget, "", (String)(damageValue.getValue() > 0 ? "[style.colourAqua(AoE)]\uff1a[npc2.Name]\u53d7\u5230\u4e86" + AbstractCombatMove.getFormattedDamage(aoeDamageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01" : ""), null, null));
                    for (Map.Entry<AbstractStatusEffect, Integer> entry : aoe.getStatusEffects(source, aoeTarget, crit).entrySet()) {
                        int duration = entry.getValue();
                        if (crit) {
                            duration = (int)((float)duration * this.getCritStatusEffectDurationMultiplier());
                        }
                        Main.combat.addStatusEffectToApply(aoeTarget, entry.getKey(), duration);
                        sb.append(UtilText.parse(aoeTarget, "<br/>[npc.NameIsFull]\u73b0\u5728\u53d7\u5230<b style='color:" + entry.getKey().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(entry.getKey().getName(aoeTarget)) + "</b>\u7684\u5f71\u54cd<b>" + Util.intToString(duration) + (duration == 1 ? "\u56de\u5408" : "\u56de\u5408") + "</b>\uff01", new ParserTag[0]));
                    }
                    aoeAvailableTargets.remove(aoeTarget);
                }
            }
            return sb.toString();
        }
        return UtilText.parse(source, target, parseText, new ParserTag[0]);
    }

    public void performOnSelection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        DamageType dt = this.getBlockDamageType(turnIndex, source);
        if (this.isFromExternalFile() && this.getBlock(source, false) > 0) {
            source.setShields(dt, source.getShields(dt) + this.getBlock(source, this.canCrit(turnIndex, source, target, enemies, allies)));
        }
    }

    public void performOnDeselection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        DamageType dt = this.getBlockDamageType(turnIndex, source);
        if (this.isFromExternalFile() && this.getBlock(source, false) > 0) {
            source.setShields(dt, source.getShields(dt) - this.getBlock(source, this.canCrit(turnIndex, source, target, enemies, allies)));
        }
    }

    public void applyDisruption(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        source.setRemainingAP(source.getRemainingAP() + this.getAPcost(source) * -1, enemies, allies);
    }

    public boolean isAlreadyDisrupted(GameCharacter source) {
        return source.disruptionByTypeCheck(this.getType());
    }

    public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
        if (this.fromExternalFile) {
            boolean condition = Boolean.valueOf(UtilText.parse(source, this.availabilityCondition, new ParserTag[0]).trim());
            return new Util.Value<Boolean, String>(condition, this.availabilityDescription);
        }
        return null;
    }

    public String isUsable(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        if (target != null) {
            if (!this.canTargetSelf && source == target) {
                return "\u8be5\u52a8\u4f5c\u65e0\u6cd5\u5bf9\u81ea\u5df1\u4f7f\u7528\uff01";
            }
            if (!this.canTargetAllies && allies.contains(target) && source != target) {
                return "\u8be5\u52a8\u4f5c\u65e0\u6cd5\u5bf9\u76df\u53cb\u4f7f\u7528\uff01";
            }
            if (!this.canTargetEnemies && enemies.contains(target)) {
                return "\u8be5\u52a8\u4f5c\u65e0\u6cd5\u5bf9\u654c\u4eba\u4f7f\u7528\uff01";
            }
        }
        if (source.getMoveCooldown(this.getIdentifier()) > 0) {
            return "\u8be5\u52a8\u4f5c\u5728\u51b7\u5374\u7ed3\u675f\u524d\u65e0\u6cd5\u4f7f\u7528\uff01\u8fd8\u5269\u4e0b" + String.valueOf(source.getMoveCooldown(this.getIdentifier())) + "\u56de\u5408\u3002";
        }
        if (source.getRemainingAP() < this.getAPcost(source)) {
            return "\u7531\u4e8eAP\u4e0d\u8db3\uff0c\u8be5\u52a8\u4f5c\u65e0\u6cd5\u4f7f\u7528\uff01";
        }
        return null;
    }

    public static boolean shouldBlunder() {
        return Math.random() <= (double)Main.getProperties().AIblunderRate;
    }

    public CombatMoveCategory getCategory() {
        return this.category;
    }

    public String getIdentifier() {
        return CombatMove.getIdFromCombatMove(this);
    }

    public int getCooldown(GameCharacter source) {
        int derivedCooldown = this.cooldown;
        if (this.fromExternalFile) {
            try {
                derivedCooldown = Integer.valueOf(UtilText.parse(source, this.cooldownString, new ParserTag[0]).trim());
            }
            catch (Exception ex) {
                System.err.println("CombatMove loading error: cooldownString parsing not recognised! (Left as 'cooldown')");
            }
        }
        if (!source.getEquippedMoves().contains(this)) {
            return derivedCooldown + 1;
        }
        return derivedCooldown;
    }

    public DamageType getBlockDamageType(int turnIndex, GameCharacter source) {
        if (this.fromExternalFile && this.blockDamageTypeString != null && !this.blockDamageTypeString.isEmpty()) {
            DamageType dt = DamageType.PHYSICAL;
            try {
                dt = DamageType.valueOf(UtilText.parse(source, this.blockDamageTypeString, new ParserTag[0]).trim());
            }
            catch (Exception ex) {
                System.err.println("CombatMove getBlockDamageType() loading error: DamageType parsing not recognised! (Set to PHYSICAL)");
            }
            if (dt == DamageType.UNARMED) {
                return DamageType.UNARMED.getParentDamageType(source, null);
            }
            return dt;
        }
        return this.getDamageType(turnIndex, source);
    }

    public int getBlock(GameCharacter source, boolean isCrit) {
        int block = 0;
        if (this.fromExternalFile) {
            try {
                String parseText = this.blockString;
                parseText = parseText.replaceAll("isCritical", String.valueOf(isCrit));
                block = Integer.valueOf(UtilText.parse(source, parseText, new ParserTag[0]).trim());
            }
            catch (Exception ex) {
                System.err.println("CombatMove loading error: blockString parsing not recognised! (Set to 0)");
            }
        }
        return block;
    }

    public CombatMoveType getType() {
        return this.type;
    }

    public DamageType getDamageType(int turnIndex, GameCharacter source) {
        if (this.fromExternalFile) {
            DamageType dt = DamageType.PHYSICAL;
            try {
                dt = DamageType.valueOf(UtilText.parse(source, this.damageTypeString, new ParserTag[0]).trim());
            }
            catch (Exception ex) {
                System.err.println("CombatMove getDamageType() loading error: DamageType parsing not recognised! (Set to PHYSICAL)");
            }
            if (dt == DamageType.UNARMED) {
                return DamageType.UNARMED.getParentDamageType(source, null);
            }
            return dt;
        }
        return this.damageType;
    }

    public int getBaseDamage(GameCharacter source) {
        if (this.fromExternalFile) {
            float damage = 1.0f;
            try {
                String s = UtilText.parse(source, this.baseDamageString, new ParserTag[0]).trim();
                damage = Float.valueOf(s).floatValue();
            }
            catch (Exception ex) {
                System.err.println("CombatMove loading error: baseDamage parsing not recognised! (Set to 1)");
            }
            return (int)damage;
        }
        return this.baseDamage;
    }

    protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
        if (this.getBaseDamage(source) == 0) {
            return 0;
        }
        DamageType damageType = this.getDamageType(turnIndex, source);
        return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), isCrit);
    }

    public DamageVariance getDamageVariance() {
        return this.damageVariance;
    }

    public List<AoEData> getAoeDamage() {
        return this.aoeDamage;
    }

    public Spell getAssociatedSpell() {
        return this.associatedSpell;
    }

    public void setAssociatedSpell(Spell associatedSpell) {
        this.associatedSpell = associatedSpell;
    }

    public boolean isCanTargetEnemies() {
        return this.canTargetEnemies;
    }

    public boolean isCanTargetAllies() {
        return this.canTargetAllies;
    }

    public boolean isCanTargetSelf() {
        return this.canTargetSelf;
    }

    public int getAPcost(GameCharacter source) {
        int derivedAPCost = this.APcost;
        if (this.fromExternalFile) {
            try {
                derivedAPCost = Integer.valueOf(UtilText.parse(source, this.APCostString, new ParserTag[0]).trim());
            }
            catch (Exception ex) {
                System.err.println("CombatMove loading error: APCostString parsing not recognised! (Left as 'APcost')");
            }
        }
        return derivedAPCost + (!source.getEquippedMoves().contains(this) ? 1 : 0);
    }

    public String getName(int turnIndex, GameCharacter source) {
        return UtilText.parse(source, this.name, new ParserTag[0]);
    }

    public String getDescription(int turnIndex, GameCharacter source) {
        String parseText = this.description;
        parseText = parseText.replaceAll("damageInflicted", String.valueOf(this.getDamage(turnIndex, source, null, false)));
        parseText = parseText.replaceAll("formattedDamageInflicted", AbstractCombatMove.getFormattedDamage(this.getDamageType(turnIndex, source), this.getBaseDamage(source), null, false, false));
        return UtilText.parse(source, parseText, new ParserTag[0]);
    }

    public String getSVGString() {
        return this.SVGString;
    }

    public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
        if (isCritical) {
            return this.statusEffectsCritical;
        }
        return this.statusEffects;
    }

    public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        if (this.fromExternalFile) {
            return Util.newArrayListOfValues(this.criticalDescription);
        }
        return Util.newArrayListOfValues("\u8fd9\u56de\u5408\u7b2c\u4e09\u6b21\u88ab\u4f7f\u7528\u3002");
    }

    public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
        if (this.fromExternalFile) {
            String parseText = this.criticalCondition;
            parseText = parseText.replaceAll("turnIndex", String.valueOf(turnIndex));
            parseText = parseText.replaceAll("damageInflicted", String.valueOf(this.getDamage(turnIndex, source, target, false)));
            parseText = parseText.replaceAll("damageType", "DAMAGE_TYPE_" + String.valueOf((Object)this.getDamageType(turnIndex, source)));
            return Boolean.valueOf(UtilText.parse(source, target, parseText, new ParserTag[0]).trim());
        }
        int thisMoveSelected = 0;
        for (int i = 0; i < source.getSelectedMoves().size(); ++i) {
            Util.Value<GameCharacter, AbstractCombatMove> move = source.getSelectedMoves().get(i);
            if (Objects.equals(move.getValue().getIdentifier(), this.getIdentifier())) {
                ++thisMoveSelected;
            }
            if (i != turnIndex) continue;
            return thisMoveSelected % 3 == 0;
        }
        return false;
    }

    public float getCritStatusEffectDurationMultiplier() {
        return 1.0f;
    }

    public Colour getColour() {
        if (this.getAssociatedSpell() != null) {
            return this.getAssociatedSpell().getSpellSchool().getColour();
        }
        return this.getType().getColour();
    }

    public Colour getColourByDamageType(int turnIndex, GameCharacter source) {
        if (Util.newArrayListOfValues(CombatMoveType.SPELL, CombatMoveType.POWER).contains((Object)this.type)) {
            return this.getDamageType(turnIndex, source).getColour();
        }
        return this.type.getColour();
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public boolean isMod() {
        return this.mod;
    }

    public int getEquipWeighting() {
        return this.equipWeighting;
    }
}

