/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat.moves;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.attributes.LustLevel;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.combat.Attack;
import com.lilithsthrone.game.combat.CombatBehaviour;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.moves.CombatMove;
import com.lilithsthrone.game.combat.moves.CombatMoveCategory;
import com.lilithsthrone.game.combat.moves.CombatMoveType;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CMBasicAttack {
    public static AbstractCombatMove BASIC_STRIKE = new AbstractCombatMove(CombatMoveCategory.BASIC, "\u6253\u51fb", 0, 1, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/strike", Util.newArrayListOfValues(PresetColour.BASE_CRIMSON), false, true, false, null){

        private AbstractWeapon getMainWeapon(int turnIndex, GameCharacter source, int armRow) {
            Map<AbstractWeapon, Integer> weaponsThrown;
            AbstractWeapon weapon = source.getMainWeaponArray()[armRow];
            if (Main.game.isInCombat() && Main.combat.getAllCombatants(true).contains(source) && !(weaponsThrown = Main.combat.getWeaponsThrownDuringTurn(source, InventorySlot.mainWeaponSlots[armRow])).isEmpty()) {
                AbstractWeapon thrownWeaponType;
                int mainOrDualAttacksPerformed = 0;
                int turnCountProgress = 0;
                for (Util.Value<GameCharacter, AbstractCombatMove> move : source.getSelectedMoves()) {
                    if (turnCountProgress >= turnIndex) break;
                    if (move.getValue() == BASIC_STRIKE || move.getValue() == BASIC_TWIN_STRIKE) {
                        ++mainOrDualAttacksPerformed;
                    }
                    ++turnCountProgress;
                }
                if (mainOrDualAttacksPerformed < weaponsThrown.get(thrownWeaponType = weaponsThrown.keySet().iterator().next())) {
                    weapon = weaponsThrown.keySet().iterator().next();
                }
            }
            return weapon;
        }

        private int getArcaneCost(int turnIndex, GameCharacter source) {
            int essenceCost = 0;
            for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon == null || weapon.getWeaponType().getArcaneCost() <= 0) continue;
                essenceCost += weapon.getWeaponType().getArcaneCost();
            }
            return essenceCost;
        }

        private List<String> getDamageRanges(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            ArrayList<String> damages = new ArrayList<String>();
            for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon != null) {
                    damages.add(1.getFormattedDamageRange(source, target, weapon.getDamageType(), Attack.MAIN, weapon, isCrit));
                    continue;
                }
                damages.add(1.getFormattedDamageRange(source, target, DamageType.UNARMED.getParentDamageType(source, null), Attack.MAIN, null, isCrit));
            }
            return damages;
        }

        private List<String> getFormattedDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean damageHasBeenApplied) {
            ArrayList<String> damages = new ArrayList<String>();
            for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon != null) {
                    damages.add(1.getFormattedDamage(weapon.getDamageType(), weapon.getWeaponType().getDamage(), target, damageHasBeenApplied, this.isTargetAtMaximumLust(target)));
                    continue;
                }
                damages.add(1.getFormattedDamage(DamageType.UNARMED.getParentDamageType(source, null), source.getUnarmedDamage(), target, damageHasBeenApplied, this.isTargetAtMaximumLust(target)));
            }
            return damages;
        }

        private String getPredictionPrefix(int turnIndex, GameCharacter source, GameCharacter target) {
            StringBuilder sb = new StringBuilder();
            int attackCount = Math.min(source.getArmRows(), source.getMainWeaponArray().length);
            for (int i = 0; i < attackCount; ++i) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon == null && attackCount <= 1) continue;
                if (sb.length() > 0) {
                    sb.append("/");
                }
                if (weapon != null) {
                    sb.append(Util.capitaliseSentence(weapon.getWeaponType().getAttackDescriptionPrefix(source, target)));
                    continue;
                }
                sb.append("\u653b\u51fb");
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return this.getName(turnIndex, source);
        }

        @Override
        public int getAPcost(GameCharacter source) {
            return source.getArmRows() + (!source.getEquippedMoves().contains(this) ? 1 : 0);
        }

        @Override
        public String getName(int turnIndex, GameCharacter source) {
            StringBuilder sb = new StringBuilder();
            int attackCount = Math.min(source.getArmRows(), source.getMainWeaponArray().length);
            for (int i = 0; i < attackCount; ++i) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon == null && attackCount <= 1) continue;
                if (sb.length() > 0) {
                    sb.append("/");
                }
                if (weapon != null) {
                    sb.append(Util.capitaliseSentence(weapon.getWeaponType().getAttackDescriptor()));
                    continue;
                }
                sb.append("\u653b\u51fb");
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return super.getName(turnIndex, source);
        }

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            DamageType damageType = DamageType.UNARMED.getParentDamageType(source, null);
            for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon == null) continue;
                damageType = weapon.getDamageType();
                break;
            }
            return damageType;
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(true, "\u4efb\u4f55\u89d2\u8272\u5747\u53ef\u7528\u7684\u57fa\u7840\u52a8\u4f5c\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit;
            Object costText = "";
            int essenceCost = this.getArcaneCost(turnIndex, source);
            if (essenceCost > 0) {
                costText = "\u4f7f\u7528\u6b66\u5668\u9700\u8981\u6d88\u8017[style.boldArcane(" + essenceCost + "\u5965\u672f\u7cbe\u534e)]\uff01";
            }
            return UtilText.parse(source, target, ((isCrit = this.canCrit(turnIndex, source, target, enemies, allies)) ? "[style.colourExcellent(\u66b4\u51fb)]: " : "") + "<span style='color:" + this.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.getPredictionPrefix(turnIndex, source, target)) + "</span>" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\uff0c\u4f7f\u7528[npc.her]\u7684" + (source.getArmRows() == 1 ? (this.getMainWeapon(turnIndex, source, 0) == null ? "\u62f3\u5934" : this.getMainWeapon(turnIndex, source, 0).getName()) : "\u4e3b\u624b\u6b66\u5668") + "\u9020\u6210" + Util.stringsToStringList(this.getDamageRanges(turnIndex, source, target, isCrit), false) + "\u4f24\u5bb3\u3002" + (String)costText, new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            Object costText = "";
            int essenceCost = this.getArcaneCost(turnIndex, source);
            ArrayList<String> weaponNames = new ArrayList<String>();
            for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon != null) {
                    weaponNames.add(weapon.getName());
                    continue;
                }
                if (weaponNames.contains("fists")) continue;
                weaponNames.add("\u62f3\u5934");
            }
            if (essenceCost > 0) {
                costText = "\u4f7f\u7528\u6b66\u5668\u9700\u8981\u6d88\u8017[style.boldArcane(" + essenceCost + "\u5965\u672f\u7cbe\u534e)]\uff01";
            }
            return UtilText.parse(source, "\u51fb\u6253[npc.her]\u7684\u76ee\u6807\uff0c\u4f7f\u7528[npc.her]\u7684" + (weaponNames.isEmpty() ? "\u62f3\u5934" : (weaponNames.size() == 1 ? (String)weaponNames.get(0) : "\u4e3b\u624b\u6b66\u5668")) + "\uff0c\u9020\u6210" + Util.stringsToStringList(this.getFormattedDamage(turnIndex, source, null, false), false) + "\u57fa\u7840\u4f24\u5bb3\u3002" + (String)costText, new ParserTag[0]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            void var12_17;
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            StringBuilder attackStringBuilder = new StringBuilder("");
            StringBuilder weaponAttacksStringBuilder = new StringBuilder("");
            LinkedHashMap weaponDamages = new LinkedHashMap();
            block0: for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                int inflictedDamage;
                Util.Value<String, Integer> damageValue;
                boolean maxLust;
                int n;
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon != null) {
                    n = Attack.calculateDamage(source, target, Attack.MAIN, weapon, isCrit);
                    maxLust = this.isTargetAtMaximumLust(target);
                    damageValue = weapon.getDamageType().damageTarget(source, target, n);
                    inflictedDamage = damageValue.getValue();
                    weaponAttacksStringBuilder.append((i > 0 ? "<br/>" : "") + source.getAttackDescription(weapon, target, true, isCrit) + damageValue.getKey());
                    weaponDamages.putIfAbsent(target, new ArrayList());
                    ((List)weaponDamages.get(target)).add(1.getFormattedDamage(weapon.getDamageType(), inflictedDamage, target, true, maxLust));
                    ArrayList<GameCharacter> aoeAvailableTargets = new ArrayList<GameCharacter>(enemies);
                    aoeAvailableTargets.remove(target);
                    for (Util.Value<Integer, Integer> aoe : weapon.getWeaponType().getAoeDamage()) {
                        if (aoeAvailableTargets.isEmpty()) continue block0;
                        GameCharacter aoeTarget = Util.randomItemFrom(aoeAvailableTargets);
                        if (!(Math.random() * 100.0 <= (double)aoe.getKey().intValue())) continue;
                        maxLust = this.isTargetAtMaximumLust(target);
                        n = Attack.calculateDamage(source, target, Attack.MAIN, weapon, aoe.getValue(), isCrit);
                        damageValue = weapon.getDamageType().damageTarget(source, aoeTarget, n);
                        inflictedDamage = damageValue.getValue();
                        weaponDamages.putIfAbsent(aoeTarget, new ArrayList());
                        ((List)weaponDamages.get(aoeTarget)).add(1.getFormattedDamage(weapon.getDamageType(), inflictedDamage, aoeTarget, true, maxLust));
                        aoeAvailableTargets.remove(aoeTarget);
                    }
                    continue;
                }
                n = Attack.calculateDamage(source, target, Attack.MAIN, null, isCrit);
                maxLust = this.isTargetAtMaximumLust(target);
                damageValue = DamageType.UNARMED.getParentDamageType(source, null).damageTarget(source, target, n);
                inflictedDamage = damageValue.getValue();
                weaponAttacksStringBuilder.append((i > 0 ? "<br/>" : "") + source.getAttackDescription(weapon, target, true, isCrit) + damageValue.getKey());
                weaponDamages.putIfAbsent(target, new ArrayList());
                ((List)weaponDamages.get(target)).add(1.getFormattedDamage(DamageType.UNARMED.getParentDamageType(source, null), inflictedDamage, target, true, maxLust));
            }
            if (attackStringBuilder.length() > 0) {
                attackStringBuilder.append("<br/>");
            }
            StringBuilder damageApplied = new StringBuilder();
            for (Map.Entry entry : weaponDamages.entrySet()) {
                if (damageApplied.length() > 0) {
                    damageApplied.append("<br/>");
                }
                damageApplied.append(UtilText.parse((GameCharacter)entry.getKey(), (((GameCharacter)entry.getKey()).equals(target) ? "" : "[style.boldAqua(\u8303\u56f4\u4f24\u5bb3)]: ") + "[npc.Name]\u53d7\u5230\u4e86" + Util.stringsToStringList((List)entry.getValue(), false) + "\u4f24\u5bb3\uff01", new ParserTag[0]));
            }
            attackStringBuilder.append(1.formatAttackOutcome(source, target, weaponAttacksStringBuilder.toString(), damageApplied.toString(), isCrit ? "" : null, isCrit ? "\u9020\u6210\u989d\u5916\u4f24\u5bb3\uff01" : ""));
            source.incrementEssenceCount(this.getArcaneCost(turnIndex, source), false);
            ArrayList<String> extraEffects = new ArrayList<String>();
            boolean bl = false;
            while (var12_17 < Math.min(source.getArmRows(), source.getMainWeaponArray().length)) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, (int)var12_17);
                if (weapon != null) {
                    String s = weapon.applyExtraEffects(source, target, true, isCrit);
                    attackStringBuilder.append((s.isEmpty() ? "" : "<br/>") + s);
                    extraEffects.addAll(Main.combat.applyExtraAttackEffects(source, target, Attack.MAIN, weapon, true, isCrit));
                } else {
                    extraEffects.addAll(Main.combat.applyExtraAttackEffects(source, target, Attack.MAIN, weapon, true, isCrit));
                }
                ++var12_17;
            }
            if (!extraEffects.isEmpty()) {
                attackStringBuilder.append("<div class='container-full-width' style='text-align:center; padding:0; margin:0;'>");
                for (String s : extraEffects) {
                    attackStringBuilder.append(s);
                }
                attackStringBuilder.append("</div>");
            }
            return attackStringBuilder.toString();
        }

        @Override
        public String isUsable(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int essenceCost = this.getArcaneCost(turnIndex, source);
            int weaponCount = 0;
            for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon == null) continue;
                ++weaponCount;
            }
            if (source.getEssenceCount() < essenceCost) {
                return "\u4f60\u7684\u5965\u672f\u7cbe\u534e\u4e0d\u8db3\u4ee5\u4f7f\u7528\u5f53\u524d\u6b66\u5668\uff01(\u9700\u8981" + Util.capitaliseSentence(Util.intToString(essenceCost)) + "\u3002)";
            }
            return super.isUsable(turnIndex, source, target, enemies, allies);
        }

        @Override
        public void performOnSelection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int essenceCost = this.getArcaneCost(turnIndex, source);
            source.incrementEssenceCount(-essenceCost, false);
            for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                AbstractWeapon weapon = source.getMainWeaponArray()[i];
                if (weapon == null || !weapon.getWeaponType().isOneShot()) continue;
                if (source.getWeaponCount(weapon) >= 1) {
                    source.removeWeapon(weapon);
                } else {
                    source.unequipWeaponIntoVoid(InventorySlot.mainWeaponSlots[i], weapon, true);
                    Main.combat.addThrownWeaponsDepleted(source, InventorySlot.mainWeaponSlots[i], weapon.getWeaponType());
                }
                Main.combat.incrementWeaponsThrownDuringTurn(source, InventorySlot.mainWeaponSlots[i], weapon, 1);
                Main.combat.incrementWeaponsThrownDuringCombat(source, InventorySlot.mainWeaponSlots[i], weapon, 1);
            }
        }

        @Override
        public void performOnDeselection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int essenceCost = this.getArcaneCost(turnIndex, source);
            source.incrementEssenceCount(essenceCost, false);
            for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                InventorySlot slot = InventorySlot.mainWeaponSlots[i];
                Map<AbstractWeapon, Integer> weaponsThrown = Main.combat.getWeaponsThrownDuringTurn(source, slot);
                if (weaponsThrown == null) continue;
                for (Map.Entry<AbstractWeapon, Integer> entry : weaponsThrown.entrySet()) {
                    AbstractWeapon weapon = entry.getKey();
                    int thrownCount = entry.getValue();
                    Main.combat.incrementWeaponsThrownDuringTurn(source, InventorySlot.mainWeaponSlots[i], weapon, -thrownCount);
                    Main.combat.incrementWeaponsThrownDuringCombat(source, InventorySlot.mainWeaponSlots[i], weapon, -thrownCount);
                    if (source.getMainWeapon(i) == null) {
                        --thrownCount;
                        source.equipMainWeapon(weapon, i, false);
                        Main.combat.removeThrownWeaponsDepleted(source, slot);
                        continue;
                    }
                    for (int c = 0; c < thrownCount; ++c) {
                        source.addWeapon(weapon, 1, false, false);
                    }
                }
            }
        }
    };
    public static AbstractCombatMove BASIC_OFFHAND_STRIKE = new AbstractCombatMove(CombatMoveCategory.BASIC, "\u526f\u624b\u6253\u51fb", 0, 1, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/strike_offhand", Util.newArrayListOfValues(PresetColour.BASE_ORANGE), false, true, false, null){

        private AbstractWeapon getOffhandWeapon(int turnIndex, GameCharacter source, int armRow) {
            Map<AbstractWeapon, Integer> weaponsThrown;
            AbstractWeapon weapon = source.getOffhandWeaponArray()[armRow];
            if (Main.game.isInCombat() && Main.combat.getAllCombatants(true).contains(source) && !(weaponsThrown = Main.combat.getWeaponsThrownDuringTurn(source, InventorySlot.offhandWeaponSlots[armRow])).isEmpty()) {
                AbstractWeapon thrownWeaponType;
                int offhandOrDualAttacksPerformed = 0;
                int turnCountProgress = 0;
                for (Util.Value<GameCharacter, AbstractCombatMove> move : source.getSelectedMoves()) {
                    if (turnCountProgress >= turnIndex) break;
                    if (move.getValue() == BASIC_OFFHAND_STRIKE || move.getValue() == BASIC_TWIN_STRIKE) {
                        ++offhandOrDualAttacksPerformed;
                    }
                    ++turnCountProgress;
                }
                if (offhandOrDualAttacksPerformed < weaponsThrown.get(thrownWeaponType = weaponsThrown.keySet().iterator().next())) {
                    weapon = weaponsThrown.keySet().iterator().next();
                }
            }
            return weapon;
        }

        private int getArcaneCost(int turnIndex, GameCharacter source) {
            int essenceCost = 0;
            for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon == null || weapon.getWeaponType().getArcaneCost() <= 0) continue;
                essenceCost += weapon.getWeaponType().getArcaneCost();
            }
            return essenceCost;
        }

        private List<String> getDamageRanges(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            ArrayList<String> damages = new ArrayList<String>();
            for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon != null) {
                    damages.add(2.getFormattedDamageRange(source, target, weapon.getDamageType(), Attack.OFFHAND, weapon, isCrit));
                    continue;
                }
                damages.add(2.getFormattedDamageRange(source, target, DamageType.UNARMED.getParentDamageType(source, null), Attack.OFFHAND, null, isCrit));
            }
            return damages;
        }

        private List<String> getFormattedDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean damageHasBeenApplied) {
            ArrayList<String> damages = new ArrayList<String>();
            for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon != null) {
                    damages.add(2.getFormattedDamage(weapon.getDamageType(), weapon.getWeaponType().getDamage(), target, damageHasBeenApplied, this.isTargetAtMaximumLust(target)));
                    continue;
                }
                damages.add(2.getFormattedDamage(DamageType.UNARMED.getParentDamageType(source, null), source.getUnarmedDamage(), target, damageHasBeenApplied, this.isTargetAtMaximumLust(target)));
            }
            return damages;
        }

        private String getPredictionPrefix(int turnIndex, GameCharacter source, GameCharacter target) {
            StringBuilder sb = new StringBuilder();
            int attackCount = Math.min(source.getArmRows(), source.getOffhandWeaponArray().length);
            for (int i = 0; i < attackCount; ++i) {
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon == null && attackCount <= 1) continue;
                if (sb.length() > 0) {
                    sb.append("/");
                }
                if (weapon != null) {
                    sb.append(Util.capitaliseSentence(weapon.getWeaponType().getAttackDescriptionPrefix(source, target)));
                    continue;
                }
                sb.append("\u653b\u51fb");
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return this.getName(turnIndex, source);
        }

        @Override
        public float getWeight(GameCharacter source, List<GameCharacter> enemies, List<GameCharacter> allies) {
            float weight = super.getWeight(source, enemies, allies);
            if (!source.hasPerkAnywhereInTree(Perk.MARTIAL_ARTIST) && source.getEquippedMoves().contains(CombatMove.getCombatMoveFromId("strike")) && source.getMainWeapon(0) != null && source.getOffhandWeapon(0) == null) {
                weight *= 0.1f;
            }
            return weight;
        }

        @Override
        public int getAPcost(GameCharacter source) {
            return source.getArmRows() + (!source.getEquippedMoves().contains(this) ? 1 : 0);
        }

        @Override
        public String getName(int turnIndex, GameCharacter source) {
            StringBuilder sb = new StringBuilder();
            int attackCount = Math.min(source.getArmRows(), source.getOffhandWeaponArray().length);
            for (int i = 0; i < attackCount; ++i) {
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon == null && attackCount <= 1) continue;
                if (sb.length() > 0) {
                    sb.append("/");
                }
                if (weapon != null) {
                    sb.append(Util.capitaliseSentence(weapon.getWeaponType().getAttackDescriptor()));
                    continue;
                }
                sb.append("\u653b\u51fb");
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return super.getName(turnIndex, source);
        }

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            DamageType damageType = DamageType.UNARMED.getParentDamageType(source, null);
            for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon == null) continue;
                damageType = weapon.getDamageType();
                break;
            }
            return damageType;
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(true, "\u4efb\u4f55\u89d2\u8272\u5747\u53ef\u7528\u7684\u57fa\u7840\u52a8\u4f5c\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit;
            Object costText = "";
            int essenceCost = this.getArcaneCost(turnIndex, source);
            if (essenceCost > 0) {
                costText = "\u4f7f\u7528\u6b66\u5668\u9700\u8981\u6d88\u8017[style.boldArcane(" + essenceCost + "\u5965\u672f\u7cbe\u534e)]\uff01";
            }
            return UtilText.parse(source, target, ((isCrit = this.canCrit(turnIndex, source, target, enemies, allies)) ? "[style.colourExcellent(\u66b4\u51fb)]: " : "") + "<span style='color:" + this.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(this.getPredictionPrefix(turnIndex, source, target)) + "</span>" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\uff0c\u4f7f\u7528[npc.her]\u7684" + (source.getArmRows() == 1 ? (this.getOffhandWeapon(turnIndex, source, 0) == null ? "\u62f3\u5934" : this.getOffhandWeapon(turnIndex, source, 0).getName()) : "\u526f\u624b\u6b66\u5668") + "\u9020\u6210" + Util.stringsToStringList(this.getDamageRanges(turnIndex, source, target, isCrit), false) + "\u4f24\u5bb3\u3002" + (String)costText, new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            Object costText = "";
            int essenceCost = this.getArcaneCost(turnIndex, source);
            ArrayList<String> weaponNames = new ArrayList<String>();
            for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon != null) {
                    weaponNames.add(weapon.getName());
                    continue;
                }
                if (weaponNames.contains("fists")) continue;
                weaponNames.add("\u62f3\u5934");
            }
            if (essenceCost > 0) {
                costText = "\u4f7f\u7528\u6b66\u5668\u9700\u8981\u6d88\u8017[style.boldArcane(" + essenceCost + "\u5965\u672f\u7cbe\u534e)]\uff01";
            }
            return UtilText.parse(source, "\u51fb\u6253[npc.her]\u7684\u76ee\u6807\uff0c\u4f7f\u7528[npc.her]\u7684" + (weaponNames.isEmpty() ? "\u62f3\u5934" : (weaponNames.size() == 1 ? (String)weaponNames.get(0) : "\u526f\u624b\u6b66\u5668")) + "\uff0c\u9020\u6210" + Util.stringsToStringList(this.getFormattedDamage(turnIndex, source, null, false), false) + "\u57fa\u7840\u4f24\u5bb3\u3002" + (String)costText, new ParserTag[0]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            void var12_17;
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            StringBuilder attackStringBuilder = new StringBuilder("");
            StringBuilder weaponAttacksStringBuilder = new StringBuilder("");
            LinkedHashMap weaponDamages = new LinkedHashMap();
            block0: for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                int inflictedDamage;
                Util.Value<String, Integer> damageValue;
                boolean maxLust;
                int n;
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon != null) {
                    n = Attack.calculateDamage(source, target, Attack.OFFHAND, weapon, isCrit);
                    maxLust = this.isTargetAtMaximumLust(target);
                    damageValue = weapon.getDamageType().damageTarget(source, target, n);
                    inflictedDamage = damageValue.getValue();
                    weaponAttacksStringBuilder.append((i > 0 ? "<br/>" : "") + source.getAttackDescription(weapon, target, true, isCrit) + damageValue.getKey());
                    weaponDamages.putIfAbsent(target, new ArrayList());
                    ((List)weaponDamages.get(target)).add(2.getFormattedDamage(weapon.getDamageType(), inflictedDamage, target, true, maxLust));
                    ArrayList<GameCharacter> aoeAvailableTargets = new ArrayList<GameCharacter>(enemies);
                    aoeAvailableTargets.remove(target);
                    for (Util.Value<Integer, Integer> aoe : weapon.getWeaponType().getAoeDamage()) {
                        if (aoeAvailableTargets.isEmpty()) continue block0;
                        GameCharacter aoeTarget = Util.randomItemFrom(aoeAvailableTargets);
                        if (!(Math.random() * 100.0 <= (double)aoe.getKey().intValue())) continue;
                        maxLust = this.isTargetAtMaximumLust(target);
                        n = Attack.calculateDamage(source, target, Attack.OFFHAND, weapon, aoe.getValue(), isCrit);
                        damageValue = weapon.getDamageType().damageTarget(source, aoeTarget, n);
                        inflictedDamage = damageValue.getValue();
                        weaponDamages.putIfAbsent(aoeTarget, new ArrayList());
                        ((List)weaponDamages.get(aoeTarget)).add(2.getFormattedDamage(weapon.getDamageType(), inflictedDamage, aoeTarget, true, maxLust));
                        aoeAvailableTargets.remove(aoeTarget);
                    }
                    continue;
                }
                n = Attack.calculateDamage(source, target, Attack.OFFHAND, null, isCrit);
                maxLust = this.isTargetAtMaximumLust(target);
                damageValue = DamageType.UNARMED.getParentDamageType(source, null).damageTarget(source, target, n);
                inflictedDamage = damageValue.getValue();
                weaponAttacksStringBuilder.append((i > 0 ? "<br/>" : "") + source.getAttackDescription(weapon, target, true, isCrit) + damageValue.getKey());
                weaponDamages.putIfAbsent(target, new ArrayList());
                ((List)weaponDamages.get(target)).add(2.getFormattedDamage(DamageType.UNARMED.getParentDamageType(source, null), inflictedDamage, target, true, maxLust));
            }
            if (attackStringBuilder.length() > 0) {
                attackStringBuilder.append("<br/>");
            }
            StringBuilder damageApplied = new StringBuilder();
            for (Map.Entry entry : weaponDamages.entrySet()) {
                if (damageApplied.length() > 0) {
                    damageApplied.append("<br/>");
                }
                damageApplied.append(UtilText.parse((GameCharacter)entry.getKey(), (((GameCharacter)entry.getKey()).equals(target) ? "" : "[style.boldAqua(\u8303\u56f4\u4f24\u5bb3)]: ") + "[npc.Name]\u53d7\u5230\u4e86" + Util.stringsToStringList((List)entry.getValue(), false) + "\u4f24\u5bb3\uff01", new ParserTag[0]));
            }
            attackStringBuilder.append(2.formatAttackOutcome(source, target, weaponAttacksStringBuilder.toString(), damageApplied.toString(), isCrit ? "" : null, isCrit ? "\u9020\u6210\u989d\u5916\u4f24\u5bb3\uff01" : ""));
            source.incrementEssenceCount(this.getArcaneCost(turnIndex, source), false);
            ArrayList<String> extraEffects = new ArrayList<String>();
            boolean bl = false;
            while (var12_17 < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length)) {
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, (int)var12_17);
                if (weapon != null) {
                    String s = weapon.applyExtraEffects(source, target, true, isCrit);
                    attackStringBuilder.append((s.isEmpty() ? "" : "<br/>") + s);
                    extraEffects.addAll(Main.combat.applyExtraAttackEffects(source, target, Attack.OFFHAND, weapon, true, isCrit));
                } else {
                    extraEffects.addAll(Main.combat.applyExtraAttackEffects(source, target, Attack.OFFHAND, weapon, true, isCrit));
                }
                ++var12_17;
            }
            if (!extraEffects.isEmpty()) {
                attackStringBuilder.append("<div class='container-full-width' style='text-align:center; padding:0; margin:0;'>");
                for (String s : extraEffects) {
                    attackStringBuilder.append(s);
                }
                attackStringBuilder.append("</div>");
            }
            return attackStringBuilder.toString();
        }

        @Override
        public String isUsable(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int essenceCost = this.getArcaneCost(turnIndex, source);
            int weaponCount = 0;
            for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon == null) continue;
                ++weaponCount;
            }
            if (source.getEssenceCount() < essenceCost) {
                return "\u4f60\u7684\u5965\u672f\u7cbe\u534e\u4e0d\u8db3\u4ee5\u4f7f\u7528\u5f53\u524d\u6b66\u5668\uff01(\u9700\u8981" + Util.capitaliseSentence(Util.intToString(essenceCost)) + "\u3002)";
            }
            return super.isUsable(turnIndex, source, target, enemies, allies);
        }

        @Override
        public void performOnSelection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int essenceCost = this.getArcaneCost(turnIndex, source);
            source.incrementEssenceCount(-essenceCost, false);
            for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                AbstractWeapon weapon = source.getOffhandWeaponArray()[i];
                if (weapon == null || !weapon.getWeaponType().isOneShot()) continue;
                if (source.getWeaponCount(weapon) >= 1) {
                    source.removeWeapon(weapon);
                } else {
                    source.unequipWeaponIntoVoid(InventorySlot.offhandWeaponSlots[i], weapon, true);
                    Main.combat.addThrownWeaponsDepleted(source, InventorySlot.offhandWeaponSlots[i], weapon.getWeaponType());
                }
                Main.combat.incrementWeaponsThrownDuringTurn(source, InventorySlot.offhandWeaponSlots[i], weapon, 1);
                Main.combat.incrementWeaponsThrownDuringCombat(source, InventorySlot.offhandWeaponSlots[i], weapon, 1);
            }
        }

        @Override
        public void performOnDeselection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int essenceCost = this.getArcaneCost(turnIndex, source);
            source.incrementEssenceCount(essenceCost, false);
            for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                InventorySlot slot = InventorySlot.offhandWeaponSlots[i];
                Map<AbstractWeapon, Integer> weaponsThrown = Main.combat.getWeaponsThrownDuringTurn(source, slot);
                if (weaponsThrown == null) continue;
                for (Map.Entry<AbstractWeapon, Integer> entry : weaponsThrown.entrySet()) {
                    AbstractWeapon weapon = entry.getKey();
                    int thrownCount = entry.getValue();
                    Main.combat.incrementWeaponsThrownDuringTurn(source, InventorySlot.offhandWeaponSlots[i], weapon, -thrownCount);
                    Main.combat.incrementWeaponsThrownDuringCombat(source, InventorySlot.offhandWeaponSlots[i], weapon, -thrownCount);
                    if (source.getOffhandWeapon(i) == null) {
                        --thrownCount;
                        source.equipOffhandWeapon(weapon, i, false);
                        Main.combat.removeThrownWeaponsDepleted(source, slot);
                        continue;
                    }
                    for (int c = 0; c < thrownCount; ++c) {
                        source.addWeapon(weapon, 1, false, false);
                    }
                }
            }
        }
    };
    public static AbstractCombatMove BASIC_TWIN_STRIKE = new AbstractCombatMove(CombatMoveCategory.BASIC, "\u5168\u529b\u6253\u51fb", 2, 2, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/strike_twin", Util.newArrayListOfValues(PresetColour.BASE_CRIMSON, PresetColour.BASE_ORANGE), false, true, false, null){

        private AbstractWeapon getMainWeapon(int turnIndex, GameCharacter source, int armRow) {
            Map<AbstractWeapon, Integer> weaponsThrown;
            AbstractWeapon weapon = source.getMainWeaponArray()[armRow];
            if (Main.game.isInCombat() && Main.combat.getAllCombatants(true).contains(source) && !(weaponsThrown = Main.combat.getWeaponsThrownDuringTurn(source, InventorySlot.mainWeaponSlots[armRow])).isEmpty()) {
                AbstractWeapon thrownWeaponType;
                int mainOrDualAttacksPerformed = 0;
                int turnCountProgress = 0;
                for (Util.Value<GameCharacter, AbstractCombatMove> move : source.getSelectedMoves()) {
                    if (turnCountProgress >= turnIndex) break;
                    if (move.getValue() == BASIC_STRIKE || move.getValue() == BASIC_TWIN_STRIKE) {
                        ++mainOrDualAttacksPerformed;
                    }
                    ++turnCountProgress;
                }
                if (mainOrDualAttacksPerformed < weaponsThrown.get(thrownWeaponType = weaponsThrown.keySet().iterator().next())) {
                    weapon = weaponsThrown.keySet().iterator().next();
                }
            }
            return weapon;
        }

        private AbstractWeapon getOffhandWeapon(int turnIndex, GameCharacter source, int armRow) {
            Map<AbstractWeapon, Integer> weaponsThrown;
            AbstractWeapon weapon = source.getOffhandWeaponArray()[armRow];
            if (Main.game.isInCombat() && Main.combat.getAllCombatants(true).contains(source) && !(weaponsThrown = Main.combat.getWeaponsThrownDuringTurn(source, InventorySlot.offhandWeaponSlots[armRow])).isEmpty()) {
                AbstractWeapon thrownWeaponType;
                int offhandOrDualAttacksPerformed = 0;
                int turnCountProgress = 0;
                for (Util.Value<GameCharacter, AbstractCombatMove> move : source.getSelectedMoves()) {
                    if (turnCountProgress >= turnIndex) break;
                    if (move.getValue() == BASIC_OFFHAND_STRIKE || move.getValue() == BASIC_TWIN_STRIKE) {
                        ++offhandOrDualAttacksPerformed;
                    }
                    ++turnCountProgress;
                }
                if (offhandOrDualAttacksPerformed < weaponsThrown.get(thrownWeaponType = weaponsThrown.keySet().iterator().next())) {
                    weapon = weaponsThrown.keySet().iterator().next();
                }
            }
            return weapon;
        }

        private int getArcaneCost(int turnIndex, GameCharacter source) {
            AbstractWeapon weapon;
            int i;
            int essenceCost = 0;
            for (i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon == null || weapon.getWeaponType().getArcaneCost() <= 0) continue;
                essenceCost += weapon.getWeaponType().getArcaneCost();
            }
            for (i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                weapon = this.getOffhandWeapon(turnIndex, source, i);
                if (weapon == null || weapon.getWeaponType().getArcaneCost() <= 0) continue;
                essenceCost += weapon.getWeaponType().getArcaneCost();
            }
            return essenceCost;
        }

        private List<String> getDamageRanges(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            AbstractWeapon weapon;
            int i;
            ArrayList<String> damages = new ArrayList<String>();
            for (i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon != null) {
                    damages.add(3.getFormattedDamageRange(source, target, weapon.getDamageType(), Attack.MAIN, weapon, isCrit));
                    continue;
                }
                damages.add(3.getFormattedDamageRange(source, target, DamageType.UNARMED.getParentDamageType(source, null), Attack.MAIN, null, isCrit));
            }
            for (i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                weapon = this.getOffhandWeapon(turnIndex, source, i);
                AbstractWeapon primaryWeapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon != null) {
                    damages.add(3.getFormattedDamageRange(source, target, weapon.getDamageType(), Attack.OFFHAND, weapon, isCrit));
                    continue;
                }
                if (primaryWeapon == null || primaryWeapon.getWeaponType().isTwoHanded()) continue;
                damages.add(3.getFormattedDamageRange(source, target, DamageType.UNARMED.getParentDamageType(source, null), Attack.OFFHAND, null, isCrit));
            }
            return damages;
        }

        private List<String> getFormattedDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean damageHasBeenApplied) {
            AbstractWeapon weapon;
            int i;
            ArrayList<String> damages = new ArrayList<String>();
            for (i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon != null) {
                    damages.add(3.getFormattedDamage(weapon.getDamageType(), weapon.getWeaponType().getDamage(), target, damageHasBeenApplied, this.isTargetAtMaximumLust(target)));
                    continue;
                }
                damages.add(3.getFormattedDamage(DamageType.UNARMED.getParentDamageType(source, null), source.getUnarmedDamage(), target, damageHasBeenApplied, this.isTargetAtMaximumLust(target)));
            }
            for (i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                weapon = this.getOffhandWeapon(turnIndex, source, i);
                AbstractWeapon primaryWeapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon != null) {
                    damages.add(3.getFormattedDamage(weapon.getDamageType(), weapon.getWeaponType().getDamage(), target, damageHasBeenApplied, this.isTargetAtMaximumLust(target)));
                    continue;
                }
                if (primaryWeapon == null || primaryWeapon.getWeaponType().isTwoHanded()) continue;
                damages.add(3.getFormattedDamage(DamageType.UNARMED.getParentDamageType(source, null), source.getUnarmedDamage(), target, damageHasBeenApplied, this.isTargetAtMaximumLust(target)));
            }
            return damages;
        }

        @Override
        public int getAPcost(GameCharacter source) {
            return Math.min(3, Math.max(2, source.getArmRows() + (!source.getEquippedMoves().contains(this) ? 1 : 0)));
        }

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            DamageType damageType = DamageType.UNARMED.getParentDamageType(source, null);
            for (int i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                AbstractWeapon weapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon == null) continue;
                damageType = weapon.getDamageType();
                break;
            }
            return damageType;
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(true, "\u4efb\u4f55\u89d2\u8272\u5747\u53ef\u7528\u7684\u57fa\u7840\u52a8\u4f5c\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit;
            Object costText = "";
            int cost = this.getArcaneCost(turnIndex, source);
            if (cost > 0) {
                costText = "\u4f7f\u7528\u8be5\u653b\u51fb\u5c06\u6d88\u8017[style.boldArcane(" + cost + "\u5965\u672f\u7cbe\u534e)]\u3002";
            }
            return UtilText.parse(source, target, ((isCrit = this.canCrit(turnIndex, source, target, enemies, allies)) ? "[style.colourExcellent(\u66b4\u51fb)]: " : "") + "<span style='color:" + this.getColour().toWebHexString() + ";'>\u5168\u529b\u6253\u51fb</span>" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\uff0c\u4f7f\u7528\u5168\u90e8\u7684\u6b66\u5668\u9020\u6210" + Util.stringsToStringList(this.getDamageRanges(turnIndex, source, target, isCrit), false) + "\u4f24\u5bb3\u3002" + (String)costText, new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            Object costText = "";
            int essenceCost = this.getArcaneCost(turnIndex, source);
            if (essenceCost > 0) {
                costText = "\u4f7f\u7528\u6b66\u5668\u9700\u8981\u6d88\u8017[style.boldArcane(" + essenceCost + "\u5965\u672f\u7cbe\u534e)]\uff01";
            }
            return UtilText.parse(source, "\u4f7f\u7528\u5168\u90e8\u6b66\u5668\u51fb\u6253[npc.her]\u7684\u76ee\u6807\uff0c\u9020\u6210" + Util.stringsToStringList(this.getFormattedDamage(turnIndex, source, null, false), false) + "\u4f24\u5bb3\u3002" + (String)costText, new ParserTag[0]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            void var12_20;
            void var12_18;
            Object weapon;
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            StringBuilder attackStringBuilder = new StringBuilder("");
            StringBuilder weaponAttacksStringBuilder = new StringBuilder("");
            LinkedHashMap weaponDamages = new LinkedHashMap();
            block0: for (int i2 = 0; i2 < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i2) {
                int inflictedDamage;
                Util.Value<String, Integer> damageValue;
                boolean maxLust;
                int n;
                weapon = this.getMainWeapon(turnIndex, source, i2);
                if (weapon != null) {
                    n = Attack.calculateDamage(source, target, Attack.MAIN, (AbstractWeapon)weapon, isCrit);
                    maxLust = this.isTargetAtMaximumLust(target);
                    damageValue = ((AbstractWeapon)weapon).getDamageType().damageTarget(source, target, n);
                    inflictedDamage = damageValue.getValue();
                    weaponAttacksStringBuilder.append((i2 > 0 ? "<br/>" : "") + source.getAttackDescription((AbstractWeapon)weapon, target, true, isCrit) + damageValue.getKey());
                    weaponDamages.putIfAbsent(target, new ArrayList());
                    ((List)weaponDamages.get(target)).add(3.getFormattedDamage(((AbstractWeapon)weapon).getDamageType(), inflictedDamage, target, true, maxLust));
                    ArrayList<GameCharacter> aoeAvailableTargets = new ArrayList<GameCharacter>(enemies);
                    aoeAvailableTargets.remove(target);
                    for (Util.Value<Integer, Integer> aoe : ((AbstractWeapon)weapon).getWeaponType().getAoeDamage()) {
                        if (aoeAvailableTargets.isEmpty()) continue block0;
                        GameCharacter aoeTarget = Util.randomItemFrom(aoeAvailableTargets);
                        if (!(Math.random() * 100.0 <= (double)aoe.getKey().intValue())) continue;
                        maxLust = this.isTargetAtMaximumLust(target);
                        n = Attack.calculateDamage(source, target, Attack.MAIN, (AbstractWeapon)weapon, aoe.getValue(), isCrit);
                        damageValue = ((AbstractWeapon)weapon).getDamageType().damageTarget(source, aoeTarget, n);
                        inflictedDamage = damageValue.getValue();
                        weaponDamages.putIfAbsent(aoeTarget, new ArrayList());
                        ((List)weaponDamages.get(aoeTarget)).add(3.getFormattedDamage(((AbstractWeapon)weapon).getDamageType(), inflictedDamage, aoeTarget, true, maxLust));
                        aoeAvailableTargets.remove(aoeTarget);
                    }
                    continue;
                }
                n = Attack.calculateDamage(source, target, Attack.MAIN, null, isCrit);
                maxLust = this.isTargetAtMaximumLust(target);
                damageValue = DamageType.UNARMED.getParentDamageType(source, null).damageTarget(source, target, n);
                inflictedDamage = damageValue.getValue();
                weaponAttacksStringBuilder.append((i2 > 0 ? "<br/>" : "") + source.getAttackDescription((AbstractWeapon)weapon, target, true, isCrit) + damageValue.getKey());
                weaponDamages.putIfAbsent(target, new ArrayList());
                ((List)weaponDamages.get(target)).add(3.getFormattedDamage(DamageType.UNARMED.getParentDamageType(source, null), inflictedDamage, target, true, maxLust));
            }
            block2: for (int i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                int inflictedDamage;
                Util.Value<String, Integer> damageValue;
                boolean maxLust;
                int damage;
                weapon = this.getOffhandWeapon(turnIndex, source, i);
                AbstractWeapon abstractWeapon = this.getMainWeapon(turnIndex, source, i);
                if (weapon != null) {
                    damage = Attack.calculateDamage(source, target, Attack.OFFHAND, (AbstractWeapon)weapon, isCrit);
                    maxLust = this.isTargetAtMaximumLust(target);
                    damageValue = ((AbstractWeapon)weapon).getDamageType().damageTarget(source, target, damage);
                    inflictedDamage = damageValue.getValue();
                    weaponAttacksStringBuilder.append("<br/>" + source.getAttackDescription((AbstractWeapon)weapon, target, true, isCrit) + damageValue.getKey());
                    weaponDamages.putIfAbsent(target, new ArrayList());
                    ((List)weaponDamages.get(target)).add(3.getFormattedDamage(((AbstractWeapon)weapon).getDamageType(), inflictedDamage, target, true, maxLust));
                    ArrayList<GameCharacter> aoeAvailableTargets = new ArrayList<GameCharacter>(enemies);
                    aoeAvailableTargets.remove(target);
                    for (Util.Value<Integer, Integer> aoe : ((AbstractWeapon)weapon).getWeaponType().getAoeDamage()) {
                        if (aoeAvailableTargets.isEmpty()) continue block2;
                        GameCharacter aoeTarget = Util.randomItemFrom(aoeAvailableTargets);
                        if (!(Math.random() * 100.0 <= (double)aoe.getKey().intValue())) continue;
                        maxLust = this.isTargetAtMaximumLust(target);
                        damage = Attack.calculateDamage(source, target, Attack.OFFHAND, (AbstractWeapon)weapon, aoe.getValue(), isCrit);
                        damageValue = ((AbstractWeapon)weapon).getDamageType().damageTarget(source, aoeTarget, damage);
                        inflictedDamage = damageValue.getValue();
                        weaponDamages.putIfAbsent(aoeTarget, new ArrayList());
                        ((List)weaponDamages.get(aoeTarget)).add(3.getFormattedDamage(((AbstractWeapon)weapon).getDamageType(), inflictedDamage, aoeTarget, true, maxLust));
                        aoeAvailableTargets.remove(aoeTarget);
                    }
                    continue;
                }
                if (abstractWeapon == null || abstractWeapon.getWeaponType().isTwoHanded()) continue;
                damage = Attack.calculateDamage(source, target, Attack.OFFHAND, null, isCrit);
                maxLust = this.isTargetAtMaximumLust(target);
                damageValue = DamageType.UNARMED.getParentDamageType(source, null).damageTarget(source, target, damage);
                inflictedDamage = damageValue.getValue();
                weaponAttacksStringBuilder.append("<br/>" + source.getAttackDescription((AbstractWeapon)weapon, target, true, isCrit) + damageValue.getKey());
                weaponDamages.putIfAbsent(target, new ArrayList());
                ((List)weaponDamages.get(target)).add(3.getFormattedDamage(DamageType.UNARMED.getParentDamageType(source, null), inflictedDamage, target, true, maxLust));
            }
            if (attackStringBuilder.length() > 0) {
                attackStringBuilder.append("<br/>");
            }
            StringBuilder damageApplied = new StringBuilder();
            for (Map.Entry entry : weaponDamages.entrySet()) {
                if (damageApplied.length() > 0) {
                    damageApplied.append("<br/>");
                }
                damageApplied.append(UtilText.parse((GameCharacter)entry.getKey(), (((GameCharacter)entry.getKey()).equals(target) ? "" : "[style.boldAqua(\u8303\u56f4\u4f24\u5bb3)]: ") + "[npc.Name]\u53d7\u5230\u4e86" + Util.stringsToStringList((List)entry.getValue(), false) + "\u4f24\u5bb3\uff01", new ParserTag[0]));
            }
            attackStringBuilder.append(3.formatAttackOutcome(source, target, weaponAttacksStringBuilder.toString(), damageApplied.toString(), isCrit ? "" : null, isCrit ? "\u9020\u6210\u989d\u5916\u4f24\u5bb3\uff01" : ""));
            source.incrementEssenceCount(this.getArcaneCost(turnIndex, source), false);
            ArrayList<String> extraEffects = new ArrayList<String>();
            boolean bl = false;
            while (var12_18 < Math.min(source.getArmRows(), source.getMainWeaponArray().length)) {
                AbstractWeapon weapon2 = this.getMainWeapon(turnIndex, source, (int)var12_18);
                if (weapon2 != null) {
                    String s = weapon2.applyExtraEffects(source, target, true, isCrit);
                    attackStringBuilder.append((s.isEmpty() ? "" : "<br/>") + s);
                    extraEffects.addAll(Main.combat.applyExtraAttackEffects(source, target, Attack.MAIN, weapon2, true, isCrit));
                } else {
                    extraEffects.addAll(Main.combat.applyExtraAttackEffects(source, target, Attack.MAIN, weapon2, true, isCrit));
                }
                ++var12_18;
            }
            boolean bl2 = false;
            while (var12_20 < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length)) {
                AbstractWeapon weapon3 = this.getOffhandWeapon(turnIndex, source, (int)var12_20);
                if (weapon3 != null) {
                    String s = weapon3.applyExtraEffects(source, target, true, isCrit);
                    attackStringBuilder.append((s.isEmpty() ? "" : "<br/>") + s);
                    extraEffects.addAll(Main.combat.applyExtraAttackEffects(source, target, Attack.OFFHAND, weapon3, true, isCrit));
                } else {
                    extraEffects.addAll(Main.combat.applyExtraAttackEffects(source, target, Attack.OFFHAND, weapon3, true, isCrit));
                }
                ++var12_20;
            }
            if (!extraEffects.isEmpty()) {
                attackStringBuilder.append("<div class='container-full-width' style='text-align:center; padding:0; margin:0;'>");
                for (String s : extraEffects) {
                    attackStringBuilder.append(s);
                }
                attackStringBuilder.append("</div>");
            }
            return attackStringBuilder.toString();
        }

        @Override
        public String isUsable(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int freeSlots = source.getArmRows();
            for (int i = 0; i < source.getArmRows(); ++i) {
                AbstractWeapon mainWeapon = this.getMainWeapon(turnIndex, source, i);
                AbstractWeapon offhandWeapon = this.getOffhandWeapon(turnIndex, source, i);
                if ((mainWeapon == null || !mainWeapon.getWeaponType().isTwoHanded()) && (offhandWeapon == null || !offhandWeapon.getWeaponType().isTwoHanded())) continue;
                --freeSlots;
            }
            if (freeSlots == 0) {
                if (source.getArmRows() > 1) {
                    return "\u4f60\u6b63\u5728\u4f7f\u7528\u4ec5\u80fd\u53cc\u624b\u4f7f\u7528\u7684\u6b66\u5668\uff0c\u6ca1\u6709\u7a7a\u4f59\u7684\u80a2\u4f53\u6765\u4f7f\u7528\u5168\u529b\u6253\u51fb\uff01";
                }
                return "\u4f60\u6b63\u5728\u4f7f\u7528\u53cc\u624b\u6b66\u5668\uff0c\u6ca1\u6709\u7a7a\u4f59\u7684\u80a2\u4f53\u6765\u4f7f\u7528\u5168\u529b\u6253\u51fb\uff01";
            }
            int cost = this.getArcaneCost(turnIndex, source);
            if (source.getEssenceCount() < cost) {
                return "\u4f60\u7684\u5965\u672f\u7cbe\u534e\u4e0d\u8db3\u4ee5\u4f7f\u7528\u5f53\u524d\u6b66\u5668\uff01(\u9700\u8981" + Util.capitaliseSentence(Util.intToString(cost)) + "\u3002)";
            }
            return super.isUsable(turnIndex, source, target, enemies, allies);
        }

        @Override
        public void performOnSelection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            AbstractWeapon weapon;
            int i;
            int essenceCost = this.getArcaneCost(turnIndex, source);
            source.incrementEssenceCount(-essenceCost, false);
            for (i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                weapon = source.getMainWeaponArray()[i];
                if (weapon == null || !weapon.getWeaponType().isOneShot()) continue;
                if (source.getWeaponCount(weapon) >= 1) {
                    source.removeWeapon(weapon);
                } else {
                    source.unequipWeaponIntoVoid(InventorySlot.mainWeaponSlots[i], weapon, true);
                    Main.combat.addThrownWeaponsDepleted(source, InventorySlot.mainWeaponSlots[i], weapon.getWeaponType());
                }
                Main.combat.incrementWeaponsThrownDuringTurn(source, InventorySlot.mainWeaponSlots[i], weapon, 1);
                Main.combat.incrementWeaponsThrownDuringCombat(source, InventorySlot.mainWeaponSlots[i], weapon, 1);
            }
            for (i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                weapon = source.getOffhandWeaponArray()[i];
                if (weapon == null || !weapon.getWeaponType().isOneShot()) continue;
                if (source.getWeaponCount(weapon) >= 1) {
                    source.removeWeapon(weapon);
                } else {
                    source.unequipWeaponIntoVoid(InventorySlot.offhandWeaponSlots[i], weapon, true);
                    Main.combat.addThrownWeaponsDepleted(source, InventorySlot.offhandWeaponSlots[i], weapon.getWeaponType());
                }
                Main.combat.incrementWeaponsThrownDuringTurn(source, InventorySlot.offhandWeaponSlots[i], weapon, 1);
                Main.combat.incrementWeaponsThrownDuringCombat(source, InventorySlot.offhandWeaponSlots[i], weapon, 1);
            }
        }

        @Override
        public void performOnDeselection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int c;
            int thrownCount;
            AbstractWeapon weapon;
            Map<AbstractWeapon, Integer> weaponsThrown;
            InventorySlot slot;
            int i;
            int essenceCost = this.getArcaneCost(turnIndex, source);
            source.incrementEssenceCount(essenceCost, false);
            for (i = 0; i < Math.min(source.getArmRows(), source.getMainWeaponArray().length); ++i) {
                slot = InventorySlot.mainWeaponSlots[i];
                weaponsThrown = Main.combat.getWeaponsThrownDuringTurn(source, slot);
                if (weaponsThrown == null) continue;
                for (Map.Entry<AbstractWeapon, Integer> entry : weaponsThrown.entrySet()) {
                    weapon = entry.getKey();
                    thrownCount = entry.getValue();
                    Main.combat.incrementWeaponsThrownDuringTurn(source, InventorySlot.mainWeaponSlots[i], weapon, -thrownCount);
                    Main.combat.incrementWeaponsThrownDuringCombat(source, InventorySlot.mainWeaponSlots[i], weapon, -thrownCount);
                    if (source.getMainWeapon(i) == null) {
                        --thrownCount;
                        source.equipMainWeapon(weapon, i, false);
                        Main.combat.removeThrownWeaponsDepleted(source, slot);
                        continue;
                    }
                    for (c = 0; c < thrownCount; ++c) {
                        source.addWeapon(weapon, 1, false, false);
                    }
                }
            }
            for (i = 0; i < Math.min(source.getArmRows(), source.getOffhandWeaponArray().length); ++i) {
                slot = InventorySlot.offhandWeaponSlots[i];
                weaponsThrown = Main.combat.getWeaponsThrownDuringTurn(source, slot);
                if (weaponsThrown == null) continue;
                for (Map.Entry<AbstractWeapon, Integer> entry : weaponsThrown.entrySet()) {
                    weapon = entry.getKey();
                    thrownCount = entry.getValue();
                    Main.combat.incrementWeaponsThrownDuringTurn(source, InventorySlot.offhandWeaponSlots[i], weapon, -thrownCount);
                    Main.combat.incrementWeaponsThrownDuringCombat(source, InventorySlot.offhandWeaponSlots[i], weapon, -thrownCount);
                    if (source.getOffhandWeapon(i) == null) {
                        --thrownCount;
                        source.equipOffhandWeapon(weapon, i, false);
                        Main.combat.removeThrownWeaponsDepleted(source, slot);
                        continue;
                    }
                    for (c = 0; c < thrownCount; ++c) {
                        source.addWeapon(weapon, 1, false, false);
                    }
                }
            }
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues("\u8fd9\u662f\u76ee\u524d\u4f7f\u7528\u7684\u552f\u4e00\u884c\u52a8\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return source.getSelectedMoves().stream().anyMatch(move -> move.getValue() == BASIC_TWIN_STRIKE) && source.getSelectedMoves().size() == 1;
        }
    };
    public static AbstractCombatMove BASIC_BLOCK = new AbstractCombatMove(CombatMoveCategory.BASIC, "\u683c\u6321", 0, 1, CombatMoveType.DEFEND, DamageType.HEALTH, "moves/block", Util.newArrayListOfValues(PresetColour.BASE_GREY), false, false, true, null){

        @Override
        public int getBlock(GameCharacter source, boolean isCrit) {
            return 7 * (isCrit ? 2 : 1);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(true, "\u4efb\u4f55\u89d2\u8272\u5747\u53ef\u7528\u7684\u57fa\u7840\u52a8\u4f5c\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            DamageType damageType = this.getDamageType(turnIndex, source);
            return (isCrit ? "[style.colourExcellent(\u66b4\u51fb)]: " : "") + "<span style='color:" + this.getColour().toWebHexString() + ";'>\u683c\u6321</span><span style='color:" + damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + String.valueOf(this.getBlock(source, isCrit)) + damageType.getName() + "</span>\u4f24\u5bb3\u3002";
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return "\u4e13\u6ce8\u4e8e\u4fdd\u62a4\u81ea\u5df1\uff0c\u83b7\u5f97\u9488\u5bf9\u4e8e<span style='color:" + damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + String.valueOf(this.getBlock(source, false)) + "</span>\u4f24\u5bb3\u7684\u9632\u62a4\u3002";
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            return 4.formatAttackOutcome(source, target, "[npc.Name]\u4e13\u6ce8\u4e8e\u4fdd\u62a4\u81ea\u5df1\u3002", "[npc.SheIs]\u73b0\u5728\u62e5\u6709\u9488\u5bf9\u4e8e" + 4.getFormattedDamage(this.getDamageType(turnIndex, source), this.getBlock(source, isCrit), target, true, false) + "\u4f24\u5bb3\u7684\u9632\u62a4\uff01", isCrit ? "" : null, isCrit ? "[npc.Name]\u52a0\u500d\u4e86\u683c\u6321\uff01" : "");
        }

        @Override
        public void performOnSelection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = DamageType.HEALTH;
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            target.setShields(damageType, target.getShields(damageType) + this.getBlock(source, isCrit));
        }

        @Override
        public void performOnDeselection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = DamageType.HEALTH;
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            target.setShields(damageType, target.getShields(damageType) - this.getBlock(source, isCrit));
        }
    };
    public static AbstractCombatMove BASIC_TEASE = new AbstractCombatMove(CombatMoveCategory.BASIC, "\u6311\u9017", 0, 1, CombatMoveType.TEASE, DamageType.LUST, "moves/tease", false, true, false, null){

        @Override
        public int getBaseDamage(GameCharacter source) {
            return 7;
        }

        protected int getDamage(GameCharacter source, GameCharacter target, boolean critical) {
            return Attack.calculateSeductionDamage(source, target, this.getBaseDamage(source), critical);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(true, "\u4efb\u4f55\u89d2\u8272\u5747\u53ef\u7528\u7684\u57fa\u7840\u52a8\u4f5c\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            return UtilText.parse(source, target, (isCrit ? "[style.colourExcellent(\u66b4\u51fb)]: " : "") + "<span style='color:" + this.getColour().toWebHexString() + ";'>\u6311\u9017</span>[npc2.name]\u9020\u6210" + 5.getFormattedDamage(this.getDamageType(turnIndex, source), this.getDamage(source, target, isCrit), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            return "\u6311\u9017\u4f60\u7684\u654c\u4eba\uff0c\u7ed9\u5bf9\u65b9\u9020\u6210" + 5.getFormattedDamage(this.getDamageType(turnIndex, source), this.getBaseDamage(source), null, false, false) + "\u70b9\u57fa\u7840\u4f24\u5bb3\u3002";
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            StringBuilder sb = new StringBuilder("");
            DamageType finalDt = this.getDamageType(turnIndex, source);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = this.getDamageType(turnIndex, source).damageTarget(source, target, this.getDamage(source, target, isCrit));
            int lustDamage = damageValue.getValue();
            sb.append(5.formatAttackOutcome(source, target, source.getSeductionDescription(target) + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 5.getFormattedDamage(finalDt, lustDamage, target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "" : null, isCrit ? "[npc2.Name]\u611f\u5230\u683c\u5916\u9965\u6e34\uff01" : ""));
            if (source.hasStatusEffect(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION)) {
                Main.combat.addStatusEffectToApply(target, StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION_TARGETED, 2);
                sb.append(Spell.getBasicStatusEffectApplication(target, false, Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.TELEPATHIC_COMMUNICATION_POWER_OF_SUGGESTION_TARGETED, 2))));
            }
            return sb.toString();
        }
    };
    public static AbstractCombatMove BASIC_TEASE_BLOCK = new AbstractCombatMove(CombatMoveCategory.BASIC, "\u62b5\u6297", 0, 1, CombatMoveType.DEFEND, DamageType.LUST, "moves/avert", false, false, true, null){

        @Override
        public int getBlock(GameCharacter source, boolean isCrit) {
            return 7 * (isCrit ? 2 : 1);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(true, "\u4efb\u4f55\u89d2\u8272\u5747\u53ef\u7528\u7684\u57fa\u7840\u52a8\u4f5c\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, (isCrit ? "[style.colourExcellent(\u66b4\u51fb)]: " : "") + "<span style='color:" + this.getColour().toWebHexString() + ";'>\u62b5\u6297</span><span style='color:" + damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + String.valueOf(this.getBlock(source, isCrit)) + damageType.getName() + "</span>\u4f24\u5bb3\u3002", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return "\u62b5\u6297\u8bf1\u60d1\uff0c\u83b7\u5f97\u9488\u5bf9\u4e8e<span style='color:" + damageType.getMultiplierAttribute().getColour().toWebHexString() + ";'>" + String.valueOf(this.getBlock(source, false)) + "</span>\u4f24\u5bb3\u7684\u9632\u62a4\u3002";
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            return 6.formatAttackOutcome(source, target, "[npc.Name]\u4e13\u6ce8\u4e8e\u62b5\u6297\u8bf1\u60d1\u3002", "[npc.SheIs]\u73b0\u5728\u62e5\u6709\u9488\u5bf9\u4e8e" + 6.getFormattedDamage(this.getDamageType(turnIndex, source), this.getBlock(source, isCrit), target, true, false) + "\u4f24\u5bb3\u7684\u9632\u62a4\uff01", isCrit ? "" : null, isCrit ? "[npc.Name]\u52a0\u500d\u4e86\u62a4\u76fe\uff01" : "");
        }

        @Override
        public void performOnSelection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            target.setShields(damageType, target.getShields(damageType) + this.getBlock(source, this.canCrit(turnIndex, source, target, enemies, allies)));
        }

        @Override
        public void performOnDeselection(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            target.setShields(damageType, target.getShields(damageType) - this.getBlock(source, this.canCrit(turnIndex, source, target, enemies, allies)));
        }

        @Override
        public float getWeight(GameCharacter source, List<GameCharacter> enemies, List<GameCharacter> allies) {
            if (6.shouldBlunder()) {
                return (float)Math.random() - 0.2f * (float)source.getSelectedMovesByType(this.getType());
            }
            int behaviourMultiplier = 1;
            if (source.getCombatBehaviour() == CombatBehaviour.DEFEND) {
                behaviourMultiplier = 2;
            }
            if (source.getLustLevel() == LustLevel.FOUR_IMPASSIONED || source.getLustLevel() == LustLevel.FIVE_BURNING) {
                return 1.0f * (float)behaviourMultiplier + 0.2f * (float)Math.random() - 0.2f * (float)source.getSelectedMovesByType(this.getType());
            }
            return super.getWeight(source, enemies, allies);
        }
    };
    public static AbstractCombatMove BASIC_ARCANE_STRIKE = new AbstractCombatMove(CombatMoveCategory.BASIC, "\u5965\u672f\u6253\u51fb", 0, 1, CombatMoveType.ATTACK, DamageType.PHYSICAL, "moves/arcane_strike", Util.newArrayListOfValues(PresetColour.GENERIC_ARCANE), false, true, false, null){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.LUST;
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return (int)Math.max(1.0f, (float)this.getManaGain(source) * 0.1f);
        }

        private int getManaGain(GameCharacter source) {
            return source.getLevel() * 2;
        }

        protected int getDamage(GameCharacter source, GameCharacter target) {
            return Math.max(1, (int)Attack.getModifiedDamage(source, target, Attack.SEDUCTION, null, DamageType.LUST, this.getBaseDamage(source)));
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.getSpells().size() > 0, "\u81f3\u5c11\u9700\u8981\u5b66\u4f1a\u4e00\u79cd\u6cd5\u672f\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            return UtilText.parse(source, target, (isCrit ? "[style.colourExcellent(\u66b4\u51fb)]: " : "") + "<span style='color:" + this.getColour().toWebHexString() + ";'>\u5965\u672f\u6253\u51fb</span>" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\u9020\u6210" + 7.getFormattedDamage(this.getDamageType(turnIndex, source), this.getDamage(source, target), null, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u5e76\u4e14\u83b7\u5f97<span style='color:" + PresetColour.ATTRIBUTE_MANA.toWebHexString() + ";'>" + this.getManaGain(source) * (isCrit ? 2 : 1) + Attribute.MANA_MAXIMUM.getName() + "</span>\u3002", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            return UtilText.parse(source, "\u4f7f\u7528\u4e00\u9053\u7eaf\u7cb9\u7684\u5965\u672f\u80fd\u91cf\u51fb\u6253[npc.her]\u7684\u76ee\u6807\uff0c\u9020\u6210" + 7.getFormattedDamage(this.getDamageType(turnIndex, source), this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3\u5e76\u4e14\u6062\u590d<span style='color:" + PresetColour.ATTRIBUTE_MANA.toWebHexString() + ";'>" + this.getManaGain(source) + "\u57fa\u7840" + Attribute.MANA_MAXIMUM.getName() + "</span>\u3002", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = this.getDamageType(turnIndex, source).damageTarget(source, target, this.getDamage(source, target));
            int dealtDamage = damageValue.getValue();
            int manaGain = this.getManaGain(source);
            if (isCrit) {
                manaGain *= 2;
            }
            source.incrementMana(manaGain);
            StringBuilder attackStringBuilder = new StringBuilder("");
            if (attackStringBuilder.length() > 0) {
                attackStringBuilder.append("<br/>");
            }
            attackStringBuilder.append(7.formatAttackOutcome(source, target, "[npc.Name]\u638c\u63e1\u7740\u5965\u672f\u7684\u77e5\u8bc6\uff0c\u4e8e\u662f\u5c06\u8eab\u8fb9\u7684\u7075\u6c14\u5145\u76c8\u540e\uff0c\u5411\u7740[npc2.name]\u53d1\u51fa\u4e86\u4e00\u9053\u7eaf\u7cb9\u7684\u5965\u672f\u80fd\u91cf\uff01" + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 7.getFormattedDamage(this.getDamageType(turnIndex, source), dealtDamage, target, true, maxLust) + "\u4f24\u5bb3\uff0c\u800c[npc.name]\u6062\u590d\u4e86<span style='color:" + PresetColour.ATTRIBUTE_MANA.toWebHexString() + ";'>" + manaGain + Attribute.MANA_MAXIMUM.getName() + "</span>\uff01", isCrit ? "" : null, isCrit ? "\u7075\u6c14\u83b7\u53d6\u52a0\u500d\u4e86\uff01" : ""));
            List<String> extraEffects = Main.combat.applyExtraAttackEffects(source, target, Attack.SEDUCTION, null, true, isCrit);
            if (!extraEffects.isEmpty()) {
                attackStringBuilder.append("<div class='container-full-width' style='text-align:center; padding:0; margin:0;'>");
                for (String s : extraEffects) {
                    attackStringBuilder.append(s);
                }
                attackStringBuilder.append("</div>");
            }
            return attackStringBuilder.toString();
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues(UtilText.parse(source, "[npc.NameIsFull]\u6ca1\u6709\u65bd\u653e\u6cd5\u672f\u3002", new ParserTag[0]));
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            if (source.getSelectedMovesByType(CombatMoveType.SPELL) == 0) {
                return true;
            }
            return super.canCrit(turnIndex, source, target, enemies, allies);
        }
    };
}

